include(CheckFunctionExists)
function(find_function FUNCTION_NAME)
	if(CMAKE_SYSTEM_NAME STREQUAL "Generic")
		set(CMAKE_REQUIRED_FLAGS -Wl,--require-defined,${FUNCTION_NAME})
	endif()
	string(TOUPPER ${FUNCTION_NAME} FLAG_NAME)
	check_function_exists(${FUNCTION_NAME} HAVE_${FLAG_NAME})
	unset(CMAKE_REQUIRED_FLAGS)
	set(HAVE_${FLAG_NAME} ${HAVE_${FLAG_NAME}} PARENT_SCOPE)
	if(HAVE_${FLAG_NAME})
		list(APPEND FUNCTION_DEFINES HAVE_${FLAG_NAME})
		set(FUNCTION_DEFINES "${FUNCTION_DEFINES}" PARENT_SCOPE)
	endif()
endfunction()
