(display "loading nat0.scm ...") (newline)

(add-alg "nat" '("Zero" "nat") '("Succ" "nat=>nat"))

(av "n" "m" "k" (py "nat"))

(define (make-numeric-term n)
  (if (= n 0)
      (pt "Zero")
      (make-term-in-app-form
       (pt "Succ")
       (make-numeric-term (- n 1)))))

(define (is-numeric-term? term)
  (or
   (and (term-in-const-form? term)
	(string=? "Zero" (const-to-name (term-in-const-form-to-const term))))
   (and (term-in-app-form? term)
	(let ((op (term-in-app-form-to-op term)))
	  (and (term-in-const-form? op)
	       (string=? "Succ" (const-to-name
				 (term-in-const-form-to-const op)))
	       (is-numeric-term? (term-in-app-form-to-arg term)))))))

(define (numeric-term-to-number term)
  (if (equal? term (pt "Zero"))
      0
      (+ 1 (numeric-term-to-number (term-in-app-form-to-arg term)))))

