/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.HashMap;
import java.util.Map;

public class NamingStrategy {
    public static final NamingStrategy DEFAULT = new NamingStrategy();
    static Map<String, String> _identifierMappings = new HashMap<String, String>();

    static {
        NamingStrategy.keywords("readonly", "params", "override", "event", "operator", "internal", "base", "ref", "out", "as", "is", "in", "object", "string", "bool", "using");
        NamingStrategy.mapIdentifier("lock", "Lock");
        NamingStrategy.mapIdentifier("delegate", "delegate_");
    }

    private static void keywords(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            NamingStrategy.keyword(value);
            ++n2;
        }
    }

    private static void keyword(String value) {
        NamingStrategy.mapIdentifier(value, "@" + value);
    }

    private static void mapIdentifier(String from, String to) {
        _identifierMappings.put(from, to);
    }

    public String identifier(String name) {
        String mapped = _identifierMappings.get(name);
        return mapped != null ? mapped : name;
    }

    public String methodName(String name) {
        return this.namespacePart(name);
    }

    public String namespace(String name) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(this.namespacePart(part));
            ++n2;
        }
        return builder.toString();
    }

    protected String namespacePart(String part) {
        return this.identifier(part);
    }
}

