/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WorkspaceUtilities {
    public static final String DEFAULT_CHARSET = "utf-8";

    public static void addProjectReference(IProject referent, IProject reference, IProgressMonitor monitor) throws CoreException {
        IProject[] referencedProjects = referent.getReferencedProjects();
        if (WorkspaceUtilities.contains(referencedProjects, reference)) {
            return;
        }
        IProjectDescription description = referent.getDescription();
        description.setReferencedProjects(WorkspaceUtilities.append(referencedProjects, reference));
        referent.setDescription(description, monitor);
    }

    private static IProject[] append(IProject[] projects, IProject project) {
        IProject[] newProjects = new IProject[projects.length + 1];
        System.arraycopy(projects, 0, newProjects, 0, projects.length);
        newProjects[projects.length] = project;
        return newProjects;
    }

    private static boolean contains(IProject[] array, IProject element) {
        IProject[] iProjectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p == element) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void initializeTree(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            return;
        }
        WorkspaceUtilities.initializeParent(folder, monitor);
        folder.create(true, true, monitor);
    }

    private static void initializeParent(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent.exists()) {
            return;
        }
        if (WorkspaceUtilities.isProject(parent)) {
            WorkspaceUtilities.initializeProject((IProject)parent, monitor);
        } else {
            WorkspaceUtilities.initializeTree((IFolder)parent, monitor);
        }
    }

    private static boolean isProject(IContainer parent) {
        return parent.getType() == 4;
    }

    public static void initializeProject(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.exists()) {
            project.create(monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void throwCoreException(IOException e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "sharpen.core", -1, e.getLocalizedMessage(), (Throwable)e));
    }

    public static IProject getProject(String name) {
        return WorkspaceUtilities.getWorkspaceRoot().getProject(name);
    }

    public static String[] append(String[] array, String element) {
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = element;
        return newArray;
    }

    public static void addProjectNature(IProject project, String natureId) throws CoreException {
        if (project.hasNature(natureId)) {
            return;
        }
        IProjectDescription description = project.getDescription();
        description.setNatureIds(WorkspaceUtilities.append(description.getNatureIds(), natureId));
        project.setDescription(description, null);
    }

    public static Reader decode(IFile file) throws CoreException {
        try {
            return new InputStreamReader(file.getContents(), file.getCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            WorkspaceUtilities.throwCoreException(e);
            return null;
        }
    }

    public static InputStream encode(String text, String charset) throws CoreException {
        try {
            return new ByteArrayInputStream(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            WorkspaceUtilities.throwCoreException(e);
            return null;
        }
    }

    public static void setAutoBuilding(boolean autoBuilding) throws CoreException {
        IWorkspace workspace = WorkspaceUtilities.getWorkspaceRoot().getWorkspace();
        IWorkspaceDescription workspaceDescription = workspace.getDescription();
        workspaceDescription.setAutoBuilding(autoBuilding);
        workspace.setDescription(workspaceDescription);
    }

    public static void writeFile(IFile file, InputStream contents, String charset, IProgressMonitor monitor) throws CoreException {
        if (!file.exists()) {
            file.create(contents, true, monitor);
        } else {
            file.setContents(contents, true, true, monitor);
        }
        file.setCharset(charset, monitor);
    }

    public static void writeText(IFile file, String contents) throws CoreException {
        WorkspaceUtilities.writeFile(file, WorkspaceUtilities.encode(contents, DEFAULT_CHARSET), DEFAULT_CHARSET, null);
    }
}

