﻿//
// SameGuardConditionExpressionInIfElseBranchesTests.cs
//
// Author:
//       Ji Kun <jikun.nus@gmail.com>
//
// Copyright (c) 2013 Ji Kun <jikun.nus@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using ICSharpCode.NRefactory.CSharp.Refactoring;
using NUnit.Framework;

namespace ICSharpCode.NRefactory.CSharp.CodeIssues
{
	[TestFixture]
	public class SameGuardConditionExpressionInIfElseBranchesTests : InspectionActionTestBase
	{
		[Test]
		public void TestConditionalExpression()
		{
			var input = @"
class TestClass
{
	int TestMethod ()
	{
		int foo = 1;
		if (foo > 5)
		{
			return 2;
		}
		else if(foo > 5)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 1);
		}
		
		[Test]
		public void TestConditionalExpression2()
		{
			var input = @"
class TestClass
{
	int TestMethod ()
	{
		int foo = 1;
		if (foo > 5)
		{
			return 2;
		}
		else if(foo < 5)
		{
			return 5;
		}
		else if (foo>5)
		{
			return 6;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 1);
		}
		
		[Test]
		public void TestNoProblem()
		{
			var input = @"
class TestClass
{
	int TestMethod (int foo)
	{
		if (foo > 5)
		{
			return 2;
		}
		else if (foo > 5)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}

		[Test]
		public void TestNoProblem2()
		{
			var input = @"
class TestClass
{
	int TestMethod ()
	{
		int foo = 1;
		if (foo > 5)
		{
			return 2;
		}
		else if (foo > 6)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}

		[Test]
		public void TestNoProblem3()
		{
			var input = @"
class TestClass
{
	int TestMethod ()
	{
		int foo = 1;
		if (foo-- > 5)
		{
			return 2;
		}
		else if (foo-- > 5)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}

		[Test]
		public void TestNoProblem4()
		{
			var input = @"
class TestClass
{
	int TestMethod ()
	{
		int foo = 1;
		if ((foo=3) > 5)
		{
			return 2;
		}
		else if ((foo=3) > 5)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}

		[Test]
		public void TestNoProblem5()
		{
			var input = @"
class TestClass
{
	private int foo;
	int TestMethod ()
	{
		if (foo > 5)
		{
			return 2;
		}
		else if (foo > 5)
		{
			return 5;
		}
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}

		[Test]
		public void TestResharperDisableRestore()
		{
			var input = @"
class TestClass
{
	int TestMethod (int foo)
	{
//Resharper disable SameGuardConditionExpressionInIfelseBranches
		if (foo > 5)
		{
			return 2;
		}
		else if (foo > 5)
		{
			return 5;
		}
//Resharper restore SameGuardConditionExpressionInIfelseBranches
		return 0;
	}
}";
			Test<SameGuardConditionExpressionInIfelseBranchesIssue>(input, 0);
		}
	}
}