/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanVariant;
import com.jclark.xsl.expr.ConvertibleVariantExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.NodeSetVariant;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.ObjectVariant;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class ExtensionFunctionCallExpr
extends ConvertibleVariantExpr {
    private final Name name;
    private final VariantExpr[] args;

    ExtensionFunctionCallExpr(Name name, VariantExpr[] variantExprArray) {
        this.name = name;
        this.args = variantExprArray;
    }

    public Variant eval(Node node, ExprContext exprContext) throws XSLException {
        Object[] objectArray = new Object[this.args.length];
        int n = 0;
        while (n < this.args.length) {
            objectArray[n] = this.args[n].eval(node, exprContext).convertToObject();
            ++n;
        }
        Object object = exprContext.getExtensionContext(this.name.getNamespace()).call(this.name.getLocalPart(), node, objectArray);
        if (object instanceof String) {
            return new StringVariant((String)object);
        }
        if (object instanceof Number) {
            return new NumberVariant(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return new BooleanVariant((Boolean)object);
        }
        if (object instanceof NodeIterator) {
            return new NodeSetVariant((NodeIterator)object);
        }
        if (object instanceof Node) {
            return new NodeSetVariant(new SingleNodeIterator((Node)object));
        }
        if (object instanceof Variant) {
            return (Variant)object;
        }
        return new ObjectVariant(object);
    }
}

