/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;

class MultiLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    public void invoke(ProcessContext processContext, Node node, Result result) throws XSLException {
        NumberListFormat numberListFormat = this.formatTemplate.instantiate(processContext, node);
        int n = this.count == null ? (node.getType() == 0 ? this.numberUp(node.getName(), numberListFormat, processContext, node, result) : 0) : this.numberUp(numberListFormat, processContext, node, result);
        if (n == 0) {
            result.characters(numberListFormat.getPrefix(0));
        }
        result.characters(numberListFormat.getSuffix());
    }

    MultiLevelNumberAction(Pattern pattern, Pattern pattern2, NumberListFormatTemplate numberListFormatTemplate) {
        this.count = pattern;
        this.from = pattern2;
        this.formatTemplate = numberListFormatTemplate;
    }

    private int numberUp(NumberListFormat numberListFormat, ProcessContext processContext, Node node, Result result) throws XSLException {
        Node node2;
        do {
            node2 = node.getParent();
            if (!this.count.matches(node, processContext)) continue;
            int n = 0;
            SafeNodeIterator safeNodeIterator = node2.getChildren();
            while (true) {
                Node node3;
                if (!this.count.matches(node3 = safeNodeIterator.next(), processContext)) {
                    continue;
                }
                ++n;
                if (node3.equals(node)) break;
            }
            int n2 = this.numberUp(numberListFormat, processContext, node2, result);
            result.characters(numberListFormat.getPrefix(n2));
            result.characters(numberListFormat.formatNumber(n2, n));
            return n2 + 1;
        } while ((this.from == null || !this.from.matches(node, processContext)) && (node = node2) != null);
        return 0;
    }

    private int numberUp(Name name, NumberListFormat numberListFormat, ProcessContext processContext, Node node, Result result) throws XSLException {
        int n = 0;
        Node node2 = node.getParent();
        while (node2 != null) {
            if (name.equals(node2.getName())) {
                n = this.numberUp(name, numberListFormat, processContext, node2, result);
                break;
            }
            node2 = node2.getParent();
        }
        int n2 = 0;
        SafeNodeIterator safeNodeIterator = node.getParent().getChildren();
        while (true) {
            Node node3;
            if (!name.equals((node3 = safeNodeIterator.next()).getName()) || node3.getType() != 0) {
                continue;
            }
            ++n2;
            if (node3.equals(node)) break;
        }
        result.characters(numberListFormat.getPrefix(n));
        result.characters(numberListFormat.formatNumber(n, n2));
        return n + 1;
    }
}

