/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ejbjarproject.ui.customizer;

import java.util.List;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.openide.util.Lookup;


/** Host for WsCompile features editor for editing the features enabled for
 *  running WsCompile on a web service or a web service client.
 *
 *  property format: 'webservice.client.[servicename].features=xxx,yyy,zzz
 *
 * @author Peter Williams
 */
public class CustomizerWSServiceHost extends JPanel implements PropertyChangeListener, HelpCtx.Provider {
    private static final long serialVersionUID = 105002390260070271L;
    
    private EjbJarProjectProperties ejbJarProperties;
    private WsCompileEditorSupport.Panel wsCompileEditor;

    private List serviceSettings;
    
    public CustomizerWSServiceHost(EjbJarProjectProperties ejbJarProperties, List serviceSettings) {
        assert serviceSettings != null && serviceSettings.size() > 0;
        initComponents();

        this.ejbJarProperties = ejbJarProperties;
        this.wsCompileEditor = null;
        this.serviceSettings = serviceSettings;
        
        initValues();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

    }//GEN-END:initComponents

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
    @Override
    public void addNotify() {
        super.addNotify();

        JPanel component = wsCompileEditor.getComponent();

        removeAll(); // !PW is this necessary?
        add(component);

        component.addPropertyChangeListener(WsCompileEditorSupport.PROP_FEATURES_CHANGED, this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();

        JPanel component = wsCompileEditor.getComponent();
        component.removePropertyChangeListener(WsCompileEditorSupport.PROP_FEATURES_CHANGED, this);
    }

    public void initValues() {
        if(wsCompileEditor == null) {
            WsCompileEditorSupport editorSupport = Lookup.getDefault().lookup(WsCompileEditorSupport.class);
            wsCompileEditor = editorSupport.getWsCompileSupport();
        }

        wsCompileEditor.initValues(serviceSettings);
    }   

    /*public void validatePanel() throws WizardValidationException {
        if(wsCompileEditor != null) {
            wsCompileEditor.validatePanel();
        }
    }*/

    public void propertyChange(PropertyChangeEvent evt) {
        WsCompileEditorSupport.FeatureDescriptor newFeatureDesc = (WsCompileEditorSupport.FeatureDescriptor) evt.getNewValue();
        String propertyName = "wscompile.service." + newFeatureDesc.getServiceName() + ".features";
        ejbJarProperties.putAdditionalProperty(propertyName, newFeatureDesc.getFeatures());
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerWSServiceHost.class);
    }
}
