/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.rest.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.wizard.PatternResourcesSetupPanel.Pattern;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  Nam Nguyen
 */
public class PatternSelectionPanelVisual extends javax.swing.JPanel implements AbstractPanel.Settings {
    
    private Project project;
    private List<ChangeListener> listeners;
    
    
    /** Creates new form CrudSetupPanel */
    public PatternSelectionPanelVisual(String name) {
        setName(name);
        this.listeners = new ArrayList<ChangeListener>();
        initComponents();
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        patternButtons = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        descriptionEditorPane = new javax.swing.JEditorPane();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        clientControlledRadioButton = new javax.swing.JRadioButton();
        containerRadioButton = new javax.swing.JRadioButton();
        standAloneRadioButton = new javax.swing.JRadioButton();

        descriptionEditorPane.setEditable(false);
        jScrollPane1.setViewportView(descriptionEditorPane);
        descriptionEditorPane.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_PatternDescription")); // NOI18N
        descriptionEditorPane.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "DESC_PatternDescription")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_SelectPattern")); // NOI18N

        jLabel2.setLabelFor(descriptionEditorPane);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_Description")); // NOI18N

        patternButtons.add(clientControlledRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(clientControlledRadioButton, org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_ClientControl")); // NOI18N
        clientControlledRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        clientControlledRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clientControlledPatternSelected(evt);
            }
        });

        patternButtons.add(containerRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(containerRadioButton, org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_ContainerItem")); // NOI18N
        containerRadioButton.setActionCommand(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_ContainerItem")); // NOI18N
        containerRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        containerRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                containerRadioButtonActionPerformed(evt);
            }
        });

        patternButtons.add(standAloneRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(standAloneRadioButton, org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_SingletonResource")); // NOI18N
        standAloneRadioButton.setActionCommand(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_GenericResource")); // NOI18N
        standAloneRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        standAloneRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                standAlonePatternSelected(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 413, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(standAloneRadioButton)
                    .addComponent(containerRadioButton)
                    .addComponent(clientControlledRadioButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel2)
                .addGap(0, 0, Short.MAX_VALUE))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(standAloneRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(containerRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(clientControlledRadioButton)
                .addGap(18, 18, 18)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 145, Short.MAX_VALUE))
        );

        jLabel1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_SelectDesignPattern")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_SelectPattern")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_Description")); // NOI18N
        clientControlledRadioButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_ClientControl")); // NOI18N
        clientControlledRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "ACSD_ClientControlled")); // NOI18N
        containerRadioButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_ContainerItem")); // NOI18N
        containerRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "ACSD_ContainerResource")); // NOI18N
        standAloneRadioButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_GenericResource")); // NOI18N
        standAloneRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "ACSD_Singleton")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_Select_Pattern")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PatternSelectionPanelVisual.class, "LBL_SelectPattern")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void clientControlledPatternSelected(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clientControlledPatternSelected
    setDescription();
    fireChange();
}//GEN-LAST:event_clientControlledPatternSelected

private void standAlonePatternSelected(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_standAlonePatternSelected
    setDescription();
    fireChange();    
}//GEN-LAST:event_standAlonePatternSelected

    private void containerRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_containerRadioButtonActionPerformed
        setDescription();
        fireChange();
}//GEN-LAST:event_containerRadioButtonActionPerformed
                
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton clientControlledRadioButton;
    private javax.swing.JRadioButton containerRadioButton;
    private javax.swing.JEditorPane descriptionEditorPane;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.ButtonGroup patternButtons;
    private javax.swing.JRadioButton standAloneRadioButton;
    // End of variables declaration//GEN-END:variables
    
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        return true;
    }
    
    public void read(WizardDescriptor settings) {
        Pattern p = (Pattern) settings.getProperty(WizardProperties.PATTERN_SELECTION);
        if (p == Pattern.CONTAINER) {
            patternButtons.setSelected(containerRadioButton.getModel(), true);
        } else if (p == Pattern.CLIENTCONTROLLED) {
            patternButtons.setSelected(clientControlledRadioButton.getModel(), true);
        } else { // default
            patternButtons.setSelected(standAloneRadioButton.getModel(), true);
        }
        setDescription();
    }
    
    public void store(WizardDescriptor settings) {
        Pattern p;
        if (containerRadioButton.isSelected()) {
            p = Pattern.CONTAINER;
        } else if (clientControlledRadioButton.isSelected()) {
            p = Pattern.CLIENTCONTROLLED;
        } else {
            p = Pattern.STANDALONE;
        }
        settings.putProperty(WizardProperties.PATTERN_SELECTION, p);
    }
    
    private void setDescription() {
        descriptionEditorPane.setContentType("text/html");
        String bundleKey;
        if (containerRadioButton.isSelected()) {
            bundleKey = "DESC_Container_Pattern";
        } else if (clientControlledRadioButton.isSelected()) {
            bundleKey = "DESC_Client_Control_Pattern";
        } else {
            bundleKey = "DESC_Singleton_Pattern";
        }
        String text = NbBundle.getMessage(this.getClass(), bundleKey);
        descriptionEditorPane.setText(text);
        descriptionEditorPane.setCaretPosition(0);
        descriptionEditorPane.putClientProperty( JEditorPane.HONOR_DISPLAY_PROPERTIES, Boolean.TRUE );
    }
    
    public void addChangeListener(ChangeListener listener) {
        listeners.add(listener);
    }
    
    public void fireChange() {
        ChangeEvent event =  new ChangeEvent(this);
        
        for (ChangeListener listener : listeners) {
            listener.stateChanged(event);
        }
    }
    
}
