/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.css.lib;

import org.antlr.runtime.CommonToken;

/**
 *
 * @author marekfukala
 */
public class CommonTokenUtil {

    /**
     * Returns a pointer to the start and end of the token image in the
     * underlaying stream. The token.getStopIndex() points to the last character
     * of the token which is a bit confusing.
     *
     * Use this method to get CommonToken's boundaries instead of using the
     * getStart/StopIndex methods.
     *
     * @return two members array - arr[0] is the start offset, arr[1] is the end
     * offset
     */
    public static int[] getCommonTokenOffsetRange(CommonToken token) {
        if (token.getType() == CommonToken.EOF) {
            //"eof token" points at the end offset of the source, with zero length
            return new int[]{token.getStartIndex(), token.getStopIndex()};
        } else {
            return new int[]{token.getStartIndex(), token.getStopIndex() + 1};
        }

    }
}
