/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* $Id$ */

//copied from package org.netbeans.modules.form.editors;
package org.netbeans.modules.beans.beaninfo;

import org.openide.nodes.Node;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

/**
 *
 * @author  Pavel Buzek
 * @version
 */
public class CustomCodeEditor extends javax.swing.JPanel
                              implements EnhancedCustomPropertyEditor {

    private Node.Property property;

    static final long serialVersionUID =-7413680598253484271L;

    /** Creates new form CustomCodeEditor */
    public CustomCodeEditor(Node.Property property) {
        this.property = property;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        codeEditorPane = new javax.swing.JEditorPane();
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;

        codeEditorPane.setContentType("text/x-java"); // NOI18N
        try {
            String propVal = (String) property.getValue();
            if(  propVal == null )   //be carefull about null value
                propVal = "";
            codeEditorPane.setText(propVal);
        } catch (java.lang.reflect.InvocationTargetException e1) {
            e1.printStackTrace();
        } catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }

        jScrollPane1.setViewportView(codeEditorPane);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(8, 8, 8, 8);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints1);
    }

    public Object getPropertyValue() throws IllegalStateException {
        if( codeEditorPane.getText() != null && codeEditorPane.getText().length() == 0 )
            return null;
        else
            return codeEditorPane.getText();
    }

    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JEditorPane codeEditorPane;
    // End of variables declaration
}
