/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javafx2.project.ui;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;

/**
 *
 * @author psomol
 */
public class JFXApplicationPanel extends javax.swing.JPanel {

    private static JFXProjectProperties jfxProps = null;

    /**
     * Creates new form JFXApplicationPanel
     */
    public JFXApplicationPanel(JFXProjectProperties properties) {
        initComponents();
        jfxProps = properties;
        textFieldVer.getDocument().addDocumentListener(new DocumentListener() {
            @Override
            public void insertUpdate(DocumentEvent e) {
                changed();
            }
            @Override
            public void removeUpdate(DocumentEvent e) {
                changed();
            }
            @Override
            public void changedUpdate(DocumentEvent e) {}
            void changed() {
                String v = textFieldVer.getText();
                jfxProps.setImplementationVersion(v);
            }
        });
        String ver = jfxProps.getImplementationVersion();
        textFieldVer.setText(ver);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labelVer = new javax.swing.JLabel();
        textFieldVer = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        labelVer.setLabelFor(textFieldVer);
        org.openide.awt.Mnemonics.setLocalizedText(labelVer, org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "JFXApplicationPanel.labelVer.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(14, 1, 10, 0);
        add(labelVer, gridBagConstraints);
        labelVer.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "AN_JFXApplicationPanel.labelVer.text")); // NOI18N
        labelVer.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "AD_JFXApplicationPanel.labelVer.text")); // NOI18N

        textFieldVer.setText(org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "JFXApplicationPanel.textFieldVer.text")); // NOI18N
        textFieldVer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                textFieldVerActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 160;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 5);
        add(textFieldVer, gridBagConstraints);
        textFieldVer.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "AN_JFXApplicationPanel.textFieldVer.text")); // NOI18N
        textFieldVer.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JFXApplicationPanel.class, "AD_JFXApplicationPanel.textFieldVer.text")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void textFieldVerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_textFieldVerActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_textFieldVerActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelVer;
    private javax.swing.JTextField textFieldVer;
    // End of variables declaration//GEN-END:variables
}
