# Copyright 2013 Mellanox Technologies, Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.


_FATAL_EXCEPTION_FORMAT_ERRORS = False


class BaseException(Exception):

    message = "An unknown exception occurred"

    def __init__(self, **kwargs):
        try:
            self._error_string = self.message % kwargs

        except Exception as e:
            if _FATAL_EXCEPTION_FORMAT_ERRORS:
                raise e
            self._error_string = self.message

    def __str__(self):
        return self._error_string


class MlxException(BaseException):
    def __init__(self, message=None):
        self.message = message

    def __str__(self):
        return 'MlxException: %s' % self.message
