## Heads up!

Breaking changes in v2.0! See the [release history](#release-history) for details.

## Usage

```js
const has = require('{%= name %}');

console.log(has()) //=> true
console.log(has('foo')) //=> true
```

**Works for:**

  - booleans
  - functions
  - numbers 
  - strings
  - nulls
  - object
  - arrays

**isEmpty**

To do the opposite and test for empty values, do:

```js
const isEmpty = (...args) => !has(...args);
```

## Supported types

### Arrays

```js
console.log(has({ foo: { bar: ['a'] } }, 'foo.bar'));    //=> true
console.log(has({ foo: { bar: [0] } }, 'foo.bar'));      //=> true
console.log(has({ foo: { bar: [[[]]] } }, 'foo.bar'));   //=> false
console.log(has({ foo: { bar: [[], []] } }, 'foo.bar')); //=> false
console.log(has({ foo: { bar: [] } }, 'foo.bar'));       //=> false
```

### Booleans

```js
console.log(has({ foo: { bar: true } }, 'foo.bar'));  //=> true
console.log(has({ foo: { bar: false } }, 'foo.bar')); //=> true
```

### Buffers

```js
console.log(has({ foo: { bar: new Buffer() } }, 'foo.bar'));      //=> false
console.log(has({ foo: { bar: new Buffer('foo') } }, 'foo.bar')); //=> true
```

### Dates

Dates are always true. 

```js
console.log(has({ foo: { bar: new Date() } }, 'foo.bar')); //=> true
```

### Errors

Returns `false` if `err.message` is an empty string.

```js
console.log(has({ foo: { bar: new Error() } }, 'foo.bar'));      //=> false
console.log(has({ foo: { bar: new Error('foo') } }, 'foo.bar')); //=> true
```

### Functions

Functions are always true. 

```js
console.log(has({ foo: { bar: function(foo) {} } }, 'foo.bar')); //=> true
console.log(has({ foo: { bar: function() {} } }, 'foo.bar'));    //=> true
```

### Maps

```js
console.log(has({ foo: { bar: new Map() } }, 'foo.bar'));                 //=> false
console.log(has({ foo: { bar: new Map([['foo', 'bar']]) } }, 'foo.bar')); //=> true
```

### Null

`null` is always true, as it's assumed that this is a user-defined value, versus `undefined` which is not.

```js
console.log(has({ foo: { bar: null } }, 'foo.bar')); //=> true
```

### Objects

```js
console.log(has({ foo: { bar: {} } }, 'foo.bar')); //=> false
console.log(has({ foo: { bar: { a: 'a' }} } }, 'foo.bar'));        //=> true
console.log(has({ foo: { bar: { foo: undefined } } }, 'foo.bar')); //=> false
console.log(has({ foo: { bar: { foo: null } } }, 'foo.bar'));      //=> true
```

### Numbers

```js
console.log(has({ foo: { bar: 1 } }, 'foo.bar')); //=> true
console.log(has({ foo: { bar: 0 } }, 'foo.bar')); //=> true
```

### Regular expressions

```js
console.log(has({ foo: { bar: new RegExp() } }, 'foo.bar'));      //=> false
console.log(has({ foo: { bar: new RegExp('foo') } }, 'foo.bar')); //=> true
```

### Sets

```js
console.log(has({ foo: { bar: new Set() } }, 'foo.bar'));               //=> false
console.log(has({ foo: { bar: new Set(['foo', 'bar']) } }, 'foo.bar')); //=> true
```

### Strings

```js
console.log(has({ foo: { bar: 'a' } }, 'foo.bar')); //=> true
console.log(has({ foo: { bar: '' } }, 'foo.bar'));  //=> false
```

## Undefined

```js
console.log(has({ foo: { bar:  } }, 'foo.bar'));          //=> false
console.log(has({ foo: { bar: void 0 } }, 'foo.bar'));    //=> false
console.log(has({ foo: { bar: undefined } }, 'foo.bar')); //=> false
```


## Release history

### v2.0.0

**Breaking changes**

* Now returns false if the first argument is not an object, function or array, and the second argument is not a string or array.

### v1.0.0

* `zero` always returns true
* `array` now recurses, so that an array of empty arrays will return `false`
* `null` now returns true
