---
id: why-web-components
title: Why Web Components?
sidebar_label: Why Web Components?
custom_edit_url: https://github.com/microsoft/fast/edit/master/sites/website/src/docs/resources/why-web-components.md
description: Performance, interoperability, and compatibility are a few reasons you might choose Web Components.
keywords:
  - web components
  - performance
  - interoperability
  - compatibility
---

### You might choose Web Components for performance. 

Web Components have proven to be consistently faster than many popular JavaScript frameworks when it comes to both startup time and paint performance. They also use less memory and often result in significantly smaller bundle sizes when compared to their JavaScript counterparts. Standard benchmarks show our component implementation outperforming React, Angular 12, Vue 3.2 as well as many others.

### You might use Web Components for their interoperability. 

Every Web Component inherits from HTMLElement. So, Web Components seamlessly interoperate with any library or framework designed to work with DOM. This includes modern frameworks like React, Angular, Vue, etc. but also libraries like jQuery and others. Adopting Web Components enables use of a consistent component library across a diverse set of applications. So, teams can standardize on the components and design system without having to force a specific architecture or framework on the application developer.

### You might leverage Web Components because they can be incrementally adopted.

You do not have to re-write an existing app or site to take advantage of Web Components. Since Web Components just extend the palette of available HTML elements, you can choose to simply start leveraging whatever custom elements you want within your existing app the same way as you use built-in elements.

### You might choose Web Components to be future-compatible with the open web.

Web Components are *literally*, the standard component model of the web, written into the HTML specification. The base features have shipped in every modern browser and many new features are planned for the DOM and CSS standards. Some of these new HTML capabilities will only be available to Web Components, so continuing down the path of non-standard component models will prevent you from taking advantage of platform improvements. Aligning yourself with Web Components and other standards will enable you to get the greatest benefit from the evolving web platform.

### You might choose Web Components if you are creating an extensible ecosystem or application with a plugin model. 

By choosing web components, you enable your customers to choose their preferred application framework or library, rather than forcing them to use any particular JavaScript framework. Building your ecosystem or plugin model around one framework often means the exclusion of an entire set of customers who build on another.

### You might choose Web Components if you want to include community members who are not proficient with JavaScript.
Most of the popular JavaScript frameworks require strong JavaScript skills and knowledge and often at least an intermediate proficiency for use. Web Components can be used without any knowledge of JavaScript whatsoever. Building around Web Components opens up opportunities for a broader range of customers with more diverse backgrounds.

### Who is using Web Components?
Across the industry, we see a pretty big adoption since January 2020. This includes not only heavy investment from Microsoft, but also from Google, Adobe, Salesforce, SAP, MIT, SpaceX, and many more. Curious who else is using Web Components? Check out the ever-growing list of companies [here](https://arewebcomponentsathingyet.com/).