# snapdragon-stack [![NPM version](https://img.shields.io/npm/v/snapdragon-stack.svg?style=flat)](https://www.npmjs.com/package/snapdragon-stack) [![NPM monthly downloads](https://img.shields.io/npm/dm/snapdragon-stack.svg?style=flat)](https://npmjs.org/package/snapdragon-stack) [![NPM total downloads](https://img.shields.io/npm/dt/snapdragon-stack.svg?style=flat)](https://npmjs.org/package/snapdragon-stack) [![Linux Build Status](https://img.shields.io/travis/here-be/snapdragon-stack.svg?style=flat&label=Travis)](https://travis-ci.org/here-be/snapdragon-stack)

> Snapdragon utility for creating a stack.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save snapdragon-stack
```

## Usage

```js
const Stack = require('snapdragon-stack');
```

## API

### [.first](index.js#L26)

Get the first element in the stack.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
stack.push('a');
stack.push('b');
stack.push('c');
console.log(stack.first()); //=> 'a'
```

### [.lookbehind](index.js#L49)

Get the `n`th element from the end of the stack.

**Params**

* `n` **{Number}**
* `returns` **{Object}**

**Example**

```js
const stack = new Stack();
stack.push('aaa');
stack.push('bbb');
stack.push('ccc');
stack.push('ddd');
console.log(stack.lookbehind(1)); //=> 'ddd'
console.log(stack.lookbehind(2)); //=> 'ccc'
console.log(stack.lookbehind(3)); //=> 'bbb'
```

### [.last](index.js#L69)

Get the last element in the stack.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
stack.push('a');
stack.push('b');
stack.push('c');
console.log(stack.last()); //=> 'c'
```

### [.current](index.js#L86)

Semantic alias for `stack.last()`.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
stack.push({ type: 'root' });
console.log(stack.current()); //=> { type: 'root' }
```

### [.prev](index.js#L105)

Get the second-to-last item in the stack.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
stack.push('a');
stack.push('b');
stack.push('c');
console.log(stack.prev()); //=> 'b'
```

### [.firstChild](index.js#L130)

If the [.first](#first) element in the stack is an object with a `.nodes` array, the first item from `stack.first().nodes` is returned.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
const Node = require('snapdragon-node');

const node = new Node({ type: 'brace' });
node.push(new Node({ type: 'brace.open', value: '{' }));
node.push(new Node({ type: 'text', value: 'a,b,c' }));
node.push(new Node({ type: 'brace.close', value: '}' }));

stack.push(node);
console.log(stack.firstChild()); //=> Node { type: 'brace.open', value: '{' }
```

### [.lastChild](index.js#L158)

If the [.last](#last) element in the stack is an object with a `.nodes` array, the last item from `last.nodes` is returned.

* `returns` **{any}**

**Example**

```js
const Stack = require('snapdragon-stack');
const Node = require('snapdragon-node');

const node = new Node({ type: 'brace' });
node.push(new Node({ type: 'brace.open', value: '{' }));
node.push(new Node({ type: 'text', value: 'a,b,c' }));
node.push(new Node({ type: 'brace.close', value: '}' }));

stack.push(node);
console.log(stack.lastChild()); //=> Node { type: 'brace.close', value: '}' }
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>
<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Author

**Jon Schlinkert**

* [linkedin/in/jonschlinkert](https://linkedin.com/in/jonschlinkert)
* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on January 21, 2018._