/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var arrayfun = require( './../../tools/array-like-function' );
var isTruthy = require( './../../is-truthy' );


// MAIN //

/**
* Tests if a value is an array-like object containing only truthy values.
*
* @name isTruthyArray
* @type {Function}
* @param {*} value - value to test
* @returns {boolean} boolean indicating whether an input value is an array-like object containing only truthy values
*
* @example
* var bool = isTruthyArray( [ {}, [] ] );
* // returns true
*
* bool = isTruthyArray( [ false, null, void 0, '', 0, NaN ] );
* // returns false
*
* bool = isTruthyArray( [] );
* // returns false
*/
var isTruthyArray = arrayfun( isTruthy );


// EXPORTS //

module.exports = isTruthyArray;
