/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Difference between one and the smallest value greater than one that can be represented as a single-precision floating-point number.
*
* @example
* var eps = FLOAT32_EPSILON;
* // returns 1.1920928955078125e-7
*/
declare const FLOAT32_EPSILON: number;


// EXPORTS //

export = FLOAT32_EPSILON;
