/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Number of months in a year.
*
* @module @stdlib/constants/time/months-in-year
* @type {integer32}
*
* @example
* var MONTHS_IN_YEAR = require( '@stdlib/constants/time/months-in-year' );
* // returns 12
*/


// MAIN //

/**
* The number of months in a year.
*
* @constant
* @type {integer32}
* @default 12
*/
var MONTHS_IN_YEAR = 12|0; // asm type annotation


// EXPORTS //

module.exports = MONTHS_IN_YEAR;
