/**
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* US birth data from 1994 to 2003, as provided by the Center for Disease Control and Prevention's National Center for Health Statistics.
*
* @module @stdlib/datasets/cdc-nchs-us-births-1994-2003
*
* @example
* var dataset = require( '@stdlib/datasets/cdc-nchs-us-births-1994-2003' );
* var data = dataset();
* // returns [ {...}, ... ]
*/

// MODULES //

var dataset = require( './main.js' );


// EXPORTS //

module.exports = dataset;
