/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var reExtendedLengthPath = require( './main.js' );


// MAIN //

/**
* Matches an extended-length path.
*
* Regular Expression: `/^\\\\\?\\.+/`
*
* -   `/^\\\\?\\`
*     -   match a string that begins with two backward slashes `\\\\` followed by a `?` and then a backward slash `\\`
*
* -   `.+`
*     -   match any character which occurs one or more times
*
* @constant
* @type {RegExp}
* @default /^\\\\\?\\.+/
* @see [MSDN]{@link https://msdn.microsoft.com/en-us/library/windows/desktop/aa365247(v=vs.85).aspx}
*/
var REGEXP = reExtendedLengthPath();


// EXPORTS //

module.exports = REGEXP;
