/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "stdlib/stats/base/sstdevpn.h"
#include "stdlib/stats/base/svariancepn.h"
#include <stdint.h>
#include <math.h>

/**
* Computes the standard deviation of a single-precision floating-point strided array using a two-pass algorithm.
*
* @param N           number of indexed elements
* @param correction  degrees of freedom adjustment
* @param X           input array
* @param stride      stride length
* @return            output value
*/
float stdlib_strided_sstdevpn( const int64_t N, const float correction, const float *X, const int64_t stride ) {
	return sqrtf( stdlib_strided_svariancepn( N, correction, X, stride ) );
}
