/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import unshift = require( './index' );


// TESTS //

// The function returns the updated input collection ...
{
	unshift( [ 2, 3 ], 1 ); // $ExpectType Collection
	unshift( [ 'a', 'b', 'c' ], 'z' ); // $ExpectType Collection
	unshift( [ true, false ], false ); // $ExpectType Collection
	unshift( [ true, true ], true ); // $ExpectType Collection
}

// The compiler throws an error if the function is provided a first argument which is not a collection...
{
	unshift( true ); // $ExpectError
	unshift( false ); // $ExpectError
	unshift( 5 ); // $ExpectError
}

// The compiler throws an error if the function is not provided at least one argument...
{
	unshift(); // $ExpectError
}
