import { array } from './ArrayArbitrary.js';
import { ascii, base64, char, char16bits, fullUnicode, hexa, unicode } from './CharacterArbitrary.js';
function StringArbitrary(charArb, aLength, bLength) {
    var arrayArb = aLength != null ? (bLength != null ? array(charArb, aLength, bLength) : array(charArb, aLength)) : array(charArb);
    return arrayArb.map(function (tab) { return tab.join(''); });
}
function Base64StringArbitrary(minLength, maxLength) {
    if (minLength > maxLength)
        throw new Error('Minimal length should be inferior or equal to maximal length');
    if (minLength % 4 !== 0)
        throw new Error('Minimal length of base64 strings must be a multiple of 4');
    if (maxLength % 4 !== 0)
        throw new Error('Maximal length of base64 strings must be a multiple of 4');
    return StringArbitrary(base64(), minLength, maxLength).map(function (s) {
        switch (s.length % 4) {
            case 0:
                return s;
            case 3:
                return s + "=";
            case 2:
                return s + "==";
            default:
                return s.slice(1);
        }
    });
}
function stringOf(charArb, aLength, bLength) {
    return StringArbitrary(charArb, aLength, bLength);
}
function string(aLength, bLength) {
    return StringArbitrary(char(), aLength, bLength);
}
function asciiString(aLength, bLength) {
    return StringArbitrary(ascii(), aLength, bLength);
}
function string16bits(aLength, bLength) {
    return StringArbitrary(char16bits(), aLength, bLength);
}
function unicodeString(aLength, bLength) {
    return StringArbitrary(unicode(), aLength, bLength);
}
function fullUnicodeString(aLength, bLength) {
    return StringArbitrary(fullUnicode(), aLength, bLength);
}
function hexaString(aLength, bLength) {
    return StringArbitrary(hexa(), aLength, bLength);
}
function base64String(aLength, bLength) {
    var minLength = aLength != null && bLength != null ? aLength : 0;
    var maxLength = bLength == null ? (aLength == null ? 16 : aLength) : bLength;
    return Base64StringArbitrary(minLength + 3 - ((minLength + 3) % 4), maxLength - (maxLength % 4));
}
export { stringOf, string, asciiString, string16bits, unicodeString, fullUnicodeString, hexaString, base64String };
