# coding=UTF-8
# Copyright 2014 Google Inc. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Information about various character and glyph sets."""

# From http://www.microsoft.com/typography/otspec/wgl4.htm
WGL4 = [
    0x0020,  #   SPACE
    0x0021,  # ! EXCLAMATION MARK
    0x0022,  # " QUOTATION MARK
    0x0023,  # # NUMBER SIGN
    0x0024,  # $ DOLLAR SIGN
    0x0025,  # % PERCENT SIGN
    0x0026,  # & AMPERSAND
    0x0027,  # ' APOSTROPHE
    0x0028,  # ( LEFT PARENTHESIS
    0x0029,  # ) RIGHT PARENTHESIS
    0x002A,  # * ASTERISK
    0x002B,  # + PLUS SIGN
    0x002C,  # , COMMA
    0x002D,  # - HYPHEN-MINUS
    0x002E,  # . FULL STOP
    0x002F,  # / SOLIDUS
    0x0030,  # 0 DIGIT ZERO
    0x0031,  # 1 DIGIT ONE
    0x0032,  # 2 DIGIT TWO
    0x0033,  # 3 DIGIT THREE
    0x0034,  # 4 DIGIT FOUR
    0x0035,  # 5 DIGIT FIVE
    0x0036,  # 6 DIGIT SIX
    0x0037,  # 7 DIGIT SEVEN
    0x0038,  # 8 DIGIT EIGHT
    0x0039,  # 9 DIGIT NINE
    0x003A,  # : COLON
    0x003B,  # ; SEMICOLON
    0x003C,  # < LESS-THAN SIGN
    0x003D,  # = EQUALS SIGN
    0x003E,  # > GREATER-THAN SIGN
    0x003F,  # ? QUESTION MARK
    0x0040,  # @ COMMERCIAL AT
    0x0041,  # A LATIN CAPITAL LETTER A
    0x0042,  # B LATIN CAPITAL LETTER B
    0x0043,  # C LATIN CAPITAL LETTER C
    0x0044,  # D LATIN CAPITAL LETTER D
    0x0045,  # E LATIN CAPITAL LETTER E
    0x0046,  # F LATIN CAPITAL LETTER F
    0x0047,  # G LATIN CAPITAL LETTER G
    0x0048,  # H LATIN CAPITAL LETTER H
    0x0049,  # I LATIN CAPITAL LETTER I
    0x004A,  # J LATIN CAPITAL LETTER J
    0x004B,  # K LATIN CAPITAL LETTER K
    0x004C,  # L LATIN CAPITAL LETTER L
    0x004D,  # M LATIN CAPITAL LETTER M
    0x004E,  # N LATIN CAPITAL LETTER N
    0x004F,  # O LATIN CAPITAL LETTER O
    0x0050,  # P LATIN CAPITAL LETTER P
    0x0051,  # Q LATIN CAPITAL LETTER Q
    0x0052,  # R LATIN CAPITAL LETTER R
    0x0053,  # S LATIN CAPITAL LETTER S
    0x0054,  # T LATIN CAPITAL LETTER T
    0x0055,  # U LATIN CAPITAL LETTER U
    0x0056,  # V LATIN CAPITAL LETTER V
    0x0057,  # W LATIN CAPITAL LETTER W
    0x0058,  # X LATIN CAPITAL LETTER X
    0x0059,  # Y LATIN CAPITAL LETTER Y
    0x005A,  # Z LATIN CAPITAL LETTER Z
    0x005B,  # [ LEFT SQUARE BRACKET
    0x005C,  # \ REVERSE SOLIDUS
    0x005D,  # ] RIGHT SQUARE BRACKET
    0x005E,  # ^ CIRCUMFLEX ACCENT
    0x005F,  # _ LOW LINE
    0x0060,  # ` GRAVE ACCENT
    0x0061,  # a LATIN SMALL LETTER A
    0x0062,  # b LATIN SMALL LETTER B
    0x0063,  # c LATIN SMALL LETTER C
    0x0064,  # d LATIN SMALL LETTER D
    0x0065,  # e LATIN SMALL LETTER E
    0x0066,  # f LATIN SMALL LETTER F
    0x0067,  # g LATIN SMALL LETTER G
    0x0068,  # h LATIN SMALL LETTER H
    0x0069,  # i LATIN SMALL LETTER I
    0x006A,  # j LATIN SMALL LETTER J
    0x006B,  # k LATIN SMALL LETTER K
    0x006C,  # l LATIN SMALL LETTER L
    0x006D,  # m LATIN SMALL LETTER M
    0x006E,  # n LATIN SMALL LETTER N
    0x006F,  # o LATIN SMALL LETTER O
    0x0070,  # p LATIN SMALL LETTER P
    0x0071,  # q LATIN SMALL LETTER Q
    0x0072,  # r LATIN SMALL LETTER R
    0x0073,  # s LATIN SMALL LETTER S
    0x0074,  # t LATIN SMALL LETTER T
    0x0075,  # u LATIN SMALL LETTER U
    0x0076,  # v LATIN SMALL LETTER V
    0x0077,  # w LATIN SMALL LETTER W
    0x0078,  # x LATIN SMALL LETTER X
    0x0079,  # y LATIN SMALL LETTER Y
    0x007A,  # z LATIN SMALL LETTER Z
    0x007B,  # { LEFT CURLY BRACKET
    0x007C,  # | VERTICAL LINE
    0x007D,  # } RIGHT CURLY BRACKET
    0x007E,  # ~ TILDE
    0x00A0,  #   NO-BREAK SPACE
    0x00A1,  # ¡ INVERTED EXCLAMATION MARK
    0x00A2,  # ¢ CENT SIGN
    0x00A3,  # £ POUND SIGN
    0x00A4,  # ¤ CURRENCY SIGN
    0x00A5,  # ¥ YEN SIGN
    0x00A6,  # ¦ BROKEN BAR
    0x00A7,  # § SECTION SIGN
    0x00A8,  # ¨ DIAERESIS
    0x00A9,  # © COPYRIGHT SIGN
    0x00AA,  # ª FEMININE ORDINAL INDICATOR
    0x00AB,  # « LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00AC,  # ¬ NOT SIGN
    0x00AD,  # ­ SOFT HYPHEN
    0x00AE,  # ® REGISTERED SIGN
    0x00AF,  # ¯ MACRON
    0x00B0,  # ° DEGREE SIGN
    0x00B1,  # ± PLUS-MINUS SIGN
    0x00B2,  # ² SUPERSCRIPT TWO
    0x00B3,  # ³ SUPERSCRIPT THREE
    0x00B4,  # ´ ACUTE ACCENT
    0x00B5,  # µ MICRO SIGN
    0x00B6,  # ¶ PILCROW SIGN
    0x00B7,  # · MIDDLE DOT
    0x00B8,  # ¸ CEDILLA
    0x00B9,  # ¹ SUPERSCRIPT ONE
    0x00BA,  # º MASCULINE ORDINAL INDICATOR
    0x00BB,  # » RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00BD,  # ½ VULGAR FRACTION ONE HALF
    0x00BE,  # ¾ VULGAR FRACTION THREE QUARTERS
    0x00BF,  # ¿ INVERTED QUESTION MARK
    0x00C0,  # À LATIN CAPITAL LETTER A WITH GRAVE
    0x00C1,  # Á LATIN CAPITAL LETTER A WITH ACUTE
    0x00C2,  # Â LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x00C3,  # Ã LATIN CAPITAL LETTER A WITH TILDE
    0x00C4,  # Ä LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00C5,  # Å LATIN CAPITAL LETTER A WITH RING ABOVE
    0x00C6,  # Æ LATIN CAPITAL LETTER AE
    0x00C7,  # Ç LATIN CAPITAL LETTER C WITH CEDILLA
    0x00C8,  # È LATIN CAPITAL LETTER E WITH GRAVE
    0x00C9,  # É LATIN CAPITAL LETTER E WITH ACUTE
    0x00CA,  # Ê LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x00CB,  # Ë LATIN CAPITAL LETTER E WITH DIAERESIS
    0x00CC,  # Ì LATIN CAPITAL LETTER I WITH GRAVE
    0x00CD,  # Í LATIN CAPITAL LETTER I WITH ACUTE
    0x00CE,  # Î LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x00CF,  # Ï LATIN CAPITAL LETTER I WITH DIAERESIS
    0x00D0,  # Ð LATIN CAPITAL LETTER ETH
    0x00D1,  # Ñ LATIN CAPITAL LETTER N WITH TILDE
    0x00D2,  # Ò LATIN CAPITAL LETTER O WITH GRAVE
    0x00D3,  # Ó LATIN CAPITAL LETTER O WITH ACUTE
    0x00D4,  # Ô LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00D5,  # Õ LATIN CAPITAL LETTER O WITH TILDE
    0x00D6,  # Ö LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00D7,  # × MULTIPLICATION SIGN
    0x00D8,  # Ø LATIN CAPITAL LETTER O WITH STROKE
    0x00D9,  # Ù LATIN CAPITAL LETTER U WITH GRAVE
    0x00DA,  # Ú LATIN CAPITAL LETTER U WITH ACUTE
    0x00DB,  # Û LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x00DC,  # Ü LATIN CAPITAL LETTER U WITH DIAERESIS
    0x00DD,  # Ý LATIN CAPITAL LETTER Y WITH ACUTE
    0x00DE,  # Þ LATIN CAPITAL LETTER THORN
    0x00DF,  # ß LATIN SMALL LETTER SHARP S
    0x00E0,  # à LATIN SMALL LETTER A WITH GRAVE
    0x00E1,  # á LATIN SMALL LETTER A WITH ACUTE
    0x00E2,  # â LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x00E3,  # ã LATIN SMALL LETTER A WITH TILDE
    0x00E4,  # ä LATIN SMALL LETTER A WITH DIAERESIS
    0x00E5,  # å LATIN SMALL LETTER A WITH RING ABOVE
    0x00E6,  # æ LATIN SMALL LETTER AE
    0x00E7,  # ç LATIN SMALL LETTER C WITH CEDILLA
    0x00E8,  # è LATIN SMALL LETTER E WITH GRAVE
    0x00E9,  # é LATIN SMALL LETTER E WITH ACUTE
    0x00EA,  # ê LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x00EB,  # ë LATIN SMALL LETTER E WITH DIAERESIS
    0x00EC,  # ì LATIN SMALL LETTER I WITH GRAVE
    0x00ED,  # í LATIN SMALL LETTER I WITH ACUTE
    0x00EE,  # î LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x00EF,  # ï LATIN SMALL LETTER I WITH DIAERESIS
    0x00F0,  # ð LATIN SMALL LETTER ETH
    0x00F1,  # ñ LATIN SMALL LETTER N WITH TILDE
    0x00F2,  # ò LATIN SMALL LETTER O WITH GRAVE
    0x00F3,  # ó LATIN SMALL LETTER O WITH ACUTE
    0x00F4,  # ô LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00F5,  # õ LATIN SMALL LETTER O WITH TILDE
    0x00F6,  # ö LATIN SMALL LETTER O WITH DIAERESIS
    0x00F7,  # ÷ DIVISION SIGN
    0x00F8,  # ø LATIN SMALL LETTER O WITH STROKE
    0x00F9,  # ù LATIN SMALL LETTER U WITH GRAVE
    0x00FA,  # ú LATIN SMALL LETTER U WITH ACUTE
    0x00FB,  # û LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x00FC,  # ü LATIN SMALL LETTER U WITH DIAERESIS
    0x00FD,  # ý LATIN SMALL LETTER Y WITH ACUTE
    0x00FE,  # þ LATIN SMALL LETTER THORN
    0x00FF,  # ÿ LATIN SMALL LETTER Y WITH DIAERESIS
    0x0100,  # Ā LATIN CAPITAL LETTER A WITH MACRON
    0x0101,  # ā LATIN SMALL LETTER A WITH MACRON
    0x0102,  # Ă LATIN CAPITAL LETTER A WITH BREVE
    0x0103,  # ă LATIN SMALL LETTER A WITH BREVE
    0x0104,  # Ą LATIN CAPITAL LETTER A WITH OGONEK
    0x0105,  # ą LATIN SMALL LETTER A WITH OGONEK
    0x0106,  # Ć LATIN CAPITAL LETTER C WITH ACUTE
    0x0107,  # ć LATIN SMALL LETTER C WITH ACUTE
    0x0108,  # Ĉ LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    0x0109,  # ĉ LATIN SMALL LETTER C WITH CIRCUMFLEX
    0x010A,  # Ċ LATIN CAPITAL LETTER C WITH DOT ABOVE
    0x010B,  # ċ LATIN SMALL LETTER C WITH DOT ABOVE
    0x010C,  # Č LATIN CAPITAL LETTER C WITH CARON
    0x010D,  # č LATIN SMALL LETTER C WITH CARON
    0x010E,  # Ď LATIN CAPITAL LETTER D WITH CARON
    0x010F,  # ď LATIN SMALL LETTER D WITH CARON
    0x0110,  # Đ LATIN CAPITAL LETTER D WITH STROKE
    0x0111,  # đ LATIN SMALL LETTER D WITH STROKE
    0x0112,  # Ē LATIN CAPITAL LETTER E WITH MACRON
    0x0113,  # ē LATIN SMALL LETTER E WITH MACRON
    0x0114,  # Ĕ LATIN CAPITAL LETTER E WITH BREVE
    0x0115,  # ĕ LATIN SMALL LETTER E WITH BREVE
    0x0116,  # Ė LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x0117,  # ė LATIN SMALL LETTER E WITH DOT ABOVE
    0x0118,  # Ę LATIN CAPITAL LETTER E WITH OGONEK
    0x0119,  # ę LATIN SMALL LETTER E WITH OGONEK
    0x011A,  # Ě LATIN CAPITAL LETTER E WITH CARON
    0x011B,  # ě LATIN SMALL LETTER E WITH CARON
    0x011C,  # Ĝ LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    0x011D,  # ĝ LATIN SMALL LETTER G WITH CIRCUMFLEX
    0x011E,  # Ğ LATIN CAPITAL LETTER G WITH BREVE
    0x011F,  # ğ LATIN SMALL LETTER G WITH BREVE
    0x0120,  # Ġ LATIN CAPITAL LETTER G WITH DOT ABOVE
    0x0121,  # ġ LATIN SMALL LETTER G WITH DOT ABOVE
    0x0122,  # Ģ LATIN CAPITAL LETTER G WITH CEDILLA
    0x0123,  # ģ LATIN SMALL LETTER G WITH CEDILLA
    0x0124,  # Ĥ LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    0x0125,  # ĥ LATIN SMALL LETTER H WITH CIRCUMFLEX
    0x0126,  # Ħ LATIN CAPITAL LETTER H WITH STROKE
    0x0127,  # ħ LATIN SMALL LETTER H WITH STROKE
    0x0128,  # Ĩ LATIN CAPITAL LETTER I WITH TILDE
    0x0129,  # ĩ LATIN SMALL LETTER I WITH TILDE
    0x012A,  # Ī LATIN CAPITAL LETTER I WITH MACRON
    0x012B,  # ī LATIN SMALL LETTER I WITH MACRON
    0x012C,  # Ĭ LATIN CAPITAL LETTER I WITH BREVE
    0x012D,  # ĭ LATIN SMALL LETTER I WITH BREVE
    0x012E,  # Į LATIN CAPITAL LETTER I WITH OGONEK
    0x012F,  # į LATIN SMALL LETTER I WITH OGONEK
    0x0130,  # İ LATIN CAPITAL LETTER I WITH DOT ABOVE
    0x0131,  # ı LATIN SMALL LETTER DOTLESS I
    0x0132,  # Ĳ LATIN CAPITAL LIGATURE IJ
    0x0133,  # ĳ LATIN SMALL LIGATURE IJ
    0x0134,  # Ĵ LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    0x0135,  # ĵ LATIN SMALL LETTER J WITH CIRCUMFLEX
    0x0136,  # Ķ LATIN CAPITAL LETTER K WITH CEDILLA
    0x0137,  # ķ LATIN SMALL LETTER K WITH CEDILLA
    0x0138,  # ĸ LATIN SMALL LETTER KRA
    0x0139,  # Ĺ LATIN CAPITAL LETTER L WITH ACUTE
    0x013A,  # ĺ LATIN SMALL LETTER L WITH ACUTE
    0x013B,  # Ļ LATIN CAPITAL LETTER L WITH CEDILLA
    0x013C,  # ļ LATIN SMALL LETTER L WITH CEDILLA
    0x013D,  # Ľ LATIN CAPITAL LETTER L WITH CARON
    0x013E,  # ľ LATIN SMALL LETTER L WITH CARON
    0x013F,  # Ŀ LATIN CAPITAL LETTER L WITH MIDDLE DOT
    0x0140,  # ŀ LATIN SMALL LETTER L WITH MIDDLE DOT
    0x0141,  # Ł LATIN CAPITAL LETTER L WITH STROKE
    0x0142,  # ł LATIN SMALL LETTER L WITH STROKE
    0x0143,  # Ń LATIN CAPITAL LETTER N WITH ACUTE
    0x0144,  # ń LATIN SMALL LETTER N WITH ACUTE
    0x0145,  # Ņ LATIN CAPITAL LETTER N WITH CEDILLA
    0x0146,  # ņ LATIN SMALL LETTER N WITH CEDILLA
    0x0147,  # Ň LATIN CAPITAL LETTER N WITH CARON
    0x0148,  # ň LATIN SMALL LETTER N WITH CARON
    0x0149,  # ŉ LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    0x014A,  # Ŋ LATIN CAPITAL LETTER ENG
    0x014B,  # ŋ LATIN SMALL LETTER ENG
    0x014C,  # Ō LATIN CAPITAL LETTER O WITH MACRON
    0x014D,  # ō LATIN SMALL LETTER O WITH MACRON
    0x014E,  # Ŏ LATIN CAPITAL LETTER O WITH BREVE
    0x014F,  # ŏ LATIN SMALL LETTER O WITH BREVE
    0x0150,  # Ő LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    0x0151,  # ő LATIN SMALL LETTER O WITH DOUBLE ACUTE
    0x0152,  # Œ LATIN CAPITAL LIGATURE OE
    0x0153,  # œ LATIN SMALL LIGATURE OE
    0x0154,  # Ŕ LATIN CAPITAL LETTER R WITH ACUTE
    0x0155,  # ŕ LATIN SMALL LETTER R WITH ACUTE
    0x0156,  # Ŗ LATIN CAPITAL LETTER R WITH CEDILLA
    0x0157,  # ŗ LATIN SMALL LETTER R WITH CEDILLA
    0x0158,  # Ř LATIN CAPITAL LETTER R WITH CARON
    0x0159,  # ř LATIN SMALL LETTER R WITH CARON
    0x015A,  # Ś LATIN CAPITAL LETTER S WITH ACUTE
    0x015B,  # ś LATIN SMALL LETTER S WITH ACUTE
    0x015C,  # Ŝ LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    0x015D,  # ŝ LATIN SMALL LETTER S WITH CIRCUMFLEX
    0x015E,  # Ş LATIN CAPITAL LETTER S WITH CEDILLA
    0x015F,  # ş LATIN SMALL LETTER S WITH CEDILLA
    0x0160,  # Š LATIN CAPITAL LETTER S WITH CARON
    0x0161,  # š LATIN SMALL LETTER S WITH CARON
    0x0162,  # Ţ LATIN CAPITAL LETTER T WITH CEDILLA
    0x0163,  # ţ LATIN SMALL LETTER T WITH CEDILLA
    0x0164,  # Ť LATIN CAPITAL LETTER T WITH CARON
    0x0165,  # ť LATIN SMALL LETTER T WITH CARON
    0x0166,  # Ŧ LATIN CAPITAL LETTER T WITH STROKE
    0x0167,  # ŧ LATIN SMALL LETTER T WITH STROKE
    0x0168,  # Ũ LATIN CAPITAL LETTER U WITH TILDE
    0x0169,  # ũ LATIN SMALL LETTER U WITH TILDE
    0x016A,  # Ū LATIN CAPITAL LETTER U WITH MACRON
    0x016B,  # ū LATIN SMALL LETTER U WITH MACRON
    0x016C,  # Ŭ LATIN CAPITAL LETTER U WITH BREVE
    0x016D,  # ŭ LATIN SMALL LETTER U WITH BREVE
    0x016E,  # Ů LATIN CAPITAL LETTER U WITH RING ABOVE
    0x016F,  # ů LATIN SMALL LETTER U WITH RING ABOVE
    0x0170,  # Ű LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    0x0171,  # ű LATIN SMALL LETTER U WITH DOUBLE ACUTE
    0x0172,  # Ų LATIN CAPITAL LETTER U WITH OGONEK
    0x0173,  # ų LATIN SMALL LETTER U WITH OGONEK
    0x0174,  # Ŵ LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    0x0175,  # ŵ LATIN SMALL LETTER W WITH CIRCUMFLEX
    0x0176,  # Ŷ LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    0x0177,  # ŷ LATIN SMALL LETTER Y WITH CIRCUMFLEX
    0x0178,  # Ÿ LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x0179,  # Ź LATIN CAPITAL LETTER Z WITH ACUTE
    0x017A,  # ź LATIN SMALL LETTER Z WITH ACUTE
    0x017B,  # Ż LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x017C,  # ż LATIN SMALL LETTER Z WITH DOT ABOVE
    0x017D,  # Ž LATIN CAPITAL LETTER Z WITH CARON
    0x017E,  # ž LATIN SMALL LETTER Z WITH CARON
    0x017F,  # ſ LATIN SMALL LETTER LONG S
    0x0192,  # ƒ LATIN SMALL LETTER F WITH HOOK
    0x01FA,  # Ǻ LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
    0x01FB,  # ǻ LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
    0x01FC,  # Ǽ LATIN CAPITAL LETTER AE WITH ACUTE
    0x01FD,  # ǽ LATIN SMALL LETTER AE WITH ACUTE
    0x01FE,  # Ǿ LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    0x01FF,  # ǿ LATIN SMALL LETTER O WITH STROKE AND ACUTE
    0x02C6,  # ˆ MODIFIER LETTER CIRCUMFLEX ACCENT
    0x02C7,  # ˇ CARON
    0x02C9,  # ˉ MODIFIER LETTER MACRON
    0x02D8,  # ˘ BREVE
    0x02D9,  # ˙ DOT ABOVE
    0x02DA,  # ˚ RING ABOVE
    0x02DB,  # ˛ OGONEK
    0x02DC,  # ˜ SMALL TILDE
    0x02DD,  # ˝ DOUBLE ACUTE ACCENT
    0x0384,  # ΄ GREEK TONOS
    0x0385,  # ΅ GREEK DIALYTIKA TONOS
    0x0386,  # Ά GREEK CAPITAL LETTER ALPHA WITH TONOS
    0x0387,  # · GREEK ANO TELEIA
    0x0388,  # Έ GREEK CAPITAL LETTER EPSILON WITH TONOS
    0x0389,  # Ή GREEK CAPITAL LETTER ETA WITH TONOS
    0x038A,  # Ί GREEK CAPITAL LETTER IOTA WITH TONOS
    0x038C,  # Ό GREEK CAPITAL LETTER OMICRON WITH TONOS
    0x038E,  # Ύ GREEK CAPITAL LETTER UPSILON WITH TONOS
    0x038F,  # Ώ GREEK CAPITAL LETTER OMEGA WITH TONOS
    0x0390,  # ΐ GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    0x0391,  # Α GREEK CAPITAL LETTER ALPHA
    0x0392,  # Β GREEK CAPITAL LETTER BETA
    0x0393,  # Γ GREEK CAPITAL LETTER GAMMA
    0x0394,  # Δ GREEK CAPITAL LETTER DELTA
    0x0395,  # Ε GREEK CAPITAL LETTER EPSILON
    0x0396,  # Ζ GREEK CAPITAL LETTER ZETA
    0x0397,  # Η GREEK CAPITAL LETTER ETA
    0x0398,  # Θ GREEK CAPITAL LETTER THETA
    0x0399,  # Ι GREEK CAPITAL LETTER IOTA
    0x039A,  # Κ GREEK CAPITAL LETTER KAPPA
    0x039B,  # Λ GREEK CAPITAL LETTER LAMDA
    0x039C,  # Μ GREEK CAPITAL LETTER MU
    0x039D,  # Ν GREEK CAPITAL LETTER NU
    0x039E,  # Ξ GREEK CAPITAL LETTER XI
    0x039F,  # Ο GREEK CAPITAL LETTER OMICRON
    0x03A0,  # Π GREEK CAPITAL LETTER PI
    0x03A1,  # Ρ GREEK CAPITAL LETTER RHO
    0x03A3,  # Σ GREEK CAPITAL LETTER SIGMA
    0x03A4,  # Τ GREEK CAPITAL LETTER TAU
    0x03A5,  # Υ GREEK CAPITAL LETTER UPSILON
    0x03A6,  # Φ GREEK CAPITAL LETTER PHI
    0x03A7,  # Χ GREEK CAPITAL LETTER CHI
    0x03A8,  # Ψ GREEK CAPITAL LETTER PSI
    0x03A9,  # Ω GREEK CAPITAL LETTER OMEGA
    0x03AA,  # Ϊ GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    0x03AB,  # Ϋ GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    0x03AC,  # ά GREEK SMALL LETTER ALPHA WITH TONOS
    0x03AD,  # έ GREEK SMALL LETTER EPSILON WITH TONOS
    0x03AE,  # ή GREEK SMALL LETTER ETA WITH TONOS
    0x03AF,  # ί GREEK SMALL LETTER IOTA WITH TONOS
    0x03B0,  # ΰ GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    0x03B1,  # α GREEK SMALL LETTER ALPHA
    0x03B2,  # β GREEK SMALL LETTER BETA
    0x03B3,  # γ GREEK SMALL LETTER GAMMA
    0x03B4,  # δ GREEK SMALL LETTER DELTA
    0x03B5,  # ε GREEK SMALL LETTER EPSILON
    0x03B6,  # ζ GREEK SMALL LETTER ZETA
    0x03B7,  # η GREEK SMALL LETTER ETA
    0x03B8,  # θ GREEK SMALL LETTER THETA
    0x03B9,  # ι GREEK SMALL LETTER IOTA
    0x03BA,  # κ GREEK SMALL LETTER KAPPA
    0x03BB,  # λ GREEK SMALL LETTER LAMDA
    0x03BC,  # μ GREEK SMALL LETTER MU
    0x03BD,  # ν GREEK SMALL LETTER NU
    0x03BE,  # ξ GREEK SMALL LETTER XI
    0x03BF,  # ο GREEK SMALL LETTER OMICRON
    0x03C0,  # π GREEK SMALL LETTER PI
    0x03C1,  # ρ GREEK SMALL LETTER RHO
    0x03C2,  # ς GREEK SMALL LETTER FINAL SIGMA
    0x03C3,  # σ GREEK SMALL LETTER SIGMA
    0x03C4,  # τ GREEK SMALL LETTER TAU
    0x03C5,  # υ GREEK SMALL LETTER UPSILON
    0x03C6,  # φ GREEK SMALL LETTER PHI
    0x03C7,  # χ GREEK SMALL LETTER CHI
    0x03C8,  # ψ GREEK SMALL LETTER PSI
    0x03C9,  # ω GREEK SMALL LETTER OMEGA
    0x03CA,  # ϊ GREEK SMALL LETTER IOTA WITH DIALYTIKA
    0x03CB,  # ϋ GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    0x03CC,  # ό GREEK SMALL LETTER OMICRON WITH TONOS
    0x03CD,  # ύ GREEK SMALL LETTER UPSILON WITH TONOS
    0x03CE,  # ώ GREEK SMALL LETTER OMEGA WITH TONOS
    0x0400,  # Ѐ CYRILLIC CAPITAL LETTER IE WITH GRAVE
    0x0401,  # Ё CYRILLIC CAPITAL LETTER IO
    0x0402,  # Ђ CYRILLIC CAPITAL LETTER DJE
    0x0403,  # Ѓ CYRILLIC CAPITAL LETTER GJE
    0x0404,  # Є CYRILLIC CAPITAL LETTER UKRAINIAN IE
    0x0405,  # Ѕ CYRILLIC CAPITAL LETTER DZE
    0x0406,  # І CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    0x0407,  # Ї CYRILLIC CAPITAL LETTER YI
    0x0408,  # Ј CYRILLIC CAPITAL LETTER JE
    0x0409,  # Љ CYRILLIC CAPITAL LETTER LJE
    0x040A,  # Њ CYRILLIC CAPITAL LETTER NJE
    0x040B,  # Ћ CYRILLIC CAPITAL LETTER TSHE
    0x040C,  # Ќ CYRILLIC CAPITAL LETTER KJE
    0x040D,  # Ѝ CYRILLIC CAPITAL LETTER I WITH GRAVE
    0x040E,  # Ў CYRILLIC CAPITAL LETTER SHORT U
    0x040F,  # Џ CYRILLIC CAPITAL LETTER DZHE
    0x0410,  # А CYRILLIC CAPITAL LETTER A
    0x0411,  # Б CYRILLIC CAPITAL LETTER BE
    0x0412,  # В CYRILLIC CAPITAL LETTER VE
    0x0413,  # Г CYRILLIC CAPITAL LETTER GHE
    0x0414,  # Д CYRILLIC CAPITAL LETTER DE
    0x0415,  # Е CYRILLIC CAPITAL LETTER IE
    0x0416,  # Ж CYRILLIC CAPITAL LETTER ZHE
    0x0417,  # З CYRILLIC CAPITAL LETTER ZE
    0x0418,  # И CYRILLIC CAPITAL LETTER I
    0x0419,  # Й CYRILLIC CAPITAL LETTER SHORT I
    0x041A,  # К CYRILLIC CAPITAL LETTER KA
    0x041B,  # Л CYRILLIC CAPITAL LETTER EL
    0x041C,  # М CYRILLIC CAPITAL LETTER EM
    0x041D,  # Н CYRILLIC CAPITAL LETTER EN
    0x041E,  # О CYRILLIC CAPITAL LETTER O
    0x041F,  # П CYRILLIC CAPITAL LETTER PE
    0x0420,  # Р CYRILLIC CAPITAL LETTER ER
    0x0421,  # С CYRILLIC CAPITAL LETTER ES
    0x0422,  # Т CYRILLIC CAPITAL LETTER TE
    0x0423,  # У CYRILLIC CAPITAL LETTER U
    0x0424,  # Ф CYRILLIC CAPITAL LETTER EF
    0x0425,  # Х CYRILLIC CAPITAL LETTER HA
    0x0426,  # Ц CYRILLIC CAPITAL LETTER TSE
    0x0427,  # Ч CYRILLIC CAPITAL LETTER CHE
    0x0428,  # Ш CYRILLIC CAPITAL LETTER SHA
    0x0429,  # Щ CYRILLIC CAPITAL LETTER SHCHA
    0x042A,  # Ъ CYRILLIC CAPITAL LETTER HARD SIGN
    0x042B,  # Ы CYRILLIC CAPITAL LETTER YERU
    0x042C,  # Ь CYRILLIC CAPITAL LETTER SOFT SIGN
    0x042D,  # Э CYRILLIC CAPITAL LETTER E
    0x042E,  # Ю CYRILLIC CAPITAL LETTER YU
    0x042F,  # Я CYRILLIC CAPITAL LETTER YA
    0x0430,  # а CYRILLIC SMALL LETTER A
    0x0431,  # б CYRILLIC SMALL LETTER BE
    0x0432,  # в CYRILLIC SMALL LETTER VE
    0x0433,  # г CYRILLIC SMALL LETTER GHE
    0x0434,  # д CYRILLIC SMALL LETTER DE
    0x0435,  # е CYRILLIC SMALL LETTER IE
    0x0436,  # ж CYRILLIC SMALL LETTER ZHE
    0x0437,  # з CYRILLIC SMALL LETTER ZE
    0x0438,  # и CYRILLIC SMALL LETTER I
    0x0439,  # й CYRILLIC SMALL LETTER SHORT I
    0x043A,  # к CYRILLIC SMALL LETTER KA
    0x043B,  # л CYRILLIC SMALL LETTER EL
    0x043C,  # м CYRILLIC SMALL LETTER EM
    0x043D,  # н CYRILLIC SMALL LETTER EN
    0x043E,  # о CYRILLIC SMALL LETTER O
    0x043F,  # п CYRILLIC SMALL LETTER PE
    0x0440,  # р CYRILLIC SMALL LETTER ER
    0x0441,  # с CYRILLIC SMALL LETTER ES
    0x0442,  # т CYRILLIC SMALL LETTER TE
    0x0443,  # у CYRILLIC SMALL LETTER U
    0x0444,  # ф CYRILLIC SMALL LETTER EF
    0x0445,  # х CYRILLIC SMALL LETTER HA
    0x0446,  # ц CYRILLIC SMALL LETTER TSE
    0x0447,  # ч CYRILLIC SMALL LETTER CHE
    0x0448,  # ш CYRILLIC SMALL LETTER SHA
    0x0449,  # щ CYRILLIC SMALL LETTER SHCHA
    0x044A,  # ъ CYRILLIC SMALL LETTER HARD SIGN
    0x044B,  # ы CYRILLIC SMALL LETTER YERU
    0x044C,  # ь CYRILLIC SMALL LETTER SOFT SIGN
    0x044D,  # э CYRILLIC SMALL LETTER E
    0x044E,  # ю CYRILLIC SMALL LETTER YU
    0x044F,  # я CYRILLIC SMALL LETTER YA
    0x0450,  # ѐ CYRILLIC SMALL LETTER IE WITH GRAVE
    0x0451,  # ё CYRILLIC SMALL LETTER IO
    0x0452,  # ђ CYRILLIC SMALL LETTER DJE
    0x0453,  # ѓ CYRILLIC SMALL LETTER GJE
    0x0454,  # є CYRILLIC SMALL LETTER UKRAINIAN IE
    0x0455,  # ѕ CYRILLIC SMALL LETTER DZE
    0x0456,  # і CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    0x0457,  # ї CYRILLIC SMALL LETTER YI
    0x0458,  # ј CYRILLIC SMALL LETTER JE
    0x0459,  # љ CYRILLIC SMALL LETTER LJE
    0x045A,  # њ CYRILLIC SMALL LETTER NJE
    0x045B,  # ћ CYRILLIC SMALL LETTER TSHE
    0x045C,  # ќ CYRILLIC SMALL LETTER KJE
    0x045D,  # ѝ CYRILLIC SMALL LETTER I WITH GRAVE
    0x045E,  # ў CYRILLIC SMALL LETTER SHORT U
    0x045F,  # џ CYRILLIC SMALL LETTER DZHE
    0x0490,  # Ґ CYRILLIC CAPITAL LETTER GHE WITH UPTURN
    0x0491,  # ґ CYRILLIC SMALL LETTER GHE WITH UPTURN
    0x1E80,  # Ẁ LATIN CAPITAL LETTER W WITH GRAVE
    0x1E81,  # ẁ LATIN SMALL LETTER W WITH GRAVE
    0x1E82,  # Ẃ LATIN CAPITAL LETTER W WITH ACUTE
    0x1E83,  # ẃ LATIN SMALL LETTER W WITH ACUTE
    0x1E84,  # Ẅ LATIN CAPITAL LETTER W WITH DIAERESIS
    0x1E85,  # ẅ LATIN SMALL LETTER W WITH DIAERESIS
    0x1EF2,  # Ỳ LATIN CAPITAL LETTER Y WITH GRAVE
    0x1EF3,  # ỳ LATIN SMALL LETTER Y WITH GRAVE
    0x2014,  # — EM DASH
    0x2015,  # ― HORIZONTAL BAR
    0x2017,  # ‗ DOUBLE LOW LINE
    0x2018,  # ‘ LEFT SINGLE QUOTATION MARK
    0x2019,  # ’ RIGHT SINGLE QUOTATION MARK
    0x201A,  # ‚ SINGLE LOW-9 QUOTATION MARK
    0x201B,  # ‛ SINGLE HIGH-REVERSED-9 QUOTATION MARK
    0x201C,  # “ LEFT DOUBLE QUOTATION MARK
    0x201D,  # ” RIGHT DOUBLE QUOTATION MARK
    0x201E,  # „ DOUBLE LOW-9 QUOTATION MARK
    0x2020,  # † DAGGER
    0x2021,  # ‡ DOUBLE DAGGER
    0x2022,  # • BULLET
    0x2026,  # … HORIZONTAL ELLIPSIS
    0x2030,  # ‰ PER MILLE SIGN
    0x2032,  # ′ PRIME
    0x2033,  # ″ DOUBLE PRIME
    0x2039,  # ‹ SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    0x203A,  # › SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    0x203C,  # ‼ DOUBLE EXCLAMATION MARK
    0x203E,  # ‾ OVERLINE
    0x2044,  # ⁄ FRACTION SLASH
    0x207F,  # ⁿ SUPERSCRIPT LATIN SMALL LETTER N
    0x20A3,  # ₣ FRENCH FRANC SIGN
    0x20A4,  # ₤ LIRA SIGN
    0x20A7,  # ₧ PESETA SIGN
    0x20AC,  # € EURO SIGN
    0x2105,  # ℅ CARE OF
    0x2113,  # ℓ SCRIPT SMALL L
    0x2116,  # № NUMERO SIGN
    0x2122,  # ™ TRADE MARK SIGN
    0x2126,  # Ω OHM SIGN
    0x212E,  # ℮ ESTIMATED SYMBOL
    0x215B,  # ⅛ VULGAR FRACTION ONE EIGHTH
    0x215C,  # ⅜ VULGAR FRACTION THREE EIGHTHS
    0x215D,  # ⅝ VULGAR FRACTION FIVE EIGHTHS
    0x215E,  # ⅞ VULGAR FRACTION SEVEN EIGHTHS
    0x2190,  # ← LEFTWARDS ARROW
    0x2191,  # ↑ UPWARDS ARROW
    0x2192,  # → RIGHTWARDS ARROW
    0x2193,  # ↓ DOWNWARDS ARROW
    0x2194,  # ↔ LEFT RIGHT ARROW
    0x2195,  # ↕ UP DOWN ARROW
    0x21A8,  # ↨ UP DOWN ARROW WITH BASE
    0x2202,  # ∂ PARTIAL DIFFERENTIAL
    0x2206,  # ∆ INCREMENT
    0x220F,  # ∏ N-ARY PRODUCT
    0x2211,  # ∑ N-ARY SUMMATION
    0x2212,  # − MINUS SIGN
    0x2215,  # ∕ DIVISION SLASH
    0x2219,  # ∙ BULLET OPERATOR
    0x221A,  # √ SQUARE ROOT
    0x221E,  # ∞ INFINITY
    0x221F,  # ∟ RIGHT ANGLE
    0x2229,  # ∩ INTERSECTION
    0x222B,  # ∫ INTEGRAL
    0x2248,  # ≈ ALMOST EQUAL TO
    0x2260,  # ≠ NOT EQUAL TO
    0x2261,  # ≡ IDENTICAL TO
    0x2264,  # ≤ LESS-THAN OR EQUAL TO
    0x2265,  # ≥ GREATER-THAN OR EQUAL TO
    0x2302,  # ⌂ HOUSE
    0x2310,  # ⌐ REVERSED NOT SIGN
    0x2320,  # ⌠ TOP HALF INTEGRAL
    0x2321,  # ⌡ BOTTOM HALF INTEGRAL
    0x2500,  # ─ BOX DRAWINGS LIGHT HORIZONTAL
    0x2502,  # │ BOX DRAWINGS LIGHT VERTICAL
    0x250C,  # ┌ BOX DRAWINGS LIGHT DOWN AND RIGHT
    0x2510,  # ┐ BOX DRAWINGS LIGHT DOWN AND LEFT
    0x2514,  # └ BOX DRAWINGS LIGHT UP AND RIGHT
    0x2518,  # ┘ BOX DRAWINGS LIGHT UP AND LEFT
    0x251C,  # ├ BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    0x2524,  # ┤ BOX DRAWINGS LIGHT VERTICAL AND LEFT
    0x252C,  # ┬ BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    0x2534,  # ┴ BOX DRAWINGS LIGHT UP AND HORIZONTAL
    0x253C,  # ┼ BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    0x2550,  # ═ BOX DRAWINGS DOUBLE HORIZONTAL
    0x2551,  # ║ BOX DRAWINGS DOUBLE VERTICAL
    0x2552,  # ╒ BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    0x2553,  # ╓ BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    0x2554,  # ╔ BOX DRAWINGS DOUBLE DOWN AND RIGHT
    0x2555,  # ╕ BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    0x2556,  # ╖ BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    0x2557,  # ╗ BOX DRAWINGS DOUBLE DOWN AND LEFT
    0x2558,  # ╘ BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    0x2559,  # ╙ BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    0x255A,  # ╚ BOX DRAWINGS DOUBLE UP AND RIGHT
    0x255B,  # ╛ BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    0x255C,  # ╜ BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    0x255D,  # ╝ BOX DRAWINGS DOUBLE UP AND LEFT
    0x255E,  # ╞ BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    0x255F,  # ╟ BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    0x2560,  # ╠ BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    0x2561,  # ╡ BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    0x2562,  # ╢ BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    0x2563,  # ╣ BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    0x2564,  # ╤ BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    0x2565,  # ╥ BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    0x2566,  # ╦ BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    0x2567,  # ╧ BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    0x2568,  # ╨ BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    0x2569,  # ╩ BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    0x256A,  # ╪ BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    0x256B,  # ╫ BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    0x256C,  # ╬ BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    0x2580,  # ▀ UPPER HALF BLOCK
    0x2584,  # ▄ LOWER HALF BLOCK
    0x2588,  # █ FULL BLOCK
    0x258C,  # ▌ LEFT HALF BLOCK
    0x2590,  # ▐ RIGHT HALF BLOCK
    0x2591,  # ░ LIGHT SHADE
    0x2592,  # ▒ MEDIUM SHADE
    0x2593,  # ▓ DARK SHADE
    0x25A0,  # ■ BLACK SQUARE
    0x25A1,  # □ WHITE SQUARE
    0x25AA,  # ▪ BLACK SMALL SQUARE
    0x25AB,  # ▫ WHITE SMALL SQUARE
    0x25AC,  # ▬ BLACK RECTANGLE
    0x25B2,  # ▲ BLACK UP-POINTING TRIANGLE
    0x25BA,  # ► BLACK RIGHT-POINTING POINTER
    0x25BC,  # ▼ BLACK DOWN-POINTING TRIANGLE
    0x25C4,  # ◄ BLACK LEFT-POINTING POINTER
    0x25CA,  # ◊ LOZENGE
    0x25CB,  # ○ WHITE CIRCLE
    0x25CF,  # ● BLACK CIRCLE
    0x25D8,  # ◘ INVERSE BULLET
    0x25D9,  # ◙ INVERSE WHITE CIRCLE
    0x25E6,  # ◦ WHITE BULLET
    0x263A,  # ☺ WHITE SMILING FACE
    0x263B,  # ☻ BLACK SMILING FACE
    0x263C,  # ☼ WHITE SUN WITH RAYS
    0x2640,  # ♀ FEMALE SIGN
    0x2642,  # ♂ MALE SIGN
    0x2660,  # ♠ BLACK SPADE SUIT
    0x2663,  # ♣ BLACK CLUB SUIT
    0x2665,  # ♥ BLACK HEART SUIT
    0x2666,  # ♦ BLACK DIAMOND SUIT
    0x266A,  # ♪ EIGHTH NOTE
    0x266B,  # ♫ BEAMED EIGHTH NOTES
    0xF001,  #  <Unassigned>
    0xF002,  #  <Unassigned>
    0xFB01,  # ﬁ LATIN SMALL LIGATURE FI
    0xFB02,  # ﬂ LATIN SMALL LIGATURE FL
]

# From https://sites.google.com/site/unicodesymbols/Home/japanese-tv-symbols/arib-unicode-mapping-table
# With additions from http://www.arib.or.jp/english/html/overview/doc/2-STD-B62v1_0-1p2.pdf
ARIB = [
    0x00B2,  # ² SUPERSCRIPT TWO
    0x00B3,  # ³ SUPERSCRIPT THREE
    0x00BC,  # ¼ VULGAR FRACTION ONE QUARTER
    0x00BD,  # ½ VULGAR FRACTION ONE HALF
    0x00BE,  # ¾ VULGAR FRACTION THREE QUARTERS
    0x0FD6,  # ࿖ LEFT-FACING SVASTI SIGN
    0x203C,  # ‼ DOUBLE EXCLAMATION MARK
    0x2049,  # ⁉ EXCLAMATION QUESTION MARK
    0x2113,  # ℓ SCRIPT SMALL L
    0x2116,  # № NUMERO SIGN
    0x2121,  # ℡ TELEPHONE SIGN
    0x213B,  # ℻ FACSIMILE SIGN
    0x2150,  # ⅐ VULGAR FRACTION ONE SEVENTH
    0x2151,  # ⅑ VULGAR FRACTION ONE NINTH
    0x2152,  # ⅒ VULGAR FRACTION ONE TENTH
    0x2153,  # ⅓ VULGAR FRACTION ONE THIRD
    0x2154,  # ⅔ VULGAR FRACTION TWO THIRDS
    0x2155,  # ⅕ VULGAR FRACTION ONE FIFTH
    0x2156,  # ⅖ VULGAR FRACTION TWO FIFTHS
    0x2157,  # ⅗ VULGAR FRACTION THREE FIFTHS
    0x2158,  # ⅘ VULGAR FRACTION FOUR FIFTHS
    0x2159,  # ⅙ VULGAR FRACTION ONE SIXTH
    0x215A,  # ⅚ VULGAR FRACTION FIVE SIXTHS
    0x215B,  # ⅛ VULGAR FRACTION ONE EIGHTH
    0x2160,  # Ⅰ ROMAN NUMERAL ONE
    0x2161,  # Ⅱ ROMAN NUMERAL TWO
    0x2162,  # Ⅲ ROMAN NUMERAL THREE
    0x2163,  # Ⅳ ROMAN NUMERAL FOUR
    0x2164,  # Ⅴ ROMAN NUMERAL FIVE
    0x2165,  # Ⅵ ROMAN NUMERAL SIX
    0x2166,  # Ⅶ ROMAN NUMERAL SEVEN
    0x2167,  # Ⅷ ROMAN NUMERAL EIGHT
    0x2168,  # Ⅸ ROMAN NUMERAL NINE
    0x2169,  # Ⅹ ROMAN NUMERAL TEN
    0x216A,  # Ⅺ ROMAN NUMERAL ELEVEN
    0x216B,  # Ⅻ ROMAN NUMERAL TWELVE
    0x2189,  # ↉ VULGAR FRACTION ZERO THIRDS
    0x2460,  # ① CIRCLED DIGIT ONE
    0x2461,  # ② CIRCLED DIGIT TWO
    0x2462,  # ③ CIRCLED DIGIT THREE
    0x2463,  # ④ CIRCLED DIGIT FOUR
    0x2464,  # ⑤ CIRCLED DIGIT FIVE
    0x2465,  # ⑥ CIRCLED DIGIT SIX
    0x2466,  # ⑦ CIRCLED DIGIT SEVEN
    0x2467,  # ⑧ CIRCLED DIGIT EIGHT
    0x2468,  # ⑨ CIRCLED DIGIT NINE
    0x2469,  # ⑩ CIRCLED NUMBER TEN
    0x246A,  # ⑪ CIRCLED NUMBER ELEVEN
    0x246B,  # ⑫ CIRCLED NUMBER TWELVE
    0x246C,  # ⑬ CIRCLED NUMBER THIRTEEN
    0x246D,  # ⑭ CIRCLED NUMBER FOURTEEN
    0x246E,  # ⑮ CIRCLED NUMBER FIFTEEN
    0x246F,  # ⑯ CIRCLED NUMBER SIXTEEN
    0x2470,  # ⑰ CIRCLED NUMBER SEVENTEEN
    0x2471,  # ⑱ CIRCLED NUMBER EIGHTEEN
    0x2472,  # ⑲ CIRCLED NUMBER NINETEEN
    0x2473,  # ⑳ CIRCLED NUMBER TWENTY
    0x2474,  # ⑴ PARENTHESIZED DIGIT ONE
    0x2475,  # ⑵ PARENTHESIZED DIGIT TWO
    0x2476,  # ⑶ PARENTHESIZED DIGIT THREE
    0x2477,  # ⑷ PARENTHESIZED DIGIT FOUR
    0x2478,  # ⑸ PARENTHESIZED DIGIT FIVE
    0x2479,  # ⑹ PARENTHESIZED DIGIT SIX
    0x247A,  # ⑺ PARENTHESIZED DIGIT SEVEN
    0x247B,  # ⑻ PARENTHESIZED DIGIT EIGHT
    0x247C,  # ⑼ PARENTHESIZED DIGIT NINE
    0x247D,  # ⑽ PARENTHESIZED NUMBER TEN
    0x247E,  # ⑾ PARENTHESIZED NUMBER ELEVEN
    0x247F,  # ⑿ PARENTHESIZED NUMBER TWELVE
    0x2488,  # ⒈ DIGIT ONE FULL STOP
    0x2489,  # ⒉ DIGIT TWO FULL STOP
    0x248A,  # ⒊ DIGIT THREE FULL STOP
    0x248B,  # ⒋ DIGIT FOUR FULL STOP
    0x248C,  # ⒌ DIGIT FIVE FULL STOP
    0x248D,  # ⒍ DIGIT SIX FULL STOP
    0x248E,  # ⒎ DIGIT SEVEN FULL STOP
    0x248F,  # ⒏ DIGIT EIGHT FULL STOP
    0x2490,  # ⒐ DIGIT NINE FULL STOP
    0x2491,  # ⒑ NUMBER TEN FULL STOP
    0x2492,  # ⒒ NUMBER ELEVEN FULL STOP
    0x2493,  # ⒓ NUMBER TWELVE FULL STOP
    0x24B9,  # Ⓓ CIRCLED LATIN CAPITAL LETTER D
    0x24C8,  # Ⓢ CIRCLED LATIN CAPITAL LETTER S
    0x24EB,  # ⓫ NEGATIVE CIRCLED NUMBER ELEVEN
    0x24EC,  # ⓬ NEGATIVE CIRCLED NUMBER TWELVE
    0x25B6,  # ▶ BLACK RIGHT-POINTING TRIANGLE
    0x25C0,  # ◀ BLACK LEFT-POINTING TRIANGLE
    0x2600,  # ☀ BLACK SUN WITH RAYS
    0x2601,  # ☁ CLOUD
    0x2602,  # ☂ UMBRELLA
    0x2603,  # ☃ SNOWMAN
    0x260E,  # ☎ BLACK TELEPHONE
    0x2613,  # ☓ SALTIRE
    0x2614,  # ☔ UMBRELLA WITH RAIN DROPS
    0x2616,  # ☖ WHITE SHOGI PIECE
    0x2617,  # ☗ BLACK SHOGI PIECE
    0x2660,  # ♠ BLACK SPADE SUIT
    0x2663,  # ♣ BLACK CLUB SUIT
    0x2665,  # ♥ BLACK HEART SUIT
    0x2666,  # ♦ BLACK DIAMOND SUIT
    0x2668,  # ♨ HOT SPRINGS
    0x266C,  # ♬ BEAMED SIXTEENTH NOTES
    0x2693,  # ⚓ ANCHOR
    0x269E,  # ⚞ THREE LINES CONVERGING RIGHT
    0x269F,  # ⚟ THREE LINES CONVERGING LEFT
    0x26A1,  # ⚡ HIGH VOLTAGE SIGN
    0x26BE,  # ⚾ BASEBALL
    0x26BF,  # ⚿ SQUARED KEY
    0x26C4,  # ⛄ SNOWMAN WITHOUT SNOW
    0x26C5,  # ⛅ SUN BEHIND CLOUD
    0x26C6,  # ⛆ RAIN
    0x26C7,  # ⛇ BLACK SNOWMAN
    0x26C8,  # ⛈ THUNDER CLOUD AND RAIN
    0x26C9,  # ⛉ TURNED WHITE SHOGI PIECE
    0x26CA,  # ⛊ TURNED BLACK SHOGI PIECE
    0x26CB,  # ⛋ WHITE DIAMOND IN SQUARE
    0x26CC,  # ⛌ CROSSING LANES
    0x26CD,  # ⛍ DISABLED CAR
    0x26CE,  # ⛎ OPHIUCHUS
    0x26CF,  # ⛏ PICK
    0x26D0,  # ⛐ CAR SLIDING
    0x26D1,  # ⛑ HELMET WITH WHITE CROSS
    0x26D2,  # ⛒ CIRCLED CROSSING LANES
    0x26D3,  # ⛓ CHAINS
    0x26D4,  # ⛔ NO ENTRY
    0x26D5,  # ⛕ ALTERNATE ONE-WAY LEFT WAY TRAFFIC
    0x26D6,  # ⛖ BLACK TWO-WAY LEFT WAY TRAFFIC
    0x26D7,  # ⛗ WHITE TWO-WAY LEFT WAY TRAFFIC
    0x26D8,  # ⛘ BLACK LEFT LANE MERGE
    0x26D9,  # ⛙ WHITE LEFT LANE MERGE
    0x26DA,  # ⛚ DRIVE SLOW SIGN
    0x26DB,  # ⛛ HEAVY WHITE DOWN-POINTING TRIANGLE
    0x26DC,  # ⛜ LEFT CLOSED ENTRY
    0x26DD,  # ⛝ SQUARED SALTIRE
    0x26DE,  # ⛞ FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE
    0x26DF,  # ⛟ BLACK TRUCK
    0x26E0,  # ⛠ RESTRICTED LEFT ENTRY-1
    0x26E1,  # ⛡ RESTRICTED LEFT ENTRY-2
    0x26E2,  # ⛢ ASTRONOMICAL SYMBOL FOR URANUS
    0x26E3,  # ⛣ HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE
    0x26E4,  # ⛤ PENTAGRAM
    0x26E5,  # ⛥ RIGHT-HANDED INTERLACED PENTAGRAM
    0x26E6,  # ⛦ LEFT-HANDED INTERLACED PENTAGRAM
    0x26E7,  # ⛧ INVERTED PENTAGRAM
    0x26E8,  # ⛨ BLACK CROSS ON SHIELD
    0x26E9,  # ⛩ SHINTO SHRINE
    0x26EA,  # ⛪ CHURCH
    0x26EB,  # ⛫ CASTLE
    0x26EC,  # ⛬ HISTORIC SITE
    0x26ED,  # ⛭ GEAR WITHOUT HUB
    0x26EE,  # ⛮ GEAR WITH HANDLES
    0x26EF,  # ⛯ MAP SYMBOL FOR LIGHTHOUSE
    0x26F0,  # ⛰ MOUNTAIN
    0x26F1,  # ⛱ UMBRELLA ON GROUND
    0x26F2,  # ⛲ FOUNTAIN
    0x26F3,  # ⛳ FLAG IN HOLE
    0x26F4,  # ⛴ FERRY
    0x26F5,  # ⛵ SAILBOAT
    0x26F6,  # ⛶ SQUARE FOUR CORNERS
    0x26F7,  # ⛷ SKIER
    0x26F8,  # ⛸ ICE SKATE
    0x26F9,  # ⛹ PERSON WITH BALL
    0x26FA,  # ⛺ TENT
    0x26FB,  # ⛻ JAPANESE BANK SYMBOL
    0x26FC,  # ⛼ HEADSTONE GRAVEYARD SYMBOL
    0x26FD,  # ⛽ FUEL PUMP
    0x26FE,  # ⛾ CUP ON BLACK SQUARE
    0x26FF,  # ⛿ WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE
    0x2708,  # ✈ AIRPLANE
    0x2757,  # ❗ HEAVY EXCLAMATION MARK SYMBOL
    0x2776,  # ❶ DINGBAT NEGATIVE CIRCLED DIGIT ONE
    0x2777,  # ❷ DINGBAT NEGATIVE CIRCLED DIGIT TWO
    0x2778,  # ❸ DINGBAT NEGATIVE CIRCLED DIGIT THREE
    0x2779,  # ❹ DINGBAT NEGATIVE CIRCLED DIGIT FOUR
    0x277A,  # ❺ DINGBAT NEGATIVE CIRCLED DIGIT FIVE
    0x277B,  # ❻ DINGBAT NEGATIVE CIRCLED DIGIT SIX
    0x277C,  # ❼ DINGBAT NEGATIVE CIRCLED DIGIT SEVEN
    0x277D,  # ❽ DINGBAT NEGATIVE CIRCLED DIGIT EIGHT
    0x277E,  # ❾ DINGBAT NEGATIVE CIRCLED DIGIT NINE
    0x277F,  # ❿ DINGBAT NEGATIVE CIRCLED NUMBER TEN
    0x27A1,  # ➡ BLACK RIGHTWARDS ARROW
    0x27D0,  # ⟐ WHITE DIAMOND WITH CENTRED DOT
    0x2A00,  # ⨀ N-ARY CIRCLED DOT OPERATOR
    0x2B05,  # ⬅ LEFTWARDS BLACK ARROW
    0x2B06,  # ⬆ UPWARDS BLACK ARROW
    0x2B07,  # ⬇ DOWNWARDS BLACK ARROW
    0x2B1B,  # ⬛ BLACK LARGE SQUARE
    0x2B24,  # ⬤ BLACK LARGE CIRCLE
    0x2B2E,  # ⬮ BLACK VERTICAL ELLIPSE
    0x2B2F,  # ⬯ WHITE VERTICAL ELLIPSE
    0x2B55,  # ⭕ HEAVY LARGE CIRCLE
    0x2B56,  # ⭖ HEAVY OVAL WITH OVAL INSIDE
    0x2B57,  # ⭗ HEAVY CIRCLE WITH CIRCLE INSIDE
    0x2B58,  # ⭘ HEAVY CIRCLE
    0x2B59,  # ⭙ HEAVY CIRCLED SALTIRE
    0x3012,  # 〒 POSTAL MARK
    0x3016,  # 〖 LEFT WHITE LENTICULAR BRACKET
    0x3017,  # 〗 RIGHT WHITE LENTICULAR BRACKET
    0x3036,  # 〶 CIRCLED POSTAL MARK
    0x322A,  # ㈪ PARENTHESIZED IDEOGRAPH MOON
    0x322B,  # ㈫ PARENTHESIZED IDEOGRAPH FIRE
    0x322C,  # ㈬ PARENTHESIZED IDEOGRAPH WATER
    0x322D,  # ㈭ PARENTHESIZED IDEOGRAPH WOOD
    0x322E,  # ㈮ PARENTHESIZED IDEOGRAPH METAL
    0x322F,  # ㈯ PARENTHESIZED IDEOGRAPH EARTH
    0x3230,  # ㈰ PARENTHESIZED IDEOGRAPH SUN
    0x3231,  # ㈱ PARENTHESIZED IDEOGRAPH STOCK
    0x3232,  # ㈲ PARENTHESIZED IDEOGRAPH HAVE
    0x3233,  # ㈳ PARENTHESIZED IDEOGRAPH SOCIETY
    0x3236,  # ㈶ PARENTHESIZED IDEOGRAPH FINANCIAL
    0x3237,  # ㈷ PARENTHESIZED IDEOGRAPH CONGRATULATION
    0x3239,  # ㈹ PARENTHESIZED IDEOGRAPH REPRESENT
    0x3244,  # ㉄ CIRCLED IDEOGRAPH QUESTION
    0x3245,  # ㉅ CIRCLED IDEOGRAPH KINDERGARTEN
    0x3246,  # ㉆ CIRCLED IDEOGRAPH SCHOOL
    0x3247,  # ㉇ CIRCLED IDEOGRAPH KOTO
    0x3248,  # ㉈ CIRCLED NUMBER TEN ON BLACK SQUARE
    0x3249,  # ㉉ CIRCLED NUMBER TWENTY ON BLACK SQUARE
    0x324A,  # ㉊ CIRCLED NUMBER THIRTY ON BLACK SQUARE
    0x324B,  # ㉋ CIRCLED NUMBER FORTY ON BLACK SQUARE
    0x324C,  # ㉌ CIRCLED NUMBER FIFTY ON BLACK SQUARE
    0x324D,  # ㉍ CIRCLED NUMBER SIXTY ON BLACK SQUARE
    0x324E,  # ㉎ CIRCLED NUMBER SEVENTY ON BLACK SQUARE
    0x324F,  # ㉏ CIRCLED NUMBER EIGHTY ON BLACK SQUARE
    0x3251,  # ㉑ CIRCLED NUMBER TWENTY ONE
    0x3252,  # ㉒ CIRCLED NUMBER TWENTY TWO
    0x3253,  # ㉓ CIRCLED NUMBER TWENTY THREE
    0x3254,  # ㉔ CIRCLED NUMBER TWENTY FOUR
    0x3255,  # ㉕ CIRCLED NUMBER TWENTY FIVE
    0x3256,  # ㉖ CIRCLED NUMBER TWENTY SIX
    0x3257,  # ㉗ CIRCLED NUMBER TWENTY SEVEN
    0x3258,  # ㉘ CIRCLED NUMBER TWENTY EIGHT
    0x3259,  # ㉙ CIRCLED NUMBER TWENTY NINE
    0x325A,  # ㉚ CIRCLED NUMBER THIRTY
    0x325B,  # ㉛ CIRCLED NUMBER THIRTY ONE
    0x328B,  # ㊋ CIRCLED IDEOGRAPH FIRE
    0x3299,  # ㊙ CIRCLED IDEOGRAPH SECRET
    0x3371,  # ㍱ SQUARE HPA
    0x337B,  # ㍻ SQUARE ERA NAME HEISEI
    0x337C,  # ㍼ SQUARE ERA NAME SYOUWA
    0x337D,  # ㍽ SQUARE ERA NAME TAISYOU
    0x337E,  # ㍾ SQUARE ERA NAME MEIZI
    0x338F,  # ㎏ SQUARE KG
    0x3390,  # ㎐ SQUARE HZ
    0x339D,  # ㎝ SQUARE CM
    0x339E,  # ㎞ SQUARE KM
    0x33A0,  # ㎠ SQUARE CM SQUARED
    0x33A1,  # ㎡ SQUARE M SQUARED
    0x33A2,  # ㎢ SQUARE KM SQUARED
    0x33A4,  # ㎤ SQUARE CM CUBED
    0x33A5,  # ㎥ SQUARE M CUBED
    0x33CA,  # ㏊ SQUARE HA
    0x3EDA,  # 㻚 CJK UNIFIED IDEOGRAPH-3EDA
    0x4103,  # 䄃 CJK UNIFIED IDEOGRAPH-4103
    0x5186,  # 円 CJK UNIFIED IDEOGRAPH-5186
    0x56E4,  # 囤 CJK UNIFIED IDEOGRAPH-56E4
    0x5880,  # 墀 CJK UNIFIED IDEOGRAPH-5880
    0x5E74,  # 年 CJK UNIFIED IDEOGRAPH-5E74
    0x65E5,  # 日 CJK UNIFIED IDEOGRAPH-65E5
    0x6708,  # 月 CJK UNIFIED IDEOGRAPH-6708
    0x6911,  # 椑 CJK UNIFIED IDEOGRAPH-6911
    0x6DF8,  # 淸 CJK UNIFIED IDEOGRAPH-6DF8
    0x7421,  # 琡 CJK UNIFIED IDEOGRAPH-7421
    0x7575,  # 畵 CJK UNIFIED IDEOGRAPH-7575
    0x79DA,  # 秚 CJK UNIFIED IDEOGRAPH-79DA
    0x7FA1,  # 羡 CJK UNIFIED IDEOGRAPH-7FA1
    0x813A,  # 脺 CJK UNIFIED IDEOGRAPH-813A
    0x8FF6,  # 迶 CJK UNIFIED IDEOGRAPH-8FF6
    0x91B2,  # 醲 CJK UNIFIED IDEOGRAPH-91B2
    0x9592,  # 閒 CJK UNIFIED IDEOGRAPH-9592
    0x9AD9,  # 髙 CJK UNIFIED IDEOGRAPH-9AD9
    0x9FC4,  # 鿄 CJK UNIFIED IDEOGRAPH-9FC4
    0x9FC5,  # 鿅 CJK UNIFIED IDEOGRAPH-9FC5
    0x9FC6,  # 鿆 CJK UNIFIED IDEOGRAPH-9FC6
    0xFA6B,  # 恵 CJK COMPATIBILITY IDEOGRAPH-FA6B
    0xFA6C,  # 𤋮 CJK COMPATIBILITY IDEOGRAPH-FA6C
    0xFA6D,  # 舘 CJK COMPATIBILITY IDEOGRAPH-FA6D
    0x1F100,  # 🄀 DIGIT ZERO FULL STOP
    0x1F101,  # 🄁 DIGIT ZERO COMMA
    0x1F102,  # 🄂 DIGIT ONE COMMA
    0x1F103,  # 🄃 DIGIT TWO COMMA
    0x1F104,  # 🄄 DIGIT THREE COMMA
    0x1F105,  # 🄅 DIGIT FOUR COMMA
    0x1F106,  # 🄆 DIGIT FIVE COMMA
    0x1F107,  # 🄇 DIGIT SIX COMMA
    0x1F108,  # 🄈 DIGIT SEVEN COMMA
    0x1F109,  # 🄉 DIGIT EIGHT COMMA
    0x1F10A,  # 🄊 DIGIT NINE COMMA
    0x1F110,  # 🄐 PARENTHESIZED LATIN CAPITAL LETTER A
    0x1F111,  # 🄑 PARENTHESIZED LATIN CAPITAL LETTER B
    0x1F112,  # 🄒 PARENTHESIZED LATIN CAPITAL LETTER C
    0x1F113,  # 🄓 PARENTHESIZED LATIN CAPITAL LETTER D
    0x1F114,  # 🄔 PARENTHESIZED LATIN CAPITAL LETTER E
    0x1F115,  # 🄕 PARENTHESIZED LATIN CAPITAL LETTER F
    0x1F116,  # 🄖 PARENTHESIZED LATIN CAPITAL LETTER G
    0x1F117,  # 🄗 PARENTHESIZED LATIN CAPITAL LETTER H
    0x1F118,  # 🄘 PARENTHESIZED LATIN CAPITAL LETTER I
    0x1F119,  # 🄙 PARENTHESIZED LATIN CAPITAL LETTER J
    0x1F11A,  # 🄚 PARENTHESIZED LATIN CAPITAL LETTER K
    0x1F11B,  # 🄛 PARENTHESIZED LATIN CAPITAL LETTER L
    0x1F11C,  # 🄜 PARENTHESIZED LATIN CAPITAL LETTER M
    0x1F11D,  # 🄝 PARENTHESIZED LATIN CAPITAL LETTER N
    0x1F11E,  # 🄞 PARENTHESIZED LATIN CAPITAL LETTER O
    0x1F11F,  # 🄟 PARENTHESIZED LATIN CAPITAL LETTER P
    0x1F120,  # 🄠 PARENTHESIZED LATIN CAPITAL LETTER Q
    0x1F121,  # 🄡 PARENTHESIZED LATIN CAPITAL LETTER R
    0x1F122,  # 🄢 PARENTHESIZED LATIN CAPITAL LETTER S
    0x1F123,  # 🄣 PARENTHESIZED LATIN CAPITAL LETTER T
    0x1F124,  # 🄤 PARENTHESIZED LATIN CAPITAL LETTER U
    0x1F125,  # 🄥 PARENTHESIZED LATIN CAPITAL LETTER V
    0x1F126,  # 🄦 PARENTHESIZED LATIN CAPITAL LETTER W
    0x1F127,  # 🄧 PARENTHESIZED LATIN CAPITAL LETTER X
    0x1F128,  # 🄨 PARENTHESIZED LATIN CAPITAL LETTER Y
    0x1F129,  # 🄩 PARENTHESIZED LATIN CAPITAL LETTER Z
    0x1F12A,  # 🄪 TORTOISE SHELL BRACKETED LATIN CAPITAL LETTER S
    0x1F12B,  # 🄫 CIRCLED ITALIC LATIN CAPITAL LETTER C
    0x1F12C,  # 🄬 CIRCLED ITALIC LATIN CAPITAL LETTER R
    0x1F12D,  # 🄭 CIRCLED CD
    0x1F131,  # 🄱 SQUARED LATIN CAPITAL LETTER B
    0x1F13D,  # 🄽 SQUARED LATIN CAPITAL LETTER N
    0x1F13F,  # 🄿 SQUARED LATIN CAPITAL LETTER P
    0x1F142,  # 🅂 SQUARED LATIN CAPITAL LETTER S
    0x1F146,  # 🅆 SQUARED LATIN CAPITAL LETTER W
    0x1F14A,  # 🅊 SQUARED HV
    0x1F14B,  # 🅋 SQUARED MV
    0x1F14C,  # 🅌 SQUARED SD
    0x1F14D,  # 🅍 SQUARED SS
    0x1F14E,  # 🅎 SQUARED PPV
    0x1F14F,  # 🅏 SQUARED WC
    0x1F157,  # 🅗 NEGATIVE CIRCLED LATIN CAPITAL LETTER H
    0x1F15F,  # 🅟 NEGATIVE CIRCLED LATIN CAPITAL LETTER P
    0x1F179,  # 🅹 NEGATIVE SQUARED LATIN CAPITAL LETTER J
    0x1F17B,  # 🅻 NEGATIVE SQUARED LATIN CAPITAL LETTER L
    0x1F17C,  # 🅼 NEGATIVE SQUARED LATIN CAPITAL LETTER M
    0x1F17F,  # 🅿 NEGATIVE SQUARED LATIN CAPITAL LETTER P
    0x1F18A,  # 🆊 CROSSED NEGATIVE SQUARED LATIN CAPITAL LETTER P
    0x1F18B,  # 🆋 NEGATIVE SQUARED IC
    0x1F18C,  # 🆌 NEGATIVE SQUARED PA
    0x1F18D,  # 🆍 NEGATIVE SQUARED SA
    0x1F190,  # 🆐 SQUARE DJ
    0x1F200,  # 🈀 SQUARE HIRAGANA HOKA
    0x1F210,  # 🈐 SQUARED CJK UNIFIED IDEOGRAPH-624B
    0x1F211,  # 🈑 SQUARED CJK UNIFIED IDEOGRAPH-5B57
    0x1F212,  # 🈒 SQUARED CJK UNIFIED IDEOGRAPH-53CC
    0x1F213,  # 🈓 SQUARED KATAKANA DE
    0x1F214,  # 🈔 SQUARED CJK UNIFIED IDEOGRAPH-4E8C
    0x1F215,  # 🈕 SQUARED CJK UNIFIED IDEOGRAPH-591A
    0x1F216,  # 🈖 SQUARED CJK UNIFIED IDEOGRAPH-89E3
    0x1F217,  # 🈗 SQUARED CJK UNIFIED IDEOGRAPH-5929
    0x1F218,  # 🈘 SQUARED CJK UNIFIED IDEOGRAPH-4EA4
    0x1F219,  # 🈙 SQUARED CJK UNIFIED IDEOGRAPH-6620
    0x1F21A,  # 🈚 SQUARED CJK UNIFIED IDEOGRAPH-7121
    0x1F21B,  # 🈛 SQUARED CJK UNIFIED IDEOGRAPH-6599
    0x1F21C,  # 🈜 SQUARED CJK UNIFIED IDEOGRAPH-524D
    0x1F21D,  # 🈝 SQUARED CJK UNIFIED IDEOGRAPH-5F8C
    0x1F21E,  # 🈞 SQUARED CJK UNIFIED IDEOGRAPH-518D
    0x1F21F,  # 🈟 SQUARED CJK UNIFIED IDEOGRAPH-65B0
    0x1F220,  # 🈠 SQUARED CJK UNIFIED IDEOGRAPH-521D
    0x1F221,  # 🈡 SQUARED CJK UNIFIED IDEOGRAPH-7D42
    0x1F222,  # 🈢 SQUARED CJK UNIFIED IDEOGRAPH-751F
    0x1F223,  # 🈣 SQUARED CJK UNIFIED IDEOGRAPH-8CA9
    0x1F224,  # 🈤 SQUARED CJK UNIFIED IDEOGRAPH-58F0
    0x1F225,  # 🈥 SQUARED CJK UNIFIED IDEOGRAPH-5439
    0x1F226,  # 🈦 SQUARED CJK UNIFIED IDEOGRAPH-6F14
    0x1F227,  # 🈧 SQUARED CJK UNIFIED IDEOGRAPH-6295
    0x1F228,  # 🈨 SQUARED CJK UNIFIED IDEOGRAPH-6355
    0x1F229,  # 🈩 SQUARED CJK UNIFIED IDEOGRAPH-4E00
    0x1F22A,  # 🈪 SQUARED CJK UNIFIED IDEOGRAPH-4E09
    0x1F22B,  # 🈫 SQUARED CJK UNIFIED IDEOGRAPH-904A
    0x1F22C,  # 🈬 SQUARED CJK UNIFIED IDEOGRAPH-5DE6
    0x1F22D,  # 🈭 SQUARED CJK UNIFIED IDEOGRAPH-4E2D
    0x1F22E,  # 🈮 SQUARED CJK UNIFIED IDEOGRAPH-53F3
    0x1F22F,  # 🈯 SQUARED CJK UNIFIED IDEOGRAPH-6307
    0x1F230,  # 🈰 SQUARED CJK UNIFIED IDEOGRAPH-8D70
    0x1F231,  # 🈱 SQUARED CJK UNIFIED IDEOGRAPH-6253
    0x1F240,  # 🉀 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
    0x1F241,  # 🉁 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
    0x1F242,  # 🉂 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
    0x1F243,  # 🉃 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
    0x1F244,  # 🉄 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
    0x1F245,  # 🉅 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
    0x1F246,  # 🉆 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
    0x1F247,  # 🉇 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
    0x1F248,  # 🉈 TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
    0x20158,  # 𠅘 CJK UNIFIED IDEOGRAPH-20158
    0x20BB7,  # 𠮷 CJK UNIFIED IDEOGRAPH-20BB7
    0x233CC,  # 𣏌 CJK UNIFIED IDEOGRAPH-233CC
    0x233FE,  # 𣏾 CJK UNIFIED IDEOGRAPH-233FE
    0x242EE,  # 𤋮 CJK UNIFIED IDEOGRAPH-242EE
]
