// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepAdaptor_CompCurve_HeaderFile
#define _BRepAdaptor_CompCurve_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Wire.hxx>
#include <Standard_Real.hxx>
#include <Handle_BRepAdaptor_HArray1OfCurve.hxx>
#include <Handle_TColStd_HArray1OfReal.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <Adaptor3d_Curve.hxx>
#include <GeomAbs_Shape.hxx>
#include <Handle_Adaptor3d_HCurve.hxx>
#include <GeomAbs_CurveType.hxx>
#include <Handle_Geom_BezierCurve.hxx>
#include <Handle_Geom_BSplineCurve.hxx>
class BRepAdaptor_HArray1OfCurve;
class TColStd_HArray1OfReal;
class Standard_NullObject;
class Standard_DomainError;
class Standard_OutOfRange;
class Standard_NoSuchObject;
class TopoDS_Wire;
class TopoDS_Edge;
class TColStd_Array1OfReal;
class Adaptor3d_HCurve;
class gp_Pnt;
class gp_Vec;
class gp_Lin;
class gp_Circ;
class gp_Elips;
class gp_Hypr;
class gp_Parab;
class Geom_BezierCurve;
class Geom_BSplineCurve;


//! The Curve from BRepAdaptor allows to use a Wire
//! of the BRep topology like a 3D curve.
//! Warning: With this  class of curve,  C0 and C1 continuities
//! are not assumed. So be carful with some algorithm!
class BRepAdaptor_CompCurve  : public Adaptor3d_Curve
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates an undefined Curve with no Wire loaded.
  Standard_EXPORT BRepAdaptor_CompCurve();
  
  Standard_EXPORT BRepAdaptor_CompCurve(const TopoDS_Wire& W, const Standard_Boolean KnotByCurvilinearAbcissa = Standard_False);
  
  //! Creates a Curve  to  acces to the geometry of edge
  //! <W>.
  Standard_EXPORT BRepAdaptor_CompCurve(const TopoDS_Wire& W, const Standard_Boolean KnotByCurvilinearAbcissa, const Standard_Real First, const Standard_Real Last, const Standard_Real Tol);
  
  //! Sets the  wire <W>.
  Standard_EXPORT   void Initialize (const TopoDS_Wire& W, const Standard_Boolean KnotByCurvilinearAbcissa) ;
  
  //! Sets wire <W> and trimmed  parameter.
  Standard_EXPORT   void Initialize (const TopoDS_Wire& W, const Standard_Boolean KnotByCurvilinearAbcissa, const Standard_Real First, const Standard_Real Last, const Standard_Real Tol) ;
  
  //! Set the flag Periodic.
  //! Warning: This method has no effect if the wire is not closed
  Standard_EXPORT   void SetPeriodic (const Standard_Boolean Periodic) ;
  
  //! Returns the wire.
  Standard_EXPORT  const  TopoDS_Wire& Wire()  const;
  
  //! returns an  edge  and   one  parameter on them
  //! corresponding to the parameter U.
  Standard_EXPORT   void Edge (const Standard_Real U, TopoDS_Edge& E, Standard_Real& UonE)  const;
  
  Standard_EXPORT   Standard_Real FirstParameter()  const;
  
  Standard_EXPORT   Standard_Real LastParameter()  const;
  
  Standard_EXPORT   GeomAbs_Shape Continuity()  const;
  
  //! Returns  the number  of  intervals for  continuity
  //! <S>. May be one if Continuity(me) >= <S>
  Standard_EXPORT   Standard_Integer NbIntervals (const GeomAbs_Shape S) ;
  
  //! Stores in <T> the  parameters bounding the intervals
  //! of continuity <S>.
  //!
  //! The array must provide  enough room to  accomodate
  //! for the parameters. i.e. T.Length() > NbIntervals()
  Standard_EXPORT   void Intervals (TColStd_Array1OfReal& T, const GeomAbs_Shape S) ;
  
  //! Returns    a  curve equivalent   of  <me>  between
  //! parameters <First>  and <Last>. <Tol>  is used  to
  //! test for 3d points confusion.
  //! If <First> >= <Last>
  Standard_EXPORT   Handle(Adaptor3d_HCurve) Trim (const Standard_Real First, const Standard_Real Last, const Standard_Real Tol)  const;
  
  Standard_EXPORT   Standard_Boolean IsClosed()  const;
  
  Standard_EXPORT   Standard_Boolean IsPeriodic()  const;
  
  Standard_EXPORT   Standard_Real Period()  const;
  
  //! Computes the point of parameter U on the curve
  Standard_EXPORT   gp_Pnt Value (const Standard_Real U)  const;
  
  //! Computes the point of parameter U.
  Standard_EXPORT   void D0 (const Standard_Real U, gp_Pnt& P)  const;
  
  //! Computes the point of parameter U on the curve
  //! with its first derivative.
  //! Raised if the continuity of the current interval
  //! is not C1.
  Standard_EXPORT   void D1 (const Standard_Real U, gp_Pnt& P, gp_Vec& V)  const;
  

  //! Returns the point P of parameter U, the first and second
  //! derivatives V1 and V2.
  //! Raised if the continuity of the current interval
  //! is not C2.
  Standard_EXPORT   void D2 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2)  const;
  

  //! Returns the point P of parameter U, the first, the second
  //! and the third derivative.
  //! Raised if the continuity of the current interval
  //! is not C3.
  Standard_EXPORT   void D3 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2, gp_Vec& V3)  const;
  

  //! The returned vector gives the value of the derivative for the
  //! order of derivation N.
  //! Raised if the continuity of the current interval
  //! is not CN.
  //! Raised if N < 1.
  Standard_EXPORT   gp_Vec DN (const Standard_Real U, const Standard_Integer N)  const;
  
  //! returns the parametric resolution
  Standard_EXPORT   Standard_Real Resolution (const Standard_Real R3d)  const;
  
  Standard_EXPORT   GeomAbs_CurveType GetType()  const;
  
  Standard_EXPORT   gp_Lin Line()  const;
  
  Standard_EXPORT   gp_Circ Circle()  const;
  
  Standard_EXPORT   gp_Elips Ellipse()  const;
  
  Standard_EXPORT   gp_Hypr Hyperbola()  const;
  
  Standard_EXPORT   gp_Parab Parabola()  const;
  
  Standard_EXPORT   Standard_Integer Degree()  const;
  
  Standard_EXPORT   Standard_Boolean IsRational()  const;
  
  Standard_EXPORT   Standard_Integer NbPoles()  const;
  
  Standard_EXPORT   Standard_Integer NbKnots()  const;
  
  Standard_EXPORT   Handle(Geom_BezierCurve) Bezier()  const;
  
  Standard_EXPORT   Handle(Geom_BSplineCurve) BSpline()  const;




protected:





private:

  
  Standard_EXPORT   void Prepare (Standard_Real& W, Standard_Real& D, Standard_Integer& ind)  const;
  
  Standard_EXPORT   void InvPrepare (const Standard_Integer ind, Standard_Real& F, Standard_Real& D)  const;


  TopoDS_Wire myWire;
  Standard_Real TFirst;
  Standard_Real TLast;
  Standard_Real PTol;
  Standard_Real myPeriod;
  Handle(BRepAdaptor_HArray1OfCurve) myCurves;
  Handle(TColStd_HArray1OfReal) myKnots;
  Standard_Integer CurIndex;
  Standard_Boolean Forward;
  Standard_Boolean IsbyAC;
  Standard_Boolean Periodic;


};







#endif // _BRepAdaptor_CompCurve_HeaderFile
