// Copyright (C) 2018   John Donoghue   <john.donoghue@ieee.org>
// Copyright (C) 2013   Stefan Mahr     <dac922@gmx.de>
// Copyright (C) 2012   Andrius Sutas   <andrius.sutas@gmail.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.

#include <octave/oct.h>

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#ifdef BUILD_VXI11
#include "vxi11_class.h"
#endif

// PKG_ADD: autoload ("vxi11_write", "vxi11.oct");
DEFUN_DLD (vxi11_write, args, nargout,
"-*- texinfo -*-\n\
@deftypefn {Loadable Function} {@var{n} = } vxi11_write (@var{vxi11}, @var{data})\n \
\n\
Write data to a vxi11 slave device.\n \
\n\
@var{vxi11} - instance of @var{octave_vxi11} class.@* \
@var{data} - data to be written to the slave device. Can be either of String or uint8 type.\n \
\n\
Upon successful completion, vxi11_write() shall return the number of bytes written as the result @var{n}.\n \
@end deftypefn")
{
#ifndef BUILD_VXI11
  error ("vxi11: Your system doesn't support the VXI11 interface");
  return octave_value ();
#else

  if (args.length () != 2 || args (0).type_id () != octave_vxi11::static_type_id ())
    {
      print_usage ();
      return octave_value (-1);
    }

  octave_vxi11* vxi11 = NULL;

  const octave_base_value& rep = args (0).get_rep ();
  vxi11 = &((octave_vxi11 &)rep);

  const octave_base_value& data = args (1).get_rep ();
  int retval;

  if (data.is_string ())
    {
      string buf = data.string_value ();
      retval = vxi11->write (buf.c_str (), buf.length ());
    }
  else if (data.is_uint8_type ())
    {
      NDArray dtmp = data.array_value ();
      OCTAVE_LOCAL_BUFFER (char, buf, (dtmp.numel ()));

      for (int i = 0; i < dtmp.numel (); i++)
          buf[i] = (char)dtmp(i);

      retval = vxi11->write (buf, data.byte_size());
    }
  else
    {
      print_usage ();
      return octave_value (-1);
    }

  return octave_value (retval);
#endif
}
