$ oldverify=f$verify(0)
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! DCL path command for maintaining the DCL$PATH logical name.
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ ! Subroutines
$ !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$usage: subroutine
$   type sys$input

Usage:	path		Path with no arguments or path HELP displays this help
	path HELP	screen.
	path -DIR	Removes DIR from logical name dcl$path.
	path +DIR	Adds DIR to end of dcl$path.
	path ^DIR	Adds DIR to top of dcl$path.
	path DIR	Defines dcl$path to be DIR.

An argument of "." adds or removes the default working directory.

I.e.,	path -.		Removes the default working directory from dcl$path
	path +.		Adds the default working directory to end of dcl$path
	path ^.		Adds the default working directory to top of dcl$path
	path .		Defines dcl$path to be the default working directory

An argument of "SHOW" displays the current definition of dcl$path.
$   exit
$ endsubroutine	!usage
$!
$ showpath: subroutine
$ index=0
$ show_nextdir:
$   next=f$trnlnm("dcl$path",,index)
$   if next .eqs. "" then goto show_quit
$   write sys$output next
$   index = index + 1
$   goto show_nextdir
$ show_quit:
$ exit
$ endsubroutine	! showpath
$ !
$ removefrom_path: subroutine
$ dir=p1
$ if dir.eqs."." then dir=f$environment("default")
$ translation=""
$ index=0
$ first=1
$ remove_nextdir:
$   next=f$trnlnm("dcl$path",,index)
$   if next .eqs. "" then goto remove_quit
$   if    f$parse(dir,,,"device","no_conceal")-
       +  f$parse(dir,,,"directory","no_conceal")-
    .nes. f$parse(next,,,"device","no_conceal")-
       +  f$parse(next,,,"directory","no_conceal")
$   then
$     if .not. first then translation = translation + ","
$     first = 0
$     translation = translation + next
$   endif
$   index = index + 1
$   goto remove_nextdir
$ remove_quit:
$ if translation .eqs. ""
$ then
$   deassign dcl$path
$ else
$   define/nolog dcl$path 'translation'
$ endif
$ exit
$ endsubroutine	! removefrom_path
$ !
$ addto_path: subroutine
$ dir=p1
$ if dir.eqs."." then dir=f$environment("default")
$ translation=""
$ index=0
$ first=1
$ add_nextdir:
$   next=f$trnlnm("dcl$path",,index)
$   if next .eqs. "" then goto add_quit
$   if    f$parse(dir,,,"device","no_conceal")-
       +  f$parse(dir,,,"directory","no_conceal")-
    .eqs. f$parse(next,,,"device","no_conceal")-
       +  f$parse(next,,,"directory","no_conceal") then exit
$   if .not. first then translation = translation + ","
$   first = 0
$   translation = translation + next
$   index = index + 1
$   goto add_nextdir
$ add_quit:
$ if translation .eqs. ""
$ then
$   define/nolog dcl$path 'dir'
$ else
$   define/nolog dcl$path 'translation','dir'
$ endif
$ exit
$ endsubroutine	! addto_path
$ !
$ topof_path: subroutine
$ dir=p1
$ if dir.eqs."." then dir=f$environment("default")
$ translation=dir
$ index=0
$ first=1
$ top_nextdir:
$   next=f$trnlnm("dcl$path",,index)
$   if next .eqs. "" then goto top_quit
$   index = index + 1
$   if    f$parse(dir,,,"device","no_conceal")-
       +  f$parse(dir,,,"directory","no_conceal")-
    .eqs. f$parse(next,,,"device","no_conceal")-
       +  f$parse(next,,,"directory","no_conceal") then goto top_nextdir
$   translation = translation + "," + next
$   goto top_nextdir
$ top_quit:
$ define/nolog dcl$path 'translation'
$ exit
$ endsubroutine	! topof_path
$ !
$ handle_argument: subroutine
$ arg=p1
$ if arg .eqs. "" then exit
$!
$ if arg.eqs."."
$ then
$   define/nolog dcl$path 'f$environment("default")'
$   exit
$ endif
$!
$ if f$edit(arg,"upcase").eqs."SHOW"
$ then
$   call showpath
$   exit
$ endif
$!
$ if f$edit(arg,"upcase").eqs."HELP"
$ then
$   call usage
$   exit
$ endif
$!
$ if f$extract(0,1,arg) .eqs. "-"
$ then
$   call removefrom_path 'f$extract(1,f$length(arg),arg)
$   exit
$ endif
$ !
$ if f$extract(0,1,arg) .eqs. "+"
$ then
$   call addto_path 'f$extract(1,f$length(arg),arg)
$   exit
$ endif
$ !
$ if f$extract(0,1,arg) .eqs. "^"
$ then
$   call topof_path 'f$extract(1,f$length(arg),arg)
$   exit
$ endif
$ !
$ define/nolog dcl$path 'arg'
$ exit
$ endsubroutine ! handle_argument
$ !
$ !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ !
$ ! If no arguments then display usage and get out.
$ !
$ if p1 .eqs. ""
$ then
$   call usage
$   exit
$ endif
$ !
$ call handle_argument "''p1'"
$ call handle_argument "''p2'"
$ call handle_argument "''p3'"
$ call handle_argument "''p4'"
$ call handle_argument "''p5'"
$ call handle_argument "''p6'"
$ call handle_argument "''p7'"
$ call handle_argument "''p8'"
$ x=f$verify(oldverify)
