Openbox-menu is a pipemenu for Openbox window manager. It provides a dynamic menu listing installed applications. Most of the work is done by the LXDE library menu-cache.

# Compilation.

Type `make` then, with superuser privileges, `make install` to install it. openbox-menu is installed in /usr/local/bin directory by default.type `make install DESTDIR=/usr` to install it to /usr/bin/directory.

## Compile openbox-menu without icons ##

Openbox-menu shows icons before categories name and applications name (in fact, the menu and the icons are displayed by Openbox; Openbox-menu only outputs text content). You can remove icon support by editing the Makefile and commenting the following line (add a # in the begining)

>  CFLAGS+=-DWITH_ICONS

If errors occur while compiling, remove gtk+-2.0 from lines above the one previously commented.

## SVG support

Openbox can display SVG icons since version 3.5.1. SVG support in openbox-menu has to be activated in Makefile by uncommenting the following line

>  CFLAGS+=-DWITH_SVG

SVG suport will be activated by default in the future.

# Settings

## Default menu file

If no menu file specified in the command line, openbox-menu will use "applications.menu" as default menu filename. If $XDG_MENU_PREFIX is set, openbox-menu uses its content to prefix "applications.menu".

## User menu file

Openbox-menu looks up for a valid menu file in /etc/xdg/menus directory. In order to make it looks up somewhere else, set up the $XDG_CONFIG_DIRS variable (don't suffix pathnames with "menus", it's automatically added).

For example, if $XDG_CONFIG_DIRS is set like this:

>  export XDG_CONFIG_DIRS="$HOME/.config:/etc/xdg"

And openbox-menu is called this way:

>  openbox-menu my.menu

Openbox-menu will check for "my.menu" (or "my.menu" prefixed by the value of $XDG_MENU_PREFIX) in "$HOME/.config/menus/" directory and, if the file doesn't exist here, in "/etc/xdg/menus/" directory.

## Custom XML header and footer.

Openbox-menu is not only a pipe-menu, it can also be used as an XML generator by setting the output file with the -o parameter (output file will be written in `$HOME/.cache/` directory).

In case you want to embed openbox-menu output in another menu, it is possible to define the header and the footer for the XML output generated by openbox-menu with the -H and -F parameters. Openbox-menu can even create the equivalent of Openbox's menu.xml file if proper header and footer content are passed.

Openbox-menu uses, as default, a `<openbox_pipe_menu>` tag for header, and a `</openbox_pipe_menu>` tag for footer.

# Examples

For the folliwing examples, we consider that the proper menu file is automatically found by openbox-menu.


## Memory and CPU load when called, manual refesh.

We won't use openbox-menu as a pipe-menu, we will use a file containing the pipe-menu XML output. User should launch the next command every time he wants the menu to be refreshed.

>   openbox-menu -o menu.xml

This command creates a file menu.xml located in ~/.cache. Its content is used as a pipe-menu with the `cat ~/.cache/menu.xml` command.

## Memory and CPU load when called, automatic refresh.

This time we simply use the command `openbox-menu`; Openbox-menu is used as every pipe-menu.

## Low memory, small CPU load, automatic refresh.

First, we launch openbox-menu at openbox startup with `openbox-menu -p -o menu.xml &`. It makes openbox-menu to stay in memory and to output the menu content in the ~/.cache/menu.xml` file. As in the first example, we simply use `cat ~/.cache/menu.xml` to display the menu as a pipe-menu.
