################################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

AC_DEFUN([SHOW_COPYRIGHT],
	[
	echo "#################################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################
"
	]
)

AC_DEFUN([CHECK_CIMSERVER],
	[
	AC_MSG_CHECKING(for CIM servers)
	
	if test x"$CIMSERVER" == x
	then
		AC_MSG_ERROR([[please define the CIMSERVER variable (see ./configure --help)]])
	fi
	
	if test "$CIMSERVER" != pegasus && test "$CIMSERVER" != sfcb && test "$CIMSERVER" != openwbem
	then
		AC_MSG_ERROR([[please define the CIMSERVER variable (see ./configure --help)]])
	fi
	
	if test "$CIMSERVER" == pegasus
	then
		if !( command -v cimmof > /dev/null )
		then
			AC_MSG_ERROR([[no. the Pegasus mof compiler could not be found (cimmof)]])
		fi
	fi
	
	if test "$CIMSERVER" == openwbem
	then
		if !( command -v owmofc > /dev/null)
		then
			AC_MSG_ERROR([[no. the OpenWBEM mof compiler could not be found (owmofc)]])
		fi
	fi
	
	if test "$CIMSERVER" == sfcb
	then
		if !( command -v sfcbd > /dev/null )
		then
			AC_MSG_ERROR([[no. the SBLIM sfcb deamon could not be found (sfcbd)]])
		fi
		if !( command -v sfcbstage > /dev/null )
		then
			AC_MSG_ERROR([[no. the SBLIM mof stager could not be found (sfcbstage)]])
		fi
		if !( command -v sfcbrepos > /dev/null )
		then
			AC_MSG_ERROR([[no. the SBLIM repository builder could no be found (sfcbrepos)]])
		fi
	fi
	
	if test "$CIMSERVER" == pegasus
	then
		if test x"$prefix" == xNONE
		then
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				PROVIDERDIR_TMP=/usr/lib64/Pegasus/providers
				COMMONLIBDIR_TMP=/usr/lib64
				OPENDRIMCOMMONLIBDIR_TMP=/usr/lib64
			else
				PROVIDERDIR_TMP=/usr/lib/Pegasus/providers
				COMMONLIBDIR_TMP=/usr/lib
				OPENDRIMCOMMONLIBDIR_TMP=/usr/lib
			fi
			OPENDRIMCOMMONINCLUDE_TMP=/usr/include/OpenDRIM
		else
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				PROVIDERDIR_TMP=$prefix/lib64/Pegasus/providers
				COMMONLIBDIR_TMP=$prefix/lib64
				OPENDRIMCOMMONLIBDIR_TMP=$prefix/lib64
			else
				PROVIDERDIR_TMP=$prefix/lib/Pegasus/providers
				COMMONLIBDIR_TMP=$prefix/lib
				OPENDRIMCOMMONLIBDIR_TMP=$prefix/lib
			fi
			OPENDRIMCOMMONINCLUDE_TMP=$prefix/include/OpenDRIM
		fi

		if test x"$PEGASUS_HOME" != x
		then
			PROVIDERDIR_TMP=$PEGASUS_HOME/lib
			COMMONLIBDIR_TMP=$PEGASUS_HOME/lib
			OPENDRIMCOMMONLIBDIR_TMP=$PEGASUS_HOME/lib
			OPENDRIMCOMMONINCLUDE_TMP=$PEGASUS_HOME/include/OpenDRIM
		fi
	fi
	
	if test "$CIMSERVER" == sfcb
	then
		if test x"$prefix" == xNONE
		then
			PROVIDERDIR_TMP=$ac_default_prefix/lib/cmpi
			COMMONLIBDIR_TMP=$ac_default_prefix/lib
			OPENDRIMCOMMONLIBDIR_TMP=$ac_default_prefix/lib
			OPENDRIMCOMMONINCLUDE_TMP=$ac_default_prefix/include/OpenDRIM
		else
			PROVIDERDIR_TMP=$prefix/lib/cmpi
			COMMONLIBDIR_TMP=$prefix/lib
			OPENDRIMCOMMONLIBDIR_TMP=$prefix/lib
			OPENDRIMCOMMONINCLUDE_TMP=$prefix/include/OpenDRIM
		fi
	fi
	
	if test "$CIMSERVER" == openwbem
	then
		if test x"$prefix" == xNONE
		then
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				PROVIDERDIR_TMP=/usr/lib64/openwbem/cmpiproviders
				COMMONLIBDIR_TMP=/usr/lib64
				OPENDRIMCOMMONLIBDIR_TMP=/usr/lib64
			else
				PROVIDERDIR_TMP=/usr/lib/openwbem/cmpiproviders
				COMMONLIBDIR_TMP=/usr/lib
				OPENDRIMCOMMONLIBDIR_TMP=/usr/lib
			fi
			OPENDRIMCOMMONINCLUDE_TMP=/usr/include/OpenDRIM
		else
			PROVIDERDIR_TMP=$prefix/lib/openwbem/cmpiproviders
			COMMONLIBDIR_TMP=$prefix/lib
			OPENDRIMCOMMONLIBDIR_TMP=$prefix/lib
			OPENDRIMCOMMONINCLUDE_TMP=$prefix/include/OpenDRIM
		fi
	fi
	
	if test x"$PROVIDERDIR" = x
	then
		PROVIDERDIR=$PROVIDERDIR_TMP
	fi

	if test x"$COMMONLIBDIR" = x
	then
		COMMONLIBDIR=$COMMONLIBDIR_TMP
	fi

	if test x"$OPENDRIMCOMMONLIBDIR" = x
	then
		OPENDRIMCOMMONLIBDIR=$OPENDRIMCOMMONLIBDIR_TMP
	fi

	if test x"$OPENDRIMCOMMONINCLUDE" = x
	then
		OPENDRIMCOMMONINCLUDE=$OPENDRIMCOMMONINCLUDE_TMP
	fi
	
	TEMP_CPPFLAGS="$CPPFLAGS -D_REENTRANT"
	CFLAGS="-Wall -Wunused -fPIC -O2 $CFLAGS"
	CXXFLAGS="-Wall -Wunused -fPIC -fno-rtti -fno-exceptions -O2 $CXXFLAGS"
	LDFLAGS="$LDFLAGS -L. -L$PROVIDERDIR -L$COMMONLIBDIR"
	
	AC_MSG_RESULT(yes)
	]
)

AC_DEFUN([CHECK_CIMNAMESPACE],
	[
	if test x"$CIMNAMESPACE" == x
	then
		CIMNAMESPACE=root/cimv2
	fi
	TEMP_CPPFLAGS="$TEMP_CPPFLAGS -D_NAMESPACE=\\\"$CIMNAMESPACE\\\""
	]	
)

AC_DEFUN([CHECK_INTEROPNAMESPACE],
	[
	if test x"$INTEROPNAMESPACE" == x
	then
		if test "$CIMSERVER" == pegasus
		then
			INTEROPNAMESPACE=Interop
		fi
		if test "$CIMSERVER" == openwbem
		then
			INTEROPNAMESPACE=root/Interop
		fi
		if test "$CIMSERVER" == sfcb
		then
			INTEROPNAMESPACE=Interop
		fi
	fi
	TEMP_CPPFLAGS="$TEMP_CPPFLAGS -D_INTEROP_NAMESPACE=\\\"$INTEROPNAMESPACE\\\""
	]	
)

AC_DEFUN([CHECK_OPENDRIMCOMMONHEADERS],
	[
	AC_MSG_CHECKING(for OpenDRIM Common headers)
	_HEADERS="Common.h Datastore.h CMPIBroking.h Association.h Indication.h Instance.h Objectpath.h Transtype.h"
	for _HEADER in $_HEADERS
	do
		if !( test -e $OPENDRIMCOMMONINCLUDE/$_HEADER )
		then
			AC_MSG_ERROR([[no. Could not find OpenDRIM Common headers:] $_HEADER])
		fi
	done
	AC_MSG_RESULT(yes)
	]
)

AC_DEFUN([CHECK_OPENDRIMCOMMONLIBRARY],
	[
	AC_MSG_CHECKING(for OpenDRIM Common library)

	if test -e $OPENDRIMCOMMONLIBDIR/libopendrim.so
	then
		AC_MSG_RESULT(yes)
	else
		AC_MSG_ERROR([[no. The OpenDRIM Common library could not be found (libopendrim.so)]])
	fi
	]
)

AC_DEFUN([_CHECK_CMPIHEADERS],
	[
	AC_MSG_CHECKING($1)
	AC_TRY_LINK(
	[
		#include <cmpimacs.h>
		#include <cmpidt.h>
		#include <cmpift.h>
	],
	[
		CMPIBroker broker;
		CMPIStatus status = {CMPI_RC_OK, NULL};
		CMPIString *s = CMNewString(&broker, "TEST", &status);
	],
	[
		have_CMPI=yes
	],
	[
		have_CMPI=no
	])

])

AC_DEFUN([CHECK_CMPIHEADERS],
	[
	AC_MSG_CHECKING(for CMPI headers)
	
	CPPFLAGS="$TEMP_CPPFLAGS -DCMPI_PLATFORM_LINUX_GENERIC_GNU -I$OPENDRIMCOMMONINCLUDE/cmpi"
	_CHECK_CMPIHEADERS($OPENDRIMCOMMONINCLUDE)
	if test "$have_CMPI" == "yes"
	then
		CPPFLAGS="$TEMP_CPPFLAGS"
		AC_MSG_RESULT(yes)
	else
		_CHECK_CMPIHEADERS(standard)
		if test "$have_CMPI" == "yes"
		then
			CPPFLAGS="$TEMP_CPPFLAGS"
			AC_MSG_RESULT(yes)
		fi
	fi
	
	if test "$have_CMPI" == "no"
	then
		AC_MSG_ERROR([[no. The CMPI headers could not be found (cmpidt.h, cmpimacs.h, cmpift.h)]])
	fi

	]
)
