/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_DNSGeneralSettingDataAccess.h"

string _InstanceID;

int DNS_OpenDRIM_DNSGeneralSettingData_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(_InstanceID, errorMessage));
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSGeneralSettingData_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSGeneralSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSGeneralSettingData>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DNSGeneralSettingData instance; 
	instance.setInstanceID(_InstanceID);
	
	if (discriminant == "ei")
		CF_assert(DNS_OpenDRIM_DNSGeneralSettingData_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSGeneralSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSGeneralSettingData& instance, const char** properties, string& errorMessage) {
	_E_;
	if(instance.InstanceID!=_InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
		CF_assert(DNS_OpenDRIM_DNSGeneralSettingData_populate(instance, errorMessage));
	_L_;
	return OK;
}

int DNS_OpenDRIM_DNSGeneralSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSGeneralSettingData& newInstance, const OpenDRIM_DNSGeneralSettingData& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSGeneralSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSGeneralSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSGeneralSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSGeneralSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_DNSGeneralSettingData_populate(OpenDRIM_DNSGeneralSettingData& instance, string& errorMessage) {
	_E_;
	instance.setElementName("DNS General Setting");
	instance.setAddressOrigin(2);
	_L_;
	return OK;
}

