/*
 * Copyright (c) 1998, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */



/*  Table mlib_filters_u8_bl
 *
 *  DESCRIPTION
 *    mlib_filters_u8_bl[i].s[0] = mlib_filters_u8_bl[i + 256].s[0] = (511 - 2*i) << SHIFT;
 *    mlib_filters_u8_bl[i].s[2] = mlib_filters_u8_bl[i + 256].s[1] = (511 - 2*i) << SHIFT;
 *    mlib_filters_u8_bl[i].s[1] = mlib_filters_u8_bl[i + 256].s[2] = (2*i + 1) << SHIFT;
 *    mlib_filters_u8_bl[i].s[3] = mlib_filters_u8_bl[i + 256].s[3] = (2*i + 1) << SHIFT;
 *
 *  Where
 *    SHIFT = 5;
 *    i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_u8_bc and mlib_filters_u8_bc2
 *
 *  DESCRIPTION
 *    mlib_filters_u8_bc[i].s[0] = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_u8_bc[i].s[1] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_u8_bc[i].s[2] = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_u8_bc[i].s[3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_u8_bc2[i].s[0] = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_u8_bc2[i].s[1] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_u8_bc2[i].s[2] = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_u8_bc2[i].s[3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 14));
 *    dx = (double)i/256 + 1./512.; i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_u8_bc_3 and mlib_filters_u8_bc2_3
 *
 *  DESCRIPTION
 *    mlib_filters_u8_bc_3[3*i].s[0-2]   = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_u8_bc_3[3*i].s[3]     =
 *    mlib_filters_u8_bc_3[3*i+1].s[0-1] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_u8_bc_3[3*i+1].s[2-3] =
 *    mlib_filters_u8_bc_3[3*i+2].s[0]   = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_u8_bc_3[3*i+2].s[1-3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_u8_bc2_3[3*i].s[0-2]   = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_u8_bc2_3[3*i].s[3]     =
 *    mlib_filters_u8_bc2_3[3*i+1].s[0-1] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_u8_bc2_3[3*i+1].s[2-3] =
 *    mlib_filters_u8_bc2_3[3*i+2].s[0]   = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_u8_bc2_3[3*i+2].s[1-3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 14));
 *    dx = (double)i/256 + 1./512.; i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_u8_bc_4 and mlib_filters_u8_bc2_4
 *
 *  DESCRIPTION
 *    mlib_filters_u8_bc_4[4*i].s[0-3]   = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_u8_bc_4[4*i+1].s[0-3] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_u8_bc_4[4*i+2].s[0-3] = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_u8_bc_4[4*i+3].s[0-3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_u8_bc2_4[4*i].s[0-3]   = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_u8_bc2_4[4*i+1].s[0-3] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_u8_bc2_4[4*i+2].s[0-3] = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_u8_bc2_4[4*i+3].s[0-3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 14));
 *    dx = (double)i/256 + 1./512.; i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_s16_bc and mlib_filters_s16_bc2
 *
 *  DESCRIPTION
 *    mlib_filters_s16_bc[i].s[0] = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_s16_bc[i].s[1] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_s16_bc[i].s[2] = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_s16_bc[i].s[3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_s16_bc2[i].s[0] = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_s16_bc2[i].s[1] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_s16_bc2[i].s[2] = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_s16_bc2[i].s[3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 15));
 *    dx = (double)i/512 + 1./1024.; i = 0, 1, ..., 511;
 *    All 32768 are replace to 32767
 *
 *  Tables mlib_filters_s16_bc_3 and mlib_filters_s16_bc2_3
 *
 *  DESCRIPTION
 *    mlib_filters_s16_bc_3[3*i].s[0-2]   = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_s16_bc_3[3*i].s[3]     =
 *    mlib_filters_s16_bc_3[3*i+1].s[0-1] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_s16_bc_3[3*i+1].s[2-3] =
 *    mlib_filters_s16_bc_3[3*i+2].s[0]   = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_s16_bc_3[3*i+2].s[1-3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_s16_bc2_3[3*i].s[0-2]   = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_s16_bc2_3[3*i].s[3]     =
 *    mlib_filters_s16_bc2_3[3*i+1].s[0-1] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_s16_bc2_3[3*i+1].s[2-3] =
 *    mlib_filters_s16_bc2_3[3*i+2].s[0]   = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_s16_bc2_3[3*i+2].s[1-3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 15));
 *    dx = (double)i/512 + 1./1024.; i = 0, 1, ..., 511;
 *    All 32768 are replace to 32767
 *
 *  Tables mlib_filters_s16_bc_4 and mlib_filters_s16_bc2_4
 *
 *  DESCRIPTION
 *    mlib_filters_s16_bc_4[4*i].s[0-3]   = (mlib_s16) ((-0.5*dx*dx*dx +     dx*dx - 0.5*dx)*PREC - 0.5);
 *    mlib_filters_s16_bc_4[4*i+1].s[0-3] = (mlib_s16) (( 1.5*dx*dx*dx - 2.5*dx*dx + 1.0   )*PREC + 0.5);
 *    mlib_filters_s16_bc_4[4*i+2].s[0-3] = (mlib_s16) ((-1.5*dx*dx*dx + 2.0*dx*dx + 0.5*dx)*PREC + 0.5);
 *    mlib_filters_s16_bc_4[4*i+3].s[0-3] = (mlib_s16) (( 0.5*dx*dx*dx - 0.5*dx*dx         )*PREC - 0.5);
 *
 *    mlib_filters_s16_bc2_4[4*i].s[0-3]   = (mlib_s16) ((-dx*dx*dx + 2.0*dx*dx - dx )*PREC - 0.5);
 *    mlib_filters_s16_bc2_4[4*i+1].s[0-3] = (mlib_s16) (( dx*dx*dx - 2.0*dx*dx + 1.0)*PREC + 0.5);
 *    mlib_filters_s16_bc2_4[4*i+2].s[0-3] = (mlib_s16) ((-dx*dx*dx +     dx*dx + dx )*PREC + 0.5);
 *    mlib_filters_s16_bc2_4[4*i+3].s[0-3] = (mlib_s16) (( dx*dx*dx -     dx*dx      )*PREC - 0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 15));
 *    dx = (double)i/512 + 1./1024.; i = 0, 1, ..., 511;
 *    All 32768 are replace to 32767
 *
 *  COMMENTS
 *    These tables are used by VIS versions of the following functions:
 *      mlib_ImageRotate(Index)
 *      mlib_ImageAffine(Index)
 *      mlib_ImageZoom(Index)
 *      mlib_ImageGridWarp
 *      mlib_ImagePolynomialWarp
 *
 */

#include "mlib_image.h"
#define __INIT_TABLE
#include "mlib_v_ImageFilters.h"

/***************************************************************/
const mlib_s16 mlib_filters_u8_bl[] = {
 16352,     32,  16352,     32,
 16288,     96,  16288,     96,
 16224,    160,  16224,    160,
 16160,    224,  16160,    224,
 16096,    288,  16096,    288,
 16032,    352,  16032,    352,
 15968,    416,  15968,    416,
 15904,    480,  15904,    480,
 15840,    544,  15840,    544,
 15776,    608,  15776,    608,
 15712,    672,  15712,    672,
 15648,    736,  15648,    736,
 15584,    800,  15584,    800,
 15520,    864,  15520,    864,
 15456,    928,  15456,    928,
 15392,    992,  15392,    992,
 15328,   1056,  15328,   1056,
 15264,   1120,  15264,   1120,
 15200,   1184,  15200,   1184,
 15136,   1248,  15136,   1248,
 15072,   1312,  15072,   1312,
 15008,   1376,  15008,   1376,
 14944,   1440,  14944,   1440,
 14880,   1504,  14880,   1504,
 14816,   1568,  14816,   1568,
 14752,   1632,  14752,   1632,
 14688,   1696,  14688,   1696,
 14624,   1760,  14624,   1760,
 14560,   1824,  14560,   1824,
 14496,   1888,  14496,   1888,
 14432,   1952,  14432,   1952,
 14368,   2016,  14368,   2016,
 14304,   2080,  14304,   2080,
 14240,   2144,  14240,   2144,
 14176,   2208,  14176,   2208,
 14112,   2272,  14112,   2272,
 14048,   2336,  14048,   2336,
 13984,   2400,  13984,   2400,
 13920,   2464,  13920,   2464,
 13856,   2528,  13856,   2528,
 13792,   2592,  13792,   2592,
 13728,   2656,  13728,   2656,
 13664,   2720,  13664,   2720,
 13600,   2784,  13600,   2784,
 13536,   2848,  13536,   2848,
 13472,   2912,  13472,   2912,
 13408,   2976,  13408,   2976,
 13344,   3040,  13344,   3040,
 13280,   3104,  13280,   3104,
 13216,   3168,  13216,   3168,
 13152,   3232,  13152,   3232,
 13088,   3296,  13088,   3296,
 13024,   3360,  13024,   3360,
 12960,   3424,  12960,   3424,
 12896,   3488,  12896,   3488,
 12832,   3552,  12832,   3552,
 12768,   3616,  12768,   3616,
 12704,   3680,  12704,   3680,
 12640,   3744,  12640,   3744,
 12576,   3808,  12576,   3808,
 12512,   3872,  12512,   3872,
 12448,   3936,  12448,   3936,
 12384,   4000,  12384,   4000,
 12320,   4064,  12320,   4064,
 12256,   4128,  12256,   4128,
 12192,   4192,  12192,   4192,
 12128,   4256,  12128,   4256,
 12064,   4320,  12064,   4320,
 12000,   4384,  12000,   4384,
 11936,   4448,  11936,   4448,
 11872,   4512,  11872,   4512,
 11808,   4576,  11808,   4576,
 11744,   4640,  11744,   4640,
 11680,   4704,  11680,   4704,
 11616,   4768,  11616,   4768,
 11552,   4832,  11552,   4832,
 11488,   4896,  11488,   4896,
 11424,   4960,  11424,   4960,
 11360,   5024,  11360,   5024,
 11296,   5088,  11296,   5088,
 11232,   5152,  11232,   5152,
 11168,   5216,  11168,   5216,
 11104,   5280,  11104,   5280,
 11040,   5344,  11040,   5344,
 10976,   5408,  10976,   5408,
 10912,   5472,  10912,   5472,
 10848,   5536,  10848,   5536,
 10784,   5600,  10784,   5600,
 10720,   5664,  10720,   5664,
 10656,   5728,  10656,   5728,
 10592,   5792,  10592,   5792,
 10528,   5856,  10528,   5856,
 10464,   5920,  10464,   5920,
 10400,   5984,  10400,   5984,
 10336,   6048,  10336,   6048,
 10272,   6112,  10272,   6112,
 10208,   6176,  10208,   6176,
 10144,   6240,  10144,   6240,
 10080,   6304,  10080,   6304,
 10016,   6368,  10016,   6368,
  9952,   6432,   9952,   6432,
  9888,   6496,   9888,   6496,
  9824,   6560,   9824,   6560,
  9760,   6624,   9760,   6624,
  9696,   6688,   9696,   6688,
  9632,   6752,   9632,   6752,
  9568,   6816,   9568,   6816,
  9504,   6880,   9504,   6880,
  9440,   6944,   9440,   6944,
  9376,   7008,   9376,   7008,
  9312,   7072,   9312,   7072,
  9248,   7136,   9248,   7136,
  9184,   7200,   9184,   7200,
  9120,   7264,   9120,   7264,
  9056,   7328,   9056,   7328,
  8992,   7392,   8992,   7392,
  8928,   7456,   8928,   7456,
  8864,   7520,   8864,   7520,
  8800,   7584,   8800,   7584,
  8736,   7648,   8736,   7648,
  8672,   7712,   8672,   7712,
  8608,   7776,   8608,   7776,
  8544,   7840,   8544,   7840,
  8480,   7904,   8480,   7904,
  8416,   7968,   8416,   7968,
  8352,   8032,   8352,   8032,
  8288,   8096,   8288,   8096,
  8224,   8160,   8224,   8160,
  8160,   8224,   8160,   8224,
  8096,   8288,   8096,   8288,
  8032,   8352,   8032,   8352,
  7968,   8416,   7968,   8416,
  7904,   8480,   7904,   8480,
  7840,   8544,   7840,   8544,
  7776,   8608,   7776,   8608,
  7712,   8672,   7712,   8672,
  7648,   8736,   7648,   8736,
  7584,   8800,   7584,   8800,
  7520,   8864,   7520,   8864,
  7456,   8928,   7456,   8928,
  7392,   8992,   7392,   8992,
  7328,   9056,   7328,   9056,
  7264,   9120,   7264,   9120,
  7200,   9184,   7200,   9184,
  7136,   9248,   7136,   9248,
  7072,   9312,   7072,   9312,
  7008,   9376,   7008,   9376,
  6944,   9440,   6944,   9440,
  6880,   9504,   6880,   9504,
  6816,   9568,   6816,   9568,
  6752,   9632,   6752,   9632,
  6688,   9696,   6688,   9696,
  6624,   9760,   6624,   9760,
  6560,   9824,   6560,   9824,
  6496,   9888,   6496,   9888,
  6432,   9952,   6432,   9952,
  6368,  10016,   6368,  10016,
  6304,  10080,   6304,  10080,
  6240,  10144,   6240,  10144,
  6176,  10208,   6176,  10208,
  6112,  10272,   6112,  10272,
  6048,  10336,   6048,  10336,
  5984,  10400,   5984,  10400,
  5920,  10464,   5920,  10464,
  5856,  10528,   5856,  10528,
  5792,  10592,   5792,  10592,
  5728,  10656,   5728,  10656,
  5664,  10720,   5664,  10720,
  5600,  10784,   5600,  10784,
  5536,  10848,   5536,  10848,
  5472,  10912,   5472,  10912,
  5408,  10976,   5408,  10976,
  5344,  11040,   5344,  11040,
  5280,  11104,   5280,  11104,
  5216,  11168,   5216,  11168,
  5152,  11232,   5152,  11232,
  5088,  11296,   5088,  11296,
  5024,  11360,   5024,  11360,
  4960,  11424,   4960,  11424,
  4896,  11488,   4896,  11488,
  4832,  11552,   4832,  11552,
  4768,  11616,   4768,  11616,
  4704,  11680,   4704,  11680,
  4640,  11744,   4640,  11744,
  4576,  11808,   4576,  11808,
  4512,  11872,   4512,  11872,
  4448,  11936,   4448,  11936,
  4384,  12000,   4384,  12000,
  4320,  12064,   4320,  12064,
  4256,  12128,   4256,  12128,
  4192,  12192,   4192,  12192,
  4128,  12256,   4128,  12256,
  4064,  12320,   4064,  12320,
  4000,  12384,   4000,  12384,
  3936,  12448,   3936,  12448,
  3872,  12512,   3872,  12512,
  3808,  12576,   3808,  12576,
  3744,  12640,   3744,  12640,
  3680,  12704,   3680,  12704,
  3616,  12768,   3616,  12768,
  3552,  12832,   3552,  12832,
  3488,  12896,   3488,  12896,
  3424,  12960,   3424,  12960,
  3360,  13024,   3360,  13024,
  3296,  13088,   3296,  13088,
  3232,  13152,   3232,  13152,
  3168,  13216,   3168,  13216,
  3104,  13280,   3104,  13280,
  3040,  13344,   3040,  13344,
  2976,  13408,   2976,  13408,
  2912,  13472,   2912,  13472,
  2848,  13536,   2848,  13536,
  2784,  13600,   2784,  13600,
  2720,  13664,   2720,  13664,
  2656,  13728,   2656,  13728,
  2592,  13792,   2592,  13792,
  2528,  13856,   2528,  13856,
  2464,  13920,   2464,  13920,
  2400,  13984,   2400,  13984,
  2336,  14048,   2336,  14048,
  2272,  14112,   2272,  14112,
  2208,  14176,   2208,  14176,
  2144,  14240,   2144,  14240,
  2080,  14304,   2080,  14304,
  2016,  14368,   2016,  14368,
  1952,  14432,   1952,  14432,
  1888,  14496,   1888,  14496,
  1824,  14560,   1824,  14560,
  1760,  14624,   1760,  14624,
  1696,  14688,   1696,  14688,
  1632,  14752,   1632,  14752,
  1568,  14816,   1568,  14816,
  1504,  14880,   1504,  14880,
  1440,  14944,   1440,  14944,
  1376,  15008,   1376,  15008,
  1312,  15072,   1312,  15072,
  1248,  15136,   1248,  15136,
  1184,  15200,   1184,  15200,
  1120,  15264,   1120,  15264,
  1056,  15328,   1056,  15328,
   992,  15392,    992,  15392,
   928,  15456,    928,  15456,
   864,  15520,    864,  15520,
   800,  15584,    800,  15584,
   736,  15648,    736,  15648,
   672,  15712,    672,  15712,
   608,  15776,    608,  15776,
   544,  15840,    544,  15840,
   480,  15904,    480,  15904,
   416,  15968,    416,  15968,
   352,  16032,    352,  16032,
   288,  16096,    288,  16096,
   224,  16160,    224,  16160,
   160,  16224,    160,  16224,
    96,  16288,     96,  16288,
    32,  16352,     32,  16352,
 16352,  16352,     32,     32,
 16288,  16288,     96,     96,
 16224,  16224,    160,    160,
 16160,  16160,    224,    224,
 16096,  16096,    288,    288,
 16032,  16032,    352,    352,
 15968,  15968,    416,    416,
 15904,  15904,    480,    480,
 15840,  15840,    544,    544,
 15776,  15776,    608,    608,
 15712,  15712,    672,    672,
 15648,  15648,    736,    736,
 15584,  15584,    800,    800,
 15520,  15520,    864,    864,
 15456,  15456,    928,    928,
 15392,  15392,    992,    992,
 15328,  15328,   1056,   1056,
 15264,  15264,   1120,   1120,
 15200,  15200,   1184,   1184,
 15136,  15136,   1248,   1248,
 15072,  15072,   1312,   1312,
 15008,  15008,   1376,   1376,
 14944,  14944,   1440,   1440,
 14880,  14880,   1504,   1504,
 14816,  14816,   1568,   1568,
 14752,  14752,   1632,   1632,
 14688,  14688,   1696,   1696,
 14624,  14624,   1760,   1760,
 14560,  14560,   1824,   1824,
 14496,  14496,   1888,   1888,
 14432,  14432,   1952,   1952,
 14368,  14368,   2016,   2016,
 14304,  14304,   2080,   2080,
 14240,  14240,   2144,   2144,
 14176,  14176,   2208,   2208,
 14112,  14112,   2272,   2272,
 14048,  14048,   2336,   2336,
 13984,  13984,   2400,   2400,
 13920,  13920,   2464,   2464,
 13856,  13856,   2528,   2528,
 13792,  13792,   2592,   2592,
 13728,  13728,   2656,   2656,
 13664,  13664,   2720,   2720,
 13600,  13600,   2784,   2784,
 13536,  13536,   2848,   2848,
 13472,  13472,   2912,   2912,
 13408,  13408,   2976,   2976,
 13344,  13344,   3040,   3040,
 13280,  13280,   3104,   3104,
 13216,  13216,   3168,   3168,
 13152,  13152,   3232,   3232,
 13088,  13088,   3296,   3296,
 13024,  13024,   3360,   3360,
 12960,  12960,   3424,   3424,
 12896,  12896,   3488,   3488,
 12832,  12832,   3552,   3552,
 12768,  12768,   3616,   3616,
 12704,  12704,   3680,   3680,
 12640,  12640,   3744,   3744,
 12576,  12576,   3808,   3808,
 12512,  12512,   3872,   3872,
 12448,  12448,   3936,   3936,
 12384,  12384,   4000,   4000,
 12320,  12320,   4064,   4064,
 12256,  12256,   4128,   4128,
 12192,  12192,   4192,   4192,
 12128,  12128,   4256,   4256,
 12064,  12064,   4320,   4320,
 12000,  12000,   4384,   4384,
 11936,  11936,   4448,   4448,
 11872,  11872,   4512,   4512,
 11808,  11808,   4576,   4576,
 11744,  11744,   4640,   4640,
 11680,  11680,   4704,   4704,
 11616,  11616,   4768,   4768,
 11552,  11552,   4832,   4832,
 11488,  11488,   4896,   4896,
 11424,  11424,   4960,   4960,
 11360,  11360,   5024,   5024,
 11296,  11296,   5088,   5088,
 11232,  11232,   5152,   5152,
 11168,  11168,   5216,   5216,
 11104,  11104,   5280,   5280,
 11040,  11040,   5344,   5344,
 10976,  10976,   5408,   5408,
 10912,  10912,   5472,   5472,
 10848,  10848,   5536,   5536,
 10784,  10784,   5600,   5600,
 10720,  10720,   5664,   5664,
 10656,  10656,   5728,   5728,
 10592,  10592,   5792,   5792,
 10528,  10528,   5856,   5856,
 10464,  10464,   5920,   5920,
 10400,  10400,   5984,   5984,
 10336,  10336,   6048,   6048,
 10272,  10272,   6112,   6112,
 10208,  10208,   6176,   6176,
 10144,  10144,   6240,   6240,
 10080,  10080,   6304,   6304,
 10016,  10016,   6368,   6368,
  9952,   9952,   6432,   6432,
  9888,   9888,   6496,   6496,
  9824,   9824,   6560,   6560,
  9760,   9760,   6624,   6624,
  9696,   9696,   6688,   6688,
  9632,   9632,   6752,   6752,
  9568,   9568,   6816,   6816,
  9504,   9504,   6880,   6880,
  9440,   9440,   6944,   6944,
  9376,   9376,   7008,   7008,
  9312,   9312,   7072,   7072,
  9248,   9248,   7136,   7136,
  9184,   9184,   7200,   7200,
  9120,   9120,   7264,   7264,
  9056,   9056,   7328,   7328,
  8992,   8992,   7392,   7392,
  8928,   8928,   7456,   7456,
  8864,   8864,   7520,   7520,
  8800,   8800,   7584,   7584,
  8736,   8736,   7648,   7648,
  8672,   8672,   7712,   7712,
  8608,   8608,   7776,   7776,
  8544,   8544,   7840,   7840,
  8480,   8480,   7904,   7904,
  8416,   8416,   7968,   7968,
  8352,   8352,   8032,   8032,
  8288,   8288,   8096,   8096,
  8224,   8224,   8160,   8160,
  8160,   8160,   8224,   8224,
  8096,   8096,   8288,   8288,
  8032,   8032,   8352,   8352,
  7968,   7968,   8416,   8416,
  7904,   7904,   8480,   8480,
  7840,   7840,   8544,   8544,
  7776,   7776,   8608,   8608,
  7712,   7712,   8672,   8672,
  7648,   7648,   8736,   8736,
  7584,   7584,   8800,   8800,
  7520,   7520,   8864,   8864,
  7456,   7456,   8928,   8928,
  7392,   7392,   8992,   8992,
  7328,   7328,   9056,   9056,
  7264,   7264,   9120,   9120,
  7200,   7200,   9184,   9184,
  7136,   7136,   9248,   9248,
  7072,   7072,   9312,   9312,
  7008,   7008,   9376,   9376,
  6944,   6944,   9440,   9440,
  6880,   6880,   9504,   9504,
  6816,   6816,   9568,   9568,
  6752,   6752,   9632,   9632,
  6688,   6688,   9696,   9696,
  6624,   6624,   9760,   9760,
  6560,   6560,   9824,   9824,
  6496,   6496,   9888,   9888,
  6432,   6432,   9952,   9952,
  6368,   6368,  10016,  10016,
  6304,   6304,  10080,  10080,
  6240,   6240,  10144,  10144,
  6176,   6176,  10208,  10208,
  6112,   6112,  10272,  10272,
  6048,   6048,  10336,  10336,
  5984,   5984,  10400,  10400,
  5920,   5920,  10464,  10464,
  5856,   5856,  10528,  10528,
  5792,   5792,  10592,  10592,
  5728,   5728,  10656,  10656,
  5664,   5664,  10720,  10720,
  5600,   5600,  10784,  10784,
  5536,   5536,  10848,  10848,
  5472,   5472,  10912,  10912,
  5408,   5408,  10976,  10976,
  5344,   5344,  11040,  11040,
  5280,   5280,  11104,  11104,
  5216,   5216,  11168,  11168,
  5152,   5152,  11232,  11232,
  5088,   5088,  11296,  11296,
  5024,   5024,  11360,  11360,
  4960,   4960,  11424,  11424,
  4896,   4896,  11488,  11488,
  4832,   4832,  11552,  11552,
  4768,   4768,  11616,  11616,
  4704,   4704,  11680,  11680,
  4640,   4640,  11744,  11744,
  4576,   4576,  11808,  11808,
  4512,   4512,  11872,  11872,
  4448,   4448,  11936,  11936,
  4384,   4384,  12000,  12000,
  4320,   4320,  12064,  12064,
  4256,   4256,  12128,  12128,
  4192,   4192,  12192,  12192,
  4128,   4128,  12256,  12256,
  4064,   4064,  12320,  12320,
  4000,   4000,  12384,  12384,
  3936,   3936,  12448,  12448,
  3872,   3872,  12512,  12512,
  3808,   3808,  12576,  12576,
  3744,   3744,  12640,  12640,
  3680,   3680,  12704,  12704,
  3616,   3616,  12768,  12768,
  3552,   3552,  12832,  12832,
  3488,   3488,  12896,  12896,
  3424,   3424,  12960,  12960,
  3360,   3360,  13024,  13024,
  3296,   3296,  13088,  13088,
  3232,   3232,  13152,  13152,
  3168,   3168,  13216,  13216,
  3104,   3104,  13280,  13280,
  3040,   3040,  13344,  13344,
  2976,   2976,  13408,  13408,
  2912,   2912,  13472,  13472,
  2848,   2848,  13536,  13536,
  2784,   2784,  13600,  13600,
  2720,   2720,  13664,  13664,
  2656,   2656,  13728,  13728,
  2592,   2592,  13792,  13792,
  2528,   2528,  13856,  13856,
  2464,   2464,  13920,  13920,
  2400,   2400,  13984,  13984,
  2336,   2336,  14048,  14048,
  2272,   2272,  14112,  14112,
  2208,   2208,  14176,  14176,
  2144,   2144,  14240,  14240,
  2080,   2080,  14304,  14304,
  2016,   2016,  14368,  14368,
  1952,   1952,  14432,  14432,
  1888,   1888,  14496,  14496,
  1824,   1824,  14560,  14560,
  1760,   1760,  14624,  14624,
  1696,   1696,  14688,  14688,
  1632,   1632,  14752,  14752,
  1568,   1568,  14816,  14816,
  1504,   1504,  14880,  14880,
  1440,   1440,  14944,  14944,
  1376,   1376,  15008,  15008,
  1312,   1312,  15072,  15072,
  1248,   1248,  15136,  15136,
  1184,   1184,  15200,  15200,
  1120,   1120,  15264,  15264,
  1056,   1056,  15328,  15328,
   992,    992,  15392,  15392,
   928,    928,  15456,  15456,
   864,    864,  15520,  15520,
   800,    800,  15584,  15584,
   736,    736,  15648,  15648,
   672,    672,  15712,  15712,
   608,    608,  15776,  15776,
   544,    544,  15840,  15840,
   480,    480,  15904,  15904,
   416,    416,  15968,  15968,
   352,    352,  16032,  16032,
   288,    288,  16096,  16096,
   224,    224,  16160,  16160,
   160,    160,  16224,  16224,
    96,     96,  16288,  16288,
    32,     32,  16352,  16352
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc[] = {
   -16,  16384,     16,      0,
   -47,  16383,     49,      0,
   -78,  16380,     83,     -1,
  -109,  16376,    118,     -2,
  -139,  16371,    154,     -2,
  -169,  16365,    191,     -4,
  -198,  16358,    229,     -5,
  -226,  16349,    268,     -7,
  -254,  16340,    307,     -9,
  -282,  16329,    348,    -11,
  -309,  16317,    389,    -13,
  -336,  16304,    432,    -16,
  -362,  16289,    475,    -19,
  -388,  16274,    520,    -22,
  -413,  16257,    565,    -25,
  -438,  16239,    611,    -28,
  -462,  16220,    658,    -32,
  -486,  16200,    705,    -36,
  -510,  16179,    754,    -40,
  -533,  16157,    803,    -44,
  -555,  16134,    854,    -48,
  -577,  16110,    905,    -53,
  -599,  16084,    956,    -58,
  -620,  16058,   1009,    -63,
  -641,  16030,   1063,    -68,
  -662,  16002,   1117,    -73,
  -682,  15972,   1172,    -79,
  -701,  15942,   1228,    -84,
  -720,  15910,   1284,    -90,
  -739,  15878,   1342,    -96,
  -757,  15844,   1400,   -102,
  -775,  15810,   1458,   -109,
  -793,  15774,   1518,   -115,
  -810,  15738,   1578,   -122,
  -826,  15700,   1639,   -129,
  -843,  15662,   1701,   -136,
  -859,  15623,   1763,   -143,
  -874,  15582,   1826,   -150,
  -889,  15541,   1890,   -157,
  -904,  15499,   1954,   -165,
  -918,  15456,   2019,   -173,
  -932,  15412,   2084,   -180,
  -946,  15368,   2151,   -188,
  -959,  15322,   2218,   -196,
  -972,  15275,   2285,   -205,
  -984,  15228,   2353,   -213,
  -997,  15180,   2422,   -221,
 -1008,  15131,   2491,   -230,
 -1020,  15081,   2561,   -238,
 -1031,  15030,   2631,   -247,
 -1041,  14979,   2702,   -256,
 -1052,  14926,   2774,   -265,
 -1062,  14873,   2846,   -274,
 -1071,  14819,   2919,   -283,
 -1080,  14765,   2992,   -292,
 -1089,  14709,   3066,   -302,
 -1098,  14653,   3140,   -311,
 -1106,  14596,   3215,   -320,
 -1114,  14538,   3290,   -330,
 -1122,  14480,   3366,   -340,
 -1129,  14421,   3442,   -349,
 -1136,  14361,   3518,   -359,
 -1143,  14300,   3595,   -369,
 -1149,  14239,   3673,   -379,
 -1155,  14177,   3751,   -389,
 -1161,  14114,   3829,   -399,
 -1166,  14051,   3908,   -409,
 -1171,  13987,   3988,   -419,
 -1176,  13922,   4067,   -430,
 -1180,  13857,   4147,   -440,
 -1185,  13791,   4228,   -450,
 -1188,  13724,   4309,   -461,
 -1192,  13657,   4390,   -471,
 -1195,  13589,   4471,   -481,
 -1198,  13521,   4553,   -492,
 -1201,  13452,   4636,   -502,
 -1204,  13382,   4718,   -513,
 -1206,  13312,   4801,   -523,
 -1208,  13241,   4885,   -534,
 -1209,  13170,   4968,   -545,
 -1211,  13098,   5052,   -555,
 -1212,  13026,   5136,   -566,
 -1213,  12953,   5221,   -577,
 -1213,  12879,   5305,   -587,
 -1214,  12805,   5390,   -598,
 -1214,  12731,   5476,   -609,
 -1213,  12656,   5561,   -619,
 -1213,  12580,   5647,   -630,
 -1212,  12504,   5733,   -641,
 -1211,  12428,   5819,   -651,
 -1210,  12351,   5905,   -662,
 -1209,  12274,   5992,   -672,
 -1207,  12196,   6079,   -683,
 -1206,  12117,   6166,   -694,
 -1204,  12039,   6253,   -704,
 -1201,  11960,   6340,   -715,
 -1199,  11880,   6428,   -725,
 -1196,  11800,   6515,   -736,
 -1193,  11720,   6603,   -746,
 -1190,  11639,   6691,   -757,
 -1187,  11558,   6779,   -767,
 -1183,  11477,   6867,   -777,
 -1179,  11395,   6956,   -787,
 -1175,  11313,   7044,   -798,
 -1171,  11230,   7132,   -808,
 -1167,  11148,   7221,   -818,
 -1162,  11065,   7310,   -828,
 -1158,  10981,   7398,   -838,
 -1153,  10897,   7487,   -848,
 -1148,  10813,   7576,   -858,
 -1142,  10729,   7665,   -867,
 -1137,  10644,   7754,   -877,
 -1131,  10560,   7842,   -887,
 -1125,  10474,   7931,   -896,
 -1119,  10389,   8020,   -906,
 -1113,  10303,   8109,   -915,
 -1107,  10218,   8198,   -924,
 -1101,  10131,   8287,   -934,
 -1094,  10045,   8376,   -943,
 -1087,   9959,   8464,   -952,
 -1080,   9872,   8553,   -961,
 -1073,   9785,   8642,   -969,
 -1066,   9698,   8730,   -978,
 -1059,   9611,   8819,   -987,
 -1051,   9523,   8907,   -995,
 -1044,   9436,   8996,  -1004,
 -1036,   9348,   9084,  -1012,
 -1028,   9260,   9172,  -1020,
 -1020,   9172,   9260,  -1028,
 -1012,   9084,   9348,  -1036,
 -1004,   8996,   9436,  -1044,
  -995,   8907,   9523,  -1051,
  -987,   8819,   9611,  -1059,
  -978,   8730,   9698,  -1066,
  -969,   8642,   9785,  -1073,
  -961,   8553,   9872,  -1080,
  -952,   8464,   9959,  -1087,
  -943,   8376,  10045,  -1094,
  -934,   8287,  10131,  -1101,
  -924,   8198,  10218,  -1107,
  -915,   8109,  10303,  -1113,
  -906,   8020,  10389,  -1119,
  -896,   7931,  10474,  -1125,
  -887,   7842,  10560,  -1131,
  -877,   7754,  10644,  -1137,
  -867,   7665,  10729,  -1142,
  -858,   7576,  10813,  -1148,
  -848,   7487,  10897,  -1153,
  -838,   7398,  10981,  -1158,
  -828,   7310,  11065,  -1162,
  -818,   7221,  11148,  -1167,
  -808,   7132,  11230,  -1171,
  -798,   7044,  11313,  -1175,
  -787,   6956,  11395,  -1179,
  -777,   6867,  11477,  -1183,
  -767,   6779,  11558,  -1187,
  -757,   6691,  11639,  -1190,
  -746,   6603,  11720,  -1193,
  -736,   6515,  11800,  -1196,
  -725,   6428,  11880,  -1199,
  -715,   6340,  11960,  -1201,
  -704,   6253,  12039,  -1204,
  -694,   6166,  12117,  -1206,
  -683,   6079,  12196,  -1207,
  -672,   5992,  12274,  -1209,
  -662,   5905,  12351,  -1210,
  -651,   5819,  12428,  -1211,
  -641,   5733,  12504,  -1212,
  -630,   5647,  12580,  -1213,
  -619,   5561,  12656,  -1213,
  -609,   5476,  12731,  -1214,
  -598,   5390,  12805,  -1214,
  -587,   5305,  12879,  -1213,
  -577,   5221,  12953,  -1213,
  -566,   5136,  13026,  -1212,
  -555,   5052,  13098,  -1211,
  -545,   4968,  13170,  -1209,
  -534,   4885,  13241,  -1208,
  -523,   4801,  13312,  -1206,
  -513,   4718,  13382,  -1204,
  -502,   4636,  13452,  -1201,
  -492,   4553,  13521,  -1198,
  -481,   4471,  13589,  -1195,
  -471,   4390,  13657,  -1192,
  -461,   4309,  13724,  -1188,
  -450,   4228,  13791,  -1185,
  -440,   4147,  13857,  -1180,
  -430,   4067,  13922,  -1176,
  -419,   3988,  13987,  -1171,
  -409,   3908,  14051,  -1166,
  -399,   3829,  14114,  -1161,
  -389,   3751,  14177,  -1155,
  -379,   3673,  14239,  -1149,
  -369,   3595,  14300,  -1143,
  -359,   3518,  14361,  -1136,
  -349,   3442,  14421,  -1129,
  -340,   3366,  14480,  -1122,
  -330,   3290,  14538,  -1114,
  -320,   3215,  14596,  -1106,
  -311,   3140,  14653,  -1098,
  -302,   3066,  14709,  -1089,
  -292,   2992,  14765,  -1080,
  -283,   2919,  14819,  -1071,
  -274,   2846,  14873,  -1062,
  -265,   2774,  14926,  -1052,
  -256,   2702,  14979,  -1041,
  -247,   2631,  15030,  -1031,
  -238,   2561,  15081,  -1020,
  -230,   2491,  15131,  -1008,
  -221,   2422,  15180,   -997,
  -213,   2353,  15228,   -984,
  -205,   2285,  15275,   -972,
  -196,   2218,  15322,   -959,
  -188,   2151,  15368,   -946,
  -180,   2084,  15412,   -932,
  -173,   2019,  15456,   -918,
  -165,   1954,  15499,   -904,
  -157,   1890,  15541,   -889,
  -150,   1826,  15582,   -874,
  -143,   1763,  15623,   -859,
  -136,   1701,  15662,   -843,
  -129,   1639,  15700,   -826,
  -122,   1578,  15738,   -810,
  -115,   1518,  15774,   -793,
  -109,   1458,  15810,   -775,
  -102,   1400,  15844,   -757,
   -96,   1342,  15878,   -739,
   -90,   1284,  15910,   -720,
   -84,   1228,  15942,   -701,
   -79,   1172,  15972,   -682,
   -73,   1117,  16002,   -662,
   -68,   1063,  16030,   -641,
   -63,   1009,  16058,   -620,
   -58,    956,  16084,   -599,
   -53,    905,  16110,   -577,
   -48,    854,  16134,   -555,
   -44,    803,  16157,   -533,
   -40,    754,  16179,   -510,
   -36,    705,  16200,   -486,
   -32,    658,  16220,   -462,
   -28,    611,  16239,   -438,
   -25,    565,  16257,   -413,
   -22,    520,  16274,   -388,
   -19,    475,  16289,   -362,
   -16,    432,  16304,   -336,
   -13,    389,  16317,   -309,
   -11,    348,  16329,   -282,
    -9,    307,  16340,   -254,
    -7,    268,  16349,   -226,
    -5,    229,  16358,   -198,
    -4,    191,  16365,   -169,
    -2,    154,  16371,   -139,
    -2,    118,  16376,   -109,
    -1,     83,  16380,    -78,
     0,     49,  16383,    -47,
     0,     16,  16384,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc2[] = {
   -32,  16384,     32,      0,
   -95,  16383,     97,     -1,
  -157,  16381,    162,     -2,
  -218,  16378,    227,     -3,
  -278,  16374,    293,     -5,
  -337,  16369,    359,     -7,
  -395,  16363,    426,    -10,
  -452,  16356,    494,    -14,
  -508,  16348,    561,    -17,
  -564,  16340,    630,    -22,
  -618,  16330,    698,    -26,
  -671,  16319,    768,    -32,
  -724,  16308,    837,    -37,
  -775,  16295,    907,    -43,
  -826,  16282,    978,    -50,
  -876,  16268,   1048,    -56,
  -924,  16252,   1120,    -64,
  -972,  16236,   1191,    -71,
 -1019,  16219,   1263,    -79,
 -1065,  16201,   1336,    -88,
 -1110,  16182,   1409,    -97,
 -1155,  16163,   1482,   -106,
 -1198,  16142,   1555,   -115,
 -1241,  16121,   1629,   -125,
 -1282,  16098,   1704,   -136,
 -1323,  16075,   1778,   -146,
 -1363,  16051,   1853,   -157,
 -1402,  16026,   1929,   -169,
 -1440,  16000,   2004,   -180,
 -1478,  15974,   2080,   -192,
 -1515,  15947,   2157,   -205,
 -1550,  15918,   2234,   -218,
 -1585,  15889,   2311,   -231,
 -1620,  15860,   2388,   -244,
 -1653,  15829,   2465,   -257,
 -1686,  15798,   2543,   -271,
 -1717,  15765,   2622,   -286,
 -1748,  15732,   2700,   -300,
 -1779,  15699,   2779,   -315,
 -1808,  15664,   2858,   -330,
 -1837,  15629,   2937,   -345,
 -1865,  15593,   3017,   -361,
 -1892,  15556,   3097,   -377,
 -1918,  15518,   3177,   -393,
 -1944,  15480,   3257,   -409,
 -1969,  15441,   3338,   -426,
 -1993,  15401,   3418,   -442,
 -2017,  15361,   3499,   -459,
 -2039,  15319,   3581,   -477,
 -2061,  15277,   3662,   -494,
 -2083,  15235,   3744,   -512,
 -2103,  15191,   3826,   -530,
 -2123,  15147,   3908,   -548,
 -2142,  15102,   3990,   -566,
 -2161,  15057,   4072,   -584,
 -2179,  15011,   4155,   -603,
 -2196,  14964,   4238,   -622,
 -2213,  14917,   4321,   -641,
 -2228,  14868,   4404,   -660,
 -2244,  14820,   4487,   -679,
 -2258,  14770,   4571,   -699,
 -2272,  14720,   4654,   -718,
 -2285,  14669,   4738,   -738,
 -2298,  14618,   4822,   -758,
 -2310,  14566,   4906,   -778,
 -2321,  14513,   4990,   -798,
 -2332,  14460,   5074,   -818,
 -2342,  14406,   5159,   -839,
 -2352,  14352,   5243,   -859,
 -2361,  14297,   5328,   -880,
 -2369,  14241,   5412,   -900,
 -2377,  14185,   5497,   -921,
 -2384,  14128,   5582,   -942,
 -2391,  14071,   5667,   -963,
 -2397,  14013,   5752,   -984,
 -2402,  13954,   5837,  -1005,
 -2407,  13895,   5922,  -1026,
 -2411,  13835,   6007,  -1047,
 -2415,  13775,   6092,  -1068,
 -2419,  13715,   6177,  -1089,
 -2421,  13653,   6263,  -1111,
 -2424,  13592,   6348,  -1132,
 -2425,  13529,   6433,  -1153,
 -2426,  13466,   6519,  -1175,
 -2427,  13403,   6604,  -1196,
 -2427,  13339,   6689,  -1217,
 -2427,  13275,   6775,  -1239,
 -2426,  13210,   6860,  -1260,
 -2425,  13145,   6945,  -1281,
 -2423,  13079,   7030,  -1302,
 -2421,  13013,   7116,  -1324,
 -2418,  12946,   7201,  -1345,
 -2415,  12879,   7286,  -1366,
 -2411,  12811,   7371,  -1387,
 -2407,  12743,   7456,  -1408,
 -2402,  12674,   7541,  -1429,
 -2397,  12605,   7626,  -1450,
 -2392,  12536,   7711,  -1471,
 -2386,  12466,   7796,  -1492,
 -2380,  12396,   7881,  -1513,
 -2373,  12325,   7966,  -1534,
 -2366,  12254,   8050,  -1554,
 -2359,  12183,   8135,  -1575,
 -2351,  12111,   8219,  -1595,
 -2342,  12038,   8304,  -1616,
 -2334,  11966,   8388,  -1636,
 -2325,  11893,   8472,  -1656,
 -2315,  11819,   8556,  -1676,
 -2305,  11745,   8640,  -1696,
 -2295,  11671,   8723,  -1715,
 -2284,  11596,   8807,  -1735,
 -2274,  11522,   8890,  -1754,
 -2262,  11446,   8974,  -1774,
 -2251,  11371,   9057,  -1793,
 -2239,  11295,   9140,  -1812,
 -2227,  11219,   9222,  -1830,
 -2214,  11142,   9305,  -1849,
 -2201,  11065,   9387,  -1867,
 -2188,  10988,   9470,  -1886,
 -2174,  10910,   9552,  -1904,
 -2161,  10833,   9633,  -1921,
 -2146,  10754,   9715,  -1939,
 -2132,  10676,   9796,  -1956,
 -2117,  10597,   9878,  -1974,
 -2102,  10518,   9959,  -1991,
 -2087,  10439,  10039,  -2007,
 -2072,  10360,  10120,  -2024,
 -2056,  10280,  10200,  -2040,
 -2040,  10200,  10280,  -2056,
 -2024,  10120,  10360,  -2072,
 -2007,  10039,  10439,  -2087,
 -1991,   9959,  10518,  -2102,
 -1974,   9878,  10597,  -2117,
 -1956,   9796,  10676,  -2132,
 -1939,   9715,  10754,  -2146,
 -1921,   9633,  10833,  -2161,
 -1904,   9552,  10910,  -2174,
 -1886,   9470,  10988,  -2188,
 -1867,   9387,  11065,  -2201,
 -1849,   9305,  11142,  -2214,
 -1830,   9222,  11219,  -2227,
 -1812,   9140,  11295,  -2239,
 -1793,   9057,  11371,  -2251,
 -1774,   8974,  11446,  -2262,
 -1754,   8890,  11522,  -2274,
 -1735,   8807,  11596,  -2284,
 -1715,   8723,  11671,  -2295,
 -1696,   8640,  11745,  -2305,
 -1676,   8556,  11819,  -2315,
 -1656,   8472,  11893,  -2325,
 -1636,   8388,  11966,  -2334,
 -1616,   8304,  12038,  -2342,
 -1595,   8219,  12111,  -2351,
 -1575,   8135,  12183,  -2359,
 -1554,   8050,  12254,  -2366,
 -1534,   7966,  12325,  -2373,
 -1513,   7881,  12396,  -2380,
 -1492,   7796,  12466,  -2386,
 -1471,   7711,  12536,  -2392,
 -1450,   7626,  12605,  -2397,
 -1429,   7541,  12674,  -2402,
 -1408,   7456,  12743,  -2407,
 -1387,   7371,  12811,  -2411,
 -1366,   7286,  12879,  -2415,
 -1345,   7201,  12946,  -2418,
 -1324,   7116,  13013,  -2421,
 -1302,   7030,  13079,  -2423,
 -1281,   6945,  13145,  -2425,
 -1260,   6860,  13210,  -2426,
 -1239,   6775,  13275,  -2427,
 -1217,   6689,  13339,  -2427,
 -1196,   6604,  13403,  -2427,
 -1175,   6519,  13466,  -2426,
 -1153,   6433,  13529,  -2425,
 -1132,   6348,  13592,  -2424,
 -1111,   6263,  13653,  -2421,
 -1089,   6177,  13715,  -2419,
 -1068,   6092,  13775,  -2415,
 -1047,   6007,  13835,  -2411,
 -1026,   5922,  13895,  -2407,
 -1005,   5837,  13954,  -2402,
  -984,   5752,  14013,  -2397,
  -963,   5667,  14071,  -2391,
  -942,   5582,  14128,  -2384,
  -921,   5497,  14185,  -2377,
  -900,   5412,  14241,  -2369,
  -880,   5328,  14297,  -2361,
  -859,   5243,  14352,  -2352,
  -839,   5159,  14406,  -2342,
  -818,   5074,  14460,  -2332,
  -798,   4990,  14513,  -2321,
  -778,   4906,  14566,  -2310,
  -758,   4822,  14618,  -2298,
  -738,   4738,  14669,  -2285,
  -718,   4654,  14720,  -2272,
  -699,   4571,  14770,  -2258,
  -679,   4487,  14820,  -2244,
  -660,   4404,  14868,  -2228,
  -641,   4321,  14917,  -2213,
  -622,   4238,  14964,  -2196,
  -603,   4155,  15011,  -2179,
  -584,   4072,  15057,  -2161,
  -566,   3990,  15102,  -2142,
  -548,   3908,  15147,  -2123,
  -530,   3826,  15191,  -2103,
  -512,   3744,  15235,  -2083,
  -494,   3662,  15277,  -2061,
  -477,   3581,  15319,  -2039,
  -459,   3499,  15361,  -2017,
  -442,   3418,  15401,  -1993,
  -426,   3338,  15441,  -1969,
  -409,   3257,  15480,  -1944,
  -393,   3177,  15518,  -1918,
  -377,   3097,  15556,  -1892,
  -361,   3017,  15593,  -1865,
  -345,   2937,  15629,  -1837,
  -330,   2858,  15664,  -1808,
  -315,   2779,  15699,  -1779,
  -300,   2700,  15732,  -1748,
  -286,   2622,  15765,  -1717,
  -271,   2543,  15798,  -1686,
  -257,   2465,  15829,  -1653,
  -244,   2388,  15860,  -1620,
  -231,   2311,  15889,  -1585,
  -218,   2234,  15918,  -1550,
  -205,   2157,  15947,  -1515,
  -192,   2080,  15974,  -1478,
  -180,   2004,  16000,  -1440,
  -169,   1929,  16026,  -1402,
  -157,   1853,  16051,  -1363,
  -146,   1778,  16075,  -1323,
  -136,   1704,  16098,  -1282,
  -125,   1629,  16121,  -1241,
  -115,   1555,  16142,  -1198,
  -106,   1482,  16163,  -1155,
   -97,   1409,  16182,  -1110,
   -88,   1336,  16201,  -1065,
   -79,   1263,  16219,  -1019,
   -71,   1191,  16236,   -972,
   -64,   1120,  16252,   -924,
   -56,   1048,  16268,   -876,
   -50,    978,  16282,   -826,
   -43,    907,  16295,   -775,
   -37,    837,  16308,   -724,
   -32,    768,  16319,   -671,
   -26,    698,  16330,   -618,
   -22,    630,  16340,   -564,
   -17,    561,  16348,   -508,
   -14,    494,  16356,   -452,
   -10,    426,  16363,   -395,
    -7,    359,  16369,   -337,
    -5,    293,  16374,   -278,
    -3,    227,  16378,   -218,
    -2,    162,  16381,   -157,
    -1,     97,  16383,    -95,
     0,     32,  16384,    -32
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc_3[] = {
   -16,    -16,    -16,
 16384,  16384,  16384,
    16,     16,     16,
     0,      0,      0,
   -47,    -47,    -47,
 16383,  16383,  16383,
    49,     49,     49,
     0,      0,      0,
   -78,    -78,    -78,
 16380,  16380,  16380,
    83,     83,     83,
    -1,     -1,     -1,
  -109,   -109,   -109,
 16376,  16376,  16376,
   118,    118,    118,
    -2,     -2,     -2,
  -139,   -139,   -139,
 16371,  16371,  16371,
   154,    154,    154,
    -2,     -2,     -2,
  -169,   -169,   -169,
 16365,  16365,  16365,
   191,    191,    191,
    -4,     -4,     -4,
  -198,   -198,   -198,
 16358,  16358,  16358,
   229,    229,    229,
    -5,     -5,     -5,
  -226,   -226,   -226,
 16349,  16349,  16349,
   268,    268,    268,
    -7,     -7,     -7,
  -254,   -254,   -254,
 16340,  16340,  16340,
   307,    307,    307,
    -9,     -9,     -9,
  -282,   -282,   -282,
 16329,  16329,  16329,
   348,    348,    348,
   -11,    -11,    -11,
  -309,   -309,   -309,
 16317,  16317,  16317,
   389,    389,    389,
   -13,    -13,    -13,
  -336,   -336,   -336,
 16304,  16304,  16304,
   432,    432,    432,
   -16,    -16,    -16,
  -362,   -362,   -362,
 16289,  16289,  16289,
   475,    475,    475,
   -19,    -19,    -19,
  -388,   -388,   -388,
 16274,  16274,  16274,
   520,    520,    520,
   -22,    -22,    -22,
  -413,   -413,   -413,
 16257,  16257,  16257,
   565,    565,    565,
   -25,    -25,    -25,
  -438,   -438,   -438,
 16239,  16239,  16239,
   611,    611,    611,
   -28,    -28,    -28,
  -462,   -462,   -462,
 16220,  16220,  16220,
   658,    658,    658,
   -32,    -32,    -32,
  -486,   -486,   -486,
 16200,  16200,  16200,
   705,    705,    705,
   -36,    -36,    -36,
  -510,   -510,   -510,
 16179,  16179,  16179,
   754,    754,    754,
   -40,    -40,    -40,
  -533,   -533,   -533,
 16157,  16157,  16157,
   803,    803,    803,
   -44,    -44,    -44,
  -555,   -555,   -555,
 16134,  16134,  16134,
   854,    854,    854,
   -48,    -48,    -48,
  -577,   -577,   -577,
 16110,  16110,  16110,
   905,    905,    905,
   -53,    -53,    -53,
  -599,   -599,   -599,
 16084,  16084,  16084,
   956,    956,    956,
   -58,    -58,    -58,
  -620,   -620,   -620,
 16058,  16058,  16058,
  1009,   1009,   1009,
   -63,    -63,    -63,
  -641,   -641,   -641,
 16030,  16030,  16030,
  1063,   1063,   1063,
   -68,    -68,    -68,
  -662,   -662,   -662,
 16002,  16002,  16002,
  1117,   1117,   1117,
   -73,    -73,    -73,
  -682,   -682,   -682,
 15972,  15972,  15972,
  1172,   1172,   1172,
   -79,    -79,    -79,
  -701,   -701,   -701,
 15942,  15942,  15942,
  1228,   1228,   1228,
   -84,    -84,    -84,
  -720,   -720,   -720,
 15910,  15910,  15910,
  1284,   1284,   1284,
   -90,    -90,    -90,
  -739,   -739,   -739,
 15878,  15878,  15878,
  1342,   1342,   1342,
   -96,    -96,    -96,
  -757,   -757,   -757,
 15844,  15844,  15844,
  1400,   1400,   1400,
  -102,   -102,   -102,
  -775,   -775,   -775,
 15810,  15810,  15810,
  1458,   1458,   1458,
  -109,   -109,   -109,
  -793,   -793,   -793,
 15774,  15774,  15774,
  1518,   1518,   1518,
  -115,   -115,   -115,
  -810,   -810,   -810,
 15738,  15738,  15738,
  1578,   1578,   1578,
  -122,   -122,   -122,
  -826,   -826,   -826,
 15700,  15700,  15700,
  1639,   1639,   1639,
  -129,   -129,   -129,
  -843,   -843,   -843,
 15662,  15662,  15662,
  1701,   1701,   1701,
  -136,   -136,   -136,
  -859,   -859,   -859,
 15623,  15623,  15623,
  1763,   1763,   1763,
  -143,   -143,   -143,
  -874,   -874,   -874,
 15582,  15582,  15582,
  1826,   1826,   1826,
  -150,   -150,   -150,
  -889,   -889,   -889,
 15541,  15541,  15541,
  1890,   1890,   1890,
  -157,   -157,   -157,
  -904,   -904,   -904,
 15499,  15499,  15499,
  1954,   1954,   1954,
  -165,   -165,   -165,
  -918,   -918,   -918,
 15456,  15456,  15456,
  2019,   2019,   2019,
  -173,   -173,   -173,
  -932,   -932,   -932,
 15412,  15412,  15412,
  2084,   2084,   2084,
  -180,   -180,   -180,
  -946,   -946,   -946,
 15368,  15368,  15368,
  2151,   2151,   2151,
  -188,   -188,   -188,
  -959,   -959,   -959,
 15322,  15322,  15322,
  2218,   2218,   2218,
  -196,   -196,   -196,
  -972,   -972,   -972,
 15275,  15275,  15275,
  2285,   2285,   2285,
  -205,   -205,   -205,
  -984,   -984,   -984,
 15228,  15228,  15228,
  2353,   2353,   2353,
  -213,   -213,   -213,
  -997,   -997,   -997,
 15180,  15180,  15180,
  2422,   2422,   2422,
  -221,   -221,   -221,
 -1008,  -1008,  -1008,
 15131,  15131,  15131,
  2491,   2491,   2491,
  -230,   -230,   -230,
 -1020,  -1020,  -1020,
 15081,  15081,  15081,
  2561,   2561,   2561,
  -238,   -238,   -238,
 -1031,  -1031,  -1031,
 15030,  15030,  15030,
  2631,   2631,   2631,
  -247,   -247,   -247,
 -1041,  -1041,  -1041,
 14979,  14979,  14979,
  2702,   2702,   2702,
  -256,   -256,   -256,
 -1052,  -1052,  -1052,
 14926,  14926,  14926,
  2774,   2774,   2774,
  -265,   -265,   -265,
 -1062,  -1062,  -1062,
 14873,  14873,  14873,
  2846,   2846,   2846,
  -274,   -274,   -274,
 -1071,  -1071,  -1071,
 14819,  14819,  14819,
  2919,   2919,   2919,
  -283,   -283,   -283,
 -1080,  -1080,  -1080,
 14765,  14765,  14765,
  2992,   2992,   2992,
  -292,   -292,   -292,
 -1089,  -1089,  -1089,
 14709,  14709,  14709,
  3066,   3066,   3066,
  -302,   -302,   -302,
 -1098,  -1098,  -1098,
 14653,  14653,  14653,
  3140,   3140,   3140,
  -311,   -311,   -311,
 -1106,  -1106,  -1106,
 14596,  14596,  14596,
  3215,   3215,   3215,
  -320,   -320,   -320,
 -1114,  -1114,  -1114,
 14538,  14538,  14538,
  3290,   3290,   3290,
  -330,   -330,   -330,
 -1122,  -1122,  -1122,
 14480,  14480,  14480,
  3366,   3366,   3366,
  -340,   -340,   -340,
 -1129,  -1129,  -1129,
 14421,  14421,  14421,
  3442,   3442,   3442,
  -349,   -349,   -349,
 -1136,  -1136,  -1136,
 14361,  14361,  14361,
  3518,   3518,   3518,
  -359,   -359,   -359,
 -1143,  -1143,  -1143,
 14300,  14300,  14300,
  3595,   3595,   3595,
  -369,   -369,   -369,
 -1149,  -1149,  -1149,
 14239,  14239,  14239,
  3673,   3673,   3673,
  -379,   -379,   -379,
 -1155,  -1155,  -1155,
 14177,  14177,  14177,
  3751,   3751,   3751,
  -389,   -389,   -389,
 -1161,  -1161,  -1161,
 14114,  14114,  14114,
  3829,   3829,   3829,
  -399,   -399,   -399,
 -1166,  -1166,  -1166,
 14051,  14051,  14051,
  3908,   3908,   3908,
  -409,   -409,   -409,
 -1171,  -1171,  -1171,
 13987,  13987,  13987,
  3988,   3988,   3988,
  -419,   -419,   -419,
 -1176,  -1176,  -1176,
 13922,  13922,  13922,
  4067,   4067,   4067,
  -430,   -430,   -430,
 -1180,  -1180,  -1180,
 13857,  13857,  13857,
  4147,   4147,   4147,
  -440,   -440,   -440,
 -1185,  -1185,  -1185,
 13791,  13791,  13791,
  4228,   4228,   4228,
  -450,   -450,   -450,
 -1188,  -1188,  -1188,
 13724,  13724,  13724,
  4309,   4309,   4309,
  -461,   -461,   -461,
 -1192,  -1192,  -1192,
 13657,  13657,  13657,
  4390,   4390,   4390,
  -471,   -471,   -471,
 -1195,  -1195,  -1195,
 13589,  13589,  13589,
  4471,   4471,   4471,
  -481,   -481,   -481,
 -1198,  -1198,  -1198,
 13521,  13521,  13521,
  4553,   4553,   4553,
  -492,   -492,   -492,
 -1201,  -1201,  -1201,
 13452,  13452,  13452,
  4636,   4636,   4636,
  -502,   -502,   -502,
 -1204,  -1204,  -1204,
 13382,  13382,  13382,
  4718,   4718,   4718,
  -513,   -513,   -513,
 -1206,  -1206,  -1206,
 13312,  13312,  13312,
  4801,   4801,   4801,
  -523,   -523,   -523,
 -1208,  -1208,  -1208,
 13241,  13241,  13241,
  4885,   4885,   4885,
  -534,   -534,   -534,
 -1209,  -1209,  -1209,
 13170,  13170,  13170,
  4968,   4968,   4968,
  -545,   -545,   -545,
 -1211,  -1211,  -1211,
 13098,  13098,  13098,
  5052,   5052,   5052,
  -555,   -555,   -555,
 -1212,  -1212,  -1212,
 13026,  13026,  13026,
  5136,   5136,   5136,
  -566,   -566,   -566,
 -1213,  -1213,  -1213,
 12953,  12953,  12953,
  5221,   5221,   5221,
  -577,   -577,   -577,
 -1213,  -1213,  -1213,
 12879,  12879,  12879,
  5305,   5305,   5305,
  -587,   -587,   -587,
 -1214,  -1214,  -1214,
 12805,  12805,  12805,
  5390,   5390,   5390,
  -598,   -598,   -598,
 -1214,  -1214,  -1214,
 12731,  12731,  12731,
  5476,   5476,   5476,
  -609,   -609,   -609,
 -1213,  -1213,  -1213,
 12656,  12656,  12656,
  5561,   5561,   5561,
  -619,   -619,   -619,
 -1213,  -1213,  -1213,
 12580,  12580,  12580,
  5647,   5647,   5647,
  -630,   -630,   -630,
 -1212,  -1212,  -1212,
 12504,  12504,  12504,
  5733,   5733,   5733,
  -641,   -641,   -641,
 -1211,  -1211,  -1211,
 12428,  12428,  12428,
  5819,   5819,   5819,
  -651,   -651,   -651,
 -1210,  -1210,  -1210,
 12351,  12351,  12351,
  5905,   5905,   5905,
  -662,   -662,   -662,
 -1209,  -1209,  -1209,
 12274,  12274,  12274,
  5992,   5992,   5992,
  -672,   -672,   -672,
 -1207,  -1207,  -1207,
 12196,  12196,  12196,
  6079,   6079,   6079,
  -683,   -683,   -683,
 -1206,  -1206,  -1206,
 12117,  12117,  12117,
  6166,   6166,   6166,
  -694,   -694,   -694,
 -1204,  -1204,  -1204,
 12039,  12039,  12039,
  6253,   6253,   6253,
  -704,   -704,   -704,
 -1201,  -1201,  -1201,
 11960,  11960,  11960,
  6340,   6340,   6340,
  -715,   -715,   -715,
 -1199,  -1199,  -1199,
 11880,  11880,  11880,
  6428,   6428,   6428,
  -725,   -725,   -725,
 -1196,  -1196,  -1196,
 11800,  11800,  11800,
  6515,   6515,   6515,
  -736,   -736,   -736,
 -1193,  -1193,  -1193,
 11720,  11720,  11720,
  6603,   6603,   6603,
  -746,   -746,   -746,
 -1190,  -1190,  -1190,
 11639,  11639,  11639,
  6691,   6691,   6691,
  -757,   -757,   -757,
 -1187,  -1187,  -1187,
 11558,  11558,  11558,
  6779,   6779,   6779,
  -767,   -767,   -767,
 -1183,  -1183,  -1183,
 11477,  11477,  11477,
  6867,   6867,   6867,
  -777,   -777,   -777,
 -1179,  -1179,  -1179,
 11395,  11395,  11395,
  6956,   6956,   6956,
  -787,   -787,   -787,
 -1175,  -1175,  -1175,
 11313,  11313,  11313,
  7044,   7044,   7044,
  -798,   -798,   -798,
 -1171,  -1171,  -1171,
 11230,  11230,  11230,
  7132,   7132,   7132,
  -808,   -808,   -808,
 -1167,  -1167,  -1167,
 11148,  11148,  11148,
  7221,   7221,   7221,
  -818,   -818,   -818,
 -1162,  -1162,  -1162,
 11065,  11065,  11065,
  7310,   7310,   7310,
  -828,   -828,   -828,
 -1158,  -1158,  -1158,
 10981,  10981,  10981,
  7398,   7398,   7398,
  -838,   -838,   -838,
 -1153,  -1153,  -1153,
 10897,  10897,  10897,
  7487,   7487,   7487,
  -848,   -848,   -848,
 -1148,  -1148,  -1148,
 10813,  10813,  10813,
  7576,   7576,   7576,
  -858,   -858,   -858,
 -1142,  -1142,  -1142,
 10729,  10729,  10729,
  7665,   7665,   7665,
  -867,   -867,   -867,
 -1137,  -1137,  -1137,
 10644,  10644,  10644,
  7754,   7754,   7754,
  -877,   -877,   -877,
 -1131,  -1131,  -1131,
 10560,  10560,  10560,
  7842,   7842,   7842,
  -887,   -887,   -887,
 -1125,  -1125,  -1125,
 10474,  10474,  10474,
  7931,   7931,   7931,
  -896,   -896,   -896,
 -1119,  -1119,  -1119,
 10389,  10389,  10389,
  8020,   8020,   8020,
  -906,   -906,   -906,
 -1113,  -1113,  -1113,
 10303,  10303,  10303,
  8109,   8109,   8109,
  -915,   -915,   -915,
 -1107,  -1107,  -1107,
 10218,  10218,  10218,
  8198,   8198,   8198,
  -924,   -924,   -924,
 -1101,  -1101,  -1101,
 10131,  10131,  10131,
  8287,   8287,   8287,
  -934,   -934,   -934,
 -1094,  -1094,  -1094,
 10045,  10045,  10045,
  8376,   8376,   8376,
  -943,   -943,   -943,
 -1087,  -1087,  -1087,
  9959,   9959,   9959,
  8464,   8464,   8464,
  -952,   -952,   -952,
 -1080,  -1080,  -1080,
  9872,   9872,   9872,
  8553,   8553,   8553,
  -961,   -961,   -961,
 -1073,  -1073,  -1073,
  9785,   9785,   9785,
  8642,   8642,   8642,
  -969,   -969,   -969,
 -1066,  -1066,  -1066,
  9698,   9698,   9698,
  8730,   8730,   8730,
  -978,   -978,   -978,
 -1059,  -1059,  -1059,
  9611,   9611,   9611,
  8819,   8819,   8819,
  -987,   -987,   -987,
 -1051,  -1051,  -1051,
  9523,   9523,   9523,
  8907,   8907,   8907,
  -995,   -995,   -995,
 -1044,  -1044,  -1044,
  9436,   9436,   9436,
  8996,   8996,   8996,
 -1004,  -1004,  -1004,
 -1036,  -1036,  -1036,
  9348,   9348,   9348,
  9084,   9084,   9084,
 -1012,  -1012,  -1012,
 -1028,  -1028,  -1028,
  9260,   9260,   9260,
  9172,   9172,   9172,
 -1020,  -1020,  -1020,
 -1020,  -1020,  -1020,
  9172,   9172,   9172,
  9260,   9260,   9260,
 -1028,  -1028,  -1028,
 -1012,  -1012,  -1012,
  9084,   9084,   9084,
  9348,   9348,   9348,
 -1036,  -1036,  -1036,
 -1004,  -1004,  -1004,
  8996,   8996,   8996,
  9436,   9436,   9436,
 -1044,  -1044,  -1044,
  -995,   -995,   -995,
  8907,   8907,   8907,
  9523,   9523,   9523,
 -1051,  -1051,  -1051,
  -987,   -987,   -987,
  8819,   8819,   8819,
  9611,   9611,   9611,
 -1059,  -1059,  -1059,
  -978,   -978,   -978,
  8730,   8730,   8730,
  9698,   9698,   9698,
 -1066,  -1066,  -1066,
  -969,   -969,   -969,
  8642,   8642,   8642,
  9785,   9785,   9785,
 -1073,  -1073,  -1073,
  -961,   -961,   -961,
  8553,   8553,   8553,
  9872,   9872,   9872,
 -1080,  -1080,  -1080,
  -952,   -952,   -952,
  8464,   8464,   8464,
  9959,   9959,   9959,
 -1087,  -1087,  -1087,
  -943,   -943,   -943,
  8376,   8376,   8376,
 10045,  10045,  10045,
 -1094,  -1094,  -1094,
  -934,   -934,   -934,
  8287,   8287,   8287,
 10131,  10131,  10131,
 -1101,  -1101,  -1101,
  -924,   -924,   -924,
  8198,   8198,   8198,
 10218,  10218,  10218,
 -1107,  -1107,  -1107,
  -915,   -915,   -915,
  8109,   8109,   8109,
 10303,  10303,  10303,
 -1113,  -1113,  -1113,
  -906,   -906,   -906,
  8020,   8020,   8020,
 10389,  10389,  10389,
 -1119,  -1119,  -1119,
  -896,   -896,   -896,
  7931,   7931,   7931,
 10474,  10474,  10474,
 -1125,  -1125,  -1125,
  -887,   -887,   -887,
  7842,   7842,   7842,
 10560,  10560,  10560,
 -1131,  -1131,  -1131,
  -877,   -877,   -877,
  7754,   7754,   7754,
 10644,  10644,  10644,
 -1137,  -1137,  -1137,
  -867,   -867,   -867,
  7665,   7665,   7665,
 10729,  10729,  10729,
 -1142,  -1142,  -1142,
  -858,   -858,   -858,
  7576,   7576,   7576,
 10813,  10813,  10813,
 -1148,  -1148,  -1148,
  -848,   -848,   -848,
  7487,   7487,   7487,
 10897,  10897,  10897,
 -1153,  -1153,  -1153,
  -838,   -838,   -838,
  7398,   7398,   7398,
 10981,  10981,  10981,
 -1158,  -1158,  -1158,
  -828,   -828,   -828,
  7310,   7310,   7310,
 11065,  11065,  11065,
 -1162,  -1162,  -1162,
  -818,   -818,   -818,
  7221,   7221,   7221,
 11148,  11148,  11148,
 -1167,  -1167,  -1167,
  -808,   -808,   -808,
  7132,   7132,   7132,
 11230,  11230,  11230,
 -1171,  -1171,  -1171,
  -798,   -798,   -798,
  7044,   7044,   7044,
 11313,  11313,  11313,
 -1175,  -1175,  -1175,
  -787,   -787,   -787,
  6956,   6956,   6956,
 11395,  11395,  11395,
 -1179,  -1179,  -1179,
  -777,   -777,   -777,
  6867,   6867,   6867,
 11477,  11477,  11477,
 -1183,  -1183,  -1183,
  -767,   -767,   -767,
  6779,   6779,   6779,
 11558,  11558,  11558,
 -1187,  -1187,  -1187,
  -757,   -757,   -757,
  6691,   6691,   6691,
 11639,  11639,  11639,
 -1190,  -1190,  -1190,
  -746,   -746,   -746,
  6603,   6603,   6603,
 11720,  11720,  11720,
 -1193,  -1193,  -1193,
  -736,   -736,   -736,
  6515,   6515,   6515,
 11800,  11800,  11800,
 -1196,  -1196,  -1196,
  -725,   -725,   -725,
  6428,   6428,   6428,
 11880,  11880,  11880,
 -1199,  -1199,  -1199,
  -715,   -715,   -715,
  6340,   6340,   6340,
 11960,  11960,  11960,
 -1201,  -1201,  -1201,
  -704,   -704,   -704,
  6253,   6253,   6253,
 12039,  12039,  12039,
 -1204,  -1204,  -1204,
  -694,   -694,   -694,
  6166,   6166,   6166,
 12117,  12117,  12117,
 -1206,  -1206,  -1206,
  -683,   -683,   -683,
  6079,   6079,   6079,
 12196,  12196,  12196,
 -1207,  -1207,  -1207,
  -672,   -672,   -672,
  5992,   5992,   5992,
 12274,  12274,  12274,
 -1209,  -1209,  -1209,
  -662,   -662,   -662,
  5905,   5905,   5905,
 12351,  12351,  12351,
 -1210,  -1210,  -1210,
  -651,   -651,   -651,
  5819,   5819,   5819,
 12428,  12428,  12428,
 -1211,  -1211,  -1211,
  -641,   -641,   -641,
  5733,   5733,   5733,
 12504,  12504,  12504,
 -1212,  -1212,  -1212,
  -630,   -630,   -630,
  5647,   5647,   5647,
 12580,  12580,  12580,
 -1213,  -1213,  -1213,
  -619,   -619,   -619,
  5561,   5561,   5561,
 12656,  12656,  12656,
 -1213,  -1213,  -1213,
  -609,   -609,   -609,
  5476,   5476,   5476,
 12731,  12731,  12731,
 -1214,  -1214,  -1214,
  -598,   -598,   -598,
  5390,   5390,   5390,
 12805,  12805,  12805,
 -1214,  -1214,  -1214,
  -587,   -587,   -587,
  5305,   5305,   5305,
 12879,  12879,  12879,
 -1213,  -1213,  -1213,
  -577,   -577,   -577,
  5221,   5221,   5221,
 12953,  12953,  12953,
 -1213,  -1213,  -1213,
  -566,   -566,   -566,
  5136,   5136,   5136,
 13026,  13026,  13026,
 -1212,  -1212,  -1212,
  -555,   -555,   -555,
  5052,   5052,   5052,
 13098,  13098,  13098,
 -1211,  -1211,  -1211,
  -545,   -545,   -545,
  4968,   4968,   4968,
 13170,  13170,  13170,
 -1209,  -1209,  -1209,
  -534,   -534,   -534,
  4885,   4885,   4885,
 13241,  13241,  13241,
 -1208,  -1208,  -1208,
  -523,   -523,   -523,
  4801,   4801,   4801,
 13312,  13312,  13312,
 -1206,  -1206,  -1206,
  -513,   -513,   -513,
  4718,   4718,   4718,
 13382,  13382,  13382,
 -1204,  -1204,  -1204,
  -502,   -502,   -502,
  4636,   4636,   4636,
 13452,  13452,  13452,
 -1201,  -1201,  -1201,
  -492,   -492,   -492,
  4553,   4553,   4553,
 13521,  13521,  13521,
 -1198,  -1198,  -1198,
  -481,   -481,   -481,
  4471,   4471,   4471,
 13589,  13589,  13589,
 -1195,  -1195,  -1195,
  -471,   -471,   -471,
  4390,   4390,   4390,
 13657,  13657,  13657,
 -1192,  -1192,  -1192,
  -461,   -461,   -461,
  4309,   4309,   4309,
 13724,  13724,  13724,
 -1188,  -1188,  -1188,
  -450,   -450,   -450,
  4228,   4228,   4228,
 13791,  13791,  13791,
 -1185,  -1185,  -1185,
  -440,   -440,   -440,
  4147,   4147,   4147,
 13857,  13857,  13857,
 -1180,  -1180,  -1180,
  -430,   -430,   -430,
  4067,   4067,   4067,
 13922,  13922,  13922,
 -1176,  -1176,  -1176,
  -419,   -419,   -419,
  3988,   3988,   3988,
 13987,  13987,  13987,
 -1171,  -1171,  -1171,
  -409,   -409,   -409,
  3908,   3908,   3908,
 14051,  14051,  14051,
 -1166,  -1166,  -1166,
  -399,   -399,   -399,
  3829,   3829,   3829,
 14114,  14114,  14114,
 -1161,  -1161,  -1161,
  -389,   -389,   -389,
  3751,   3751,   3751,
 14177,  14177,  14177,
 -1155,  -1155,  -1155,
  -379,   -379,   -379,
  3673,   3673,   3673,
 14239,  14239,  14239,
 -1149,  -1149,  -1149,
  -369,   -369,   -369,
  3595,   3595,   3595,
 14300,  14300,  14300,
 -1143,  -1143,  -1143,
  -359,   -359,   -359,
  3518,   3518,   3518,
 14361,  14361,  14361,
 -1136,  -1136,  -1136,
  -349,   -349,   -349,
  3442,   3442,   3442,
 14421,  14421,  14421,
 -1129,  -1129,  -1129,
  -340,   -340,   -340,
  3366,   3366,   3366,
 14480,  14480,  14480,
 -1122,  -1122,  -1122,
  -330,   -330,   -330,
  3290,   3290,   3290,
 14538,  14538,  14538,
 -1114,  -1114,  -1114,
  -320,   -320,   -320,
  3215,   3215,   3215,
 14596,  14596,  14596,
 -1106,  -1106,  -1106,
  -311,   -311,   -311,
  3140,   3140,   3140,
 14653,  14653,  14653,
 -1098,  -1098,  -1098,
  -302,   -302,   -302,
  3066,   3066,   3066,
 14709,  14709,  14709,
 -1089,  -1089,  -1089,
  -292,   -292,   -292,
  2992,   2992,   2992,
 14765,  14765,  14765,
 -1080,  -1080,  -1080,
  -283,   -283,   -283,
  2919,   2919,   2919,
 14819,  14819,  14819,
 -1071,  -1071,  -1071,
  -274,   -274,   -274,
  2846,   2846,   2846,
 14873,  14873,  14873,
 -1062,  -1062,  -1062,
  -265,   -265,   -265,
  2774,   2774,   2774,
 14926,  14926,  14926,
 -1052,  -1052,  -1052,
  -256,   -256,   -256,
  2702,   2702,   2702,
 14979,  14979,  14979,
 -1041,  -1041,  -1041,
  -247,   -247,   -247,
  2631,   2631,   2631,
 15030,  15030,  15030,
 -1031,  -1031,  -1031,
  -238,   -238,   -238,
  2561,   2561,   2561,
 15081,  15081,  15081,
 -1020,  -1020,  -1020,
  -230,   -230,   -230,
  2491,   2491,   2491,
 15131,  15131,  15131,
 -1008,  -1008,  -1008,
  -221,   -221,   -221,
  2422,   2422,   2422,
 15180,  15180,  15180,
  -997,   -997,   -997,
  -213,   -213,   -213,
  2353,   2353,   2353,
 15228,  15228,  15228,
  -984,   -984,   -984,
  -205,   -205,   -205,
  2285,   2285,   2285,
 15275,  15275,  15275,
  -972,   -972,   -972,
  -196,   -196,   -196,
  2218,   2218,   2218,
 15322,  15322,  15322,
  -959,   -959,   -959,
  -188,   -188,   -188,
  2151,   2151,   2151,
 15368,  15368,  15368,
  -946,   -946,   -946,
  -180,   -180,   -180,
  2084,   2084,   2084,
 15412,  15412,  15412,
  -932,   -932,   -932,
  -173,   -173,   -173,
  2019,   2019,   2019,
 15456,  15456,  15456,
  -918,   -918,   -918,
  -165,   -165,   -165,
  1954,   1954,   1954,
 15499,  15499,  15499,
  -904,   -904,   -904,
  -157,   -157,   -157,
  1890,   1890,   1890,
 15541,  15541,  15541,
  -889,   -889,   -889,
  -150,   -150,   -150,
  1826,   1826,   1826,
 15582,  15582,  15582,
  -874,   -874,   -874,
  -143,   -143,   -143,
  1763,   1763,   1763,
 15623,  15623,  15623,
  -859,   -859,   -859,
  -136,   -136,   -136,
  1701,   1701,   1701,
 15662,  15662,  15662,
  -843,   -843,   -843,
  -129,   -129,   -129,
  1639,   1639,   1639,
 15700,  15700,  15700,
  -826,   -826,   -826,
  -122,   -122,   -122,
  1578,   1578,   1578,
 15738,  15738,  15738,
  -810,   -810,   -810,
  -115,   -115,   -115,
  1518,   1518,   1518,
 15774,  15774,  15774,
  -793,   -793,   -793,
  -109,   -109,   -109,
  1458,   1458,   1458,
 15810,  15810,  15810,
  -775,   -775,   -775,
  -102,   -102,   -102,
  1400,   1400,   1400,
 15844,  15844,  15844,
  -757,   -757,   -757,
   -96,    -96,    -96,
  1342,   1342,   1342,
 15878,  15878,  15878,
  -739,   -739,   -739,
   -90,    -90,    -90,
  1284,   1284,   1284,
 15910,  15910,  15910,
  -720,   -720,   -720,
   -84,    -84,    -84,
  1228,   1228,   1228,
 15942,  15942,  15942,
  -701,   -701,   -701,
   -79,    -79,    -79,
  1172,   1172,   1172,
 15972,  15972,  15972,
  -682,   -682,   -682,
   -73,    -73,    -73,
  1117,   1117,   1117,
 16002,  16002,  16002,
  -662,   -662,   -662,
   -68,    -68,    -68,
  1063,   1063,   1063,
 16030,  16030,  16030,
  -641,   -641,   -641,
   -63,    -63,    -63,
  1009,   1009,   1009,
 16058,  16058,  16058,
  -620,   -620,   -620,
   -58,    -58,    -58,
   956,    956,    956,
 16084,  16084,  16084,
  -599,   -599,   -599,
   -53,    -53,    -53,
   905,    905,    905,
 16110,  16110,  16110,
  -577,   -577,   -577,
   -48,    -48,    -48,
   854,    854,    854,
 16134,  16134,  16134,
  -555,   -555,   -555,
   -44,    -44,    -44,
   803,    803,    803,
 16157,  16157,  16157,
  -533,   -533,   -533,
   -40,    -40,    -40,
   754,    754,    754,
 16179,  16179,  16179,
  -510,   -510,   -510,
   -36,    -36,    -36,
   705,    705,    705,
 16200,  16200,  16200,
  -486,   -486,   -486,
   -32,    -32,    -32,
   658,    658,    658,
 16220,  16220,  16220,
  -462,   -462,   -462,
   -28,    -28,    -28,
   611,    611,    611,
 16239,  16239,  16239,
  -438,   -438,   -438,
   -25,    -25,    -25,
   565,    565,    565,
 16257,  16257,  16257,
  -413,   -413,   -413,
   -22,    -22,    -22,
   520,    520,    520,
 16274,  16274,  16274,
  -388,   -388,   -388,
   -19,    -19,    -19,
   475,    475,    475,
 16289,  16289,  16289,
  -362,   -362,   -362,
   -16,    -16,    -16,
   432,    432,    432,
 16304,  16304,  16304,
  -336,   -336,   -336,
   -13,    -13,    -13,
   389,    389,    389,
 16317,  16317,  16317,
  -309,   -309,   -309,
   -11,    -11,    -11,
   348,    348,    348,
 16329,  16329,  16329,
  -282,   -282,   -282,
    -9,     -9,     -9,
   307,    307,    307,
 16340,  16340,  16340,
  -254,   -254,   -254,
    -7,     -7,     -7,
   268,    268,    268,
 16349,  16349,  16349,
  -226,   -226,   -226,
    -5,     -5,     -5,
   229,    229,    229,
 16358,  16358,  16358,
  -198,   -198,   -198,
    -4,     -4,     -4,
   191,    191,    191,
 16365,  16365,  16365,
  -169,   -169,   -169,
    -2,     -2,     -2,
   154,    154,    154,
 16371,  16371,  16371,
  -139,   -139,   -139,
    -2,     -2,     -2,
   118,    118,    118,
 16376,  16376,  16376,
  -109,   -109,   -109,
    -1,     -1,     -1,
    83,     83,     83,
 16380,  16380,  16380,
   -78,    -78,    -78,
     0,      0,      0,
    49,     49,     49,
 16383,  16383,  16383,
   -47,    -47,    -47,
     0,      0,      0,
    16,     16,     16,
 16384,  16384,  16384,
   -16,    -16,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc2_3[] = {
   -32,    -32,    -32,
 16384,  16384,  16384,
    32,     32,     32,
     0,      0,      0,
   -95,    -95,    -95,
 16383,  16383,  16383,
    97,     97,     97,
    -1,     -1,     -1,
  -157,   -157,   -157,
 16381,  16381,  16381,
   162,    162,    162,
    -2,     -2,     -2,
  -218,   -218,   -218,
 16378,  16378,  16378,
   227,    227,    227,
    -3,     -3,     -3,
  -278,   -278,   -278,
 16374,  16374,  16374,
   293,    293,    293,
    -5,     -5,     -5,
  -337,   -337,   -337,
 16369,  16369,  16369,
   359,    359,    359,
    -7,     -7,     -7,
  -395,   -395,   -395,
 16363,  16363,  16363,
   426,    426,    426,
   -10,    -10,    -10,
  -452,   -452,   -452,
 16356,  16356,  16356,
   494,    494,    494,
   -14,    -14,    -14,
  -508,   -508,   -508,
 16348,  16348,  16348,
   561,    561,    561,
   -17,    -17,    -17,
  -564,   -564,   -564,
 16340,  16340,  16340,
   630,    630,    630,
   -22,    -22,    -22,
  -618,   -618,   -618,
 16330,  16330,  16330,
   698,    698,    698,
   -26,    -26,    -26,
  -671,   -671,   -671,
 16319,  16319,  16319,
   768,    768,    768,
   -32,    -32,    -32,
  -724,   -724,   -724,
 16308,  16308,  16308,
   837,    837,    837,
   -37,    -37,    -37,
  -775,   -775,   -775,
 16295,  16295,  16295,
   907,    907,    907,
   -43,    -43,    -43,
  -826,   -826,   -826,
 16282,  16282,  16282,
   978,    978,    978,
   -50,    -50,    -50,
  -876,   -876,   -876,
 16268,  16268,  16268,
  1048,   1048,   1048,
   -56,    -56,    -56,
  -924,   -924,   -924,
 16252,  16252,  16252,
  1120,   1120,   1120,
   -64,    -64,    -64,
  -972,   -972,   -972,
 16236,  16236,  16236,
  1191,   1191,   1191,
   -71,    -71,    -71,
 -1019,  -1019,  -1019,
 16219,  16219,  16219,
  1263,   1263,   1263,
   -79,    -79,    -79,
 -1065,  -1065,  -1065,
 16201,  16201,  16201,
  1336,   1336,   1336,
   -88,    -88,    -88,
 -1110,  -1110,  -1110,
 16182,  16182,  16182,
  1409,   1409,   1409,
   -97,    -97,    -97,
 -1155,  -1155,  -1155,
 16163,  16163,  16163,
  1482,   1482,   1482,
  -106,   -106,   -106,
 -1198,  -1198,  -1198,
 16142,  16142,  16142,
  1555,   1555,   1555,
  -115,   -115,   -115,
 -1241,  -1241,  -1241,
 16121,  16121,  16121,
  1629,   1629,   1629,
  -125,   -125,   -125,
 -1282,  -1282,  -1282,
 16098,  16098,  16098,
  1704,   1704,   1704,
  -136,   -136,   -136,
 -1323,  -1323,  -1323,
 16075,  16075,  16075,
  1778,   1778,   1778,
  -146,   -146,   -146,
 -1363,  -1363,  -1363,
 16051,  16051,  16051,
  1853,   1853,   1853,
  -157,   -157,   -157,
 -1402,  -1402,  -1402,
 16026,  16026,  16026,
  1929,   1929,   1929,
  -169,   -169,   -169,
 -1440,  -1440,  -1440,
 16000,  16000,  16000,
  2004,   2004,   2004,
  -180,   -180,   -180,
 -1478,  -1478,  -1478,
 15974,  15974,  15974,
  2080,   2080,   2080,
  -192,   -192,   -192,
 -1515,  -1515,  -1515,
 15947,  15947,  15947,
  2157,   2157,   2157,
  -205,   -205,   -205,
 -1550,  -1550,  -1550,
 15918,  15918,  15918,
  2234,   2234,   2234,
  -218,   -218,   -218,
 -1585,  -1585,  -1585,
 15889,  15889,  15889,
  2311,   2311,   2311,
  -231,   -231,   -231,
 -1620,  -1620,  -1620,
 15860,  15860,  15860,
  2388,   2388,   2388,
  -244,   -244,   -244,
 -1653,  -1653,  -1653,
 15829,  15829,  15829,
  2465,   2465,   2465,
  -257,   -257,   -257,
 -1686,  -1686,  -1686,
 15798,  15798,  15798,
  2543,   2543,   2543,
  -271,   -271,   -271,
 -1717,  -1717,  -1717,
 15765,  15765,  15765,
  2622,   2622,   2622,
  -286,   -286,   -286,
 -1748,  -1748,  -1748,
 15732,  15732,  15732,
  2700,   2700,   2700,
  -300,   -300,   -300,
 -1779,  -1779,  -1779,
 15699,  15699,  15699,
  2779,   2779,   2779,
  -315,   -315,   -315,
 -1808,  -1808,  -1808,
 15664,  15664,  15664,
  2858,   2858,   2858,
  -330,   -330,   -330,
 -1837,  -1837,  -1837,
 15629,  15629,  15629,
  2937,   2937,   2937,
  -345,   -345,   -345,
 -1865,  -1865,  -1865,
 15593,  15593,  15593,
  3017,   3017,   3017,
  -361,   -361,   -361,
 -1892,  -1892,  -1892,
 15556,  15556,  15556,
  3097,   3097,   3097,
  -377,   -377,   -377,
 -1918,  -1918,  -1918,
 15518,  15518,  15518,
  3177,   3177,   3177,
  -393,   -393,   -393,
 -1944,  -1944,  -1944,
 15480,  15480,  15480,
  3257,   3257,   3257,
  -409,   -409,   -409,
 -1969,  -1969,  -1969,
 15441,  15441,  15441,
  3338,   3338,   3338,
  -426,   -426,   -426,
 -1993,  -1993,  -1993,
 15401,  15401,  15401,
  3418,   3418,   3418,
  -442,   -442,   -442,
 -2017,  -2017,  -2017,
 15361,  15361,  15361,
  3499,   3499,   3499,
  -459,   -459,   -459,
 -2039,  -2039,  -2039,
 15319,  15319,  15319,
  3581,   3581,   3581,
  -477,   -477,   -477,
 -2061,  -2061,  -2061,
 15277,  15277,  15277,
  3662,   3662,   3662,
  -494,   -494,   -494,
 -2083,  -2083,  -2083,
 15235,  15235,  15235,
  3744,   3744,   3744,
  -512,   -512,   -512,
 -2103,  -2103,  -2103,
 15191,  15191,  15191,
  3826,   3826,   3826,
  -530,   -530,   -530,
 -2123,  -2123,  -2123,
 15147,  15147,  15147,
  3908,   3908,   3908,
  -548,   -548,   -548,
 -2142,  -2142,  -2142,
 15102,  15102,  15102,
  3990,   3990,   3990,
  -566,   -566,   -566,
 -2161,  -2161,  -2161,
 15057,  15057,  15057,
  4072,   4072,   4072,
  -584,   -584,   -584,
 -2179,  -2179,  -2179,
 15011,  15011,  15011,
  4155,   4155,   4155,
  -603,   -603,   -603,
 -2196,  -2196,  -2196,
 14964,  14964,  14964,
  4238,   4238,   4238,
  -622,   -622,   -622,
 -2213,  -2213,  -2213,
 14917,  14917,  14917,
  4321,   4321,   4321,
  -641,   -641,   -641,
 -2228,  -2228,  -2228,
 14868,  14868,  14868,
  4404,   4404,   4404,
  -660,   -660,   -660,
 -2244,  -2244,  -2244,
 14820,  14820,  14820,
  4487,   4487,   4487,
  -679,   -679,   -679,
 -2258,  -2258,  -2258,
 14770,  14770,  14770,
  4571,   4571,   4571,
  -699,   -699,   -699,
 -2272,  -2272,  -2272,
 14720,  14720,  14720,
  4654,   4654,   4654,
  -718,   -718,   -718,
 -2285,  -2285,  -2285,
 14669,  14669,  14669,
  4738,   4738,   4738,
  -738,   -738,   -738,
 -2298,  -2298,  -2298,
 14618,  14618,  14618,
  4822,   4822,   4822,
  -758,   -758,   -758,
 -2310,  -2310,  -2310,
 14566,  14566,  14566,
  4906,   4906,   4906,
  -778,   -778,   -778,
 -2321,  -2321,  -2321,
 14513,  14513,  14513,
  4990,   4990,   4990,
  -798,   -798,   -798,
 -2332,  -2332,  -2332,
 14460,  14460,  14460,
  5074,   5074,   5074,
  -818,   -818,   -818,
 -2342,  -2342,  -2342,
 14406,  14406,  14406,
  5159,   5159,   5159,
  -839,   -839,   -839,
 -2352,  -2352,  -2352,
 14352,  14352,  14352,
  5243,   5243,   5243,
  -859,   -859,   -859,
 -2361,  -2361,  -2361,
 14297,  14297,  14297,
  5328,   5328,   5328,
  -880,   -880,   -880,
 -2369,  -2369,  -2369,
 14241,  14241,  14241,
  5412,   5412,   5412,
  -900,   -900,   -900,
 -2377,  -2377,  -2377,
 14185,  14185,  14185,
  5497,   5497,   5497,
  -921,   -921,   -921,
 -2384,  -2384,  -2384,
 14128,  14128,  14128,
  5582,   5582,   5582,
  -942,   -942,   -942,
 -2391,  -2391,  -2391,
 14071,  14071,  14071,
  5667,   5667,   5667,
  -963,   -963,   -963,
 -2397,  -2397,  -2397,
 14013,  14013,  14013,
  5752,   5752,   5752,
  -984,   -984,   -984,
 -2402,  -2402,  -2402,
 13954,  13954,  13954,
  5837,   5837,   5837,
 -1005,  -1005,  -1005,
 -2407,  -2407,  -2407,
 13895,  13895,  13895,
  5922,   5922,   5922,
 -1026,  -1026,  -1026,
 -2411,  -2411,  -2411,
 13835,  13835,  13835,
  6007,   6007,   6007,
 -1047,  -1047,  -1047,
 -2415,  -2415,  -2415,
 13775,  13775,  13775,
  6092,   6092,   6092,
 -1068,  -1068,  -1068,
 -2419,  -2419,  -2419,
 13715,  13715,  13715,
  6177,   6177,   6177,
 -1089,  -1089,  -1089,
 -2421,  -2421,  -2421,
 13653,  13653,  13653,
  6263,   6263,   6263,
 -1111,  -1111,  -1111,
 -2424,  -2424,  -2424,
 13592,  13592,  13592,
  6348,   6348,   6348,
 -1132,  -1132,  -1132,
 -2425,  -2425,  -2425,
 13529,  13529,  13529,
  6433,   6433,   6433,
 -1153,  -1153,  -1153,
 -2426,  -2426,  -2426,
 13466,  13466,  13466,
  6519,   6519,   6519,
 -1175,  -1175,  -1175,
 -2427,  -2427,  -2427,
 13403,  13403,  13403,
  6604,   6604,   6604,
 -1196,  -1196,  -1196,
 -2427,  -2427,  -2427,
 13339,  13339,  13339,
  6689,   6689,   6689,
 -1217,  -1217,  -1217,
 -2427,  -2427,  -2427,
 13275,  13275,  13275,
  6775,   6775,   6775,
 -1239,  -1239,  -1239,
 -2426,  -2426,  -2426,
 13210,  13210,  13210,
  6860,   6860,   6860,
 -1260,  -1260,  -1260,
 -2425,  -2425,  -2425,
 13145,  13145,  13145,
  6945,   6945,   6945,
 -1281,  -1281,  -1281,
 -2423,  -2423,  -2423,
 13079,  13079,  13079,
  7030,   7030,   7030,
 -1302,  -1302,  -1302,
 -2421,  -2421,  -2421,
 13013,  13013,  13013,
  7116,   7116,   7116,
 -1324,  -1324,  -1324,
 -2418,  -2418,  -2418,
 12946,  12946,  12946,
  7201,   7201,   7201,
 -1345,  -1345,  -1345,
 -2415,  -2415,  -2415,
 12879,  12879,  12879,
  7286,   7286,   7286,
 -1366,  -1366,  -1366,
 -2411,  -2411,  -2411,
 12811,  12811,  12811,
  7371,   7371,   7371,
 -1387,  -1387,  -1387,
 -2407,  -2407,  -2407,
 12743,  12743,  12743,
  7456,   7456,   7456,
 -1408,  -1408,  -1408,
 -2402,  -2402,  -2402,
 12674,  12674,  12674,
  7541,   7541,   7541,
 -1429,  -1429,  -1429,
 -2397,  -2397,  -2397,
 12605,  12605,  12605,
  7626,   7626,   7626,
 -1450,  -1450,  -1450,
 -2392,  -2392,  -2392,
 12536,  12536,  12536,
  7711,   7711,   7711,
 -1471,  -1471,  -1471,
 -2386,  -2386,  -2386,
 12466,  12466,  12466,
  7796,   7796,   7796,
 -1492,  -1492,  -1492,
 -2380,  -2380,  -2380,
 12396,  12396,  12396,
  7881,   7881,   7881,
 -1513,  -1513,  -1513,
 -2373,  -2373,  -2373,
 12325,  12325,  12325,
  7966,   7966,   7966,
 -1534,  -1534,  -1534,
 -2366,  -2366,  -2366,
 12254,  12254,  12254,
  8050,   8050,   8050,
 -1554,  -1554,  -1554,
 -2359,  -2359,  -2359,
 12183,  12183,  12183,
  8135,   8135,   8135,
 -1575,  -1575,  -1575,
 -2351,  -2351,  -2351,
 12111,  12111,  12111,
  8219,   8219,   8219,
 -1595,  -1595,  -1595,
 -2342,  -2342,  -2342,
 12038,  12038,  12038,
  8304,   8304,   8304,
 -1616,  -1616,  -1616,
 -2334,  -2334,  -2334,
 11966,  11966,  11966,
  8388,   8388,   8388,
 -1636,  -1636,  -1636,
 -2325,  -2325,  -2325,
 11893,  11893,  11893,
  8472,   8472,   8472,
 -1656,  -1656,  -1656,
 -2315,  -2315,  -2315,
 11819,  11819,  11819,
  8556,   8556,   8556,
 -1676,  -1676,  -1676,
 -2305,  -2305,  -2305,
 11745,  11745,  11745,
  8640,   8640,   8640,
 -1696,  -1696,  -1696,
 -2295,  -2295,  -2295,
 11671,  11671,  11671,
  8723,   8723,   8723,
 -1715,  -1715,  -1715,
 -2284,  -2284,  -2284,
 11596,  11596,  11596,
  8807,   8807,   8807,
 -1735,  -1735,  -1735,
 -2274,  -2274,  -2274,
 11522,  11522,  11522,
  8890,   8890,   8890,
 -1754,  -1754,  -1754,
 -2262,  -2262,  -2262,
 11446,  11446,  11446,
  8974,   8974,   8974,
 -1774,  -1774,  -1774,
 -2251,  -2251,  -2251,
 11371,  11371,  11371,
  9057,   9057,   9057,
 -1793,  -1793,  -1793,
 -2239,  -2239,  -2239,
 11295,  11295,  11295,
  9140,   9140,   9140,
 -1812,  -1812,  -1812,
 -2227,  -2227,  -2227,
 11219,  11219,  11219,
  9222,   9222,   9222,
 -1830,  -1830,  -1830,
 -2214,  -2214,  -2214,
 11142,  11142,  11142,
  9305,   9305,   9305,
 -1849,  -1849,  -1849,
 -2201,  -2201,  -2201,
 11065,  11065,  11065,
  9387,   9387,   9387,
 -1867,  -1867,  -1867,
 -2188,  -2188,  -2188,
 10988,  10988,  10988,
  9470,   9470,   9470,
 -1886,  -1886,  -1886,
 -2174,  -2174,  -2174,
 10910,  10910,  10910,
  9552,   9552,   9552,
 -1904,  -1904,  -1904,
 -2161,  -2161,  -2161,
 10833,  10833,  10833,
  9633,   9633,   9633,
 -1921,  -1921,  -1921,
 -2146,  -2146,  -2146,
 10754,  10754,  10754,
  9715,   9715,   9715,
 -1939,  -1939,  -1939,
 -2132,  -2132,  -2132,
 10676,  10676,  10676,
  9796,   9796,   9796,
 -1956,  -1956,  -1956,
 -2117,  -2117,  -2117,
 10597,  10597,  10597,
  9878,   9878,   9878,
 -1974,  -1974,  -1974,
 -2102,  -2102,  -2102,
 10518,  10518,  10518,
  9959,   9959,   9959,
 -1991,  -1991,  -1991,
 -2087,  -2087,  -2087,
 10439,  10439,  10439,
 10039,  10039,  10039,
 -2007,  -2007,  -2007,
 -2072,  -2072,  -2072,
 10360,  10360,  10360,
 10120,  10120,  10120,
 -2024,  -2024,  -2024,
 -2056,  -2056,  -2056,
 10280,  10280,  10280,
 10200,  10200,  10200,
 -2040,  -2040,  -2040,
 -2040,  -2040,  -2040,
 10200,  10200,  10200,
 10280,  10280,  10280,
 -2056,  -2056,  -2056,
 -2024,  -2024,  -2024,
 10120,  10120,  10120,
 10360,  10360,  10360,
 -2072,  -2072,  -2072,
 -2007,  -2007,  -2007,
 10039,  10039,  10039,
 10439,  10439,  10439,
 -2087,  -2087,  -2087,
 -1991,  -1991,  -1991,
  9959,   9959,   9959,
 10518,  10518,  10518,
 -2102,  -2102,  -2102,
 -1974,  -1974,  -1974,
  9878,   9878,   9878,
 10597,  10597,  10597,
 -2117,  -2117,  -2117,
 -1956,  -1956,  -1956,
  9796,   9796,   9796,
 10676,  10676,  10676,
 -2132,  -2132,  -2132,
 -1939,  -1939,  -1939,
  9715,   9715,   9715,
 10754,  10754,  10754,
 -2146,  -2146,  -2146,
 -1921,  -1921,  -1921,
  9633,   9633,   9633,
 10833,  10833,  10833,
 -2161,  -2161,  -2161,
 -1904,  -1904,  -1904,
  9552,   9552,   9552,
 10910,  10910,  10910,
 -2174,  -2174,  -2174,
 -1886,  -1886,  -1886,
  9470,   9470,   9470,
 10988,  10988,  10988,
 -2188,  -2188,  -2188,
 -1867,  -1867,  -1867,
  9387,   9387,   9387,
 11065,  11065,  11065,
 -2201,  -2201,  -2201,
 -1849,  -1849,  -1849,
  9305,   9305,   9305,
 11142,  11142,  11142,
 -2214,  -2214,  -2214,
 -1830,  -1830,  -1830,
  9222,   9222,   9222,
 11219,  11219,  11219,
 -2227,  -2227,  -2227,
 -1812,  -1812,  -1812,
  9140,   9140,   9140,
 11295,  11295,  11295,
 -2239,  -2239,  -2239,
 -1793,  -1793,  -1793,
  9057,   9057,   9057,
 11371,  11371,  11371,
 -2251,  -2251,  -2251,
 -1774,  -1774,  -1774,
  8974,   8974,   8974,
 11446,  11446,  11446,
 -2262,  -2262,  -2262,
 -1754,  -1754,  -1754,
  8890,   8890,   8890,
 11522,  11522,  11522,
 -2274,  -2274,  -2274,
 -1735,  -1735,  -1735,
  8807,   8807,   8807,
 11596,  11596,  11596,
 -2284,  -2284,  -2284,
 -1715,  -1715,  -1715,
  8723,   8723,   8723,
 11671,  11671,  11671,
 -2295,  -2295,  -2295,
 -1696,  -1696,  -1696,
  8640,   8640,   8640,
 11745,  11745,  11745,
 -2305,  -2305,  -2305,
 -1676,  -1676,  -1676,
  8556,   8556,   8556,
 11819,  11819,  11819,
 -2315,  -2315,  -2315,
 -1656,  -1656,  -1656,
  8472,   8472,   8472,
 11893,  11893,  11893,
 -2325,  -2325,  -2325,
 -1636,  -1636,  -1636,
  8388,   8388,   8388,
 11966,  11966,  11966,
 -2334,  -2334,  -2334,
 -1616,  -1616,  -1616,
  8304,   8304,   8304,
 12038,  12038,  12038,
 -2342,  -2342,  -2342,
 -1595,  -1595,  -1595,
  8219,   8219,   8219,
 12111,  12111,  12111,
 -2351,  -2351,  -2351,
 -1575,  -1575,  -1575,
  8135,   8135,   8135,
 12183,  12183,  12183,
 -2359,  -2359,  -2359,
 -1554,  -1554,  -1554,
  8050,   8050,   8050,
 12254,  12254,  12254,
 -2366,  -2366,  -2366,
 -1534,  -1534,  -1534,
  7966,   7966,   7966,
 12325,  12325,  12325,
 -2373,  -2373,  -2373,
 -1513,  -1513,  -1513,
  7881,   7881,   7881,
 12396,  12396,  12396,
 -2380,  -2380,  -2380,
 -1492,  -1492,  -1492,
  7796,   7796,   7796,
 12466,  12466,  12466,
 -2386,  -2386,  -2386,
 -1471,  -1471,  -1471,
  7711,   7711,   7711,
 12536,  12536,  12536,
 -2392,  -2392,  -2392,
 -1450,  -1450,  -1450,
  7626,   7626,   7626,
 12605,  12605,  12605,
 -2397,  -2397,  -2397,
 -1429,  -1429,  -1429,
  7541,   7541,   7541,
 12674,  12674,  12674,
 -2402,  -2402,  -2402,
 -1408,  -1408,  -1408,
  7456,   7456,   7456,
 12743,  12743,  12743,
 -2407,  -2407,  -2407,
 -1387,  -1387,  -1387,
  7371,   7371,   7371,
 12811,  12811,  12811,
 -2411,  -2411,  -2411,
 -1366,  -1366,  -1366,
  7286,   7286,   7286,
 12879,  12879,  12879,
 -2415,  -2415,  -2415,
 -1345,  -1345,  -1345,
  7201,   7201,   7201,
 12946,  12946,  12946,
 -2418,  -2418,  -2418,
 -1324,  -1324,  -1324,
  7116,   7116,   7116,
 13013,  13013,  13013,
 -2421,  -2421,  -2421,
 -1302,  -1302,  -1302,
  7030,   7030,   7030,
 13079,  13079,  13079,
 -2423,  -2423,  -2423,
 -1281,  -1281,  -1281,
  6945,   6945,   6945,
 13145,  13145,  13145,
 -2425,  -2425,  -2425,
 -1260,  -1260,  -1260,
  6860,   6860,   6860,
 13210,  13210,  13210,
 -2426,  -2426,  -2426,
 -1239,  -1239,  -1239,
  6775,   6775,   6775,
 13275,  13275,  13275,
 -2427,  -2427,  -2427,
 -1217,  -1217,  -1217,
  6689,   6689,   6689,
 13339,  13339,  13339,
 -2427,  -2427,  -2427,
 -1196,  -1196,  -1196,
  6604,   6604,   6604,
 13403,  13403,  13403,
 -2427,  -2427,  -2427,
 -1175,  -1175,  -1175,
  6519,   6519,   6519,
 13466,  13466,  13466,
 -2426,  -2426,  -2426,
 -1153,  -1153,  -1153,
  6433,   6433,   6433,
 13529,  13529,  13529,
 -2425,  -2425,  -2425,
 -1132,  -1132,  -1132,
  6348,   6348,   6348,
 13592,  13592,  13592,
 -2424,  -2424,  -2424,
 -1111,  -1111,  -1111,
  6263,   6263,   6263,
 13653,  13653,  13653,
 -2421,  -2421,  -2421,
 -1089,  -1089,  -1089,
  6177,   6177,   6177,
 13715,  13715,  13715,
 -2419,  -2419,  -2419,
 -1068,  -1068,  -1068,
  6092,   6092,   6092,
 13775,  13775,  13775,
 -2415,  -2415,  -2415,
 -1047,  -1047,  -1047,
  6007,   6007,   6007,
 13835,  13835,  13835,
 -2411,  -2411,  -2411,
 -1026,  -1026,  -1026,
  5922,   5922,   5922,
 13895,  13895,  13895,
 -2407,  -2407,  -2407,
 -1005,  -1005,  -1005,
  5837,   5837,   5837,
 13954,  13954,  13954,
 -2402,  -2402,  -2402,
  -984,   -984,   -984,
  5752,   5752,   5752,
 14013,  14013,  14013,
 -2397,  -2397,  -2397,
  -963,   -963,   -963,
  5667,   5667,   5667,
 14071,  14071,  14071,
 -2391,  -2391,  -2391,
  -942,   -942,   -942,
  5582,   5582,   5582,
 14128,  14128,  14128,
 -2384,  -2384,  -2384,
  -921,   -921,   -921,
  5497,   5497,   5497,
 14185,  14185,  14185,
 -2377,  -2377,  -2377,
  -900,   -900,   -900,
  5412,   5412,   5412,
 14241,  14241,  14241,
 -2369,  -2369,  -2369,
  -880,   -880,   -880,
  5328,   5328,   5328,
 14297,  14297,  14297,
 -2361,  -2361,  -2361,
  -859,   -859,   -859,
  5243,   5243,   5243,
 14352,  14352,  14352,
 -2352,  -2352,  -2352,
  -839,   -839,   -839,
  5159,   5159,   5159,
 14406,  14406,  14406,
 -2342,  -2342,  -2342,
  -818,   -818,   -818,
  5074,   5074,   5074,
 14460,  14460,  14460,
 -2332,  -2332,  -2332,
  -798,   -798,   -798,
  4990,   4990,   4990,
 14513,  14513,  14513,
 -2321,  -2321,  -2321,
  -778,   -778,   -778,
  4906,   4906,   4906,
 14566,  14566,  14566,
 -2310,  -2310,  -2310,
  -758,   -758,   -758,
  4822,   4822,   4822,
 14618,  14618,  14618,
 -2298,  -2298,  -2298,
  -738,   -738,   -738,
  4738,   4738,   4738,
 14669,  14669,  14669,
 -2285,  -2285,  -2285,
  -718,   -718,   -718,
  4654,   4654,   4654,
 14720,  14720,  14720,
 -2272,  -2272,  -2272,
  -699,   -699,   -699,
  4571,   4571,   4571,
 14770,  14770,  14770,
 -2258,  -2258,  -2258,
  -679,   -679,   -679,
  4487,   4487,   4487,
 14820,  14820,  14820,
 -2244,  -2244,  -2244,
  -660,   -660,   -660,
  4404,   4404,   4404,
 14868,  14868,  14868,
 -2228,  -2228,  -2228,
  -641,   -641,   -641,
  4321,   4321,   4321,
 14917,  14917,  14917,
 -2213,  -2213,  -2213,
  -622,   -622,   -622,
  4238,   4238,   4238,
 14964,  14964,  14964,
 -2196,  -2196,  -2196,
  -603,   -603,   -603,
  4155,   4155,   4155,
 15011,  15011,  15011,
 -2179,  -2179,  -2179,
  -584,   -584,   -584,
  4072,   4072,   4072,
 15057,  15057,  15057,
 -2161,  -2161,  -2161,
  -566,   -566,   -566,
  3990,   3990,   3990,
 15102,  15102,  15102,
 -2142,  -2142,  -2142,
  -548,   -548,   -548,
  3908,   3908,   3908,
 15147,  15147,  15147,
 -2123,  -2123,  -2123,
  -530,   -530,   -530,
  3826,   3826,   3826,
 15191,  15191,  15191,
 -2103,  -2103,  -2103,
  -512,   -512,   -512,
  3744,   3744,   3744,
 15235,  15235,  15235,
 -2083,  -2083,  -2083,
  -494,   -494,   -494,
  3662,   3662,   3662,
 15277,  15277,  15277,
 -2061,  -2061,  -2061,
  -477,   -477,   -477,
  3581,   3581,   3581,
 15319,  15319,  15319,
 -2039,  -2039,  -2039,
  -459,   -459,   -459,
  3499,   3499,   3499,
 15361,  15361,  15361,
 -2017,  -2017,  -2017,
  -442,   -442,   -442,
  3418,   3418,   3418,
 15401,  15401,  15401,
 -1993,  -1993,  -1993,
  -426,   -426,   -426,
  3338,   3338,   3338,
 15441,  15441,  15441,
 -1969,  -1969,  -1969,
  -409,   -409,   -409,
  3257,   3257,   3257,
 15480,  15480,  15480,
 -1944,  -1944,  -1944,
  -393,   -393,   -393,
  3177,   3177,   3177,
 15518,  15518,  15518,
 -1918,  -1918,  -1918,
  -377,   -377,   -377,
  3097,   3097,   3097,
 15556,  15556,  15556,
 -1892,  -1892,  -1892,
  -361,   -361,   -361,
  3017,   3017,   3017,
 15593,  15593,  15593,
 -1865,  -1865,  -1865,
  -345,   -345,   -345,
  2937,   2937,   2937,
 15629,  15629,  15629,
 -1837,  -1837,  -1837,
  -330,   -330,   -330,
  2858,   2858,   2858,
 15664,  15664,  15664,
 -1808,  -1808,  -1808,
  -315,   -315,   -315,
  2779,   2779,   2779,
 15699,  15699,  15699,
 -1779,  -1779,  -1779,
  -300,   -300,   -300,
  2700,   2700,   2700,
 15732,  15732,  15732,
 -1748,  -1748,  -1748,
  -286,   -286,   -286,
  2622,   2622,   2622,
 15765,  15765,  15765,
 -1717,  -1717,  -1717,
  -271,   -271,   -271,
  2543,   2543,   2543,
 15798,  15798,  15798,
 -1686,  -1686,  -1686,
  -257,   -257,   -257,
  2465,   2465,   2465,
 15829,  15829,  15829,
 -1653,  -1653,  -1653,
  -244,   -244,   -244,
  2388,   2388,   2388,
 15860,  15860,  15860,
 -1620,  -1620,  -1620,
  -231,   -231,   -231,
  2311,   2311,   2311,
 15889,  15889,  15889,
 -1585,  -1585,  -1585,
  -218,   -218,   -218,
  2234,   2234,   2234,
 15918,  15918,  15918,
 -1550,  -1550,  -1550,
  -205,   -205,   -205,
  2157,   2157,   2157,
 15947,  15947,  15947,
 -1515,  -1515,  -1515,
  -192,   -192,   -192,
  2080,   2080,   2080,
 15974,  15974,  15974,
 -1478,  -1478,  -1478,
  -180,   -180,   -180,
  2004,   2004,   2004,
 16000,  16000,  16000,
 -1440,  -1440,  -1440,
  -169,   -169,   -169,
  1929,   1929,   1929,
 16026,  16026,  16026,
 -1402,  -1402,  -1402,
  -157,   -157,   -157,
  1853,   1853,   1853,
 16051,  16051,  16051,
 -1363,  -1363,  -1363,
  -146,   -146,   -146,
  1778,   1778,   1778,
 16075,  16075,  16075,
 -1323,  -1323,  -1323,
  -136,   -136,   -136,
  1704,   1704,   1704,
 16098,  16098,  16098,
 -1282,  -1282,  -1282,
  -125,   -125,   -125,
  1629,   1629,   1629,
 16121,  16121,  16121,
 -1241,  -1241,  -1241,
  -115,   -115,   -115,
  1555,   1555,   1555,
 16142,  16142,  16142,
 -1198,  -1198,  -1198,
  -106,   -106,   -106,
  1482,   1482,   1482,
 16163,  16163,  16163,
 -1155,  -1155,  -1155,
   -97,    -97,    -97,
  1409,   1409,   1409,
 16182,  16182,  16182,
 -1110,  -1110,  -1110,
   -88,    -88,    -88,
  1336,   1336,   1336,
 16201,  16201,  16201,
 -1065,  -1065,  -1065,
   -79,    -79,    -79,
  1263,   1263,   1263,
 16219,  16219,  16219,
 -1019,  -1019,  -1019,
   -71,    -71,    -71,
  1191,   1191,   1191,
 16236,  16236,  16236,
  -972,   -972,   -972,
   -64,    -64,    -64,
  1120,   1120,   1120,
 16252,  16252,  16252,
  -924,   -924,   -924,
   -56,    -56,    -56,
  1048,   1048,   1048,
 16268,  16268,  16268,
  -876,   -876,   -876,
   -50,    -50,    -50,
   978,    978,    978,
 16282,  16282,  16282,
  -826,   -826,   -826,
   -43,    -43,    -43,
   907,    907,    907,
 16295,  16295,  16295,
  -775,   -775,   -775,
   -37,    -37,    -37,
   837,    837,    837,
 16308,  16308,  16308,
  -724,   -724,   -724,
   -32,    -32,    -32,
   768,    768,    768,
 16319,  16319,  16319,
  -671,   -671,   -671,
   -26,    -26,    -26,
   698,    698,    698,
 16330,  16330,  16330,
  -618,   -618,   -618,
   -22,    -22,    -22,
   630,    630,    630,
 16340,  16340,  16340,
  -564,   -564,   -564,
   -17,    -17,    -17,
   561,    561,    561,
 16348,  16348,  16348,
  -508,   -508,   -508,
   -14,    -14,    -14,
   494,    494,    494,
 16356,  16356,  16356,
  -452,   -452,   -452,
   -10,    -10,    -10,
   426,    426,    426,
 16363,  16363,  16363,
  -395,   -395,   -395,
    -7,     -7,     -7,
   359,    359,    359,
 16369,  16369,  16369,
  -337,   -337,   -337,
    -5,     -5,     -5,
   293,    293,    293,
 16374,  16374,  16374,
  -278,   -278,   -278,
    -3,     -3,     -3,
   227,    227,    227,
 16378,  16378,  16378,
  -218,   -218,   -218,
    -2,     -2,     -2,
   162,    162,    162,
 16381,  16381,  16381,
  -157,   -157,   -157,
    -1,     -1,     -1,
    97,     97,     97,
 16383,  16383,  16383,
   -95,    -95,    -95,
     0,      0,      0,
    32,     32,     32,
 16384,  16384,  16384,
   -32,    -32,    -32
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc_4[] = {
   -16,    -16,    -16,    -16,
 16384,  16384,  16384,  16384,
    16,     16,     16,     16,
     0,      0,      0,      0,
   -47,    -47,    -47,    -47,
 16383,  16383,  16383,  16383,
    49,     49,     49,     49,
     0,      0,      0,      0,
   -78,    -78,    -78,    -78,
 16380,  16380,  16380,  16380,
    83,     83,     83,     83,
    -1,     -1,     -1,     -1,
  -109,   -109,   -109,   -109,
 16376,  16376,  16376,  16376,
   118,    118,    118,    118,
    -2,     -2,     -2,     -2,
  -139,   -139,   -139,   -139,
 16371,  16371,  16371,  16371,
   154,    154,    154,    154,
    -2,     -2,     -2,     -2,
  -169,   -169,   -169,   -169,
 16365,  16365,  16365,  16365,
   191,    191,    191,    191,
    -4,     -4,     -4,     -4,
  -198,   -198,   -198,   -198,
 16358,  16358,  16358,  16358,
   229,    229,    229,    229,
    -5,     -5,     -5,     -5,
  -226,   -226,   -226,   -226,
 16349,  16349,  16349,  16349,
   268,    268,    268,    268,
    -7,     -7,     -7,     -7,
  -254,   -254,   -254,   -254,
 16340,  16340,  16340,  16340,
   307,    307,    307,    307,
    -9,     -9,     -9,     -9,
  -282,   -282,   -282,   -282,
 16329,  16329,  16329,  16329,
   348,    348,    348,    348,
   -11,    -11,    -11,    -11,
  -309,   -309,   -309,   -309,
 16317,  16317,  16317,  16317,
   389,    389,    389,    389,
   -13,    -13,    -13,    -13,
  -336,   -336,   -336,   -336,
 16304,  16304,  16304,  16304,
   432,    432,    432,    432,
   -16,    -16,    -16,    -16,
  -362,   -362,   -362,   -362,
 16289,  16289,  16289,  16289,
   475,    475,    475,    475,
   -19,    -19,    -19,    -19,
  -388,   -388,   -388,   -388,
 16274,  16274,  16274,  16274,
   520,    520,    520,    520,
   -22,    -22,    -22,    -22,
  -413,   -413,   -413,   -413,
 16257,  16257,  16257,  16257,
   565,    565,    565,    565,
   -25,    -25,    -25,    -25,
  -438,   -438,   -438,   -438,
 16239,  16239,  16239,  16239,
   611,    611,    611,    611,
   -28,    -28,    -28,    -28,
  -462,   -462,   -462,   -462,
 16220,  16220,  16220,  16220,
   658,    658,    658,    658,
   -32,    -32,    -32,    -32,
  -486,   -486,   -486,   -486,
 16200,  16200,  16200,  16200,
   705,    705,    705,    705,
   -36,    -36,    -36,    -36,
  -510,   -510,   -510,   -510,
 16179,  16179,  16179,  16179,
   754,    754,    754,    754,
   -40,    -40,    -40,    -40,
  -533,   -533,   -533,   -533,
 16157,  16157,  16157,  16157,
   803,    803,    803,    803,
   -44,    -44,    -44,    -44,
  -555,   -555,   -555,   -555,
 16134,  16134,  16134,  16134,
   854,    854,    854,    854,
   -48,    -48,    -48,    -48,
  -577,   -577,   -577,   -577,
 16110,  16110,  16110,  16110,
   905,    905,    905,    905,
   -53,    -53,    -53,    -53,
  -599,   -599,   -599,   -599,
 16084,  16084,  16084,  16084,
   956,    956,    956,    956,
   -58,    -58,    -58,    -58,
  -620,   -620,   -620,   -620,
 16058,  16058,  16058,  16058,
  1009,   1009,   1009,   1009,
   -63,    -63,    -63,    -63,
  -641,   -641,   -641,   -641,
 16030,  16030,  16030,  16030,
  1063,   1063,   1063,   1063,
   -68,    -68,    -68,    -68,
  -662,   -662,   -662,   -662,
 16002,  16002,  16002,  16002,
  1117,   1117,   1117,   1117,
   -73,    -73,    -73,    -73,
  -682,   -682,   -682,   -682,
 15972,  15972,  15972,  15972,
  1172,   1172,   1172,   1172,
   -79,    -79,    -79,    -79,
  -701,   -701,   -701,   -701,
 15942,  15942,  15942,  15942,
  1228,   1228,   1228,   1228,
   -84,    -84,    -84,    -84,
  -720,   -720,   -720,   -720,
 15910,  15910,  15910,  15910,
  1284,   1284,   1284,   1284,
   -90,    -90,    -90,    -90,
  -739,   -739,   -739,   -739,
 15878,  15878,  15878,  15878,
  1342,   1342,   1342,   1342,
   -96,    -96,    -96,    -96,
  -757,   -757,   -757,   -757,
 15844,  15844,  15844,  15844,
  1400,   1400,   1400,   1400,
  -102,   -102,   -102,   -102,
  -775,   -775,   -775,   -775,
 15810,  15810,  15810,  15810,
  1458,   1458,   1458,   1458,
  -109,   -109,   -109,   -109,
  -793,   -793,   -793,   -793,
 15774,  15774,  15774,  15774,
  1518,   1518,   1518,   1518,
  -115,   -115,   -115,   -115,
  -810,   -810,   -810,   -810,
 15738,  15738,  15738,  15738,
  1578,   1578,   1578,   1578,
  -122,   -122,   -122,   -122,
  -826,   -826,   -826,   -826,
 15700,  15700,  15700,  15700,
  1639,   1639,   1639,   1639,
  -129,   -129,   -129,   -129,
  -843,   -843,   -843,   -843,
 15662,  15662,  15662,  15662,
  1701,   1701,   1701,   1701,
  -136,   -136,   -136,   -136,
  -859,   -859,   -859,   -859,
 15623,  15623,  15623,  15623,
  1763,   1763,   1763,   1763,
  -143,   -143,   -143,   -143,
  -874,   -874,   -874,   -874,
 15582,  15582,  15582,  15582,
  1826,   1826,   1826,   1826,
  -150,   -150,   -150,   -150,
  -889,   -889,   -889,   -889,
 15541,  15541,  15541,  15541,
  1890,   1890,   1890,   1890,
  -157,   -157,   -157,   -157,
  -904,   -904,   -904,   -904,
 15499,  15499,  15499,  15499,
  1954,   1954,   1954,   1954,
  -165,   -165,   -165,   -165,
  -918,   -918,   -918,   -918,
 15456,  15456,  15456,  15456,
  2019,   2019,   2019,   2019,
  -173,   -173,   -173,   -173,
  -932,   -932,   -932,   -932,
 15412,  15412,  15412,  15412,
  2084,   2084,   2084,   2084,
  -180,   -180,   -180,   -180,
  -946,   -946,   -946,   -946,
 15368,  15368,  15368,  15368,
  2151,   2151,   2151,   2151,
  -188,   -188,   -188,   -188,
  -959,   -959,   -959,   -959,
 15322,  15322,  15322,  15322,
  2218,   2218,   2218,   2218,
  -196,   -196,   -196,   -196,
  -972,   -972,   -972,   -972,
 15275,  15275,  15275,  15275,
  2285,   2285,   2285,   2285,
  -205,   -205,   -205,   -205,
  -984,   -984,   -984,   -984,
 15228,  15228,  15228,  15228,
  2353,   2353,   2353,   2353,
  -213,   -213,   -213,   -213,
  -997,   -997,   -997,   -997,
 15180,  15180,  15180,  15180,
  2422,   2422,   2422,   2422,
  -221,   -221,   -221,   -221,
 -1008,  -1008,  -1008,  -1008,
 15131,  15131,  15131,  15131,
  2491,   2491,   2491,   2491,
  -230,   -230,   -230,   -230,
 -1020,  -1020,  -1020,  -1020,
 15081,  15081,  15081,  15081,
  2561,   2561,   2561,   2561,
  -238,   -238,   -238,   -238,
 -1031,  -1031,  -1031,  -1031,
 15030,  15030,  15030,  15030,
  2631,   2631,   2631,   2631,
  -247,   -247,   -247,   -247,
 -1041,  -1041,  -1041,  -1041,
 14979,  14979,  14979,  14979,
  2702,   2702,   2702,   2702,
  -256,   -256,   -256,   -256,
 -1052,  -1052,  -1052,  -1052,
 14926,  14926,  14926,  14926,
  2774,   2774,   2774,   2774,
  -265,   -265,   -265,   -265,
 -1062,  -1062,  -1062,  -1062,
 14873,  14873,  14873,  14873,
  2846,   2846,   2846,   2846,
  -274,   -274,   -274,   -274,
 -1071,  -1071,  -1071,  -1071,
 14819,  14819,  14819,  14819,
  2919,   2919,   2919,   2919,
  -283,   -283,   -283,   -283,
 -1080,  -1080,  -1080,  -1080,
 14765,  14765,  14765,  14765,
  2992,   2992,   2992,   2992,
  -292,   -292,   -292,   -292,
 -1089,  -1089,  -1089,  -1089,
 14709,  14709,  14709,  14709,
  3066,   3066,   3066,   3066,
  -302,   -302,   -302,   -302,
 -1098,  -1098,  -1098,  -1098,
 14653,  14653,  14653,  14653,
  3140,   3140,   3140,   3140,
  -311,   -311,   -311,   -311,
 -1106,  -1106,  -1106,  -1106,
 14596,  14596,  14596,  14596,
  3215,   3215,   3215,   3215,
  -320,   -320,   -320,   -320,
 -1114,  -1114,  -1114,  -1114,
 14538,  14538,  14538,  14538,
  3290,   3290,   3290,   3290,
  -330,   -330,   -330,   -330,
 -1122,  -1122,  -1122,  -1122,
 14480,  14480,  14480,  14480,
  3366,   3366,   3366,   3366,
  -340,   -340,   -340,   -340,
 -1129,  -1129,  -1129,  -1129,
 14421,  14421,  14421,  14421,
  3442,   3442,   3442,   3442,
  -349,   -349,   -349,   -349,
 -1136,  -1136,  -1136,  -1136,
 14361,  14361,  14361,  14361,
  3518,   3518,   3518,   3518,
  -359,   -359,   -359,   -359,
 -1143,  -1143,  -1143,  -1143,
 14300,  14300,  14300,  14300,
  3595,   3595,   3595,   3595,
  -369,   -369,   -369,   -369,
 -1149,  -1149,  -1149,  -1149,
 14239,  14239,  14239,  14239,
  3673,   3673,   3673,   3673,
  -379,   -379,   -379,   -379,
 -1155,  -1155,  -1155,  -1155,
 14177,  14177,  14177,  14177,
  3751,   3751,   3751,   3751,
  -389,   -389,   -389,   -389,
 -1161,  -1161,  -1161,  -1161,
 14114,  14114,  14114,  14114,
  3829,   3829,   3829,   3829,
  -399,   -399,   -399,   -399,
 -1166,  -1166,  -1166,  -1166,
 14051,  14051,  14051,  14051,
  3908,   3908,   3908,   3908,
  -409,   -409,   -409,   -409,
 -1171,  -1171,  -1171,  -1171,
 13987,  13987,  13987,  13987,
  3988,   3988,   3988,   3988,
  -419,   -419,   -419,   -419,
 -1176,  -1176,  -1176,  -1176,
 13922,  13922,  13922,  13922,
  4067,   4067,   4067,   4067,
  -430,   -430,   -430,   -430,
 -1180,  -1180,  -1180,  -1180,
 13857,  13857,  13857,  13857,
  4147,   4147,   4147,   4147,
  -440,   -440,   -440,   -440,
 -1185,  -1185,  -1185,  -1185,
 13791,  13791,  13791,  13791,
  4228,   4228,   4228,   4228,
  -450,   -450,   -450,   -450,
 -1188,  -1188,  -1188,  -1188,
 13724,  13724,  13724,  13724,
  4309,   4309,   4309,   4309,
  -461,   -461,   -461,   -461,
 -1192,  -1192,  -1192,  -1192,
 13657,  13657,  13657,  13657,
  4390,   4390,   4390,   4390,
  -471,   -471,   -471,   -471,
 -1195,  -1195,  -1195,  -1195,
 13589,  13589,  13589,  13589,
  4471,   4471,   4471,   4471,
  -481,   -481,   -481,   -481,
 -1198,  -1198,  -1198,  -1198,
 13521,  13521,  13521,  13521,
  4553,   4553,   4553,   4553,
  -492,   -492,   -492,   -492,
 -1201,  -1201,  -1201,  -1201,
 13452,  13452,  13452,  13452,
  4636,   4636,   4636,   4636,
  -502,   -502,   -502,   -502,
 -1204,  -1204,  -1204,  -1204,
 13382,  13382,  13382,  13382,
  4718,   4718,   4718,   4718,
  -513,   -513,   -513,   -513,
 -1206,  -1206,  -1206,  -1206,
 13312,  13312,  13312,  13312,
  4801,   4801,   4801,   4801,
  -523,   -523,   -523,   -523,
 -1208,  -1208,  -1208,  -1208,
 13241,  13241,  13241,  13241,
  4885,   4885,   4885,   4885,
  -534,   -534,   -534,   -534,
 -1209,  -1209,  -1209,  -1209,
 13170,  13170,  13170,  13170,
  4968,   4968,   4968,   4968,
  -545,   -545,   -545,   -545,
 -1211,  -1211,  -1211,  -1211,
 13098,  13098,  13098,  13098,
  5052,   5052,   5052,   5052,
  -555,   -555,   -555,   -555,
 -1212,  -1212,  -1212,  -1212,
 13026,  13026,  13026,  13026,
  5136,   5136,   5136,   5136,
  -566,   -566,   -566,   -566,
 -1213,  -1213,  -1213,  -1213,
 12953,  12953,  12953,  12953,
  5221,   5221,   5221,   5221,
  -577,   -577,   -577,   -577,
 -1213,  -1213,  -1213,  -1213,
 12879,  12879,  12879,  12879,
  5305,   5305,   5305,   5305,
  -587,   -587,   -587,   -587,
 -1214,  -1214,  -1214,  -1214,
 12805,  12805,  12805,  12805,
  5390,   5390,   5390,   5390,
  -598,   -598,   -598,   -598,
 -1214,  -1214,  -1214,  -1214,
 12731,  12731,  12731,  12731,
  5476,   5476,   5476,   5476,
  -609,   -609,   -609,   -609,
 -1213,  -1213,  -1213,  -1213,
 12656,  12656,  12656,  12656,
  5561,   5561,   5561,   5561,
  -619,   -619,   -619,   -619,
 -1213,  -1213,  -1213,  -1213,
 12580,  12580,  12580,  12580,
  5647,   5647,   5647,   5647,
  -630,   -630,   -630,   -630,
 -1212,  -1212,  -1212,  -1212,
 12504,  12504,  12504,  12504,
  5733,   5733,   5733,   5733,
  -641,   -641,   -641,   -641,
 -1211,  -1211,  -1211,  -1211,
 12428,  12428,  12428,  12428,
  5819,   5819,   5819,   5819,
  -651,   -651,   -651,   -651,
 -1210,  -1210,  -1210,  -1210,
 12351,  12351,  12351,  12351,
  5905,   5905,   5905,   5905,
  -662,   -662,   -662,   -662,
 -1209,  -1209,  -1209,  -1209,
 12274,  12274,  12274,  12274,
  5992,   5992,   5992,   5992,
  -672,   -672,   -672,   -672,
 -1207,  -1207,  -1207,  -1207,
 12196,  12196,  12196,  12196,
  6079,   6079,   6079,   6079,
  -683,   -683,   -683,   -683,
 -1206,  -1206,  -1206,  -1206,
 12117,  12117,  12117,  12117,
  6166,   6166,   6166,   6166,
  -694,   -694,   -694,   -694,
 -1204,  -1204,  -1204,  -1204,
 12039,  12039,  12039,  12039,
  6253,   6253,   6253,   6253,
  -704,   -704,   -704,   -704,
 -1201,  -1201,  -1201,  -1201,
 11960,  11960,  11960,  11960,
  6340,   6340,   6340,   6340,
  -715,   -715,   -715,   -715,
 -1199,  -1199,  -1199,  -1199,
 11880,  11880,  11880,  11880,
  6428,   6428,   6428,   6428,
  -725,   -725,   -725,   -725,
 -1196,  -1196,  -1196,  -1196,
 11800,  11800,  11800,  11800,
  6515,   6515,   6515,   6515,
  -736,   -736,   -736,   -736,
 -1193,  -1193,  -1193,  -1193,
 11720,  11720,  11720,  11720,
  6603,   6603,   6603,   6603,
  -746,   -746,   -746,   -746,
 -1190,  -1190,  -1190,  -1190,
 11639,  11639,  11639,  11639,
  6691,   6691,   6691,   6691,
  -757,   -757,   -757,   -757,
 -1187,  -1187,  -1187,  -1187,
 11558,  11558,  11558,  11558,
  6779,   6779,   6779,   6779,
  -767,   -767,   -767,   -767,
 -1183,  -1183,  -1183,  -1183,
 11477,  11477,  11477,  11477,
  6867,   6867,   6867,   6867,
  -777,   -777,   -777,   -777,
 -1179,  -1179,  -1179,  -1179,
 11395,  11395,  11395,  11395,
  6956,   6956,   6956,   6956,
  -787,   -787,   -787,   -787,
 -1175,  -1175,  -1175,  -1175,
 11313,  11313,  11313,  11313,
  7044,   7044,   7044,   7044,
  -798,   -798,   -798,   -798,
 -1171,  -1171,  -1171,  -1171,
 11230,  11230,  11230,  11230,
  7132,   7132,   7132,   7132,
  -808,   -808,   -808,   -808,
 -1167,  -1167,  -1167,  -1167,
 11148,  11148,  11148,  11148,
  7221,   7221,   7221,   7221,
  -818,   -818,   -818,   -818,
 -1162,  -1162,  -1162,  -1162,
 11065,  11065,  11065,  11065,
  7310,   7310,   7310,   7310,
  -828,   -828,   -828,   -828,
 -1158,  -1158,  -1158,  -1158,
 10981,  10981,  10981,  10981,
  7398,   7398,   7398,   7398,
  -838,   -838,   -838,   -838,
 -1153,  -1153,  -1153,  -1153,
 10897,  10897,  10897,  10897,
  7487,   7487,   7487,   7487,
  -848,   -848,   -848,   -848,
 -1148,  -1148,  -1148,  -1148,
 10813,  10813,  10813,  10813,
  7576,   7576,   7576,   7576,
  -858,   -858,   -858,   -858,
 -1142,  -1142,  -1142,  -1142,
 10729,  10729,  10729,  10729,
  7665,   7665,   7665,   7665,
  -867,   -867,   -867,   -867,
 -1137,  -1137,  -1137,  -1137,
 10644,  10644,  10644,  10644,
  7754,   7754,   7754,   7754,
  -877,   -877,   -877,   -877,
 -1131,  -1131,  -1131,  -1131,
 10560,  10560,  10560,  10560,
  7842,   7842,   7842,   7842,
  -887,   -887,   -887,   -887,
 -1125,  -1125,  -1125,  -1125,
 10474,  10474,  10474,  10474,
  7931,   7931,   7931,   7931,
  -896,   -896,   -896,   -896,
 -1119,  -1119,  -1119,  -1119,
 10389,  10389,  10389,  10389,
  8020,   8020,   8020,   8020,
  -906,   -906,   -906,   -906,
 -1113,  -1113,  -1113,  -1113,
 10303,  10303,  10303,  10303,
  8109,   8109,   8109,   8109,
  -915,   -915,   -915,   -915,
 -1107,  -1107,  -1107,  -1107,
 10218,  10218,  10218,  10218,
  8198,   8198,   8198,   8198,
  -924,   -924,   -924,   -924,
 -1101,  -1101,  -1101,  -1101,
 10131,  10131,  10131,  10131,
  8287,   8287,   8287,   8287,
  -934,   -934,   -934,   -934,
 -1094,  -1094,  -1094,  -1094,
 10045,  10045,  10045,  10045,
  8376,   8376,   8376,   8376,
  -943,   -943,   -943,   -943,
 -1087,  -1087,  -1087,  -1087,
  9959,   9959,   9959,   9959,
  8464,   8464,   8464,   8464,
  -952,   -952,   -952,   -952,
 -1080,  -1080,  -1080,  -1080,
  9872,   9872,   9872,   9872,
  8553,   8553,   8553,   8553,
  -961,   -961,   -961,   -961,
 -1073,  -1073,  -1073,  -1073,
  9785,   9785,   9785,   9785,
  8642,   8642,   8642,   8642,
  -969,   -969,   -969,   -969,
 -1066,  -1066,  -1066,  -1066,
  9698,   9698,   9698,   9698,
  8730,   8730,   8730,   8730,
  -978,   -978,   -978,   -978,
 -1059,  -1059,  -1059,  -1059,
  9611,   9611,   9611,   9611,
  8819,   8819,   8819,   8819,
  -987,   -987,   -987,   -987,
 -1051,  -1051,  -1051,  -1051,
  9523,   9523,   9523,   9523,
  8907,   8907,   8907,   8907,
  -995,   -995,   -995,   -995,
 -1044,  -1044,  -1044,  -1044,
  9436,   9436,   9436,   9436,
  8996,   8996,   8996,   8996,
 -1004,  -1004,  -1004,  -1004,
 -1036,  -1036,  -1036,  -1036,
  9348,   9348,   9348,   9348,
  9084,   9084,   9084,   9084,
 -1012,  -1012,  -1012,  -1012,
 -1028,  -1028,  -1028,  -1028,
  9260,   9260,   9260,   9260,
  9172,   9172,   9172,   9172,
 -1020,  -1020,  -1020,  -1020,
 -1020,  -1020,  -1020,  -1020,
  9172,   9172,   9172,   9172,
  9260,   9260,   9260,   9260,
 -1028,  -1028,  -1028,  -1028,
 -1012,  -1012,  -1012,  -1012,
  9084,   9084,   9084,   9084,
  9348,   9348,   9348,   9348,
 -1036,  -1036,  -1036,  -1036,
 -1004,  -1004,  -1004,  -1004,
  8996,   8996,   8996,   8996,
  9436,   9436,   9436,   9436,
 -1044,  -1044,  -1044,  -1044,
  -995,   -995,   -995,   -995,
  8907,   8907,   8907,   8907,
  9523,   9523,   9523,   9523,
 -1051,  -1051,  -1051,  -1051,
  -987,   -987,   -987,   -987,
  8819,   8819,   8819,   8819,
  9611,   9611,   9611,   9611,
 -1059,  -1059,  -1059,  -1059,
  -978,   -978,   -978,   -978,
  8730,   8730,   8730,   8730,
  9698,   9698,   9698,   9698,
 -1066,  -1066,  -1066,  -1066,
  -969,   -969,   -969,   -969,
  8642,   8642,   8642,   8642,
  9785,   9785,   9785,   9785,
 -1073,  -1073,  -1073,  -1073,
  -961,   -961,   -961,   -961,
  8553,   8553,   8553,   8553,
  9872,   9872,   9872,   9872,
 -1080,  -1080,  -1080,  -1080,
  -952,   -952,   -952,   -952,
  8464,   8464,   8464,   8464,
  9959,   9959,   9959,   9959,
 -1087,  -1087,  -1087,  -1087,
  -943,   -943,   -943,   -943,
  8376,   8376,   8376,   8376,
 10045,  10045,  10045,  10045,
 -1094,  -1094,  -1094,  -1094,
  -934,   -934,   -934,   -934,
  8287,   8287,   8287,   8287,
 10131,  10131,  10131,  10131,
 -1101,  -1101,  -1101,  -1101,
  -924,   -924,   -924,   -924,
  8198,   8198,   8198,   8198,
 10218,  10218,  10218,  10218,
 -1107,  -1107,  -1107,  -1107,
  -915,   -915,   -915,   -915,
  8109,   8109,   8109,   8109,
 10303,  10303,  10303,  10303,
 -1113,  -1113,  -1113,  -1113,
  -906,   -906,   -906,   -906,
  8020,   8020,   8020,   8020,
 10389,  10389,  10389,  10389,
 -1119,  -1119,  -1119,  -1119,
  -896,   -896,   -896,   -896,
  7931,   7931,   7931,   7931,
 10474,  10474,  10474,  10474,
 -1125,  -1125,  -1125,  -1125,
  -887,   -887,   -887,   -887,
  7842,   7842,   7842,   7842,
 10560,  10560,  10560,  10560,
 -1131,  -1131,  -1131,  -1131,
  -877,   -877,   -877,   -877,
  7754,   7754,   7754,   7754,
 10644,  10644,  10644,  10644,
 -1137,  -1137,  -1137,  -1137,
  -867,   -867,   -867,   -867,
  7665,   7665,   7665,   7665,
 10729,  10729,  10729,  10729,
 -1142,  -1142,  -1142,  -1142,
  -858,   -858,   -858,   -858,
  7576,   7576,   7576,   7576,
 10813,  10813,  10813,  10813,
 -1148,  -1148,  -1148,  -1148,
  -848,   -848,   -848,   -848,
  7487,   7487,   7487,   7487,
 10897,  10897,  10897,  10897,
 -1153,  -1153,  -1153,  -1153,
  -838,   -838,   -838,   -838,
  7398,   7398,   7398,   7398,
 10981,  10981,  10981,  10981,
 -1158,  -1158,  -1158,  -1158,
  -828,   -828,   -828,   -828,
  7310,   7310,   7310,   7310,
 11065,  11065,  11065,  11065,
 -1162,  -1162,  -1162,  -1162,
  -818,   -818,   -818,   -818,
  7221,   7221,   7221,   7221,
 11148,  11148,  11148,  11148,
 -1167,  -1167,  -1167,  -1167,
  -808,   -808,   -808,   -808,
  7132,   7132,   7132,   7132,
 11230,  11230,  11230,  11230,
 -1171,  -1171,  -1171,  -1171,
  -798,   -798,   -798,   -798,
  7044,   7044,   7044,   7044,
 11313,  11313,  11313,  11313,
 -1175,  -1175,  -1175,  -1175,
  -787,   -787,   -787,   -787,
  6956,   6956,   6956,   6956,
 11395,  11395,  11395,  11395,
 -1179,  -1179,  -1179,  -1179,
  -777,   -777,   -777,   -777,
  6867,   6867,   6867,   6867,
 11477,  11477,  11477,  11477,
 -1183,  -1183,  -1183,  -1183,
  -767,   -767,   -767,   -767,
  6779,   6779,   6779,   6779,
 11558,  11558,  11558,  11558,
 -1187,  -1187,  -1187,  -1187,
  -757,   -757,   -757,   -757,
  6691,   6691,   6691,   6691,
 11639,  11639,  11639,  11639,
 -1190,  -1190,  -1190,  -1190,
  -746,   -746,   -746,   -746,
  6603,   6603,   6603,   6603,
 11720,  11720,  11720,  11720,
 -1193,  -1193,  -1193,  -1193,
  -736,   -736,   -736,   -736,
  6515,   6515,   6515,   6515,
 11800,  11800,  11800,  11800,
 -1196,  -1196,  -1196,  -1196,
  -725,   -725,   -725,   -725,
  6428,   6428,   6428,   6428,
 11880,  11880,  11880,  11880,
 -1199,  -1199,  -1199,  -1199,
  -715,   -715,   -715,   -715,
  6340,   6340,   6340,   6340,
 11960,  11960,  11960,  11960,
 -1201,  -1201,  -1201,  -1201,
  -704,   -704,   -704,   -704,
  6253,   6253,   6253,   6253,
 12039,  12039,  12039,  12039,
 -1204,  -1204,  -1204,  -1204,
  -694,   -694,   -694,   -694,
  6166,   6166,   6166,   6166,
 12117,  12117,  12117,  12117,
 -1206,  -1206,  -1206,  -1206,
  -683,   -683,   -683,   -683,
  6079,   6079,   6079,   6079,
 12196,  12196,  12196,  12196,
 -1207,  -1207,  -1207,  -1207,
  -672,   -672,   -672,   -672,
  5992,   5992,   5992,   5992,
 12274,  12274,  12274,  12274,
 -1209,  -1209,  -1209,  -1209,
  -662,   -662,   -662,   -662,
  5905,   5905,   5905,   5905,
 12351,  12351,  12351,  12351,
 -1210,  -1210,  -1210,  -1210,
  -651,   -651,   -651,   -651,
  5819,   5819,   5819,   5819,
 12428,  12428,  12428,  12428,
 -1211,  -1211,  -1211,  -1211,
  -641,   -641,   -641,   -641,
  5733,   5733,   5733,   5733,
 12504,  12504,  12504,  12504,
 -1212,  -1212,  -1212,  -1212,
  -630,   -630,   -630,   -630,
  5647,   5647,   5647,   5647,
 12580,  12580,  12580,  12580,
 -1213,  -1213,  -1213,  -1213,
  -619,   -619,   -619,   -619,
  5561,   5561,   5561,   5561,
 12656,  12656,  12656,  12656,
 -1213,  -1213,  -1213,  -1213,
  -609,   -609,   -609,   -609,
  5476,   5476,   5476,   5476,
 12731,  12731,  12731,  12731,
 -1214,  -1214,  -1214,  -1214,
  -598,   -598,   -598,   -598,
  5390,   5390,   5390,   5390,
 12805,  12805,  12805,  12805,
 -1214,  -1214,  -1214,  -1214,
  -587,   -587,   -587,   -587,
  5305,   5305,   5305,   5305,
 12879,  12879,  12879,  12879,
 -1213,  -1213,  -1213,  -1213,
  -577,   -577,   -577,   -577,
  5221,   5221,   5221,   5221,
 12953,  12953,  12953,  12953,
 -1213,  -1213,  -1213,  -1213,
  -566,   -566,   -566,   -566,
  5136,   5136,   5136,   5136,
 13026,  13026,  13026,  13026,
 -1212,  -1212,  -1212,  -1212,
  -555,   -555,   -555,   -555,
  5052,   5052,   5052,   5052,
 13098,  13098,  13098,  13098,
 -1211,  -1211,  -1211,  -1211,
  -545,   -545,   -545,   -545,
  4968,   4968,   4968,   4968,
 13170,  13170,  13170,  13170,
 -1209,  -1209,  -1209,  -1209,
  -534,   -534,   -534,   -534,
  4885,   4885,   4885,   4885,
 13241,  13241,  13241,  13241,
 -1208,  -1208,  -1208,  -1208,
  -523,   -523,   -523,   -523,
  4801,   4801,   4801,   4801,
 13312,  13312,  13312,  13312,
 -1206,  -1206,  -1206,  -1206,
  -513,   -513,   -513,   -513,
  4718,   4718,   4718,   4718,
 13382,  13382,  13382,  13382,
 -1204,  -1204,  -1204,  -1204,
  -502,   -502,   -502,   -502,
  4636,   4636,   4636,   4636,
 13452,  13452,  13452,  13452,
 -1201,  -1201,  -1201,  -1201,
  -492,   -492,   -492,   -492,
  4553,   4553,   4553,   4553,
 13521,  13521,  13521,  13521,
 -1198,  -1198,  -1198,  -1198,
  -481,   -481,   -481,   -481,
  4471,   4471,   4471,   4471,
 13589,  13589,  13589,  13589,
 -1195,  -1195,  -1195,  -1195,
  -471,   -471,   -471,   -471,
  4390,   4390,   4390,   4390,
 13657,  13657,  13657,  13657,
 -1192,  -1192,  -1192,  -1192,
  -461,   -461,   -461,   -461,
  4309,   4309,   4309,   4309,
 13724,  13724,  13724,  13724,
 -1188,  -1188,  -1188,  -1188,
  -450,   -450,   -450,   -450,
  4228,   4228,   4228,   4228,
 13791,  13791,  13791,  13791,
 -1185,  -1185,  -1185,  -1185,
  -440,   -440,   -440,   -440,
  4147,   4147,   4147,   4147,
 13857,  13857,  13857,  13857,
 -1180,  -1180,  -1180,  -1180,
  -430,   -430,   -430,   -430,
  4067,   4067,   4067,   4067,
 13922,  13922,  13922,  13922,
 -1176,  -1176,  -1176,  -1176,
  -419,   -419,   -419,   -419,
  3988,   3988,   3988,   3988,
 13987,  13987,  13987,  13987,
 -1171,  -1171,  -1171,  -1171,
  -409,   -409,   -409,   -409,
  3908,   3908,   3908,   3908,
 14051,  14051,  14051,  14051,
 -1166,  -1166,  -1166,  -1166,
  -399,   -399,   -399,   -399,
  3829,   3829,   3829,   3829,
 14114,  14114,  14114,  14114,
 -1161,  -1161,  -1161,  -1161,
  -389,   -389,   -389,   -389,
  3751,   3751,   3751,   3751,
 14177,  14177,  14177,  14177,
 -1155,  -1155,  -1155,  -1155,
  -379,   -379,   -379,   -379,
  3673,   3673,   3673,   3673,
 14239,  14239,  14239,  14239,
 -1149,  -1149,  -1149,  -1149,
  -369,   -369,   -369,   -369,
  3595,   3595,   3595,   3595,
 14300,  14300,  14300,  14300,
 -1143,  -1143,  -1143,  -1143,
  -359,   -359,   -359,   -359,
  3518,   3518,   3518,   3518,
 14361,  14361,  14361,  14361,
 -1136,  -1136,  -1136,  -1136,
  -349,   -349,   -349,   -349,
  3442,   3442,   3442,   3442,
 14421,  14421,  14421,  14421,
 -1129,  -1129,  -1129,  -1129,
  -340,   -340,   -340,   -340,
  3366,   3366,   3366,   3366,
 14480,  14480,  14480,  14480,
 -1122,  -1122,  -1122,  -1122,
  -330,   -330,   -330,   -330,
  3290,   3290,   3290,   3290,
 14538,  14538,  14538,  14538,
 -1114,  -1114,  -1114,  -1114,
  -320,   -320,   -320,   -320,
  3215,   3215,   3215,   3215,
 14596,  14596,  14596,  14596,
 -1106,  -1106,  -1106,  -1106,
  -311,   -311,   -311,   -311,
  3140,   3140,   3140,   3140,
 14653,  14653,  14653,  14653,
 -1098,  -1098,  -1098,  -1098,
  -302,   -302,   -302,   -302,
  3066,   3066,   3066,   3066,
 14709,  14709,  14709,  14709,
 -1089,  -1089,  -1089,  -1089,
  -292,   -292,   -292,   -292,
  2992,   2992,   2992,   2992,
 14765,  14765,  14765,  14765,
 -1080,  -1080,  -1080,  -1080,
  -283,   -283,   -283,   -283,
  2919,   2919,   2919,   2919,
 14819,  14819,  14819,  14819,
 -1071,  -1071,  -1071,  -1071,
  -274,   -274,   -274,   -274,
  2846,   2846,   2846,   2846,
 14873,  14873,  14873,  14873,
 -1062,  -1062,  -1062,  -1062,
  -265,   -265,   -265,   -265,
  2774,   2774,   2774,   2774,
 14926,  14926,  14926,  14926,
 -1052,  -1052,  -1052,  -1052,
  -256,   -256,   -256,   -256,
  2702,   2702,   2702,   2702,
 14979,  14979,  14979,  14979,
 -1041,  -1041,  -1041,  -1041,
  -247,   -247,   -247,   -247,
  2631,   2631,   2631,   2631,
 15030,  15030,  15030,  15030,
 -1031,  -1031,  -1031,  -1031,
  -238,   -238,   -238,   -238,
  2561,   2561,   2561,   2561,
 15081,  15081,  15081,  15081,
 -1020,  -1020,  -1020,  -1020,
  -230,   -230,   -230,   -230,
  2491,   2491,   2491,   2491,
 15131,  15131,  15131,  15131,
 -1008,  -1008,  -1008,  -1008,
  -221,   -221,   -221,   -221,
  2422,   2422,   2422,   2422,
 15180,  15180,  15180,  15180,
  -997,   -997,   -997,   -997,
  -213,   -213,   -213,   -213,
  2353,   2353,   2353,   2353,
 15228,  15228,  15228,  15228,
  -984,   -984,   -984,   -984,
  -205,   -205,   -205,   -205,
  2285,   2285,   2285,   2285,
 15275,  15275,  15275,  15275,
  -972,   -972,   -972,   -972,
  -196,   -196,   -196,   -196,
  2218,   2218,   2218,   2218,
 15322,  15322,  15322,  15322,
  -959,   -959,   -959,   -959,
  -188,   -188,   -188,   -188,
  2151,   2151,   2151,   2151,
 15368,  15368,  15368,  15368,
  -946,   -946,   -946,   -946,
  -180,   -180,   -180,   -180,
  2084,   2084,   2084,   2084,
 15412,  15412,  15412,  15412,
  -932,   -932,   -932,   -932,
  -173,   -173,   -173,   -173,
  2019,   2019,   2019,   2019,
 15456,  15456,  15456,  15456,
  -918,   -918,   -918,   -918,
  -165,   -165,   -165,   -165,
  1954,   1954,   1954,   1954,
 15499,  15499,  15499,  15499,
  -904,   -904,   -904,   -904,
  -157,   -157,   -157,   -157,
  1890,   1890,   1890,   1890,
 15541,  15541,  15541,  15541,
  -889,   -889,   -889,   -889,
  -150,   -150,   -150,   -150,
  1826,   1826,   1826,   1826,
 15582,  15582,  15582,  15582,
  -874,   -874,   -874,   -874,
  -143,   -143,   -143,   -143,
  1763,   1763,   1763,   1763,
 15623,  15623,  15623,  15623,
  -859,   -859,   -859,   -859,
  -136,   -136,   -136,   -136,
  1701,   1701,   1701,   1701,
 15662,  15662,  15662,  15662,
  -843,   -843,   -843,   -843,
  -129,   -129,   -129,   -129,
  1639,   1639,   1639,   1639,
 15700,  15700,  15700,  15700,
  -826,   -826,   -826,   -826,
  -122,   -122,   -122,   -122,
  1578,   1578,   1578,   1578,
 15738,  15738,  15738,  15738,
  -810,   -810,   -810,   -810,
  -115,   -115,   -115,   -115,
  1518,   1518,   1518,   1518,
 15774,  15774,  15774,  15774,
  -793,   -793,   -793,   -793,
  -109,   -109,   -109,   -109,
  1458,   1458,   1458,   1458,
 15810,  15810,  15810,  15810,
  -775,   -775,   -775,   -775,
  -102,   -102,   -102,   -102,
  1400,   1400,   1400,   1400,
 15844,  15844,  15844,  15844,
  -757,   -757,   -757,   -757,
   -96,    -96,    -96,    -96,
  1342,   1342,   1342,   1342,
 15878,  15878,  15878,  15878,
  -739,   -739,   -739,   -739,
   -90,    -90,    -90,    -90,
  1284,   1284,   1284,   1284,
 15910,  15910,  15910,  15910,
  -720,   -720,   -720,   -720,
   -84,    -84,    -84,    -84,
  1228,   1228,   1228,   1228,
 15942,  15942,  15942,  15942,
  -701,   -701,   -701,   -701,
   -79,    -79,    -79,    -79,
  1172,   1172,   1172,   1172,
 15972,  15972,  15972,  15972,
  -682,   -682,   -682,   -682,
   -73,    -73,    -73,    -73,
  1117,   1117,   1117,   1117,
 16002,  16002,  16002,  16002,
  -662,   -662,   -662,   -662,
   -68,    -68,    -68,    -68,
  1063,   1063,   1063,   1063,
 16030,  16030,  16030,  16030,
  -641,   -641,   -641,   -641,
   -63,    -63,    -63,    -63,
  1009,   1009,   1009,   1009,
 16058,  16058,  16058,  16058,
  -620,   -620,   -620,   -620,
   -58,    -58,    -58,    -58,
   956,    956,    956,    956,
 16084,  16084,  16084,  16084,
  -599,   -599,   -599,   -599,
   -53,    -53,    -53,    -53,
   905,    905,    905,    905,
 16110,  16110,  16110,  16110,
  -577,   -577,   -577,   -577,
   -48,    -48,    -48,    -48,
   854,    854,    854,    854,
 16134,  16134,  16134,  16134,
  -555,   -555,   -555,   -555,
   -44,    -44,    -44,    -44,
   803,    803,    803,    803,
 16157,  16157,  16157,  16157,
  -533,   -533,   -533,   -533,
   -40,    -40,    -40,    -40,
   754,    754,    754,    754,
 16179,  16179,  16179,  16179,
  -510,   -510,   -510,   -510,
   -36,    -36,    -36,    -36,
   705,    705,    705,    705,
 16200,  16200,  16200,  16200,
  -486,   -486,   -486,   -486,
   -32,    -32,    -32,    -32,
   658,    658,    658,    658,
 16220,  16220,  16220,  16220,
  -462,   -462,   -462,   -462,
   -28,    -28,    -28,    -28,
   611,    611,    611,    611,
 16239,  16239,  16239,  16239,
  -438,   -438,   -438,   -438,
   -25,    -25,    -25,    -25,
   565,    565,    565,    565,
 16257,  16257,  16257,  16257,
  -413,   -413,   -413,   -413,
   -22,    -22,    -22,    -22,
   520,    520,    520,    520,
 16274,  16274,  16274,  16274,
  -388,   -388,   -388,   -388,
   -19,    -19,    -19,    -19,
   475,    475,    475,    475,
 16289,  16289,  16289,  16289,
  -362,   -362,   -362,   -362,
   -16,    -16,    -16,    -16,
   432,    432,    432,    432,
 16304,  16304,  16304,  16304,
  -336,   -336,   -336,   -336,
   -13,    -13,    -13,    -13,
   389,    389,    389,    389,
 16317,  16317,  16317,  16317,
  -309,   -309,   -309,   -309,
   -11,    -11,    -11,    -11,
   348,    348,    348,    348,
 16329,  16329,  16329,  16329,
  -282,   -282,   -282,   -282,
    -9,     -9,     -9,     -9,
   307,    307,    307,    307,
 16340,  16340,  16340,  16340,
  -254,   -254,   -254,   -254,
    -7,     -7,     -7,     -7,
   268,    268,    268,    268,
 16349,  16349,  16349,  16349,
  -226,   -226,   -226,   -226,
    -5,     -5,     -5,     -5,
   229,    229,    229,    229,
 16358,  16358,  16358,  16358,
  -198,   -198,   -198,   -198,
    -4,     -4,     -4,     -4,
   191,    191,    191,    191,
 16365,  16365,  16365,  16365,
  -169,   -169,   -169,   -169,
    -2,     -2,     -2,     -2,
   154,    154,    154,    154,
 16371,  16371,  16371,  16371,
  -139,   -139,   -139,   -139,
    -2,     -2,     -2,     -2,
   118,    118,    118,    118,
 16376,  16376,  16376,  16376,
  -109,   -109,   -109,   -109,
    -1,     -1,     -1,     -1,
    83,     83,     83,     83,
 16380,  16380,  16380,  16380,
   -78,    -78,    -78,    -78,
     0,      0,      0,      0,
    49,     49,     49,     49,
 16383,  16383,  16383,  16383,
   -47,    -47,    -47,    -47,
     0,      0,      0,      0,
    16,     16,     16,     16,
 16384,  16384,  16384,  16384,
   -16,    -16,    -16,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_u8_bc2_4[] = {
   -32,    -32,    -32,    -32,
 16384,  16384,  16384,  16384,
    32,     32,     32,     32,
     0,      0,      0,      0,
   -95,    -95,    -95,    -95,
 16383,  16383,  16383,  16383,
    97,     97,     97,     97,
    -1,     -1,     -1,     -1,
  -157,   -157,   -157,   -157,
 16381,  16381,  16381,  16381,
   162,    162,    162,    162,
    -2,     -2,     -2,     -2,
  -218,   -218,   -218,   -218,
 16378,  16378,  16378,  16378,
   227,    227,    227,    227,
    -3,     -3,     -3,     -3,
  -278,   -278,   -278,   -278,
 16374,  16374,  16374,  16374,
   293,    293,    293,    293,
    -5,     -5,     -5,     -5,
  -337,   -337,   -337,   -337,
 16369,  16369,  16369,  16369,
   359,    359,    359,    359,
    -7,     -7,     -7,     -7,
  -395,   -395,   -395,   -395,
 16363,  16363,  16363,  16363,
   426,    426,    426,    426,
   -10,    -10,    -10,    -10,
  -452,   -452,   -452,   -452,
 16356,  16356,  16356,  16356,
   494,    494,    494,    494,
   -14,    -14,    -14,    -14,
  -508,   -508,   -508,   -508,
 16348,  16348,  16348,  16348,
   561,    561,    561,    561,
   -17,    -17,    -17,    -17,
  -564,   -564,   -564,   -564,
 16340,  16340,  16340,  16340,
   630,    630,    630,    630,
   -22,    -22,    -22,    -22,
  -618,   -618,   -618,   -618,
 16330,  16330,  16330,  16330,
   698,    698,    698,    698,
   -26,    -26,    -26,    -26,
  -671,   -671,   -671,   -671,
 16319,  16319,  16319,  16319,
   768,    768,    768,    768,
   -32,    -32,    -32,    -32,
  -724,   -724,   -724,   -724,
 16308,  16308,  16308,  16308,
   837,    837,    837,    837,
   -37,    -37,    -37,    -37,
  -775,   -775,   -775,   -775,
 16295,  16295,  16295,  16295,
   907,    907,    907,    907,
   -43,    -43,    -43,    -43,
  -826,   -826,   -826,   -826,
 16282,  16282,  16282,  16282,
   978,    978,    978,    978,
   -50,    -50,    -50,    -50,
  -876,   -876,   -876,   -876,
 16268,  16268,  16268,  16268,
  1048,   1048,   1048,   1048,
   -56,    -56,    -56,    -56,
  -924,   -924,   -924,   -924,
 16252,  16252,  16252,  16252,
  1120,   1120,   1120,   1120,
   -64,    -64,    -64,    -64,
  -972,   -972,   -972,   -972,
 16236,  16236,  16236,  16236,
  1191,   1191,   1191,   1191,
   -71,    -71,    -71,    -71,
 -1019,  -1019,  -1019,  -1019,
 16219,  16219,  16219,  16219,
  1263,   1263,   1263,   1263,
   -79,    -79,    -79,    -79,
 -1065,  -1065,  -1065,  -1065,
 16201,  16201,  16201,  16201,
  1336,   1336,   1336,   1336,
   -88,    -88,    -88,    -88,
 -1110,  -1110,  -1110,  -1110,
 16182,  16182,  16182,  16182,
  1409,   1409,   1409,   1409,
   -97,    -97,    -97,    -97,
 -1155,  -1155,  -1155,  -1155,
 16163,  16163,  16163,  16163,
  1482,   1482,   1482,   1482,
  -106,   -106,   -106,   -106,
 -1198,  -1198,  -1198,  -1198,
 16142,  16142,  16142,  16142,
  1555,   1555,   1555,   1555,
  -115,   -115,   -115,   -115,
 -1241,  -1241,  -1241,  -1241,
 16121,  16121,  16121,  16121,
  1629,   1629,   1629,   1629,
  -125,   -125,   -125,   -125,
 -1282,  -1282,  -1282,  -1282,
 16098,  16098,  16098,  16098,
  1704,   1704,   1704,   1704,
  -136,   -136,   -136,   -136,
 -1323,  -1323,  -1323,  -1323,
 16075,  16075,  16075,  16075,
  1778,   1778,   1778,   1778,
  -146,   -146,   -146,   -146,
 -1363,  -1363,  -1363,  -1363,
 16051,  16051,  16051,  16051,
  1853,   1853,   1853,   1853,
  -157,   -157,   -157,   -157,
 -1402,  -1402,  -1402,  -1402,
 16026,  16026,  16026,  16026,
  1929,   1929,   1929,   1929,
  -169,   -169,   -169,   -169,
 -1440,  -1440,  -1440,  -1440,
 16000,  16000,  16000,  16000,
  2004,   2004,   2004,   2004,
  -180,   -180,   -180,   -180,
 -1478,  -1478,  -1478,  -1478,
 15974,  15974,  15974,  15974,
  2080,   2080,   2080,   2080,
  -192,   -192,   -192,   -192,
 -1515,  -1515,  -1515,  -1515,
 15947,  15947,  15947,  15947,
  2157,   2157,   2157,   2157,
  -205,   -205,   -205,   -205,
 -1550,  -1550,  -1550,  -1550,
 15918,  15918,  15918,  15918,
  2234,   2234,   2234,   2234,
  -218,   -218,   -218,   -218,
 -1585,  -1585,  -1585,  -1585,
 15889,  15889,  15889,  15889,
  2311,   2311,   2311,   2311,
  -231,   -231,   -231,   -231,
 -1620,  -1620,  -1620,  -1620,
 15860,  15860,  15860,  15860,
  2388,   2388,   2388,   2388,
  -244,   -244,   -244,   -244,
 -1653,  -1653,  -1653,  -1653,
 15829,  15829,  15829,  15829,
  2465,   2465,   2465,   2465,
  -257,   -257,   -257,   -257,
 -1686,  -1686,  -1686,  -1686,
 15798,  15798,  15798,  15798,
  2543,   2543,   2543,   2543,
  -271,   -271,   -271,   -271,
 -1717,  -1717,  -1717,  -1717,
 15765,  15765,  15765,  15765,
  2622,   2622,   2622,   2622,
  -286,   -286,   -286,   -286,
 -1748,  -1748,  -1748,  -1748,
 15732,  15732,  15732,  15732,
  2700,   2700,   2700,   2700,
  -300,   -300,   -300,   -300,
 -1779,  -1779,  -1779,  -1779,
 15699,  15699,  15699,  15699,
  2779,   2779,   2779,   2779,
  -315,   -315,   -315,   -315,
 -1808,  -1808,  -1808,  -1808,
 15664,  15664,  15664,  15664,
  2858,   2858,   2858,   2858,
  -330,   -330,   -330,   -330,
 -1837,  -1837,  -1837,  -1837,
 15629,  15629,  15629,  15629,
  2937,   2937,   2937,   2937,
  -345,   -345,   -345,   -345,
 -1865,  -1865,  -1865,  -1865,
 15593,  15593,  15593,  15593,
  3017,   3017,   3017,   3017,
  -361,   -361,   -361,   -361,
 -1892,  -1892,  -1892,  -1892,
 15556,  15556,  15556,  15556,
  3097,   3097,   3097,   3097,
  -377,   -377,   -377,   -377,
 -1918,  -1918,  -1918,  -1918,
 15518,  15518,  15518,  15518,
  3177,   3177,   3177,   3177,
  -393,   -393,   -393,   -393,
 -1944,  -1944,  -1944,  -1944,
 15480,  15480,  15480,  15480,
  3257,   3257,   3257,   3257,
  -409,   -409,   -409,   -409,
 -1969,  -1969,  -1969,  -1969,
 15441,  15441,  15441,  15441,
  3338,   3338,   3338,   3338,
  -426,   -426,   -426,   -426,
 -1993,  -1993,  -1993,  -1993,
 15401,  15401,  15401,  15401,
  3418,   3418,   3418,   3418,
  -442,   -442,   -442,   -442,
 -2017,  -2017,  -2017,  -2017,
 15361,  15361,  15361,  15361,
  3499,   3499,   3499,   3499,
  -459,   -459,   -459,   -459,
 -2039,  -2039,  -2039,  -2039,
 15319,  15319,  15319,  15319,
  3581,   3581,   3581,   3581,
  -477,   -477,   -477,   -477,
 -2061,  -2061,  -2061,  -2061,
 15277,  15277,  15277,  15277,
  3662,   3662,   3662,   3662,
  -494,   -494,   -494,   -494,
 -2083,  -2083,  -2083,  -2083,
 15235,  15235,  15235,  15235,
  3744,   3744,   3744,   3744,
  -512,   -512,   -512,   -512,
 -2103,  -2103,  -2103,  -2103,
 15191,  15191,  15191,  15191,
  3826,   3826,   3826,   3826,
  -530,   -530,   -530,   -530,
 -2123,  -2123,  -2123,  -2123,
 15147,  15147,  15147,  15147,
  3908,   3908,   3908,   3908,
  -548,   -548,   -548,   -548,
 -2142,  -2142,  -2142,  -2142,
 15102,  15102,  15102,  15102,
  3990,   3990,   3990,   3990,
  -566,   -566,   -566,   -566,
 -2161,  -2161,  -2161,  -2161,
 15057,  15057,  15057,  15057,
  4072,   4072,   4072,   4072,
  -584,   -584,   -584,   -584,
 -2179,  -2179,  -2179,  -2179,
 15011,  15011,  15011,  15011,
  4155,   4155,   4155,   4155,
  -603,   -603,   -603,   -603,
 -2196,  -2196,  -2196,  -2196,
 14964,  14964,  14964,  14964,
  4238,   4238,   4238,   4238,
  -622,   -622,   -622,   -622,
 -2213,  -2213,  -2213,  -2213,
 14917,  14917,  14917,  14917,
  4321,   4321,   4321,   4321,
  -641,   -641,   -641,   -641,
 -2228,  -2228,  -2228,  -2228,
 14868,  14868,  14868,  14868,
  4404,   4404,   4404,   4404,
  -660,   -660,   -660,   -660,
 -2244,  -2244,  -2244,  -2244,
 14820,  14820,  14820,  14820,
  4487,   4487,   4487,   4487,
  -679,   -679,   -679,   -679,
 -2258,  -2258,  -2258,  -2258,
 14770,  14770,  14770,  14770,
  4571,   4571,   4571,   4571,
  -699,   -699,   -699,   -699,
 -2272,  -2272,  -2272,  -2272,
 14720,  14720,  14720,  14720,
  4654,   4654,   4654,   4654,
  -718,   -718,   -718,   -718,
 -2285,  -2285,  -2285,  -2285,
 14669,  14669,  14669,  14669,
  4738,   4738,   4738,   4738,
  -738,   -738,   -738,   -738,
 -2298,  -2298,  -2298,  -2298,
 14618,  14618,  14618,  14618,
  4822,   4822,   4822,   4822,
  -758,   -758,   -758,   -758,
 -2310,  -2310,  -2310,  -2310,
 14566,  14566,  14566,  14566,
  4906,   4906,   4906,   4906,
  -778,   -778,   -778,   -778,
 -2321,  -2321,  -2321,  -2321,
 14513,  14513,  14513,  14513,
  4990,   4990,   4990,   4990,
  -798,   -798,   -798,   -798,
 -2332,  -2332,  -2332,  -2332,
 14460,  14460,  14460,  14460,
  5074,   5074,   5074,   5074,
  -818,   -818,   -818,   -818,
 -2342,  -2342,  -2342,  -2342,
 14406,  14406,  14406,  14406,
  5159,   5159,   5159,   5159,
  -839,   -839,   -839,   -839,
 -2352,  -2352,  -2352,  -2352,
 14352,  14352,  14352,  14352,
  5243,   5243,   5243,   5243,
  -859,   -859,   -859,   -859,
 -2361,  -2361,  -2361,  -2361,
 14297,  14297,  14297,  14297,
  5328,   5328,   5328,   5328,
  -880,   -880,   -880,   -880,
 -2369,  -2369,  -2369,  -2369,
 14241,  14241,  14241,  14241,
  5412,   5412,   5412,   5412,
  -900,   -900,   -900,   -900,
 -2377,  -2377,  -2377,  -2377,
 14185,  14185,  14185,  14185,
  5497,   5497,   5497,   5497,
  -921,   -921,   -921,   -921,
 -2384,  -2384,  -2384,  -2384,
 14128,  14128,  14128,  14128,
  5582,   5582,   5582,   5582,
  -942,   -942,   -942,   -942,
 -2391,  -2391,  -2391,  -2391,
 14071,  14071,  14071,  14071,
  5667,   5667,   5667,   5667,
  -963,   -963,   -963,   -963,
 -2397,  -2397,  -2397,  -2397,
 14013,  14013,  14013,  14013,
  5752,   5752,   5752,   5752,
  -984,   -984,   -984,   -984,
 -2402,  -2402,  -2402,  -2402,
 13954,  13954,  13954,  13954,
  5837,   5837,   5837,   5837,
 -1005,  -1005,  -1005,  -1005,
 -2407,  -2407,  -2407,  -2407,
 13895,  13895,  13895,  13895,
  5922,   5922,   5922,   5922,
 -1026,  -1026,  -1026,  -1026,
 -2411,  -2411,  -2411,  -2411,
 13835,  13835,  13835,  13835,
  6007,   6007,   6007,   6007,
 -1047,  -1047,  -1047,  -1047,
 -2415,  -2415,  -2415,  -2415,
 13775,  13775,  13775,  13775,
  6092,   6092,   6092,   6092,
 -1068,  -1068,  -1068,  -1068,
 -2419,  -2419,  -2419,  -2419,
 13715,  13715,  13715,  13715,
  6177,   6177,   6177,   6177,
 -1089,  -1089,  -1089,  -1089,
 -2421,  -2421,  -2421,  -2421,
 13653,  13653,  13653,  13653,
  6263,   6263,   6263,   6263,
 -1111,  -1111,  -1111,  -1111,
 -2424,  -2424,  -2424,  -2424,
 13592,  13592,  13592,  13592,
  6348,   6348,   6348,   6348,
 -1132,  -1132,  -1132,  -1132,
 -2425,  -2425,  -2425,  -2425,
 13529,  13529,  13529,  13529,
  6433,   6433,   6433,   6433,
 -1153,  -1153,  -1153,  -1153,
 -2426,  -2426,  -2426,  -2426,
 13466,  13466,  13466,  13466,
  6519,   6519,   6519,   6519,
 -1175,  -1175,  -1175,  -1175,
 -2427,  -2427,  -2427,  -2427,
 13403,  13403,  13403,  13403,
  6604,   6604,   6604,   6604,
 -1196,  -1196,  -1196,  -1196,
 -2427,  -2427,  -2427,  -2427,
 13339,  13339,  13339,  13339,
  6689,   6689,   6689,   6689,
 -1217,  -1217,  -1217,  -1217,
 -2427,  -2427,  -2427,  -2427,
 13275,  13275,  13275,  13275,
  6775,   6775,   6775,   6775,
 -1239,  -1239,  -1239,  -1239,
 -2426,  -2426,  -2426,  -2426,
 13210,  13210,  13210,  13210,
  6860,   6860,   6860,   6860,
 -1260,  -1260,  -1260,  -1260,
 -2425,  -2425,  -2425,  -2425,
 13145,  13145,  13145,  13145,
  6945,   6945,   6945,   6945,
 -1281,  -1281,  -1281,  -1281,
 -2423,  -2423,  -2423,  -2423,
 13079,  13079,  13079,  13079,
  7030,   7030,   7030,   7030,
 -1302,  -1302,  -1302,  -1302,
 -2421,  -2421,  -2421,  -2421,
 13013,  13013,  13013,  13013,
  7116,   7116,   7116,   7116,
 -1324,  -1324,  -1324,  -1324,
 -2418,  -2418,  -2418,  -2418,
 12946,  12946,  12946,  12946,
  7201,   7201,   7201,   7201,
 -1345,  -1345,  -1345,  -1345,
 -2415,  -2415,  -2415,  -2415,
 12879,  12879,  12879,  12879,
  7286,   7286,   7286,   7286,
 -1366,  -1366,  -1366,  -1366,
 -2411,  -2411,  -2411,  -2411,
 12811,  12811,  12811,  12811,
  7371,   7371,   7371,   7371,
 -1387,  -1387,  -1387,  -1387,
 -2407,  -2407,  -2407,  -2407,
 12743,  12743,  12743,  12743,
  7456,   7456,   7456,   7456,
 -1408,  -1408,  -1408,  -1408,
 -2402,  -2402,  -2402,  -2402,
 12674,  12674,  12674,  12674,
  7541,   7541,   7541,   7541,
 -1429,  -1429,  -1429,  -1429,
 -2397,  -2397,  -2397,  -2397,
 12605,  12605,  12605,  12605,
  7626,   7626,   7626,   7626,
 -1450,  -1450,  -1450,  -1450,
 -2392,  -2392,  -2392,  -2392,
 12536,  12536,  12536,  12536,
  7711,   7711,   7711,   7711,
 -1471,  -1471,  -1471,  -1471,
 -2386,  -2386,  -2386,  -2386,
 12466,  12466,  12466,  12466,
  7796,   7796,   7796,   7796,
 -1492,  -1492,  -1492,  -1492,
 -2380,  -2380,  -2380,  -2380,
 12396,  12396,  12396,  12396,
  7881,   7881,   7881,   7881,
 -1513,  -1513,  -1513,  -1513,
 -2373,  -2373,  -2373,  -2373,
 12325,  12325,  12325,  12325,
  7966,   7966,   7966,   7966,
 -1534,  -1534,  -1534,  -1534,
 -2366,  -2366,  -2366,  -2366,
 12254,  12254,  12254,  12254,
  8050,   8050,   8050,   8050,
 -1554,  -1554,  -1554,  -1554,
 -2359,  -2359,  -2359,  -2359,
 12183,  12183,  12183,  12183,
  8135,   8135,   8135,   8135,
 -1575,  -1575,  -1575,  -1575,
 -2351,  -2351,  -2351,  -2351,
 12111,  12111,  12111,  12111,
  8219,   8219,   8219,   8219,
 -1595,  -1595,  -1595,  -1595,
 -2342,  -2342,  -2342,  -2342,
 12038,  12038,  12038,  12038,
  8304,   8304,   8304,   8304,
 -1616,  -1616,  -1616,  -1616,
 -2334,  -2334,  -2334,  -2334,
 11966,  11966,  11966,  11966,
  8388,   8388,   8388,   8388,
 -1636,  -1636,  -1636,  -1636,
 -2325,  -2325,  -2325,  -2325,
 11893,  11893,  11893,  11893,
  8472,   8472,   8472,   8472,
 -1656,  -1656,  -1656,  -1656,
 -2315,  -2315,  -2315,  -2315,
 11819,  11819,  11819,  11819,
  8556,   8556,   8556,   8556,
 -1676,  -1676,  -1676,  -1676,
 -2305,  -2305,  -2305,  -2305,
 11745,  11745,  11745,  11745,
  8640,   8640,   8640,   8640,
 -1696,  -1696,  -1696,  -1696,
 -2295,  -2295,  -2295,  -2295,
 11671,  11671,  11671,  11671,
  8723,   8723,   8723,   8723,
 -1715,  -1715,  -1715,  -1715,
 -2284,  -2284,  -2284,  -2284,
 11596,  11596,  11596,  11596,
  8807,   8807,   8807,   8807,
 -1735,  -1735,  -1735,  -1735,
 -2274,  -2274,  -2274,  -2274,
 11522,  11522,  11522,  11522,
  8890,   8890,   8890,   8890,
 -1754,  -1754,  -1754,  -1754,
 -2262,  -2262,  -2262,  -2262,
 11446,  11446,  11446,  11446,
  8974,   8974,   8974,   8974,
 -1774,  -1774,  -1774,  -1774,
 -2251,  -2251,  -2251,  -2251,
 11371,  11371,  11371,  11371,
  9057,   9057,   9057,   9057,
 -1793,  -1793,  -1793,  -1793,
 -2239,  -2239,  -2239,  -2239,
 11295,  11295,  11295,  11295,
  9140,   9140,   9140,   9140,
 -1812,  -1812,  -1812,  -1812,
 -2227,  -2227,  -2227,  -2227,
 11219,  11219,  11219,  11219,
  9222,   9222,   9222,   9222,
 -1830,  -1830,  -1830,  -1830,
 -2214,  -2214,  -2214,  -2214,
 11142,  11142,  11142,  11142,
  9305,   9305,   9305,   9305,
 -1849,  -1849,  -1849,  -1849,
 -2201,  -2201,  -2201,  -2201,
 11065,  11065,  11065,  11065,
  9387,   9387,   9387,   9387,
 -1867,  -1867,  -1867,  -1867,
 -2188,  -2188,  -2188,  -2188,
 10988,  10988,  10988,  10988,
  9470,   9470,   9470,   9470,
 -1886,  -1886,  -1886,  -1886,
 -2174,  -2174,  -2174,  -2174,
 10910,  10910,  10910,  10910,
  9552,   9552,   9552,   9552,
 -1904,  -1904,  -1904,  -1904,
 -2161,  -2161,  -2161,  -2161,
 10833,  10833,  10833,  10833,
  9633,   9633,   9633,   9633,
 -1921,  -1921,  -1921,  -1921,
 -2146,  -2146,  -2146,  -2146,
 10754,  10754,  10754,  10754,
  9715,   9715,   9715,   9715,
 -1939,  -1939,  -1939,  -1939,
 -2132,  -2132,  -2132,  -2132,
 10676,  10676,  10676,  10676,
  9796,   9796,   9796,   9796,
 -1956,  -1956,  -1956,  -1956,
 -2117,  -2117,  -2117,  -2117,
 10597,  10597,  10597,  10597,
  9878,   9878,   9878,   9878,
 -1974,  -1974,  -1974,  -1974,
 -2102,  -2102,  -2102,  -2102,
 10518,  10518,  10518,  10518,
  9959,   9959,   9959,   9959,
 -1991,  -1991,  -1991,  -1991,
 -2087,  -2087,  -2087,  -2087,
 10439,  10439,  10439,  10439,
 10039,  10039,  10039,  10039,
 -2007,  -2007,  -2007,  -2007,
 -2072,  -2072,  -2072,  -2072,
 10360,  10360,  10360,  10360,
 10120,  10120,  10120,  10120,
 -2024,  -2024,  -2024,  -2024,
 -2056,  -2056,  -2056,  -2056,
 10280,  10280,  10280,  10280,
 10200,  10200,  10200,  10200,
 -2040,  -2040,  -2040,  -2040,
 -2040,  -2040,  -2040,  -2040,
 10200,  10200,  10200,  10200,
 10280,  10280,  10280,  10280,
 -2056,  -2056,  -2056,  -2056,
 -2024,  -2024,  -2024,  -2024,
 10120,  10120,  10120,  10120,
 10360,  10360,  10360,  10360,
 -2072,  -2072,  -2072,  -2072,
 -2007,  -2007,  -2007,  -2007,
 10039,  10039,  10039,  10039,
 10439,  10439,  10439,  10439,
 -2087,  -2087,  -2087,  -2087,
 -1991,  -1991,  -1991,  -1991,
  9959,   9959,   9959,   9959,
 10518,  10518,  10518,  10518,
 -2102,  -2102,  -2102,  -2102,
 -1974,  -1974,  -1974,  -1974,
  9878,   9878,   9878,   9878,
 10597,  10597,  10597,  10597,
 -2117,  -2117,  -2117,  -2117,
 -1956,  -1956,  -1956,  -1956,
  9796,   9796,   9796,   9796,
 10676,  10676,  10676,  10676,
 -2132,  -2132,  -2132,  -2132,
 -1939,  -1939,  -1939,  -1939,
  9715,   9715,   9715,   9715,
 10754,  10754,  10754,  10754,
 -2146,  -2146,  -2146,  -2146,
 -1921,  -1921,  -1921,  -1921,
  9633,   9633,   9633,   9633,
 10833,  10833,  10833,  10833,
 -2161,  -2161,  -2161,  -2161,
 -1904,  -1904,  -1904,  -1904,
  9552,   9552,   9552,   9552,
 10910,  10910,  10910,  10910,
 -2174,  -2174,  -2174,  -2174,
 -1886,  -1886,  -1886,  -1886,
  9470,   9470,   9470,   9470,
 10988,  10988,  10988,  10988,
 -2188,  -2188,  -2188,  -2188,
 -1867,  -1867,  -1867,  -1867,
  9387,   9387,   9387,   9387,
 11065,  11065,  11065,  11065,
 -2201,  -2201,  -2201,  -2201,
 -1849,  -1849,  -1849,  -1849,
  9305,   9305,   9305,   9305,
 11142,  11142,  11142,  11142,
 -2214,  -2214,  -2214,  -2214,
 -1830,  -1830,  -1830,  -1830,
  9222,   9222,   9222,   9222,
 11219,  11219,  11219,  11219,
 -2227,  -2227,  -2227,  -2227,
 -1812,  -1812,  -1812,  -1812,
  9140,   9140,   9140,   9140,
 11295,  11295,  11295,  11295,
 -2239,  -2239,  -2239,  -2239,
 -1793,  -1793,  -1793,  -1793,
  9057,   9057,   9057,   9057,
 11371,  11371,  11371,  11371,
 -2251,  -2251,  -2251,  -2251,
 -1774,  -1774,  -1774,  -1774,
  8974,   8974,   8974,   8974,
 11446,  11446,  11446,  11446,
 -2262,  -2262,  -2262,  -2262,
 -1754,  -1754,  -1754,  -1754,
  8890,   8890,   8890,   8890,
 11522,  11522,  11522,  11522,
 -2274,  -2274,  -2274,  -2274,
 -1735,  -1735,  -1735,  -1735,
  8807,   8807,   8807,   8807,
 11596,  11596,  11596,  11596,
 -2284,  -2284,  -2284,  -2284,
 -1715,  -1715,  -1715,  -1715,
  8723,   8723,   8723,   8723,
 11671,  11671,  11671,  11671,
 -2295,  -2295,  -2295,  -2295,
 -1696,  -1696,  -1696,  -1696,
  8640,   8640,   8640,   8640,
 11745,  11745,  11745,  11745,
 -2305,  -2305,  -2305,  -2305,
 -1676,  -1676,  -1676,  -1676,
  8556,   8556,   8556,   8556,
 11819,  11819,  11819,  11819,
 -2315,  -2315,  -2315,  -2315,
 -1656,  -1656,  -1656,  -1656,
  8472,   8472,   8472,   8472,
 11893,  11893,  11893,  11893,
 -2325,  -2325,  -2325,  -2325,
 -1636,  -1636,  -1636,  -1636,
  8388,   8388,   8388,   8388,
 11966,  11966,  11966,  11966,
 -2334,  -2334,  -2334,  -2334,
 -1616,  -1616,  -1616,  -1616,
  8304,   8304,   8304,   8304,
 12038,  12038,  12038,  12038,
 -2342,  -2342,  -2342,  -2342,
 -1595,  -1595,  -1595,  -1595,
  8219,   8219,   8219,   8219,
 12111,  12111,  12111,  12111,
 -2351,  -2351,  -2351,  -2351,
 -1575,  -1575,  -1575,  -1575,
  8135,   8135,   8135,   8135,
 12183,  12183,  12183,  12183,
 -2359,  -2359,  -2359,  -2359,
 -1554,  -1554,  -1554,  -1554,
  8050,   8050,   8050,   8050,
 12254,  12254,  12254,  12254,
 -2366,  -2366,  -2366,  -2366,
 -1534,  -1534,  -1534,  -1534,
  7966,   7966,   7966,   7966,
 12325,  12325,  12325,  12325,
 -2373,  -2373,  -2373,  -2373,
 -1513,  -1513,  -1513,  -1513,
  7881,   7881,   7881,   7881,
 12396,  12396,  12396,  12396,
 -2380,  -2380,  -2380,  -2380,
 -1492,  -1492,  -1492,  -1492,
  7796,   7796,   7796,   7796,
 12466,  12466,  12466,  12466,
 -2386,  -2386,  -2386,  -2386,
 -1471,  -1471,  -1471,  -1471,
  7711,   7711,   7711,   7711,
 12536,  12536,  12536,  12536,
 -2392,  -2392,  -2392,  -2392,
 -1450,  -1450,  -1450,  -1450,
  7626,   7626,   7626,   7626,
 12605,  12605,  12605,  12605,
 -2397,  -2397,  -2397,  -2397,
 -1429,  -1429,  -1429,  -1429,
  7541,   7541,   7541,   7541,
 12674,  12674,  12674,  12674,
 -2402,  -2402,  -2402,  -2402,
 -1408,  -1408,  -1408,  -1408,
  7456,   7456,   7456,   7456,
 12743,  12743,  12743,  12743,
 -2407,  -2407,  -2407,  -2407,
 -1387,  -1387,  -1387,  -1387,
  7371,   7371,   7371,   7371,
 12811,  12811,  12811,  12811,
 -2411,  -2411,  -2411,  -2411,
 -1366,  -1366,  -1366,  -1366,
  7286,   7286,   7286,   7286,
 12879,  12879,  12879,  12879,
 -2415,  -2415,  -2415,  -2415,
 -1345,  -1345,  -1345,  -1345,
  7201,   7201,   7201,   7201,
 12946,  12946,  12946,  12946,
 -2418,  -2418,  -2418,  -2418,
 -1324,  -1324,  -1324,  -1324,
  7116,   7116,   7116,   7116,
 13013,  13013,  13013,  13013,
 -2421,  -2421,  -2421,  -2421,
 -1302,  -1302,  -1302,  -1302,
  7030,   7030,   7030,   7030,
 13079,  13079,  13079,  13079,
 -2423,  -2423,  -2423,  -2423,
 -1281,  -1281,  -1281,  -1281,
  6945,   6945,   6945,   6945,
 13145,  13145,  13145,  13145,
 -2425,  -2425,  -2425,  -2425,
 -1260,  -1260,  -1260,  -1260,
  6860,   6860,   6860,   6860,
 13210,  13210,  13210,  13210,
 -2426,  -2426,  -2426,  -2426,
 -1239,  -1239,  -1239,  -1239,
  6775,   6775,   6775,   6775,
 13275,  13275,  13275,  13275,
 -2427,  -2427,  -2427,  -2427,
 -1217,  -1217,  -1217,  -1217,
  6689,   6689,   6689,   6689,
 13339,  13339,  13339,  13339,
 -2427,  -2427,  -2427,  -2427,
 -1196,  -1196,  -1196,  -1196,
  6604,   6604,   6604,   6604,
 13403,  13403,  13403,  13403,
 -2427,  -2427,  -2427,  -2427,
 -1175,  -1175,  -1175,  -1175,
  6519,   6519,   6519,   6519,
 13466,  13466,  13466,  13466,
 -2426,  -2426,  -2426,  -2426,
 -1153,  -1153,  -1153,  -1153,
  6433,   6433,   6433,   6433,
 13529,  13529,  13529,  13529,
 -2425,  -2425,  -2425,  -2425,
 -1132,  -1132,  -1132,  -1132,
  6348,   6348,   6348,   6348,
 13592,  13592,  13592,  13592,
 -2424,  -2424,  -2424,  -2424,
 -1111,  -1111,  -1111,  -1111,
  6263,   6263,   6263,   6263,
 13653,  13653,  13653,  13653,
 -2421,  -2421,  -2421,  -2421,
 -1089,  -1089,  -1089,  -1089,
  6177,   6177,   6177,   6177,
 13715,  13715,  13715,  13715,
 -2419,  -2419,  -2419,  -2419,
 -1068,  -1068,  -1068,  -1068,
  6092,   6092,   6092,   6092,
 13775,  13775,  13775,  13775,
 -2415,  -2415,  -2415,  -2415,
 -1047,  -1047,  -1047,  -1047,
  6007,   6007,   6007,   6007,
 13835,  13835,  13835,  13835,
 -2411,  -2411,  -2411,  -2411,
 -1026,  -1026,  -1026,  -1026,
  5922,   5922,   5922,   5922,
 13895,  13895,  13895,  13895,
 -2407,  -2407,  -2407,  -2407,
 -1005,  -1005,  -1005,  -1005,
  5837,   5837,   5837,   5837,
 13954,  13954,  13954,  13954,
 -2402,  -2402,  -2402,  -2402,
  -984,   -984,   -984,   -984,
  5752,   5752,   5752,   5752,
 14013,  14013,  14013,  14013,
 -2397,  -2397,  -2397,  -2397,
  -963,   -963,   -963,   -963,
  5667,   5667,   5667,   5667,
 14071,  14071,  14071,  14071,
 -2391,  -2391,  -2391,  -2391,
  -942,   -942,   -942,   -942,
  5582,   5582,   5582,   5582,
 14128,  14128,  14128,  14128,
 -2384,  -2384,  -2384,  -2384,
  -921,   -921,   -921,   -921,
  5497,   5497,   5497,   5497,
 14185,  14185,  14185,  14185,
 -2377,  -2377,  -2377,  -2377,
  -900,   -900,   -900,   -900,
  5412,   5412,   5412,   5412,
 14241,  14241,  14241,  14241,
 -2369,  -2369,  -2369,  -2369,
  -880,   -880,   -880,   -880,
  5328,   5328,   5328,   5328,
 14297,  14297,  14297,  14297,
 -2361,  -2361,  -2361,  -2361,
  -859,   -859,   -859,   -859,
  5243,   5243,   5243,   5243,
 14352,  14352,  14352,  14352,
 -2352,  -2352,  -2352,  -2352,
  -839,   -839,   -839,   -839,
  5159,   5159,   5159,   5159,
 14406,  14406,  14406,  14406,
 -2342,  -2342,  -2342,  -2342,
  -818,   -818,   -818,   -818,
  5074,   5074,   5074,   5074,
 14460,  14460,  14460,  14460,
 -2332,  -2332,  -2332,  -2332,
  -798,   -798,   -798,   -798,
  4990,   4990,   4990,   4990,
 14513,  14513,  14513,  14513,
 -2321,  -2321,  -2321,  -2321,
  -778,   -778,   -778,   -778,
  4906,   4906,   4906,   4906,
 14566,  14566,  14566,  14566,
 -2310,  -2310,  -2310,  -2310,
  -758,   -758,   -758,   -758,
  4822,   4822,   4822,   4822,
 14618,  14618,  14618,  14618,
 -2298,  -2298,  -2298,  -2298,
  -738,   -738,   -738,   -738,
  4738,   4738,   4738,   4738,
 14669,  14669,  14669,  14669,
 -2285,  -2285,  -2285,  -2285,
  -718,   -718,   -718,   -718,
  4654,   4654,   4654,   4654,
 14720,  14720,  14720,  14720,
 -2272,  -2272,  -2272,  -2272,
  -699,   -699,   -699,   -699,
  4571,   4571,   4571,   4571,
 14770,  14770,  14770,  14770,
 -2258,  -2258,  -2258,  -2258,
  -679,   -679,   -679,   -679,
  4487,   4487,   4487,   4487,
 14820,  14820,  14820,  14820,
 -2244,  -2244,  -2244,  -2244,
  -660,   -660,   -660,   -660,
  4404,   4404,   4404,   4404,
 14868,  14868,  14868,  14868,
 -2228,  -2228,  -2228,  -2228,
  -641,   -641,   -641,   -641,
  4321,   4321,   4321,   4321,
 14917,  14917,  14917,  14917,
 -2213,  -2213,  -2213,  -2213,
  -622,   -622,   -622,   -622,
  4238,   4238,   4238,   4238,
 14964,  14964,  14964,  14964,
 -2196,  -2196,  -2196,  -2196,
  -603,   -603,   -603,   -603,
  4155,   4155,   4155,   4155,
 15011,  15011,  15011,  15011,
 -2179,  -2179,  -2179,  -2179,
  -584,   -584,   -584,   -584,
  4072,   4072,   4072,   4072,
 15057,  15057,  15057,  15057,
 -2161,  -2161,  -2161,  -2161,
  -566,   -566,   -566,   -566,
  3990,   3990,   3990,   3990,
 15102,  15102,  15102,  15102,
 -2142,  -2142,  -2142,  -2142,
  -548,   -548,   -548,   -548,
  3908,   3908,   3908,   3908,
 15147,  15147,  15147,  15147,
 -2123,  -2123,  -2123,  -2123,
  -530,   -530,   -530,   -530,
  3826,   3826,   3826,   3826,
 15191,  15191,  15191,  15191,
 -2103,  -2103,  -2103,  -2103,
  -512,   -512,   -512,   -512,
  3744,   3744,   3744,   3744,
 15235,  15235,  15235,  15235,
 -2083,  -2083,  -2083,  -2083,
  -494,   -494,   -494,   -494,
  3662,   3662,   3662,   3662,
 15277,  15277,  15277,  15277,
 -2061,  -2061,  -2061,  -2061,
  -477,   -477,   -477,   -477,
  3581,   3581,   3581,   3581,
 15319,  15319,  15319,  15319,
 -2039,  -2039,  -2039,  -2039,
  -459,   -459,   -459,   -459,
  3499,   3499,   3499,   3499,
 15361,  15361,  15361,  15361,
 -2017,  -2017,  -2017,  -2017,
  -442,   -442,   -442,   -442,
  3418,   3418,   3418,   3418,
 15401,  15401,  15401,  15401,
 -1993,  -1993,  -1993,  -1993,
  -426,   -426,   -426,   -426,
  3338,   3338,   3338,   3338,
 15441,  15441,  15441,  15441,
 -1969,  -1969,  -1969,  -1969,
  -409,   -409,   -409,   -409,
  3257,   3257,   3257,   3257,
 15480,  15480,  15480,  15480,
 -1944,  -1944,  -1944,  -1944,
  -393,   -393,   -393,   -393,
  3177,   3177,   3177,   3177,
 15518,  15518,  15518,  15518,
 -1918,  -1918,  -1918,  -1918,
  -377,   -377,   -377,   -377,
  3097,   3097,   3097,   3097,
 15556,  15556,  15556,  15556,
 -1892,  -1892,  -1892,  -1892,
  -361,   -361,   -361,   -361,
  3017,   3017,   3017,   3017,
 15593,  15593,  15593,  15593,
 -1865,  -1865,  -1865,  -1865,
  -345,   -345,   -345,   -345,
  2937,   2937,   2937,   2937,
 15629,  15629,  15629,  15629,
 -1837,  -1837,  -1837,  -1837,
  -330,   -330,   -330,   -330,
  2858,   2858,   2858,   2858,
 15664,  15664,  15664,  15664,
 -1808,  -1808,  -1808,  -1808,
  -315,   -315,   -315,   -315,
  2779,   2779,   2779,   2779,
 15699,  15699,  15699,  15699,
 -1779,  -1779,  -1779,  -1779,
  -300,   -300,   -300,   -300,
  2700,   2700,   2700,   2700,
 15732,  15732,  15732,  15732,
 -1748,  -1748,  -1748,  -1748,
  -286,   -286,   -286,   -286,
  2622,   2622,   2622,   2622,
 15765,  15765,  15765,  15765,
 -1717,  -1717,  -1717,  -1717,
  -271,   -271,   -271,   -271,
  2543,   2543,   2543,   2543,
 15798,  15798,  15798,  15798,
 -1686,  -1686,  -1686,  -1686,
  -257,   -257,   -257,   -257,
  2465,   2465,   2465,   2465,
 15829,  15829,  15829,  15829,
 -1653,  -1653,  -1653,  -1653,
  -244,   -244,   -244,   -244,
  2388,   2388,   2388,   2388,
 15860,  15860,  15860,  15860,
 -1620,  -1620,  -1620,  -1620,
  -231,   -231,   -231,   -231,
  2311,   2311,   2311,   2311,
 15889,  15889,  15889,  15889,
 -1585,  -1585,  -1585,  -1585,
  -218,   -218,   -218,   -218,
  2234,   2234,   2234,   2234,
 15918,  15918,  15918,  15918,
 -1550,  -1550,  -1550,  -1550,
  -205,   -205,   -205,   -205,
  2157,   2157,   2157,   2157,
 15947,  15947,  15947,  15947,
 -1515,  -1515,  -1515,  -1515,
  -192,   -192,   -192,   -192,
  2080,   2080,   2080,   2080,
 15974,  15974,  15974,  15974,
 -1478,  -1478,  -1478,  -1478,
  -180,   -180,   -180,   -180,
  2004,   2004,   2004,   2004,
 16000,  16000,  16000,  16000,
 -1440,  -1440,  -1440,  -1440,
  -169,   -169,   -169,   -169,
  1929,   1929,   1929,   1929,
 16026,  16026,  16026,  16026,
 -1402,  -1402,  -1402,  -1402,
  -157,   -157,   -157,   -157,
  1853,   1853,   1853,   1853,
 16051,  16051,  16051,  16051,
 -1363,  -1363,  -1363,  -1363,
  -146,   -146,   -146,   -146,
  1778,   1778,   1778,   1778,
 16075,  16075,  16075,  16075,
 -1323,  -1323,  -1323,  -1323,
  -136,   -136,   -136,   -136,
  1704,   1704,   1704,   1704,
 16098,  16098,  16098,  16098,
 -1282,  -1282,  -1282,  -1282,
  -125,   -125,   -125,   -125,
  1629,   1629,   1629,   1629,
 16121,  16121,  16121,  16121,
 -1241,  -1241,  -1241,  -1241,
  -115,   -115,   -115,   -115,
  1555,   1555,   1555,   1555,
 16142,  16142,  16142,  16142,
 -1198,  -1198,  -1198,  -1198,
  -106,   -106,   -106,   -106,
  1482,   1482,   1482,   1482,
 16163,  16163,  16163,  16163,
 -1155,  -1155,  -1155,  -1155,
   -97,    -97,    -97,    -97,
  1409,   1409,   1409,   1409,
 16182,  16182,  16182,  16182,
 -1110,  -1110,  -1110,  -1110,
   -88,    -88,    -88,    -88,
  1336,   1336,   1336,   1336,
 16201,  16201,  16201,  16201,
 -1065,  -1065,  -1065,  -1065,
   -79,    -79,    -79,    -79,
  1263,   1263,   1263,   1263,
 16219,  16219,  16219,  16219,
 -1019,  -1019,  -1019,  -1019,
   -71,    -71,    -71,    -71,
  1191,   1191,   1191,   1191,
 16236,  16236,  16236,  16236,
  -972,   -972,   -972,   -972,
   -64,    -64,    -64,    -64,
  1120,   1120,   1120,   1120,
 16252,  16252,  16252,  16252,
  -924,   -924,   -924,   -924,
   -56,    -56,    -56,    -56,
  1048,   1048,   1048,   1048,
 16268,  16268,  16268,  16268,
  -876,   -876,   -876,   -876,
   -50,    -50,    -50,    -50,
   978,    978,    978,    978,
 16282,  16282,  16282,  16282,
  -826,   -826,   -826,   -826,
   -43,    -43,    -43,    -43,
   907,    907,    907,    907,
 16295,  16295,  16295,  16295,
  -775,   -775,   -775,   -775,
   -37,    -37,    -37,    -37,
   837,    837,    837,    837,
 16308,  16308,  16308,  16308,
  -724,   -724,   -724,   -724,
   -32,    -32,    -32,    -32,
   768,    768,    768,    768,
 16319,  16319,  16319,  16319,
  -671,   -671,   -671,   -671,
   -26,    -26,    -26,    -26,
   698,    698,    698,    698,
 16330,  16330,  16330,  16330,
  -618,   -618,   -618,   -618,
   -22,    -22,    -22,    -22,
   630,    630,    630,    630,
 16340,  16340,  16340,  16340,
  -564,   -564,   -564,   -564,
   -17,    -17,    -17,    -17,
   561,    561,    561,    561,
 16348,  16348,  16348,  16348,
  -508,   -508,   -508,   -508,
   -14,    -14,    -14,    -14,
   494,    494,    494,    494,
 16356,  16356,  16356,  16356,
  -452,   -452,   -452,   -452,
   -10,    -10,    -10,    -10,
   426,    426,    426,    426,
 16363,  16363,  16363,  16363,
  -395,   -395,   -395,   -395,
    -7,     -7,     -7,     -7,
   359,    359,    359,    359,
 16369,  16369,  16369,  16369,
  -337,   -337,   -337,   -337,
    -5,     -5,     -5,     -5,
   293,    293,    293,    293,
 16374,  16374,  16374,  16374,
  -278,   -278,   -278,   -278,
    -3,     -3,     -3,     -3,
   227,    227,    227,    227,
 16378,  16378,  16378,  16378,
  -218,   -218,   -218,   -218,
    -2,     -2,     -2,     -2,
   162,    162,    162,    162,
 16381,  16381,  16381,  16381,
  -157,   -157,   -157,   -157,
    -1,     -1,     -1,     -1,
    97,     97,     97,     97,
 16383,  16383,  16383,  16383,
   -95,    -95,    -95,    -95,
     0,      0,      0,      0,
    32,     32,     32,     32,
 16384,  16384,  16384,  16384,
   -32,    -32,    -32,    -32
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc[] = {
   -16,  32767,     16,      0,
   -48,  32767,     49,      0,
   -79,  32766,     82,      0,
  -110,  32764,    115,     -1,
  -141,  32762,    149,     -1,
  -172,  32759,    184,     -2,
  -203,  32755,    218,     -3,
  -233,  32751,    254,     -3,
  -263,  32746,    290,     -4,
  -293,  32740,    326,     -6,
  -322,  32734,    363,     -7,
  -352,  32727,    401,     -8,
  -381,  32720,    438,    -10,
  -410,  32712,    477,    -11,
  -438,  32703,    515,    -13,
  -466,  32694,    555,    -15,
  -495,  32685,    594,    -16,
  -522,  32674,    635,    -18,
  -550,  32663,    675,    -21,
  -577,  32652,    716,    -23,
  -605,  32640,    758,    -25,
  -631,  32627,    800,    -28,
  -658,  32614,    842,    -30,
  -685,  32600,    885,    -33,
  -711,  32586,    929,    -36,
  -737,  32571,    972,    -39,
  -762,  32555,   1017,    -42,
  -788,  32539,   1061,    -45,
  -813,  32523,   1107,    -48,
  -838,  32505,   1152,    -51,
  -863,  32488,   1198,    -55,
  -888,  32469,   1245,    -58,
  -912,  32450,   1291,    -62,
  -936,  32431,   1339,    -66,
  -960,  32411,   1387,    -69,
  -984,  32391,   1435,    -73,
 -1007,  32369,   1483,    -77,
 -1031,  32348,   1532,    -81,
 -1054,  32326,   1582,    -86,
 -1076,  32303,   1631,    -90,
 -1099,  32280,   1682,    -94,
 -1121,  32256,   1732,    -99,
 -1144,  32232,   1783,   -104,
 -1166,  32207,   1835,   -108,
 -1187,  32181,   1887,   -113,
 -1209,  32156,   1939,   -118,
 -1230,  32129,   1992,   -123,
 -1251,  32102,   2045,   -128,
 -1272,  32075,   2098,   -133,
 -1293,  32047,   2152,   -138,
 -1313,  32018,   2206,   -144,
 -1333,  31989,   2261,   -149,
 -1353,  31960,   2316,   -155,
 -1373,  31930,   2371,   -160,
 -1392,  31899,   2427,   -166,
 -1412,  31868,   2483,   -172,
 -1431,  31836,   2540,   -177,
 -1450,  31804,   2597,   -183,
 -1469,  31772,   2654,   -189,
 -1487,  31739,   2712,   -196,
 -1506,  31705,   2770,   -202,
 -1524,  31671,   2828,   -208,
 -1542,  31637,   2887,   -214,
 -1559,  31602,   2946,   -221,
 -1577,  31566,   3006,   -227,
 -1594,  31530,   3066,   -234,
 -1611,  31494,   3126,   -240,
 -1628,  31457,   3186,   -247,
 -1645,  31419,   3247,   -254,
 -1661,  31381,   3309,   -261,
 -1677,  31343,   3370,   -268,
 -1694,  31304,   3432,   -275,
 -1709,  31265,   3495,   -282,
 -1725,  31225,   3557,   -289,
 -1741,  31185,   3620,   -296,
 -1756,  31144,   3683,   -304,
 -1771,  31103,   3747,   -311,
 -1786,  31062,   3811,   -319,
 -1801,  31019,   3875,   -326,
 -1815,  30977,   3940,   -334,
 -1830,  30934,   4005,   -341,
 -1844,  30891,   4070,   -349,
 -1858,  30847,   4136,   -357,
 -1872,  30802,   4202,   -365,
 -1885,  30758,   4268,   -373,
 -1899,  30712,   4335,   -381,
 -1912,  30667,   4402,   -389,
 -1925,  30621,   4469,   -397,
 -1938,  30574,   4536,   -405,
 -1950,  30527,   4604,   -413,
 -1963,  30480,   4672,   -421,
 -1975,  30432,   4741,   -430,
 -1987,  30384,   4809,   -438,
 -1999,  30335,   4878,   -447,
 -2011,  30286,   4948,   -455,
 -2022,  30237,   5017,   -464,
 -2034,  30187,   5087,   -472,
 -2045,  30137,   5157,   -481,
 -2056,  30086,   5228,   -490,
 -2067,  30035,   5298,   -499,
 -2077,  29983,   5369,   -507,
 -2088,  29931,   5441,   -516,
 -2098,  29879,   5512,   -525,
 -2108,  29826,   5584,   -534,
 -2118,  29773,   5656,   -543,
 -2128,  29720,   5729,   -552,
 -2138,  29666,   5801,   -561,
 -2147,  29612,   5874,   -571,
 -2156,  29557,   5947,   -580,
 -2165,  29502,   6021,   -589,
 -2174,  29446,   6094,   -598,
 -2183,  29391,   6168,   -608,
 -2192,  29334,   6243,   -617,
 -2200,  29278,   6317,   -627,
 -2208,  29221,   6392,   -636,
 -2217,  29163,   6467,   -646,
 -2224,  29106,   6542,   -655,
 -2232,  29048,   6617,   -665,
 -2240,  28989,   6693,   -675,
 -2247,  28930,   6769,   -684,
 -2255,  28871,   6845,   -694,
 -2262,  28812,   6922,   -704,
 -2269,  28752,   6998,   -713,
 -2275,  28691,   7075,   -723,
 -2282,  28631,   7152,   -733,
 -2289,  28570,   7230,   -743,
 -2295,  28509,   7307,   -753,
 -2301,  28447,   7385,   -763,
 -2307,  28385,   7463,   -773,
 -2313,  28323,   7541,   -783,
 -2319,  28260,   7620,   -793,
 -2324,  28197,   7698,   -803,
 -2329,  28134,   7777,   -813,
 -2335,  28070,   7856,   -823,
 -2340,  28006,   7936,   -834,
 -2345,  27941,   8015,   -844,
 -2349,  27877,   8095,   -854,
 -2354,  27812,   8175,   -864,
 -2359,  27746,   8255,   -875,
 -2363,  27681,   8335,   -885,
 -2367,  27615,   8415,   -895,
 -2371,  27549,   8496,   -906,
 -2375,  27482,   8577,   -916,
 -2379,  27415,   8658,   -926,
 -2382,  27348,   8739,   -937,
 -2386,  27280,   8821,   -947,
 -2389,  27212,   8902,   -958,
 -2392,  27144,   8984,   -968,
 -2395,  27076,   9066,   -979,
 -2398,  27007,   9148,   -989,
 -2401,  26938,   9230,  -1000,
 -2403,  26869,   9313,  -1010,
 -2406,  26799,   9395,  -1021,
 -2408,  26729,   9478,  -1031,
 -2410,  26659,   9561,  -1042,
 -2412,  26589,   9644,  -1052,
 -2414,  26518,   9727,  -1063,
 -2416,  26447,   9811,  -1073,
 -2418,  26376,   9894,  -1084,
 -2419,  26304,   9978,  -1095,
 -2421,  26232,  10062,  -1105,
 -2422,  26160,  10146,  -1116,
 -2423,  26087,  10230,  -1127,
 -2424,  26015,  10314,  -1137,
 -2425,  25942,  10399,  -1148,
 -2426,  25869,  10483,  -1159,
 -2426,  25795,  10568,  -1169,
 -2427,  25721,  10653,  -1180,
 -2427,  25647,  10738,  -1191,
 -2427,  25573,  10823,  -1201,
 -2427,  25499,  10908,  -1212,
 -2427,  25424,  10994,  -1223,
 -2427,  25349,  11079,  -1233,
 -2427,  25274,  11165,  -1244,
 -2426,  25198,  11251,  -1255,
 -2426,  25122,  11337,  -1265,
 -2425,  25046,  11422,  -1276,
 -2424,  24970,  11509,  -1286,
 -2423,  24894,  11595,  -1297,
 -2422,  24817,  11681,  -1308,
 -2421,  24740,  11767,  -1318,
 -2420,  24663,  11854,  -1329,
 -2419,  24586,  11941,  -1340,
 -2417,  24508,  12027,  -1350,
 -2416,  24430,  12114,  -1361,
 -2414,  24352,  12201,  -1371,
 -2412,  24274,  12288,  -1382,
 -2410,  24196,  12375,  -1393,
 -2408,  24117,  12462,  -1403,
 -2406,  24038,  12549,  -1414,
 -2404,  23959,  12637,  -1424,
 -2401,  23880,  12724,  -1435,
 -2399,  23800,  12812,  -1445,
 -2396,  23721,  12899,  -1456,
 -2393,  23641,  12987,  -1466,
 -2391,  23561,  13075,  -1477,
 -2388,  23480,  13163,  -1487,
 -2385,  23400,  13250,  -1497,
 -2381,  23319,  13338,  -1508,
 -2378,  23238,  13426,  -1518,
 -2375,  23157,  13514,  -1529,
 -2371,  23076,  13602,  -1539,
 -2368,  22994,  13691,  -1549,
 -2364,  22913,  13779,  -1560,
 -2360,  22831,  13867,  -1570,
 -2357,  22749,  13955,  -1580,
 -2353,  22667,  14044,  -1590,
 -2349,  22585,  14132,  -1600,
 -2344,  22502,  14221,  -1611,
 -2340,  22420,  14309,  -1621,
 -2336,  22337,  14398,  -1631,
 -2331,  22254,  14486,  -1641,
 -2327,  22171,  14575,  -1651,
 -2322,  22087,  14664,  -1661,
 -2317,  22004,  14752,  -1671,
 -2313,  21920,  14841,  -1681,
 -2308,  21837,  14930,  -1691,
 -2303,  21753,  15019,  -1701,
 -2298,  21669,  15107,  -1710,
 -2292,  21585,  15196,  -1720,
 -2287,  21500,  15285,  -1730,
 -2282,  21416,  15374,  -1740,
 -2276,  21331,  15463,  -1750,
 -2271,  21246,  15552,  -1759,
 -2265,  21162,  15640,  -1769,
 -2259,  21077,  15729,  -1778,
 -2254,  20991,  15818,  -1788,
 -2248,  20906,  15907,  -1797,
 -2242,  20821,  15996,  -1807,
 -2236,  20735,  16085,  -1816,
 -2230,  20650,  16174,  -1826,
 -2223,  20564,  16263,  -1835,
 -2217,  20478,  16351,  -1844,
 -2211,  20392,  16440,  -1854,
 -2204,  20306,  16529,  -1863,
 -2198,  20220,  16618,  -1872,
 -2191,  20133,  16707,  -1881,
 -2185,  20047,  16796,  -1890,
 -2178,  19960,  16884,  -1899,
 -2171,  19874,  16973,  -1908,
 -2164,  19787,  17062,  -1917,
 -2157,  19700,  17151,  -1926,
 -2150,  19613,  17239,  -1935,
 -2143,  19526,  17328,  -1943,
 -2136,  19439,  17416,  -1952,
 -2128,  19352,  17505,  -1961,
 -2121,  19265,  17593,  -1969,
 -2114,  19178,  17682,  -1978,
 -2106,  19090,  17770,  -1986,
 -2099,  19003,  17859,  -1995,
 -2091,  18915,  17947,  -2003,
 -2083,  18827,  18035,  -2011,
 -2076,  18740,  18124,  -2020,
 -2068,  18652,  18212,  -2028,
 -2060,  18564,  18300,  -2036,
 -2052,  18476,  18388,  -2044,
 -2044,  18388,  18476,  -2052,
 -2036,  18300,  18564,  -2060,
 -2028,  18212,  18652,  -2068,
 -2020,  18124,  18740,  -2076,
 -2011,  18035,  18827,  -2083,
 -2003,  17947,  18915,  -2091,
 -1995,  17859,  19003,  -2099,
 -1986,  17770,  19090,  -2106,
 -1978,  17682,  19178,  -2114,
 -1969,  17593,  19265,  -2121,
 -1961,  17505,  19352,  -2128,
 -1952,  17416,  19439,  -2136,
 -1943,  17328,  19526,  -2143,
 -1935,  17239,  19613,  -2150,
 -1926,  17151,  19700,  -2157,
 -1917,  17062,  19787,  -2164,
 -1908,  16973,  19874,  -2171,
 -1899,  16884,  19960,  -2178,
 -1890,  16796,  20047,  -2185,
 -1881,  16707,  20133,  -2191,
 -1872,  16618,  20220,  -2198,
 -1863,  16529,  20306,  -2204,
 -1854,  16440,  20392,  -2211,
 -1844,  16351,  20478,  -2217,
 -1835,  16263,  20564,  -2223,
 -1826,  16174,  20650,  -2230,
 -1816,  16085,  20735,  -2236,
 -1807,  15996,  20821,  -2242,
 -1797,  15907,  20906,  -2248,
 -1788,  15818,  20991,  -2254,
 -1778,  15729,  21077,  -2259,
 -1769,  15640,  21162,  -2265,
 -1759,  15552,  21246,  -2271,
 -1750,  15463,  21331,  -2276,
 -1740,  15374,  21416,  -2282,
 -1730,  15285,  21500,  -2287,
 -1720,  15196,  21585,  -2292,
 -1710,  15107,  21669,  -2298,
 -1701,  15019,  21753,  -2303,
 -1691,  14930,  21837,  -2308,
 -1681,  14841,  21920,  -2313,
 -1671,  14752,  22004,  -2317,
 -1661,  14664,  22087,  -2322,
 -1651,  14575,  22171,  -2327,
 -1641,  14486,  22254,  -2331,
 -1631,  14398,  22337,  -2336,
 -1621,  14309,  22420,  -2340,
 -1611,  14221,  22502,  -2344,
 -1600,  14132,  22585,  -2349,
 -1590,  14044,  22667,  -2353,
 -1580,  13955,  22749,  -2357,
 -1570,  13867,  22831,  -2360,
 -1560,  13779,  22913,  -2364,
 -1549,  13691,  22994,  -2368,
 -1539,  13602,  23076,  -2371,
 -1529,  13514,  23157,  -2375,
 -1518,  13426,  23238,  -2378,
 -1508,  13338,  23319,  -2381,
 -1497,  13250,  23400,  -2385,
 -1487,  13163,  23480,  -2388,
 -1477,  13075,  23561,  -2391,
 -1466,  12987,  23641,  -2393,
 -1456,  12899,  23721,  -2396,
 -1445,  12812,  23800,  -2399,
 -1435,  12724,  23880,  -2401,
 -1424,  12637,  23959,  -2404,
 -1414,  12549,  24038,  -2406,
 -1403,  12462,  24117,  -2408,
 -1393,  12375,  24196,  -2410,
 -1382,  12288,  24274,  -2412,
 -1371,  12201,  24352,  -2414,
 -1361,  12114,  24430,  -2416,
 -1350,  12027,  24508,  -2417,
 -1340,  11941,  24586,  -2419,
 -1329,  11854,  24663,  -2420,
 -1318,  11767,  24740,  -2421,
 -1308,  11681,  24817,  -2422,
 -1297,  11595,  24894,  -2423,
 -1286,  11509,  24970,  -2424,
 -1276,  11422,  25046,  -2425,
 -1265,  11337,  25122,  -2426,
 -1255,  11251,  25198,  -2426,
 -1244,  11165,  25274,  -2427,
 -1233,  11079,  25349,  -2427,
 -1223,  10994,  25424,  -2427,
 -1212,  10908,  25499,  -2427,
 -1201,  10823,  25573,  -2427,
 -1191,  10738,  25647,  -2427,
 -1180,  10653,  25721,  -2427,
 -1169,  10568,  25795,  -2426,
 -1159,  10483,  25869,  -2426,
 -1148,  10399,  25942,  -2425,
 -1137,  10314,  26015,  -2424,
 -1127,  10230,  26087,  -2423,
 -1116,  10146,  26160,  -2422,
 -1105,  10062,  26232,  -2421,
 -1095,   9978,  26304,  -2419,
 -1084,   9894,  26376,  -2418,
 -1073,   9811,  26447,  -2416,
 -1063,   9727,  26518,  -2414,
 -1052,   9644,  26589,  -2412,
 -1042,   9561,  26659,  -2410,
 -1031,   9478,  26729,  -2408,
 -1021,   9395,  26799,  -2406,
 -1010,   9313,  26869,  -2403,
 -1000,   9230,  26938,  -2401,
  -989,   9148,  27007,  -2398,
  -979,   9066,  27076,  -2395,
  -968,   8984,  27144,  -2392,
  -958,   8902,  27212,  -2389,
  -947,   8821,  27280,  -2386,
  -937,   8739,  27348,  -2382,
  -926,   8658,  27415,  -2379,
  -916,   8577,  27482,  -2375,
  -906,   8496,  27549,  -2371,
  -895,   8415,  27615,  -2367,
  -885,   8335,  27681,  -2363,
  -875,   8255,  27746,  -2359,
  -864,   8175,  27812,  -2354,
  -854,   8095,  27877,  -2349,
  -844,   8015,  27941,  -2345,
  -834,   7936,  28006,  -2340,
  -823,   7856,  28070,  -2335,
  -813,   7777,  28134,  -2329,
  -803,   7698,  28197,  -2324,
  -793,   7620,  28260,  -2319,
  -783,   7541,  28323,  -2313,
  -773,   7463,  28385,  -2307,
  -763,   7385,  28447,  -2301,
  -753,   7307,  28509,  -2295,
  -743,   7230,  28570,  -2289,
  -733,   7152,  28631,  -2282,
  -723,   7075,  28691,  -2275,
  -713,   6998,  28752,  -2269,
  -704,   6922,  28812,  -2262,
  -694,   6845,  28871,  -2255,
  -684,   6769,  28930,  -2247,
  -675,   6693,  28989,  -2240,
  -665,   6617,  29048,  -2232,
  -655,   6542,  29106,  -2224,
  -646,   6467,  29163,  -2217,
  -636,   6392,  29221,  -2208,
  -627,   6317,  29278,  -2200,
  -617,   6243,  29334,  -2192,
  -608,   6168,  29391,  -2183,
  -598,   6094,  29446,  -2174,
  -589,   6021,  29502,  -2165,
  -580,   5947,  29557,  -2156,
  -571,   5874,  29612,  -2147,
  -561,   5801,  29666,  -2138,
  -552,   5729,  29720,  -2128,
  -543,   5656,  29773,  -2118,
  -534,   5584,  29826,  -2108,
  -525,   5512,  29879,  -2098,
  -516,   5441,  29931,  -2088,
  -507,   5369,  29983,  -2077,
  -499,   5298,  30035,  -2067,
  -490,   5228,  30086,  -2056,
  -481,   5157,  30137,  -2045,
  -472,   5087,  30187,  -2034,
  -464,   5017,  30237,  -2022,
  -455,   4948,  30286,  -2011,
  -447,   4878,  30335,  -1999,
  -438,   4809,  30384,  -1987,
  -430,   4741,  30432,  -1975,
  -421,   4672,  30480,  -1963,
  -413,   4604,  30527,  -1950,
  -405,   4536,  30574,  -1938,
  -397,   4469,  30621,  -1925,
  -389,   4402,  30667,  -1912,
  -381,   4335,  30712,  -1899,
  -373,   4268,  30758,  -1885,
  -365,   4202,  30802,  -1872,
  -357,   4136,  30847,  -1858,
  -349,   4070,  30891,  -1844,
  -341,   4005,  30934,  -1830,
  -334,   3940,  30977,  -1815,
  -326,   3875,  31019,  -1801,
  -319,   3811,  31062,  -1786,
  -311,   3747,  31103,  -1771,
  -304,   3683,  31144,  -1756,
  -296,   3620,  31185,  -1741,
  -289,   3557,  31225,  -1725,
  -282,   3495,  31265,  -1709,
  -275,   3432,  31304,  -1694,
  -268,   3370,  31343,  -1677,
  -261,   3309,  31381,  -1661,
  -254,   3247,  31419,  -1645,
  -247,   3186,  31457,  -1628,
  -240,   3126,  31494,  -1611,
  -234,   3066,  31530,  -1594,
  -227,   3006,  31566,  -1577,
  -221,   2946,  31602,  -1559,
  -214,   2887,  31637,  -1542,
  -208,   2828,  31671,  -1524,
  -202,   2770,  31705,  -1506,
  -196,   2712,  31739,  -1487,
  -189,   2654,  31772,  -1469,
  -183,   2597,  31804,  -1450,
  -177,   2540,  31836,  -1431,
  -172,   2483,  31868,  -1412,
  -166,   2427,  31899,  -1392,
  -160,   2371,  31930,  -1373,
  -155,   2316,  31960,  -1353,
  -149,   2261,  31989,  -1333,
  -144,   2206,  32018,  -1313,
  -138,   2152,  32047,  -1293,
  -133,   2098,  32075,  -1272,
  -128,   2045,  32102,  -1251,
  -123,   1992,  32129,  -1230,
  -118,   1939,  32156,  -1209,
  -113,   1887,  32181,  -1187,
  -108,   1835,  32207,  -1166,
  -104,   1783,  32232,  -1144,
   -99,   1732,  32256,  -1121,
   -94,   1682,  32280,  -1099,
   -90,   1631,  32303,  -1076,
   -86,   1582,  32326,  -1054,
   -81,   1532,  32348,  -1031,
   -77,   1483,  32369,  -1007,
   -73,   1435,  32391,   -984,
   -69,   1387,  32411,   -960,
   -66,   1339,  32431,   -936,
   -62,   1291,  32450,   -912,
   -58,   1245,  32469,   -888,
   -55,   1198,  32488,   -863,
   -51,   1152,  32505,   -838,
   -48,   1107,  32523,   -813,
   -45,   1061,  32539,   -788,
   -42,   1017,  32555,   -762,
   -39,    972,  32571,   -737,
   -36,    929,  32586,   -711,
   -33,    885,  32600,   -685,
   -30,    842,  32614,   -658,
   -28,    800,  32627,   -631,
   -25,    758,  32640,   -605,
   -23,    716,  32652,   -577,
   -21,    675,  32663,   -550,
   -18,    635,  32674,   -522,
   -16,    594,  32685,   -495,
   -15,    555,  32694,   -466,
   -13,    515,  32703,   -438,
   -11,    477,  32712,   -410,
   -10,    438,  32720,   -381,
    -8,    401,  32727,   -352,
    -7,    363,  32734,   -322,
    -6,    326,  32740,   -293,
    -4,    290,  32746,   -263,
    -3,    254,  32751,   -233,
    -3,    218,  32755,   -203,
    -2,    184,  32759,   -172,
    -1,    149,  32762,   -141,
    -1,    115,  32764,   -110,
     0,     82,  32766,    -79,
     0,     49,  32767,    -48,
     0,     16,  32767,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc2[] = {
   -32,  32767,     32,      0,
   -95,  32767,     96,      0,
  -158,  32766,    161,     -1,
  -221,  32765,    226,     -2,
  -283,  32763,    291,     -3,
  -344,  32760,    356,     -4,
  -406,  32758,    421,     -5,
  -466,  32754,    487,     -7,
  -526,  32750,    553,     -9,
  -586,  32746,    619,    -11,
  -645,  32741,    685,    -13,
  -703,  32735,    752,    -16,
  -761,  32729,    819,    -19,
  -819,  32723,    886,    -22,
  -876,  32716,    954,    -26,
  -933,  32709,   1021,    -29,
  -989,  32701,   1089,    -33,
 -1045,  32693,   1157,    -37,
 -1100,  32684,   1225,    -41,
 -1155,  32675,   1294,    -46,
 -1209,  32665,   1362,    -50,
 -1263,  32655,   1431,    -55,
 -1316,  32644,   1501,    -61,
 -1369,  32633,   1570,    -66,
 -1422,  32622,   1639,    -71,
 -1473,  32609,   1709,    -77,
 -1525,  32597,   1779,    -83,
 -1576,  32584,   1849,    -89,
 -1627,  32571,   1920,    -96,
 -1677,  32557,   1991,   -103,
 -1726,  32542,   2061,   -109,
 -1776,  32528,   2132,   -116,
 -1824,  32512,   2204,   -124,
 -1873,  32497,   2275,   -131,
 -1920,  32480,   2347,   -139,
 -1968,  32464,   2419,   -147,
 -2015,  32447,   2491,   -155,
 -2061,  32429,   2563,   -163,
 -2107,  32411,   2635,   -171,
 -2153,  32393,   2708,   -180,
 -2198,  32374,   2781,   -189,
 -2243,  32355,   2854,   -198,
 -2287,  32335,   2927,   -207,
 -2331,  32315,   3000,   -216,
 -2374,  32294,   3074,   -226,
 -2417,  32273,   3148,   -236,
 -2460,  32252,   3222,   -246,
 -2502,  32230,   3296,   -256,
 -2544,  32208,   3370,   -266,
 -2585,  32185,   3445,   -277,
 -2626,  32162,   3519,   -287,
 -2666,  32138,   3594,   -298,
 -2706,  32114,   3669,   -309,
 -2746,  32090,   3744,   -320,
 -2785,  32065,   3820,   -332,
 -2824,  32040,   3895,   -343,
 -2862,  32014,   3971,   -355,
 -2900,  31988,   4047,   -367,
 -2937,  31961,   4123,   -379,
 -2974,  31934,   4199,   -391,
 -3011,  31907,   4275,   -403,
 -3047,  31879,   4352,   -416,
 -3083,  31851,   4429,   -429,
 -3118,  31822,   4506,   -442,
 -3153,  31793,   4583,   -455,
 -3188,  31764,   4660,   -468,
 -3222,  31734,   4737,   -481,
 -3256,  31704,   4814,   -494,
 -3289,  31673,   4892,   -508,
 -3322,  31642,   4970,   -522,
 -3355,  31611,   5048,   -536,
 -3387,  31579,   5126,   -550,
 -3419,  31547,   5204,   -564,
 -3450,  31514,   5282,   -578,
 -3481,  31481,   5361,   -593,
 -3512,  31448,   5439,   -607,
 -3542,  31414,   5518,   -622,
 -3572,  31380,   5597,   -637,
 -3602,  31346,   5676,   -652,
 -3631,  31311,   5755,   -667,
 -3659,  31275,   5835,   -683,
 -3688,  31240,   5914,   -698,
 -3716,  31204,   5994,   -714,
 -3743,  31167,   6073,   -729,
 -3770,  31130,   6153,   -745,
 -3797,  31093,   6233,   -761,
 -3823,  31055,   6313,   -777,
 -3849,  31017,   6393,   -793,
 -3875,  30979,   6474,   -810,
 -3900,  30940,   6554,   -826,
 -3925,  30901,   6635,   -843,
 -3950,  30862,   6716,   -860,
 -3974,  30822,   6796,   -876,
 -3998,  30782,   6877,   -893,
 -4021,  30741,   6958,   -910,
 -4045,  30701,   7039,   -927,
 -4067,  30659,   7121,   -945,
 -4090,  30618,   7202,   -962,
 -4112,  30576,   7283,   -979,
 -4133,  30533,   7365,   -997,
 -4155,  30491,   7447,  -1015,
 -4176,  30448,   7528,  -1032,
 -4196,  30404,   7610,  -1050,
 -4217,  30361,   7692,  -1068,
 -4237,  30317,   7774,  -1086,
 -4256,  30272,   7857,  -1105,
 -4275,  30227,   7939,  -1123,
 -4294,  30182,   8021,  -1141,
 -4313,  30137,   8104,  -1160,
 -4331,  30091,   8186,  -1178,
 -4349,  30045,   8269,  -1197,
 -4366,  29998,   8352,  -1216,
 -4384,  29952,   8434,  -1234,
 -4400,  29904,   8517,  -1253,
 -4417,  29857,   8600,  -1272,
 -4433,  29809,   8683,  -1291,
 -4449,  29761,   8767,  -1311,
 -4464,  29712,   8850,  -1330,
 -4480,  29664,   8933,  -1349,
 -4495,  29615,   9016,  -1368,
 -4509,  29565,   9100,  -1388,
 -4523,  29515,   9183,  -1407,
 -4537,  29465,   9267,  -1427,
 -4551,  29415,   9351,  -1447,
 -4564,  29364,   9434,  -1466,
 -4577,  29313,   9518,  -1486,
 -4590,  29262,   9602,  -1506,
 -4602,  29210,   9686,  -1526,
 -4614,  29158,   9770,  -1546,
 -4626,  29106,   9854,  -1566,
 -4637,  29053,   9938,  -1586,
 -4648,  29000,  10022,  -1606,
 -4659,  28947,  10107,  -1627,
 -4669,  28893,  10191,  -1647,
 -4679,  28839,  10275,  -1667,
 -4689,  28785,  10360,  -1688,
 -4699,  28731,  10444,  -1708,
 -4708,  28676,  10529,  -1729,
 -4717,  28621,  10613,  -1749,
 -4726,  28566,  10698,  -1770,
 -4734,  28510,  10782,  -1790,
 -4742,  28454,  10867,  -1811,
 -4750,  28398,  10952,  -1832,
 -4757,  28341,  11037,  -1853,
 -4765,  28285,  11121,  -1873,
 -4771,  28227,  11206,  -1894,
 -4778,  28170,  11291,  -1915,
 -4784,  28112,  11376,  -1936,
 -4790,  28054,  11461,  -1957,
 -4796,  27996,  11546,  -1978,
 -4802,  27938,  11631,  -1999,
 -4807,  27879,  11716,  -2020,
 -4812,  27820,  11801,  -2041,
 -4816,  27760,  11886,  -2062,
 -4821,  27701,  11971,  -2083,
 -4825,  27641,  12057,  -2105,
 -4829,  27581,  12142,  -2126,
 -4832,  27520,  12227,  -2147,
 -4836,  27460,  12312,  -2168,
 -4839,  27399,  12397,  -2189,
 -4841,  27337,  12483,  -2211,
 -4844,  27276,  12568,  -2232,
 -4846,  27214,  12653,  -2253,
 -4848,  27152,  12738,  -2274,
 -4850,  27090,  12824,  -2296,
 -4851,  27027,  12909,  -2317,
 -4852,  26964,  12994,  -2338,
 -4853,  26901,  13080,  -2360,
 -4854,  26838,  13165,  -2381,
 -4854,  26774,  13250,  -2402,
 -4855,  26711,  13336,  -2424,
 -4854,  26646,  13421,  -2445,
 -4854,  26582,  13506,  -2466,
 -4854,  26518,  13592,  -2488,
 -4853,  26453,  13677,  -2509,
 -4852,  26388,  13762,  -2530,
 -4850,  26322,  13848,  -2552,
 -4849,  26257,  13933,  -2573,
 -4847,  26191,  14018,  -2594,
 -4845,  26125,  14104,  -2616,
 -4843,  26059,  14189,  -2637,
 -4840,  25992,  14274,  -2658,
 -4837,  25925,  14359,  -2679,
 -4834,  25858,  14445,  -2701,
 -4831,  25791,  14530,  -2722,
 -4828,  25724,  14615,  -2743,
 -4824,  25656,  14700,  -2764,
 -4820,  25588,  14785,  -2785,
 -4816,  25520,  14870,  -2806,
 -4812,  25452,  14955,  -2827,
 -4807,  25383,  15040,  -2848,
 -4802,  25314,  15125,  -2869,
 -4797,  25245,  15210,  -2890,
 -4792,  25176,  15295,  -2911,
 -4787,  25107,  15380,  -2932,
 -4781,  25037,  15465,  -2953,
 -4775,  24967,  15550,  -2974,
 -4769,  24897,  15635,  -2995,
 -4763,  24827,  15720,  -3016,
 -4756,  24756,  15805,  -3037,
 -4750,  24686,  15889,  -3057,
 -4743,  24615,  15974,  -3078,
 -4736,  24544,  16058,  -3098,
 -4728,  24472,  16143,  -3119,
 -4721,  24401,  16228,  -3140,
 -4713,  24329,  16312,  -3160,
 -4705,  24257,  16396,  -3180,
 -4697,  24185,  16481,  -3201,
 -4689,  24113,  16565,  -3221,
 -4680,  24040,  16649,  -3241,
 -4672,  23968,  16734,  -3262,
 -4663,  23895,  16818,  -3282,
 -4654,  23822,  16902,  -3302,
 -4644,  23748,  16986,  -3322,
 -4635,  23675,  17070,  -3342,
 -4625,  23601,  17154,  -3362,
 -4615,  23527,  17238,  -3382,
 -4605,  23453,  17321,  -3401,
 -4595,  23379,  17405,  -3421,
 -4585,  23305,  17489,  -3441,
 -4574,  23230,  17572,  -3460,
 -4564,  23156,  17656,  -3480,
 -4553,  23081,  17739,  -3499,
 -4542,  23006,  17822,  -3518,
 -4530,  22930,  17906,  -3538,
 -4519,  22855,  17989,  -3557,
 -4507,  22779,  18072,  -3576,
 -4496,  22704,  18155,  -3595,
 -4484,  22628,  18238,  -3614,
 -4472,  22552,  18321,  -3633,
 -4459,  22475,  18403,  -3651,
 -4447,  22399,  18486,  -3670,
 -4434,  22322,  18569,  -3689,
 -4422,  22246,  18651,  -3707,
 -4409,  22169,  18734,  -3726,
 -4396,  22092,  18816,  -3744,
 -4382,  22014,  18898,  -3762,
 -4369,  21937,  18980,  -3780,
 -4356,  21860,  19062,  -3798,
 -4342,  21782,  19144,  -3816,
 -4328,  21704,  19226,  -3834,
 -4314,  21626,  19308,  -3852,
 -4300,  21548,  19389,  -3869,
 -4286,  21470,  19471,  -3887,
 -4271,  21391,  19552,  -3904,
 -4257,  21313,  19633,  -3921,
 -4242,  21234,  19715,  -3939,
 -4227,  21155,  19796,  -3956,
 -4212,  21076,  19877,  -3973,
 -4197,  20997,  19957,  -3989,
 -4182,  20918,  20038,  -4006,
 -4167,  20839,  20119,  -4023,
 -4151,  20759,  20199,  -4039,
 -4136,  20680,  20280,  -4056,
 -4120,  20600,  20360,  -4072,
 -4104,  20520,  20440,  -4088,
 -4088,  20440,  20520,  -4104,
 -4072,  20360,  20600,  -4120,
 -4056,  20280,  20680,  -4136,
 -4039,  20199,  20759,  -4151,
 -4023,  20119,  20839,  -4167,
 -4006,  20038,  20918,  -4182,
 -3989,  19957,  20997,  -4197,
 -3973,  19877,  21076,  -4212,
 -3956,  19796,  21155,  -4227,
 -3939,  19715,  21234,  -4242,
 -3921,  19633,  21313,  -4257,
 -3904,  19552,  21391,  -4271,
 -3887,  19471,  21470,  -4286,
 -3869,  19389,  21548,  -4300,
 -3852,  19308,  21626,  -4314,
 -3834,  19226,  21704,  -4328,
 -3816,  19144,  21782,  -4342,
 -3798,  19062,  21860,  -4356,
 -3780,  18980,  21937,  -4369,
 -3762,  18898,  22014,  -4382,
 -3744,  18816,  22092,  -4396,
 -3726,  18734,  22169,  -4409,
 -3707,  18651,  22246,  -4422,
 -3689,  18569,  22322,  -4434,
 -3670,  18486,  22399,  -4447,
 -3651,  18403,  22475,  -4459,
 -3633,  18321,  22552,  -4472,
 -3614,  18238,  22628,  -4484,
 -3595,  18155,  22704,  -4496,
 -3576,  18072,  22779,  -4507,
 -3557,  17989,  22855,  -4519,
 -3538,  17906,  22930,  -4530,
 -3518,  17822,  23006,  -4542,
 -3499,  17739,  23081,  -4553,
 -3480,  17656,  23156,  -4564,
 -3460,  17572,  23230,  -4574,
 -3441,  17489,  23305,  -4585,
 -3421,  17405,  23379,  -4595,
 -3401,  17321,  23453,  -4605,
 -3382,  17238,  23527,  -4615,
 -3362,  17154,  23601,  -4625,
 -3342,  17070,  23675,  -4635,
 -3322,  16986,  23748,  -4644,
 -3302,  16902,  23822,  -4654,
 -3282,  16818,  23895,  -4663,
 -3262,  16734,  23968,  -4672,
 -3241,  16649,  24040,  -4680,
 -3221,  16565,  24113,  -4689,
 -3201,  16481,  24185,  -4697,
 -3180,  16396,  24257,  -4705,
 -3160,  16312,  24329,  -4713,
 -3140,  16228,  24401,  -4721,
 -3119,  16143,  24472,  -4728,
 -3098,  16058,  24544,  -4736,
 -3078,  15974,  24615,  -4743,
 -3057,  15889,  24686,  -4750,
 -3037,  15805,  24756,  -4756,
 -3016,  15720,  24827,  -4763,
 -2995,  15635,  24897,  -4769,
 -2974,  15550,  24967,  -4775,
 -2953,  15465,  25037,  -4781,
 -2932,  15380,  25107,  -4787,
 -2911,  15295,  25176,  -4792,
 -2890,  15210,  25245,  -4797,
 -2869,  15125,  25314,  -4802,
 -2848,  15040,  25383,  -4807,
 -2827,  14955,  25452,  -4812,
 -2806,  14870,  25520,  -4816,
 -2785,  14785,  25588,  -4820,
 -2764,  14700,  25656,  -4824,
 -2743,  14615,  25724,  -4828,
 -2722,  14530,  25791,  -4831,
 -2701,  14445,  25858,  -4834,
 -2679,  14359,  25925,  -4837,
 -2658,  14274,  25992,  -4840,
 -2637,  14189,  26059,  -4843,
 -2616,  14104,  26125,  -4845,
 -2594,  14018,  26191,  -4847,
 -2573,  13933,  26257,  -4849,
 -2552,  13848,  26322,  -4850,
 -2530,  13762,  26388,  -4852,
 -2509,  13677,  26453,  -4853,
 -2488,  13592,  26518,  -4854,
 -2466,  13506,  26582,  -4854,
 -2445,  13421,  26646,  -4854,
 -2424,  13336,  26711,  -4855,
 -2402,  13250,  26774,  -4854,
 -2381,  13165,  26838,  -4854,
 -2360,  13080,  26901,  -4853,
 -2338,  12994,  26964,  -4852,
 -2317,  12909,  27027,  -4851,
 -2296,  12824,  27090,  -4850,
 -2274,  12738,  27152,  -4848,
 -2253,  12653,  27214,  -4846,
 -2232,  12568,  27276,  -4844,
 -2211,  12483,  27337,  -4841,
 -2189,  12397,  27399,  -4839,
 -2168,  12312,  27460,  -4836,
 -2147,  12227,  27520,  -4832,
 -2126,  12142,  27581,  -4829,
 -2105,  12057,  27641,  -4825,
 -2083,  11971,  27701,  -4821,
 -2062,  11886,  27760,  -4816,
 -2041,  11801,  27820,  -4812,
 -2020,  11716,  27879,  -4807,
 -1999,  11631,  27938,  -4802,
 -1978,  11546,  27996,  -4796,
 -1957,  11461,  28054,  -4790,
 -1936,  11376,  28112,  -4784,
 -1915,  11291,  28170,  -4778,
 -1894,  11206,  28227,  -4771,
 -1873,  11121,  28285,  -4765,
 -1853,  11037,  28341,  -4757,
 -1832,  10952,  28398,  -4750,
 -1811,  10867,  28454,  -4742,
 -1790,  10782,  28510,  -4734,
 -1770,  10698,  28566,  -4726,
 -1749,  10613,  28621,  -4717,
 -1729,  10529,  28676,  -4708,
 -1708,  10444,  28731,  -4699,
 -1688,  10360,  28785,  -4689,
 -1667,  10275,  28839,  -4679,
 -1647,  10191,  28893,  -4669,
 -1627,  10107,  28947,  -4659,
 -1606,  10022,  29000,  -4648,
 -1586,   9938,  29053,  -4637,
 -1566,   9854,  29106,  -4626,
 -1546,   9770,  29158,  -4614,
 -1526,   9686,  29210,  -4602,
 -1506,   9602,  29262,  -4590,
 -1486,   9518,  29313,  -4577,
 -1466,   9434,  29364,  -4564,
 -1447,   9351,  29415,  -4551,
 -1427,   9267,  29465,  -4537,
 -1407,   9183,  29515,  -4523,
 -1388,   9100,  29565,  -4509,
 -1368,   9016,  29615,  -4495,
 -1349,   8933,  29664,  -4480,
 -1330,   8850,  29712,  -4464,
 -1311,   8767,  29761,  -4449,
 -1291,   8683,  29809,  -4433,
 -1272,   8600,  29857,  -4417,
 -1253,   8517,  29904,  -4400,
 -1234,   8434,  29952,  -4384,
 -1216,   8352,  29998,  -4366,
 -1197,   8269,  30045,  -4349,
 -1178,   8186,  30091,  -4331,
 -1160,   8104,  30137,  -4313,
 -1141,   8021,  30182,  -4294,
 -1123,   7939,  30227,  -4275,
 -1105,   7857,  30272,  -4256,
 -1086,   7774,  30317,  -4237,
 -1068,   7692,  30361,  -4217,
 -1050,   7610,  30404,  -4196,
 -1032,   7528,  30448,  -4176,
 -1015,   7447,  30491,  -4155,
  -997,   7365,  30533,  -4133,
  -979,   7283,  30576,  -4112,
  -962,   7202,  30618,  -4090,
  -945,   7121,  30659,  -4067,
  -927,   7039,  30701,  -4045,
  -910,   6958,  30741,  -4021,
  -893,   6877,  30782,  -3998,
  -876,   6796,  30822,  -3974,
  -860,   6716,  30862,  -3950,
  -843,   6635,  30901,  -3925,
  -826,   6554,  30940,  -3900,
  -810,   6474,  30979,  -3875,
  -793,   6393,  31017,  -3849,
  -777,   6313,  31055,  -3823,
  -761,   6233,  31093,  -3797,
  -745,   6153,  31130,  -3770,
  -729,   6073,  31167,  -3743,
  -714,   5994,  31204,  -3716,
  -698,   5914,  31240,  -3688,
  -683,   5835,  31275,  -3659,
  -667,   5755,  31311,  -3631,
  -652,   5676,  31346,  -3602,
  -637,   5597,  31380,  -3572,
  -622,   5518,  31414,  -3542,
  -607,   5439,  31448,  -3512,
  -593,   5361,  31481,  -3481,
  -578,   5282,  31514,  -3450,
  -564,   5204,  31547,  -3419,
  -550,   5126,  31579,  -3387,
  -536,   5048,  31611,  -3355,
  -522,   4970,  31642,  -3322,
  -508,   4892,  31673,  -3289,
  -494,   4814,  31704,  -3256,
  -481,   4737,  31734,  -3222,
  -468,   4660,  31764,  -3188,
  -455,   4583,  31793,  -3153,
  -442,   4506,  31822,  -3118,
  -429,   4429,  31851,  -3083,
  -416,   4352,  31879,  -3047,
  -403,   4275,  31907,  -3011,
  -391,   4199,  31934,  -2974,
  -379,   4123,  31961,  -2937,
  -367,   4047,  31988,  -2900,
  -355,   3971,  32014,  -2862,
  -343,   3895,  32040,  -2824,
  -332,   3820,  32065,  -2785,
  -320,   3744,  32090,  -2746,
  -309,   3669,  32114,  -2706,
  -298,   3594,  32138,  -2666,
  -287,   3519,  32162,  -2626,
  -277,   3445,  32185,  -2585,
  -266,   3370,  32208,  -2544,
  -256,   3296,  32230,  -2502,
  -246,   3222,  32252,  -2460,
  -236,   3148,  32273,  -2417,
  -226,   3074,  32294,  -2374,
  -216,   3000,  32315,  -2331,
  -207,   2927,  32335,  -2287,
  -198,   2854,  32355,  -2243,
  -189,   2781,  32374,  -2198,
  -180,   2708,  32393,  -2153,
  -171,   2635,  32411,  -2107,
  -163,   2563,  32429,  -2061,
  -155,   2491,  32447,  -2015,
  -147,   2419,  32464,  -1968,
  -139,   2347,  32480,  -1920,
  -131,   2275,  32497,  -1873,
  -124,   2204,  32512,  -1824,
  -116,   2132,  32528,  -1776,
  -109,   2061,  32542,  -1726,
  -103,   1991,  32557,  -1677,
   -96,   1920,  32571,  -1627,
   -89,   1849,  32584,  -1576,
   -83,   1779,  32597,  -1525,
   -77,   1709,  32609,  -1473,
   -71,   1639,  32622,  -1422,
   -66,   1570,  32633,  -1369,
   -61,   1501,  32644,  -1316,
   -55,   1431,  32655,  -1263,
   -50,   1362,  32665,  -1209,
   -46,   1294,  32675,  -1155,
   -41,   1225,  32684,  -1100,
   -37,   1157,  32693,  -1045,
   -33,   1089,  32701,   -989,
   -29,   1021,  32709,   -933,
   -26,    954,  32716,   -876,
   -22,    886,  32723,   -819,
   -19,    819,  32729,   -761,
   -16,    752,  32735,   -703,
   -13,    685,  32741,   -645,
   -11,    619,  32746,   -586,
    -9,    553,  32750,   -526,
    -7,    487,  32754,   -466,
    -5,    421,  32758,   -406,
    -4,    356,  32760,   -344,
    -3,    291,  32763,   -283,
    -2,    226,  32765,   -221,
    -1,    161,  32766,   -158,
     0,     96,  32767,    -95,
     0,     32,  32767,    -32
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc_3[] = {
   -16,    -16,    -16,
 32767,  32767,  32767,
    16,     16,     16,
     0,      0,      0,
   -48,    -48,    -48,
 32767,  32767,  32767,
    49,     49,     49,
     0,      0,      0,
   -79,    -79,    -79,
 32766,  32766,  32766,
    82,     82,     82,
     0,      0,      0,
  -110,   -110,   -110,
 32764,  32764,  32764,
   115,    115,    115,
    -1,     -1,     -1,
  -141,   -141,   -141,
 32762,  32762,  32762,
   149,    149,    149,
    -1,     -1,     -1,
  -172,   -172,   -172,
 32759,  32759,  32759,
   184,    184,    184,
    -2,     -2,     -2,
  -203,   -203,   -203,
 32755,  32755,  32755,
   218,    218,    218,
    -3,     -3,     -3,
  -233,   -233,   -233,
 32751,  32751,  32751,
   254,    254,    254,
    -3,     -3,     -3,
  -263,   -263,   -263,
 32746,  32746,  32746,
   290,    290,    290,
    -4,     -4,     -4,
  -293,   -293,   -293,
 32740,  32740,  32740,
   326,    326,    326,
    -6,     -6,     -6,
  -322,   -322,   -322,
 32734,  32734,  32734,
   363,    363,    363,
    -7,     -7,     -7,
  -352,   -352,   -352,
 32727,  32727,  32727,
   401,    401,    401,
    -8,     -8,     -8,
  -381,   -381,   -381,
 32720,  32720,  32720,
   438,    438,    438,
   -10,    -10,    -10,
  -410,   -410,   -410,
 32712,  32712,  32712,
   477,    477,    477,
   -11,    -11,    -11,
  -438,   -438,   -438,
 32703,  32703,  32703,
   515,    515,    515,
   -13,    -13,    -13,
  -466,   -466,   -466,
 32694,  32694,  32694,
   555,    555,    555,
   -15,    -15,    -15,
  -495,   -495,   -495,
 32685,  32685,  32685,
   594,    594,    594,
   -16,    -16,    -16,
  -522,   -522,   -522,
 32674,  32674,  32674,
   635,    635,    635,
   -18,    -18,    -18,
  -550,   -550,   -550,
 32663,  32663,  32663,
   675,    675,    675,
   -21,    -21,    -21,
  -577,   -577,   -577,
 32652,  32652,  32652,
   716,    716,    716,
   -23,    -23,    -23,
  -605,   -605,   -605,
 32640,  32640,  32640,
   758,    758,    758,
   -25,    -25,    -25,
  -631,   -631,   -631,
 32627,  32627,  32627,
   800,    800,    800,
   -28,    -28,    -28,
  -658,   -658,   -658,
 32614,  32614,  32614,
   842,    842,    842,
   -30,    -30,    -30,
  -685,   -685,   -685,
 32600,  32600,  32600,
   885,    885,    885,
   -33,    -33,    -33,
  -711,   -711,   -711,
 32586,  32586,  32586,
   929,    929,    929,
   -36,    -36,    -36,
  -737,   -737,   -737,
 32571,  32571,  32571,
   972,    972,    972,
   -39,    -39,    -39,
  -762,   -762,   -762,
 32555,  32555,  32555,
  1017,   1017,   1017,
   -42,    -42,    -42,
  -788,   -788,   -788,
 32539,  32539,  32539,
  1061,   1061,   1061,
   -45,    -45,    -45,
  -813,   -813,   -813,
 32523,  32523,  32523,
  1107,   1107,   1107,
   -48,    -48,    -48,
  -838,   -838,   -838,
 32505,  32505,  32505,
  1152,   1152,   1152,
   -51,    -51,    -51,
  -863,   -863,   -863,
 32488,  32488,  32488,
  1198,   1198,   1198,
   -55,    -55,    -55,
  -888,   -888,   -888,
 32469,  32469,  32469,
  1245,   1245,   1245,
   -58,    -58,    -58,
  -912,   -912,   -912,
 32450,  32450,  32450,
  1291,   1291,   1291,
   -62,    -62,    -62,
  -936,   -936,   -936,
 32431,  32431,  32431,
  1339,   1339,   1339,
   -66,    -66,    -66,
  -960,   -960,   -960,
 32411,  32411,  32411,
  1387,   1387,   1387,
   -69,    -69,    -69,
  -984,   -984,   -984,
 32391,  32391,  32391,
  1435,   1435,   1435,
   -73,    -73,    -73,
 -1007,  -1007,  -1007,
 32369,  32369,  32369,
  1483,   1483,   1483,
   -77,    -77,    -77,
 -1031,  -1031,  -1031,
 32348,  32348,  32348,
  1532,   1532,   1532,
   -81,    -81,    -81,
 -1054,  -1054,  -1054,
 32326,  32326,  32326,
  1582,   1582,   1582,
   -86,    -86,    -86,
 -1076,  -1076,  -1076,
 32303,  32303,  32303,
  1631,   1631,   1631,
   -90,    -90,    -90,
 -1099,  -1099,  -1099,
 32280,  32280,  32280,
  1682,   1682,   1682,
   -94,    -94,    -94,
 -1121,  -1121,  -1121,
 32256,  32256,  32256,
  1732,   1732,   1732,
   -99,    -99,    -99,
 -1144,  -1144,  -1144,
 32232,  32232,  32232,
  1783,   1783,   1783,
  -104,   -104,   -104,
 -1166,  -1166,  -1166,
 32207,  32207,  32207,
  1835,   1835,   1835,
  -108,   -108,   -108,
 -1187,  -1187,  -1187,
 32181,  32181,  32181,
  1887,   1887,   1887,
  -113,   -113,   -113,
 -1209,  -1209,  -1209,
 32156,  32156,  32156,
  1939,   1939,   1939,
  -118,   -118,   -118,
 -1230,  -1230,  -1230,
 32129,  32129,  32129,
  1992,   1992,   1992,
  -123,   -123,   -123,
 -1251,  -1251,  -1251,
 32102,  32102,  32102,
  2045,   2045,   2045,
  -128,   -128,   -128,
 -1272,  -1272,  -1272,
 32075,  32075,  32075,
  2098,   2098,   2098,
  -133,   -133,   -133,
 -1293,  -1293,  -1293,
 32047,  32047,  32047,
  2152,   2152,   2152,
  -138,   -138,   -138,
 -1313,  -1313,  -1313,
 32018,  32018,  32018,
  2206,   2206,   2206,
  -144,   -144,   -144,
 -1333,  -1333,  -1333,
 31989,  31989,  31989,
  2261,   2261,   2261,
  -149,   -149,   -149,
 -1353,  -1353,  -1353,
 31960,  31960,  31960,
  2316,   2316,   2316,
  -155,   -155,   -155,
 -1373,  -1373,  -1373,
 31930,  31930,  31930,
  2371,   2371,   2371,
  -160,   -160,   -160,
 -1392,  -1392,  -1392,
 31899,  31899,  31899,
  2427,   2427,   2427,
  -166,   -166,   -166,
 -1412,  -1412,  -1412,
 31868,  31868,  31868,
  2483,   2483,   2483,
  -172,   -172,   -172,
 -1431,  -1431,  -1431,
 31836,  31836,  31836,
  2540,   2540,   2540,
  -177,   -177,   -177,
 -1450,  -1450,  -1450,
 31804,  31804,  31804,
  2597,   2597,   2597,
  -183,   -183,   -183,
 -1469,  -1469,  -1469,
 31772,  31772,  31772,
  2654,   2654,   2654,
  -189,   -189,   -189,
 -1487,  -1487,  -1487,
 31739,  31739,  31739,
  2712,   2712,   2712,
  -196,   -196,   -196,
 -1506,  -1506,  -1506,
 31705,  31705,  31705,
  2770,   2770,   2770,
  -202,   -202,   -202,
 -1524,  -1524,  -1524,
 31671,  31671,  31671,
  2828,   2828,   2828,
  -208,   -208,   -208,
 -1542,  -1542,  -1542,
 31637,  31637,  31637,
  2887,   2887,   2887,
  -214,   -214,   -214,
 -1559,  -1559,  -1559,
 31602,  31602,  31602,
  2946,   2946,   2946,
  -221,   -221,   -221,
 -1577,  -1577,  -1577,
 31566,  31566,  31566,
  3006,   3006,   3006,
  -227,   -227,   -227,
 -1594,  -1594,  -1594,
 31530,  31530,  31530,
  3066,   3066,   3066,
  -234,   -234,   -234,
 -1611,  -1611,  -1611,
 31494,  31494,  31494,
  3126,   3126,   3126,
  -240,   -240,   -240,
 -1628,  -1628,  -1628,
 31457,  31457,  31457,
  3186,   3186,   3186,
  -247,   -247,   -247,
 -1645,  -1645,  -1645,
 31419,  31419,  31419,
  3247,   3247,   3247,
  -254,   -254,   -254,
 -1661,  -1661,  -1661,
 31381,  31381,  31381,
  3309,   3309,   3309,
  -261,   -261,   -261,
 -1677,  -1677,  -1677,
 31343,  31343,  31343,
  3370,   3370,   3370,
  -268,   -268,   -268,
 -1694,  -1694,  -1694,
 31304,  31304,  31304,
  3432,   3432,   3432,
  -275,   -275,   -275,
 -1709,  -1709,  -1709,
 31265,  31265,  31265,
  3495,   3495,   3495,
  -282,   -282,   -282,
 -1725,  -1725,  -1725,
 31225,  31225,  31225,
  3557,   3557,   3557,
  -289,   -289,   -289,
 -1741,  -1741,  -1741,
 31185,  31185,  31185,
  3620,   3620,   3620,
  -296,   -296,   -296,
 -1756,  -1756,  -1756,
 31144,  31144,  31144,
  3683,   3683,   3683,
  -304,   -304,   -304,
 -1771,  -1771,  -1771,
 31103,  31103,  31103,
  3747,   3747,   3747,
  -311,   -311,   -311,
 -1786,  -1786,  -1786,
 31062,  31062,  31062,
  3811,   3811,   3811,
  -319,   -319,   -319,
 -1801,  -1801,  -1801,
 31019,  31019,  31019,
  3875,   3875,   3875,
  -326,   -326,   -326,
 -1815,  -1815,  -1815,
 30977,  30977,  30977,
  3940,   3940,   3940,
  -334,   -334,   -334,
 -1830,  -1830,  -1830,
 30934,  30934,  30934,
  4005,   4005,   4005,
  -341,   -341,   -341,
 -1844,  -1844,  -1844,
 30891,  30891,  30891,
  4070,   4070,   4070,
  -349,   -349,   -349,
 -1858,  -1858,  -1858,
 30847,  30847,  30847,
  4136,   4136,   4136,
  -357,   -357,   -357,
 -1872,  -1872,  -1872,
 30802,  30802,  30802,
  4202,   4202,   4202,
  -365,   -365,   -365,
 -1885,  -1885,  -1885,
 30758,  30758,  30758,
  4268,   4268,   4268,
  -373,   -373,   -373,
 -1899,  -1899,  -1899,
 30712,  30712,  30712,
  4335,   4335,   4335,
  -381,   -381,   -381,
 -1912,  -1912,  -1912,
 30667,  30667,  30667,
  4402,   4402,   4402,
  -389,   -389,   -389,
 -1925,  -1925,  -1925,
 30621,  30621,  30621,
  4469,   4469,   4469,
  -397,   -397,   -397,
 -1938,  -1938,  -1938,
 30574,  30574,  30574,
  4536,   4536,   4536,
  -405,   -405,   -405,
 -1950,  -1950,  -1950,
 30527,  30527,  30527,
  4604,   4604,   4604,
  -413,   -413,   -413,
 -1963,  -1963,  -1963,
 30480,  30480,  30480,
  4672,   4672,   4672,
  -421,   -421,   -421,
 -1975,  -1975,  -1975,
 30432,  30432,  30432,
  4741,   4741,   4741,
  -430,   -430,   -430,
 -1987,  -1987,  -1987,
 30384,  30384,  30384,
  4809,   4809,   4809,
  -438,   -438,   -438,
 -1999,  -1999,  -1999,
 30335,  30335,  30335,
  4878,   4878,   4878,
  -447,   -447,   -447,
 -2011,  -2011,  -2011,
 30286,  30286,  30286,
  4948,   4948,   4948,
  -455,   -455,   -455,
 -2022,  -2022,  -2022,
 30237,  30237,  30237,
  5017,   5017,   5017,
  -464,   -464,   -464,
 -2034,  -2034,  -2034,
 30187,  30187,  30187,
  5087,   5087,   5087,
  -472,   -472,   -472,
 -2045,  -2045,  -2045,
 30137,  30137,  30137,
  5157,   5157,   5157,
  -481,   -481,   -481,
 -2056,  -2056,  -2056,
 30086,  30086,  30086,
  5228,   5228,   5228,
  -490,   -490,   -490,
 -2067,  -2067,  -2067,
 30035,  30035,  30035,
  5298,   5298,   5298,
  -499,   -499,   -499,
 -2077,  -2077,  -2077,
 29983,  29983,  29983,
  5369,   5369,   5369,
  -507,   -507,   -507,
 -2088,  -2088,  -2088,
 29931,  29931,  29931,
  5441,   5441,   5441,
  -516,   -516,   -516,
 -2098,  -2098,  -2098,
 29879,  29879,  29879,
  5512,   5512,   5512,
  -525,   -525,   -525,
 -2108,  -2108,  -2108,
 29826,  29826,  29826,
  5584,   5584,   5584,
  -534,   -534,   -534,
 -2118,  -2118,  -2118,
 29773,  29773,  29773,
  5656,   5656,   5656,
  -543,   -543,   -543,
 -2128,  -2128,  -2128,
 29720,  29720,  29720,
  5729,   5729,   5729,
  -552,   -552,   -552,
 -2138,  -2138,  -2138,
 29666,  29666,  29666,
  5801,   5801,   5801,
  -561,   -561,   -561,
 -2147,  -2147,  -2147,
 29612,  29612,  29612,
  5874,   5874,   5874,
  -571,   -571,   -571,
 -2156,  -2156,  -2156,
 29557,  29557,  29557,
  5947,   5947,   5947,
  -580,   -580,   -580,
 -2165,  -2165,  -2165,
 29502,  29502,  29502,
  6021,   6021,   6021,
  -589,   -589,   -589,
 -2174,  -2174,  -2174,
 29446,  29446,  29446,
  6094,   6094,   6094,
  -598,   -598,   -598,
 -2183,  -2183,  -2183,
 29391,  29391,  29391,
  6168,   6168,   6168,
  -608,   -608,   -608,
 -2192,  -2192,  -2192,
 29334,  29334,  29334,
  6243,   6243,   6243,
  -617,   -617,   -617,
 -2200,  -2200,  -2200,
 29278,  29278,  29278,
  6317,   6317,   6317,
  -627,   -627,   -627,
 -2208,  -2208,  -2208,
 29221,  29221,  29221,
  6392,   6392,   6392,
  -636,   -636,   -636,
 -2217,  -2217,  -2217,
 29163,  29163,  29163,
  6467,   6467,   6467,
  -646,   -646,   -646,
 -2224,  -2224,  -2224,
 29106,  29106,  29106,
  6542,   6542,   6542,
  -655,   -655,   -655,
 -2232,  -2232,  -2232,
 29048,  29048,  29048,
  6617,   6617,   6617,
  -665,   -665,   -665,
 -2240,  -2240,  -2240,
 28989,  28989,  28989,
  6693,   6693,   6693,
  -675,   -675,   -675,
 -2247,  -2247,  -2247,
 28930,  28930,  28930,
  6769,   6769,   6769,
  -684,   -684,   -684,
 -2255,  -2255,  -2255,
 28871,  28871,  28871,
  6845,   6845,   6845,
  -694,   -694,   -694,
 -2262,  -2262,  -2262,
 28812,  28812,  28812,
  6922,   6922,   6922,
  -704,   -704,   -704,
 -2269,  -2269,  -2269,
 28752,  28752,  28752,
  6998,   6998,   6998,
  -713,   -713,   -713,
 -2275,  -2275,  -2275,
 28691,  28691,  28691,
  7075,   7075,   7075,
  -723,   -723,   -723,
 -2282,  -2282,  -2282,
 28631,  28631,  28631,
  7152,   7152,   7152,
  -733,   -733,   -733,
 -2289,  -2289,  -2289,
 28570,  28570,  28570,
  7230,   7230,   7230,
  -743,   -743,   -743,
 -2295,  -2295,  -2295,
 28509,  28509,  28509,
  7307,   7307,   7307,
  -753,   -753,   -753,
 -2301,  -2301,  -2301,
 28447,  28447,  28447,
  7385,   7385,   7385,
  -763,   -763,   -763,
 -2307,  -2307,  -2307,
 28385,  28385,  28385,
  7463,   7463,   7463,
  -773,   -773,   -773,
 -2313,  -2313,  -2313,
 28323,  28323,  28323,
  7541,   7541,   7541,
  -783,   -783,   -783,
 -2319,  -2319,  -2319,
 28260,  28260,  28260,
  7620,   7620,   7620,
  -793,   -793,   -793,
 -2324,  -2324,  -2324,
 28197,  28197,  28197,
  7698,   7698,   7698,
  -803,   -803,   -803,
 -2329,  -2329,  -2329,
 28134,  28134,  28134,
  7777,   7777,   7777,
  -813,   -813,   -813,
 -2335,  -2335,  -2335,
 28070,  28070,  28070,
  7856,   7856,   7856,
  -823,   -823,   -823,
 -2340,  -2340,  -2340,
 28006,  28006,  28006,
  7936,   7936,   7936,
  -834,   -834,   -834,
 -2345,  -2345,  -2345,
 27941,  27941,  27941,
  8015,   8015,   8015,
  -844,   -844,   -844,
 -2349,  -2349,  -2349,
 27877,  27877,  27877,
  8095,   8095,   8095,
  -854,   -854,   -854,
 -2354,  -2354,  -2354,
 27812,  27812,  27812,
  8175,   8175,   8175,
  -864,   -864,   -864,
 -2359,  -2359,  -2359,
 27746,  27746,  27746,
  8255,   8255,   8255,
  -875,   -875,   -875,
 -2363,  -2363,  -2363,
 27681,  27681,  27681,
  8335,   8335,   8335,
  -885,   -885,   -885,
 -2367,  -2367,  -2367,
 27615,  27615,  27615,
  8415,   8415,   8415,
  -895,   -895,   -895,
 -2371,  -2371,  -2371,
 27549,  27549,  27549,
  8496,   8496,   8496,
  -906,   -906,   -906,
 -2375,  -2375,  -2375,
 27482,  27482,  27482,
  8577,   8577,   8577,
  -916,   -916,   -916,
 -2379,  -2379,  -2379,
 27415,  27415,  27415,
  8658,   8658,   8658,
  -926,   -926,   -926,
 -2382,  -2382,  -2382,
 27348,  27348,  27348,
  8739,   8739,   8739,
  -937,   -937,   -937,
 -2386,  -2386,  -2386,
 27280,  27280,  27280,
  8821,   8821,   8821,
  -947,   -947,   -947,
 -2389,  -2389,  -2389,
 27212,  27212,  27212,
  8902,   8902,   8902,
  -958,   -958,   -958,
 -2392,  -2392,  -2392,
 27144,  27144,  27144,
  8984,   8984,   8984,
  -968,   -968,   -968,
 -2395,  -2395,  -2395,
 27076,  27076,  27076,
  9066,   9066,   9066,
  -979,   -979,   -979,
 -2398,  -2398,  -2398,
 27007,  27007,  27007,
  9148,   9148,   9148,
  -989,   -989,   -989,
 -2401,  -2401,  -2401,
 26938,  26938,  26938,
  9230,   9230,   9230,
 -1000,  -1000,  -1000,
 -2403,  -2403,  -2403,
 26869,  26869,  26869,
  9313,   9313,   9313,
 -1010,  -1010,  -1010,
 -2406,  -2406,  -2406,
 26799,  26799,  26799,
  9395,   9395,   9395,
 -1021,  -1021,  -1021,
 -2408,  -2408,  -2408,
 26729,  26729,  26729,
  9478,   9478,   9478,
 -1031,  -1031,  -1031,
 -2410,  -2410,  -2410,
 26659,  26659,  26659,
  9561,   9561,   9561,
 -1042,  -1042,  -1042,
 -2412,  -2412,  -2412,
 26589,  26589,  26589,
  9644,   9644,   9644,
 -1052,  -1052,  -1052,
 -2414,  -2414,  -2414,
 26518,  26518,  26518,
  9727,   9727,   9727,
 -1063,  -1063,  -1063,
 -2416,  -2416,  -2416,
 26447,  26447,  26447,
  9811,   9811,   9811,
 -1073,  -1073,  -1073,
 -2418,  -2418,  -2418,
 26376,  26376,  26376,
  9894,   9894,   9894,
 -1084,  -1084,  -1084,
 -2419,  -2419,  -2419,
 26304,  26304,  26304,
  9978,   9978,   9978,
 -1095,  -1095,  -1095,
 -2421,  -2421,  -2421,
 26232,  26232,  26232,
 10062,  10062,  10062,
 -1105,  -1105,  -1105,
 -2422,  -2422,  -2422,
 26160,  26160,  26160,
 10146,  10146,  10146,
 -1116,  -1116,  -1116,
 -2423,  -2423,  -2423,
 26087,  26087,  26087,
 10230,  10230,  10230,
 -1127,  -1127,  -1127,
 -2424,  -2424,  -2424,
 26015,  26015,  26015,
 10314,  10314,  10314,
 -1137,  -1137,  -1137,
 -2425,  -2425,  -2425,
 25942,  25942,  25942,
 10399,  10399,  10399,
 -1148,  -1148,  -1148,
 -2426,  -2426,  -2426,
 25869,  25869,  25869,
 10483,  10483,  10483,
 -1159,  -1159,  -1159,
 -2426,  -2426,  -2426,
 25795,  25795,  25795,
 10568,  10568,  10568,
 -1169,  -1169,  -1169,
 -2427,  -2427,  -2427,
 25721,  25721,  25721,
 10653,  10653,  10653,
 -1180,  -1180,  -1180,
 -2427,  -2427,  -2427,
 25647,  25647,  25647,
 10738,  10738,  10738,
 -1191,  -1191,  -1191,
 -2427,  -2427,  -2427,
 25573,  25573,  25573,
 10823,  10823,  10823,
 -1201,  -1201,  -1201,
 -2427,  -2427,  -2427,
 25499,  25499,  25499,
 10908,  10908,  10908,
 -1212,  -1212,  -1212,
 -2427,  -2427,  -2427,
 25424,  25424,  25424,
 10994,  10994,  10994,
 -1223,  -1223,  -1223,
 -2427,  -2427,  -2427,
 25349,  25349,  25349,
 11079,  11079,  11079,
 -1233,  -1233,  -1233,
 -2427,  -2427,  -2427,
 25274,  25274,  25274,
 11165,  11165,  11165,
 -1244,  -1244,  -1244,
 -2426,  -2426,  -2426,
 25198,  25198,  25198,
 11251,  11251,  11251,
 -1255,  -1255,  -1255,
 -2426,  -2426,  -2426,
 25122,  25122,  25122,
 11337,  11337,  11337,
 -1265,  -1265,  -1265,
 -2425,  -2425,  -2425,
 25046,  25046,  25046,
 11422,  11422,  11422,
 -1276,  -1276,  -1276,
 -2424,  -2424,  -2424,
 24970,  24970,  24970,
 11509,  11509,  11509,
 -1286,  -1286,  -1286,
 -2423,  -2423,  -2423,
 24894,  24894,  24894,
 11595,  11595,  11595,
 -1297,  -1297,  -1297,
 -2422,  -2422,  -2422,
 24817,  24817,  24817,
 11681,  11681,  11681,
 -1308,  -1308,  -1308,
 -2421,  -2421,  -2421,
 24740,  24740,  24740,
 11767,  11767,  11767,
 -1318,  -1318,  -1318,
 -2420,  -2420,  -2420,
 24663,  24663,  24663,
 11854,  11854,  11854,
 -1329,  -1329,  -1329,
 -2419,  -2419,  -2419,
 24586,  24586,  24586,
 11941,  11941,  11941,
 -1340,  -1340,  -1340,
 -2417,  -2417,  -2417,
 24508,  24508,  24508,
 12027,  12027,  12027,
 -1350,  -1350,  -1350,
 -2416,  -2416,  -2416,
 24430,  24430,  24430,
 12114,  12114,  12114,
 -1361,  -1361,  -1361,
 -2414,  -2414,  -2414,
 24352,  24352,  24352,
 12201,  12201,  12201,
 -1371,  -1371,  -1371,
 -2412,  -2412,  -2412,
 24274,  24274,  24274,
 12288,  12288,  12288,
 -1382,  -1382,  -1382,
 -2410,  -2410,  -2410,
 24196,  24196,  24196,
 12375,  12375,  12375,
 -1393,  -1393,  -1393,
 -2408,  -2408,  -2408,
 24117,  24117,  24117,
 12462,  12462,  12462,
 -1403,  -1403,  -1403,
 -2406,  -2406,  -2406,
 24038,  24038,  24038,
 12549,  12549,  12549,
 -1414,  -1414,  -1414,
 -2404,  -2404,  -2404,
 23959,  23959,  23959,
 12637,  12637,  12637,
 -1424,  -1424,  -1424,
 -2401,  -2401,  -2401,
 23880,  23880,  23880,
 12724,  12724,  12724,
 -1435,  -1435,  -1435,
 -2399,  -2399,  -2399,
 23800,  23800,  23800,
 12812,  12812,  12812,
 -1445,  -1445,  -1445,
 -2396,  -2396,  -2396,
 23721,  23721,  23721,
 12899,  12899,  12899,
 -1456,  -1456,  -1456,
 -2393,  -2393,  -2393,
 23641,  23641,  23641,
 12987,  12987,  12987,
 -1466,  -1466,  -1466,
 -2391,  -2391,  -2391,
 23561,  23561,  23561,
 13075,  13075,  13075,
 -1477,  -1477,  -1477,
 -2388,  -2388,  -2388,
 23480,  23480,  23480,
 13163,  13163,  13163,
 -1487,  -1487,  -1487,
 -2385,  -2385,  -2385,
 23400,  23400,  23400,
 13250,  13250,  13250,
 -1497,  -1497,  -1497,
 -2381,  -2381,  -2381,
 23319,  23319,  23319,
 13338,  13338,  13338,
 -1508,  -1508,  -1508,
 -2378,  -2378,  -2378,
 23238,  23238,  23238,
 13426,  13426,  13426,
 -1518,  -1518,  -1518,
 -2375,  -2375,  -2375,
 23157,  23157,  23157,
 13514,  13514,  13514,
 -1529,  -1529,  -1529,
 -2371,  -2371,  -2371,
 23076,  23076,  23076,
 13602,  13602,  13602,
 -1539,  -1539,  -1539,
 -2368,  -2368,  -2368,
 22994,  22994,  22994,
 13691,  13691,  13691,
 -1549,  -1549,  -1549,
 -2364,  -2364,  -2364,
 22913,  22913,  22913,
 13779,  13779,  13779,
 -1560,  -1560,  -1560,
 -2360,  -2360,  -2360,
 22831,  22831,  22831,
 13867,  13867,  13867,
 -1570,  -1570,  -1570,
 -2357,  -2357,  -2357,
 22749,  22749,  22749,
 13955,  13955,  13955,
 -1580,  -1580,  -1580,
 -2353,  -2353,  -2353,
 22667,  22667,  22667,
 14044,  14044,  14044,
 -1590,  -1590,  -1590,
 -2349,  -2349,  -2349,
 22585,  22585,  22585,
 14132,  14132,  14132,
 -1600,  -1600,  -1600,
 -2344,  -2344,  -2344,
 22502,  22502,  22502,
 14221,  14221,  14221,
 -1611,  -1611,  -1611,
 -2340,  -2340,  -2340,
 22420,  22420,  22420,
 14309,  14309,  14309,
 -1621,  -1621,  -1621,
 -2336,  -2336,  -2336,
 22337,  22337,  22337,
 14398,  14398,  14398,
 -1631,  -1631,  -1631,
 -2331,  -2331,  -2331,
 22254,  22254,  22254,
 14486,  14486,  14486,
 -1641,  -1641,  -1641,
 -2327,  -2327,  -2327,
 22171,  22171,  22171,
 14575,  14575,  14575,
 -1651,  -1651,  -1651,
 -2322,  -2322,  -2322,
 22087,  22087,  22087,
 14664,  14664,  14664,
 -1661,  -1661,  -1661,
 -2317,  -2317,  -2317,
 22004,  22004,  22004,
 14752,  14752,  14752,
 -1671,  -1671,  -1671,
 -2313,  -2313,  -2313,
 21920,  21920,  21920,
 14841,  14841,  14841,
 -1681,  -1681,  -1681,
 -2308,  -2308,  -2308,
 21837,  21837,  21837,
 14930,  14930,  14930,
 -1691,  -1691,  -1691,
 -2303,  -2303,  -2303,
 21753,  21753,  21753,
 15019,  15019,  15019,
 -1701,  -1701,  -1701,
 -2298,  -2298,  -2298,
 21669,  21669,  21669,
 15107,  15107,  15107,
 -1710,  -1710,  -1710,
 -2292,  -2292,  -2292,
 21585,  21585,  21585,
 15196,  15196,  15196,
 -1720,  -1720,  -1720,
 -2287,  -2287,  -2287,
 21500,  21500,  21500,
 15285,  15285,  15285,
 -1730,  -1730,  -1730,
 -2282,  -2282,  -2282,
 21416,  21416,  21416,
 15374,  15374,  15374,
 -1740,  -1740,  -1740,
 -2276,  -2276,  -2276,
 21331,  21331,  21331,
 15463,  15463,  15463,
 -1750,  -1750,  -1750,
 -2271,  -2271,  -2271,
 21246,  21246,  21246,
 15552,  15552,  15552,
 -1759,  -1759,  -1759,
 -2265,  -2265,  -2265,
 21162,  21162,  21162,
 15640,  15640,  15640,
 -1769,  -1769,  -1769,
 -2259,  -2259,  -2259,
 21077,  21077,  21077,
 15729,  15729,  15729,
 -1778,  -1778,  -1778,
 -2254,  -2254,  -2254,
 20991,  20991,  20991,
 15818,  15818,  15818,
 -1788,  -1788,  -1788,
 -2248,  -2248,  -2248,
 20906,  20906,  20906,
 15907,  15907,  15907,
 -1797,  -1797,  -1797,
 -2242,  -2242,  -2242,
 20821,  20821,  20821,
 15996,  15996,  15996,
 -1807,  -1807,  -1807,
 -2236,  -2236,  -2236,
 20735,  20735,  20735,
 16085,  16085,  16085,
 -1816,  -1816,  -1816,
 -2230,  -2230,  -2230,
 20650,  20650,  20650,
 16174,  16174,  16174,
 -1826,  -1826,  -1826,
 -2223,  -2223,  -2223,
 20564,  20564,  20564,
 16263,  16263,  16263,
 -1835,  -1835,  -1835,
 -2217,  -2217,  -2217,
 20478,  20478,  20478,
 16351,  16351,  16351,
 -1844,  -1844,  -1844,
 -2211,  -2211,  -2211,
 20392,  20392,  20392,
 16440,  16440,  16440,
 -1854,  -1854,  -1854,
 -2204,  -2204,  -2204,
 20306,  20306,  20306,
 16529,  16529,  16529,
 -1863,  -1863,  -1863,
 -2198,  -2198,  -2198,
 20220,  20220,  20220,
 16618,  16618,  16618,
 -1872,  -1872,  -1872,
 -2191,  -2191,  -2191,
 20133,  20133,  20133,
 16707,  16707,  16707,
 -1881,  -1881,  -1881,
 -2185,  -2185,  -2185,
 20047,  20047,  20047,
 16796,  16796,  16796,
 -1890,  -1890,  -1890,
 -2178,  -2178,  -2178,
 19960,  19960,  19960,
 16884,  16884,  16884,
 -1899,  -1899,  -1899,
 -2171,  -2171,  -2171,
 19874,  19874,  19874,
 16973,  16973,  16973,
 -1908,  -1908,  -1908,
 -2164,  -2164,  -2164,
 19787,  19787,  19787,
 17062,  17062,  17062,
 -1917,  -1917,  -1917,
 -2157,  -2157,  -2157,
 19700,  19700,  19700,
 17151,  17151,  17151,
 -1926,  -1926,  -1926,
 -2150,  -2150,  -2150,
 19613,  19613,  19613,
 17239,  17239,  17239,
 -1935,  -1935,  -1935,
 -2143,  -2143,  -2143,
 19526,  19526,  19526,
 17328,  17328,  17328,
 -1943,  -1943,  -1943,
 -2136,  -2136,  -2136,
 19439,  19439,  19439,
 17416,  17416,  17416,
 -1952,  -1952,  -1952,
 -2128,  -2128,  -2128,
 19352,  19352,  19352,
 17505,  17505,  17505,
 -1961,  -1961,  -1961,
 -2121,  -2121,  -2121,
 19265,  19265,  19265,
 17593,  17593,  17593,
 -1969,  -1969,  -1969,
 -2114,  -2114,  -2114,
 19178,  19178,  19178,
 17682,  17682,  17682,
 -1978,  -1978,  -1978,
 -2106,  -2106,  -2106,
 19090,  19090,  19090,
 17770,  17770,  17770,
 -1986,  -1986,  -1986,
 -2099,  -2099,  -2099,
 19003,  19003,  19003,
 17859,  17859,  17859,
 -1995,  -1995,  -1995,
 -2091,  -2091,  -2091,
 18915,  18915,  18915,
 17947,  17947,  17947,
 -2003,  -2003,  -2003,
 -2083,  -2083,  -2083,
 18827,  18827,  18827,
 18035,  18035,  18035,
 -2011,  -2011,  -2011,
 -2076,  -2076,  -2076,
 18740,  18740,  18740,
 18124,  18124,  18124,
 -2020,  -2020,  -2020,
 -2068,  -2068,  -2068,
 18652,  18652,  18652,
 18212,  18212,  18212,
 -2028,  -2028,  -2028,
 -2060,  -2060,  -2060,
 18564,  18564,  18564,
 18300,  18300,  18300,
 -2036,  -2036,  -2036,
 -2052,  -2052,  -2052,
 18476,  18476,  18476,
 18388,  18388,  18388,
 -2044,  -2044,  -2044,
 -2044,  -2044,  -2044,
 18388,  18388,  18388,
 18476,  18476,  18476,
 -2052,  -2052,  -2052,
 -2036,  -2036,  -2036,
 18300,  18300,  18300,
 18564,  18564,  18564,
 -2060,  -2060,  -2060,
 -2028,  -2028,  -2028,
 18212,  18212,  18212,
 18652,  18652,  18652,
 -2068,  -2068,  -2068,
 -2020,  -2020,  -2020,
 18124,  18124,  18124,
 18740,  18740,  18740,
 -2076,  -2076,  -2076,
 -2011,  -2011,  -2011,
 18035,  18035,  18035,
 18827,  18827,  18827,
 -2083,  -2083,  -2083,
 -2003,  -2003,  -2003,
 17947,  17947,  17947,
 18915,  18915,  18915,
 -2091,  -2091,  -2091,
 -1995,  -1995,  -1995,
 17859,  17859,  17859,
 19003,  19003,  19003,
 -2099,  -2099,  -2099,
 -1986,  -1986,  -1986,
 17770,  17770,  17770,
 19090,  19090,  19090,
 -2106,  -2106,  -2106,
 -1978,  -1978,  -1978,
 17682,  17682,  17682,
 19178,  19178,  19178,
 -2114,  -2114,  -2114,
 -1969,  -1969,  -1969,
 17593,  17593,  17593,
 19265,  19265,  19265,
 -2121,  -2121,  -2121,
 -1961,  -1961,  -1961,
 17505,  17505,  17505,
 19352,  19352,  19352,
 -2128,  -2128,  -2128,
 -1952,  -1952,  -1952,
 17416,  17416,  17416,
 19439,  19439,  19439,
 -2136,  -2136,  -2136,
 -1943,  -1943,  -1943,
 17328,  17328,  17328,
 19526,  19526,  19526,
 -2143,  -2143,  -2143,
 -1935,  -1935,  -1935,
 17239,  17239,  17239,
 19613,  19613,  19613,
 -2150,  -2150,  -2150,
 -1926,  -1926,  -1926,
 17151,  17151,  17151,
 19700,  19700,  19700,
 -2157,  -2157,  -2157,
 -1917,  -1917,  -1917,
 17062,  17062,  17062,
 19787,  19787,  19787,
 -2164,  -2164,  -2164,
 -1908,  -1908,  -1908,
 16973,  16973,  16973,
 19874,  19874,  19874,
 -2171,  -2171,  -2171,
 -1899,  -1899,  -1899,
 16884,  16884,  16884,
 19960,  19960,  19960,
 -2178,  -2178,  -2178,
 -1890,  -1890,  -1890,
 16796,  16796,  16796,
 20047,  20047,  20047,
 -2185,  -2185,  -2185,
 -1881,  -1881,  -1881,
 16707,  16707,  16707,
 20133,  20133,  20133,
 -2191,  -2191,  -2191,
 -1872,  -1872,  -1872,
 16618,  16618,  16618,
 20220,  20220,  20220,
 -2198,  -2198,  -2198,
 -1863,  -1863,  -1863,
 16529,  16529,  16529,
 20306,  20306,  20306,
 -2204,  -2204,  -2204,
 -1854,  -1854,  -1854,
 16440,  16440,  16440,
 20392,  20392,  20392,
 -2211,  -2211,  -2211,
 -1844,  -1844,  -1844,
 16351,  16351,  16351,
 20478,  20478,  20478,
 -2217,  -2217,  -2217,
 -1835,  -1835,  -1835,
 16263,  16263,  16263,
 20564,  20564,  20564,
 -2223,  -2223,  -2223,
 -1826,  -1826,  -1826,
 16174,  16174,  16174,
 20650,  20650,  20650,
 -2230,  -2230,  -2230,
 -1816,  -1816,  -1816,
 16085,  16085,  16085,
 20735,  20735,  20735,
 -2236,  -2236,  -2236,
 -1807,  -1807,  -1807,
 15996,  15996,  15996,
 20821,  20821,  20821,
 -2242,  -2242,  -2242,
 -1797,  -1797,  -1797,
 15907,  15907,  15907,
 20906,  20906,  20906,
 -2248,  -2248,  -2248,
 -1788,  -1788,  -1788,
 15818,  15818,  15818,
 20991,  20991,  20991,
 -2254,  -2254,  -2254,
 -1778,  -1778,  -1778,
 15729,  15729,  15729,
 21077,  21077,  21077,
 -2259,  -2259,  -2259,
 -1769,  -1769,  -1769,
 15640,  15640,  15640,
 21162,  21162,  21162,
 -2265,  -2265,  -2265,
 -1759,  -1759,  -1759,
 15552,  15552,  15552,
 21246,  21246,  21246,
 -2271,  -2271,  -2271,
 -1750,  -1750,  -1750,
 15463,  15463,  15463,
 21331,  21331,  21331,
 -2276,  -2276,  -2276,
 -1740,  -1740,  -1740,
 15374,  15374,  15374,
 21416,  21416,  21416,
 -2282,  -2282,  -2282,
 -1730,  -1730,  -1730,
 15285,  15285,  15285,
 21500,  21500,  21500,
 -2287,  -2287,  -2287,
 -1720,  -1720,  -1720,
 15196,  15196,  15196,
 21585,  21585,  21585,
 -2292,  -2292,  -2292,
 -1710,  -1710,  -1710,
 15107,  15107,  15107,
 21669,  21669,  21669,
 -2298,  -2298,  -2298,
 -1701,  -1701,  -1701,
 15019,  15019,  15019,
 21753,  21753,  21753,
 -2303,  -2303,  -2303,
 -1691,  -1691,  -1691,
 14930,  14930,  14930,
 21837,  21837,  21837,
 -2308,  -2308,  -2308,
 -1681,  -1681,  -1681,
 14841,  14841,  14841,
 21920,  21920,  21920,
 -2313,  -2313,  -2313,
 -1671,  -1671,  -1671,
 14752,  14752,  14752,
 22004,  22004,  22004,
 -2317,  -2317,  -2317,
 -1661,  -1661,  -1661,
 14664,  14664,  14664,
 22087,  22087,  22087,
 -2322,  -2322,  -2322,
 -1651,  -1651,  -1651,
 14575,  14575,  14575,
 22171,  22171,  22171,
 -2327,  -2327,  -2327,
 -1641,  -1641,  -1641,
 14486,  14486,  14486,
 22254,  22254,  22254,
 -2331,  -2331,  -2331,
 -1631,  -1631,  -1631,
 14398,  14398,  14398,
 22337,  22337,  22337,
 -2336,  -2336,  -2336,
 -1621,  -1621,  -1621,
 14309,  14309,  14309,
 22420,  22420,  22420,
 -2340,  -2340,  -2340,
 -1611,  -1611,  -1611,
 14221,  14221,  14221,
 22502,  22502,  22502,
 -2344,  -2344,  -2344,
 -1600,  -1600,  -1600,
 14132,  14132,  14132,
 22585,  22585,  22585,
 -2349,  -2349,  -2349,
 -1590,  -1590,  -1590,
 14044,  14044,  14044,
 22667,  22667,  22667,
 -2353,  -2353,  -2353,
 -1580,  -1580,  -1580,
 13955,  13955,  13955,
 22749,  22749,  22749,
 -2357,  -2357,  -2357,
 -1570,  -1570,  -1570,
 13867,  13867,  13867,
 22831,  22831,  22831,
 -2360,  -2360,  -2360,
 -1560,  -1560,  -1560,
 13779,  13779,  13779,
 22913,  22913,  22913,
 -2364,  -2364,  -2364,
 -1549,  -1549,  -1549,
 13691,  13691,  13691,
 22994,  22994,  22994,
 -2368,  -2368,  -2368,
 -1539,  -1539,  -1539,
 13602,  13602,  13602,
 23076,  23076,  23076,
 -2371,  -2371,  -2371,
 -1529,  -1529,  -1529,
 13514,  13514,  13514,
 23157,  23157,  23157,
 -2375,  -2375,  -2375,
 -1518,  -1518,  -1518,
 13426,  13426,  13426,
 23238,  23238,  23238,
 -2378,  -2378,  -2378,
 -1508,  -1508,  -1508,
 13338,  13338,  13338,
 23319,  23319,  23319,
 -2381,  -2381,  -2381,
 -1497,  -1497,  -1497,
 13250,  13250,  13250,
 23400,  23400,  23400,
 -2385,  -2385,  -2385,
 -1487,  -1487,  -1487,
 13163,  13163,  13163,
 23480,  23480,  23480,
 -2388,  -2388,  -2388,
 -1477,  -1477,  -1477,
 13075,  13075,  13075,
 23561,  23561,  23561,
 -2391,  -2391,  -2391,
 -1466,  -1466,  -1466,
 12987,  12987,  12987,
 23641,  23641,  23641,
 -2393,  -2393,  -2393,
 -1456,  -1456,  -1456,
 12899,  12899,  12899,
 23721,  23721,  23721,
 -2396,  -2396,  -2396,
 -1445,  -1445,  -1445,
 12812,  12812,  12812,
 23800,  23800,  23800,
 -2399,  -2399,  -2399,
 -1435,  -1435,  -1435,
 12724,  12724,  12724,
 23880,  23880,  23880,
 -2401,  -2401,  -2401,
 -1424,  -1424,  -1424,
 12637,  12637,  12637,
 23959,  23959,  23959,
 -2404,  -2404,  -2404,
 -1414,  -1414,  -1414,
 12549,  12549,  12549,
 24038,  24038,  24038,
 -2406,  -2406,  -2406,
 -1403,  -1403,  -1403,
 12462,  12462,  12462,
 24117,  24117,  24117,
 -2408,  -2408,  -2408,
 -1393,  -1393,  -1393,
 12375,  12375,  12375,
 24196,  24196,  24196,
 -2410,  -2410,  -2410,
 -1382,  -1382,  -1382,
 12288,  12288,  12288,
 24274,  24274,  24274,
 -2412,  -2412,  -2412,
 -1371,  -1371,  -1371,
 12201,  12201,  12201,
 24352,  24352,  24352,
 -2414,  -2414,  -2414,
 -1361,  -1361,  -1361,
 12114,  12114,  12114,
 24430,  24430,  24430,
 -2416,  -2416,  -2416,
 -1350,  -1350,  -1350,
 12027,  12027,  12027,
 24508,  24508,  24508,
 -2417,  -2417,  -2417,
 -1340,  -1340,  -1340,
 11941,  11941,  11941,
 24586,  24586,  24586,
 -2419,  -2419,  -2419,
 -1329,  -1329,  -1329,
 11854,  11854,  11854,
 24663,  24663,  24663,
 -2420,  -2420,  -2420,
 -1318,  -1318,  -1318,
 11767,  11767,  11767,
 24740,  24740,  24740,
 -2421,  -2421,  -2421,
 -1308,  -1308,  -1308,
 11681,  11681,  11681,
 24817,  24817,  24817,
 -2422,  -2422,  -2422,
 -1297,  -1297,  -1297,
 11595,  11595,  11595,
 24894,  24894,  24894,
 -2423,  -2423,  -2423,
 -1286,  -1286,  -1286,
 11509,  11509,  11509,
 24970,  24970,  24970,
 -2424,  -2424,  -2424,
 -1276,  -1276,  -1276,
 11422,  11422,  11422,
 25046,  25046,  25046,
 -2425,  -2425,  -2425,
 -1265,  -1265,  -1265,
 11337,  11337,  11337,
 25122,  25122,  25122,
 -2426,  -2426,  -2426,
 -1255,  -1255,  -1255,
 11251,  11251,  11251,
 25198,  25198,  25198,
 -2426,  -2426,  -2426,
 -1244,  -1244,  -1244,
 11165,  11165,  11165,
 25274,  25274,  25274,
 -2427,  -2427,  -2427,
 -1233,  -1233,  -1233,
 11079,  11079,  11079,
 25349,  25349,  25349,
 -2427,  -2427,  -2427,
 -1223,  -1223,  -1223,
 10994,  10994,  10994,
 25424,  25424,  25424,
 -2427,  -2427,  -2427,
 -1212,  -1212,  -1212,
 10908,  10908,  10908,
 25499,  25499,  25499,
 -2427,  -2427,  -2427,
 -1201,  -1201,  -1201,
 10823,  10823,  10823,
 25573,  25573,  25573,
 -2427,  -2427,  -2427,
 -1191,  -1191,  -1191,
 10738,  10738,  10738,
 25647,  25647,  25647,
 -2427,  -2427,  -2427,
 -1180,  -1180,  -1180,
 10653,  10653,  10653,
 25721,  25721,  25721,
 -2427,  -2427,  -2427,
 -1169,  -1169,  -1169,
 10568,  10568,  10568,
 25795,  25795,  25795,
 -2426,  -2426,  -2426,
 -1159,  -1159,  -1159,
 10483,  10483,  10483,
 25869,  25869,  25869,
 -2426,  -2426,  -2426,
 -1148,  -1148,  -1148,
 10399,  10399,  10399,
 25942,  25942,  25942,
 -2425,  -2425,  -2425,
 -1137,  -1137,  -1137,
 10314,  10314,  10314,
 26015,  26015,  26015,
 -2424,  -2424,  -2424,
 -1127,  -1127,  -1127,
 10230,  10230,  10230,
 26087,  26087,  26087,
 -2423,  -2423,  -2423,
 -1116,  -1116,  -1116,
 10146,  10146,  10146,
 26160,  26160,  26160,
 -2422,  -2422,  -2422,
 -1105,  -1105,  -1105,
 10062,  10062,  10062,
 26232,  26232,  26232,
 -2421,  -2421,  -2421,
 -1095,  -1095,  -1095,
  9978,   9978,   9978,
 26304,  26304,  26304,
 -2419,  -2419,  -2419,
 -1084,  -1084,  -1084,
  9894,   9894,   9894,
 26376,  26376,  26376,
 -2418,  -2418,  -2418,
 -1073,  -1073,  -1073,
  9811,   9811,   9811,
 26447,  26447,  26447,
 -2416,  -2416,  -2416,
 -1063,  -1063,  -1063,
  9727,   9727,   9727,
 26518,  26518,  26518,
 -2414,  -2414,  -2414,
 -1052,  -1052,  -1052,
  9644,   9644,   9644,
 26589,  26589,  26589,
 -2412,  -2412,  -2412,
 -1042,  -1042,  -1042,
  9561,   9561,   9561,
 26659,  26659,  26659,
 -2410,  -2410,  -2410,
 -1031,  -1031,  -1031,
  9478,   9478,   9478,
 26729,  26729,  26729,
 -2408,  -2408,  -2408,
 -1021,  -1021,  -1021,
  9395,   9395,   9395,
 26799,  26799,  26799,
 -2406,  -2406,  -2406,
 -1010,  -1010,  -1010,
  9313,   9313,   9313,
 26869,  26869,  26869,
 -2403,  -2403,  -2403,
 -1000,  -1000,  -1000,
  9230,   9230,   9230,
 26938,  26938,  26938,
 -2401,  -2401,  -2401,
  -989,   -989,   -989,
  9148,   9148,   9148,
 27007,  27007,  27007,
 -2398,  -2398,  -2398,
  -979,   -979,   -979,
  9066,   9066,   9066,
 27076,  27076,  27076,
 -2395,  -2395,  -2395,
  -968,   -968,   -968,
  8984,   8984,   8984,
 27144,  27144,  27144,
 -2392,  -2392,  -2392,
  -958,   -958,   -958,
  8902,   8902,   8902,
 27212,  27212,  27212,
 -2389,  -2389,  -2389,
  -947,   -947,   -947,
  8821,   8821,   8821,
 27280,  27280,  27280,
 -2386,  -2386,  -2386,
  -937,   -937,   -937,
  8739,   8739,   8739,
 27348,  27348,  27348,
 -2382,  -2382,  -2382,
  -926,   -926,   -926,
  8658,   8658,   8658,
 27415,  27415,  27415,
 -2379,  -2379,  -2379,
  -916,   -916,   -916,
  8577,   8577,   8577,
 27482,  27482,  27482,
 -2375,  -2375,  -2375,
  -906,   -906,   -906,
  8496,   8496,   8496,
 27549,  27549,  27549,
 -2371,  -2371,  -2371,
  -895,   -895,   -895,
  8415,   8415,   8415,
 27615,  27615,  27615,
 -2367,  -2367,  -2367,
  -885,   -885,   -885,
  8335,   8335,   8335,
 27681,  27681,  27681,
 -2363,  -2363,  -2363,
  -875,   -875,   -875,
  8255,   8255,   8255,
 27746,  27746,  27746,
 -2359,  -2359,  -2359,
  -864,   -864,   -864,
  8175,   8175,   8175,
 27812,  27812,  27812,
 -2354,  -2354,  -2354,
  -854,   -854,   -854,
  8095,   8095,   8095,
 27877,  27877,  27877,
 -2349,  -2349,  -2349,
  -844,   -844,   -844,
  8015,   8015,   8015,
 27941,  27941,  27941,
 -2345,  -2345,  -2345,
  -834,   -834,   -834,
  7936,   7936,   7936,
 28006,  28006,  28006,
 -2340,  -2340,  -2340,
  -823,   -823,   -823,
  7856,   7856,   7856,
 28070,  28070,  28070,
 -2335,  -2335,  -2335,
  -813,   -813,   -813,
  7777,   7777,   7777,
 28134,  28134,  28134,
 -2329,  -2329,  -2329,
  -803,   -803,   -803,
  7698,   7698,   7698,
 28197,  28197,  28197,
 -2324,  -2324,  -2324,
  -793,   -793,   -793,
  7620,   7620,   7620,
 28260,  28260,  28260,
 -2319,  -2319,  -2319,
  -783,   -783,   -783,
  7541,   7541,   7541,
 28323,  28323,  28323,
 -2313,  -2313,  -2313,
  -773,   -773,   -773,
  7463,   7463,   7463,
 28385,  28385,  28385,
 -2307,  -2307,  -2307,
  -763,   -763,   -763,
  7385,   7385,   7385,
 28447,  28447,  28447,
 -2301,  -2301,  -2301,
  -753,   -753,   -753,
  7307,   7307,   7307,
 28509,  28509,  28509,
 -2295,  -2295,  -2295,
  -743,   -743,   -743,
  7230,   7230,   7230,
 28570,  28570,  28570,
 -2289,  -2289,  -2289,
  -733,   -733,   -733,
  7152,   7152,   7152,
 28631,  28631,  28631,
 -2282,  -2282,  -2282,
  -723,   -723,   -723,
  7075,   7075,   7075,
 28691,  28691,  28691,
 -2275,  -2275,  -2275,
  -713,   -713,   -713,
  6998,   6998,   6998,
 28752,  28752,  28752,
 -2269,  -2269,  -2269,
  -704,   -704,   -704,
  6922,   6922,   6922,
 28812,  28812,  28812,
 -2262,  -2262,  -2262,
  -694,   -694,   -694,
  6845,   6845,   6845,
 28871,  28871,  28871,
 -2255,  -2255,  -2255,
  -684,   -684,   -684,
  6769,   6769,   6769,
 28930,  28930,  28930,
 -2247,  -2247,  -2247,
  -675,   -675,   -675,
  6693,   6693,   6693,
 28989,  28989,  28989,
 -2240,  -2240,  -2240,
  -665,   -665,   -665,
  6617,   6617,   6617,
 29048,  29048,  29048,
 -2232,  -2232,  -2232,
  -655,   -655,   -655,
  6542,   6542,   6542,
 29106,  29106,  29106,
 -2224,  -2224,  -2224,
  -646,   -646,   -646,
  6467,   6467,   6467,
 29163,  29163,  29163,
 -2217,  -2217,  -2217,
  -636,   -636,   -636,
  6392,   6392,   6392,
 29221,  29221,  29221,
 -2208,  -2208,  -2208,
  -627,   -627,   -627,
  6317,   6317,   6317,
 29278,  29278,  29278,
 -2200,  -2200,  -2200,
  -617,   -617,   -617,
  6243,   6243,   6243,
 29334,  29334,  29334,
 -2192,  -2192,  -2192,
  -608,   -608,   -608,
  6168,   6168,   6168,
 29391,  29391,  29391,
 -2183,  -2183,  -2183,
  -598,   -598,   -598,
  6094,   6094,   6094,
 29446,  29446,  29446,
 -2174,  -2174,  -2174,
  -589,   -589,   -589,
  6021,   6021,   6021,
 29502,  29502,  29502,
 -2165,  -2165,  -2165,
  -580,   -580,   -580,
  5947,   5947,   5947,
 29557,  29557,  29557,
 -2156,  -2156,  -2156,
  -571,   -571,   -571,
  5874,   5874,   5874,
 29612,  29612,  29612,
 -2147,  -2147,  -2147,
  -561,   -561,   -561,
  5801,   5801,   5801,
 29666,  29666,  29666,
 -2138,  -2138,  -2138,
  -552,   -552,   -552,
  5729,   5729,   5729,
 29720,  29720,  29720,
 -2128,  -2128,  -2128,
  -543,   -543,   -543,
  5656,   5656,   5656,
 29773,  29773,  29773,
 -2118,  -2118,  -2118,
  -534,   -534,   -534,
  5584,   5584,   5584,
 29826,  29826,  29826,
 -2108,  -2108,  -2108,
  -525,   -525,   -525,
  5512,   5512,   5512,
 29879,  29879,  29879,
 -2098,  -2098,  -2098,
  -516,   -516,   -516,
  5441,   5441,   5441,
 29931,  29931,  29931,
 -2088,  -2088,  -2088,
  -507,   -507,   -507,
  5369,   5369,   5369,
 29983,  29983,  29983,
 -2077,  -2077,  -2077,
  -499,   -499,   -499,
  5298,   5298,   5298,
 30035,  30035,  30035,
 -2067,  -2067,  -2067,
  -490,   -490,   -490,
  5228,   5228,   5228,
 30086,  30086,  30086,
 -2056,  -2056,  -2056,
  -481,   -481,   -481,
  5157,   5157,   5157,
 30137,  30137,  30137,
 -2045,  -2045,  -2045,
  -472,   -472,   -472,
  5087,   5087,   5087,
 30187,  30187,  30187,
 -2034,  -2034,  -2034,
  -464,   -464,   -464,
  5017,   5017,   5017,
 30237,  30237,  30237,
 -2022,  -2022,  -2022,
  -455,   -455,   -455,
  4948,   4948,   4948,
 30286,  30286,  30286,
 -2011,  -2011,  -2011,
  -447,   -447,   -447,
  4878,   4878,   4878,
 30335,  30335,  30335,
 -1999,  -1999,  -1999,
  -438,   -438,   -438,
  4809,   4809,   4809,
 30384,  30384,  30384,
 -1987,  -1987,  -1987,
  -430,   -430,   -430,
  4741,   4741,   4741,
 30432,  30432,  30432,
 -1975,  -1975,  -1975,
  -421,   -421,   -421,
  4672,   4672,   4672,
 30480,  30480,  30480,
 -1963,  -1963,  -1963,
  -413,   -413,   -413,
  4604,   4604,   4604,
 30527,  30527,  30527,
 -1950,  -1950,  -1950,
  -405,   -405,   -405,
  4536,   4536,   4536,
 30574,  30574,  30574,
 -1938,  -1938,  -1938,
  -397,   -397,   -397,
  4469,   4469,   4469,
 30621,  30621,  30621,
 -1925,  -1925,  -1925,
  -389,   -389,   -389,
  4402,   4402,   4402,
 30667,  30667,  30667,
 -1912,  -1912,  -1912,
  -381,   -381,   -381,
  4335,   4335,   4335,
 30712,  30712,  30712,
 -1899,  -1899,  -1899,
  -373,   -373,   -373,
  4268,   4268,   4268,
 30758,  30758,  30758,
 -1885,  -1885,  -1885,
  -365,   -365,   -365,
  4202,   4202,   4202,
 30802,  30802,  30802,
 -1872,  -1872,  -1872,
  -357,   -357,   -357,
  4136,   4136,   4136,
 30847,  30847,  30847,
 -1858,  -1858,  -1858,
  -349,   -349,   -349,
  4070,   4070,   4070,
 30891,  30891,  30891,
 -1844,  -1844,  -1844,
  -341,   -341,   -341,
  4005,   4005,   4005,
 30934,  30934,  30934,
 -1830,  -1830,  -1830,
  -334,   -334,   -334,
  3940,   3940,   3940,
 30977,  30977,  30977,
 -1815,  -1815,  -1815,
  -326,   -326,   -326,
  3875,   3875,   3875,
 31019,  31019,  31019,
 -1801,  -1801,  -1801,
  -319,   -319,   -319,
  3811,   3811,   3811,
 31062,  31062,  31062,
 -1786,  -1786,  -1786,
  -311,   -311,   -311,
  3747,   3747,   3747,
 31103,  31103,  31103,
 -1771,  -1771,  -1771,
  -304,   -304,   -304,
  3683,   3683,   3683,
 31144,  31144,  31144,
 -1756,  -1756,  -1756,
  -296,   -296,   -296,
  3620,   3620,   3620,
 31185,  31185,  31185,
 -1741,  -1741,  -1741,
  -289,   -289,   -289,
  3557,   3557,   3557,
 31225,  31225,  31225,
 -1725,  -1725,  -1725,
  -282,   -282,   -282,
  3495,   3495,   3495,
 31265,  31265,  31265,
 -1709,  -1709,  -1709,
  -275,   -275,   -275,
  3432,   3432,   3432,
 31304,  31304,  31304,
 -1694,  -1694,  -1694,
  -268,   -268,   -268,
  3370,   3370,   3370,
 31343,  31343,  31343,
 -1677,  -1677,  -1677,
  -261,   -261,   -261,
  3309,   3309,   3309,
 31381,  31381,  31381,
 -1661,  -1661,  -1661,
  -254,   -254,   -254,
  3247,   3247,   3247,
 31419,  31419,  31419,
 -1645,  -1645,  -1645,
  -247,   -247,   -247,
  3186,   3186,   3186,
 31457,  31457,  31457,
 -1628,  -1628,  -1628,
  -240,   -240,   -240,
  3126,   3126,   3126,
 31494,  31494,  31494,
 -1611,  -1611,  -1611,
  -234,   -234,   -234,
  3066,   3066,   3066,
 31530,  31530,  31530,
 -1594,  -1594,  -1594,
  -227,   -227,   -227,
  3006,   3006,   3006,
 31566,  31566,  31566,
 -1577,  -1577,  -1577,
  -221,   -221,   -221,
  2946,   2946,   2946,
 31602,  31602,  31602,
 -1559,  -1559,  -1559,
  -214,   -214,   -214,
  2887,   2887,   2887,
 31637,  31637,  31637,
 -1542,  -1542,  -1542,
  -208,   -208,   -208,
  2828,   2828,   2828,
 31671,  31671,  31671,
 -1524,  -1524,  -1524,
  -202,   -202,   -202,
  2770,   2770,   2770,
 31705,  31705,  31705,
 -1506,  -1506,  -1506,
  -196,   -196,   -196,
  2712,   2712,   2712,
 31739,  31739,  31739,
 -1487,  -1487,  -1487,
  -189,   -189,   -189,
  2654,   2654,   2654,
 31772,  31772,  31772,
 -1469,  -1469,  -1469,
  -183,   -183,   -183,
  2597,   2597,   2597,
 31804,  31804,  31804,
 -1450,  -1450,  -1450,
  -177,   -177,   -177,
  2540,   2540,   2540,
 31836,  31836,  31836,
 -1431,  -1431,  -1431,
  -172,   -172,   -172,
  2483,   2483,   2483,
 31868,  31868,  31868,
 -1412,  -1412,  -1412,
  -166,   -166,   -166,
  2427,   2427,   2427,
 31899,  31899,  31899,
 -1392,  -1392,  -1392,
  -160,   -160,   -160,
  2371,   2371,   2371,
 31930,  31930,  31930,
 -1373,  -1373,  -1373,
  -155,   -155,   -155,
  2316,   2316,   2316,
 31960,  31960,  31960,
 -1353,  -1353,  -1353,
  -149,   -149,   -149,
  2261,   2261,   2261,
 31989,  31989,  31989,
 -1333,  -1333,  -1333,
  -144,   -144,   -144,
  2206,   2206,   2206,
 32018,  32018,  32018,
 -1313,  -1313,  -1313,
  -138,   -138,   -138,
  2152,   2152,   2152,
 32047,  32047,  32047,
 -1293,  -1293,  -1293,
  -133,   -133,   -133,
  2098,   2098,   2098,
 32075,  32075,  32075,
 -1272,  -1272,  -1272,
  -128,   -128,   -128,
  2045,   2045,   2045,
 32102,  32102,  32102,
 -1251,  -1251,  -1251,
  -123,   -123,   -123,
  1992,   1992,   1992,
 32129,  32129,  32129,
 -1230,  -1230,  -1230,
  -118,   -118,   -118,
  1939,   1939,   1939,
 32156,  32156,  32156,
 -1209,  -1209,  -1209,
  -113,   -113,   -113,
  1887,   1887,   1887,
 32181,  32181,  32181,
 -1187,  -1187,  -1187,
  -108,   -108,   -108,
  1835,   1835,   1835,
 32207,  32207,  32207,
 -1166,  -1166,  -1166,
  -104,   -104,   -104,
  1783,   1783,   1783,
 32232,  32232,  32232,
 -1144,  -1144,  -1144,
   -99,    -99,    -99,
  1732,   1732,   1732,
 32256,  32256,  32256,
 -1121,  -1121,  -1121,
   -94,    -94,    -94,
  1682,   1682,   1682,
 32280,  32280,  32280,
 -1099,  -1099,  -1099,
   -90,    -90,    -90,
  1631,   1631,   1631,
 32303,  32303,  32303,
 -1076,  -1076,  -1076,
   -86,    -86,    -86,
  1582,   1582,   1582,
 32326,  32326,  32326,
 -1054,  -1054,  -1054,
   -81,    -81,    -81,
  1532,   1532,   1532,
 32348,  32348,  32348,
 -1031,  -1031,  -1031,
   -77,    -77,    -77,
  1483,   1483,   1483,
 32369,  32369,  32369,
 -1007,  -1007,  -1007,
   -73,    -73,    -73,
  1435,   1435,   1435,
 32391,  32391,  32391,
  -984,   -984,   -984,
   -69,    -69,    -69,
  1387,   1387,   1387,
 32411,  32411,  32411,
  -960,   -960,   -960,
   -66,    -66,    -66,
  1339,   1339,   1339,
 32431,  32431,  32431,
  -936,   -936,   -936,
   -62,    -62,    -62,
  1291,   1291,   1291,
 32450,  32450,  32450,
  -912,   -912,   -912,
   -58,    -58,    -58,
  1245,   1245,   1245,
 32469,  32469,  32469,
  -888,   -888,   -888,
   -55,    -55,    -55,
  1198,   1198,   1198,
 32488,  32488,  32488,
  -863,   -863,   -863,
   -51,    -51,    -51,
  1152,   1152,   1152,
 32505,  32505,  32505,
  -838,   -838,   -838,
   -48,    -48,    -48,
  1107,   1107,   1107,
 32523,  32523,  32523,
  -813,   -813,   -813,
   -45,    -45,    -45,
  1061,   1061,   1061,
 32539,  32539,  32539,
  -788,   -788,   -788,
   -42,    -42,    -42,
  1017,   1017,   1017,
 32555,  32555,  32555,
  -762,   -762,   -762,
   -39,    -39,    -39,
   972,    972,    972,
 32571,  32571,  32571,
  -737,   -737,   -737,
   -36,    -36,    -36,
   929,    929,    929,
 32586,  32586,  32586,
  -711,   -711,   -711,
   -33,    -33,    -33,
   885,    885,    885,
 32600,  32600,  32600,
  -685,   -685,   -685,
   -30,    -30,    -30,
   842,    842,    842,
 32614,  32614,  32614,
  -658,   -658,   -658,
   -28,    -28,    -28,
   800,    800,    800,
 32627,  32627,  32627,
  -631,   -631,   -631,
   -25,    -25,    -25,
   758,    758,    758,
 32640,  32640,  32640,
  -605,   -605,   -605,
   -23,    -23,    -23,
   716,    716,    716,
 32652,  32652,  32652,
  -577,   -577,   -577,
   -21,    -21,    -21,
   675,    675,    675,
 32663,  32663,  32663,
  -550,   -550,   -550,
   -18,    -18,    -18,
   635,    635,    635,
 32674,  32674,  32674,
  -522,   -522,   -522,
   -16,    -16,    -16,
   594,    594,    594,
 32685,  32685,  32685,
  -495,   -495,   -495,
   -15,    -15,    -15,
   555,    555,    555,
 32694,  32694,  32694,
  -466,   -466,   -466,
   -13,    -13,    -13,
   515,    515,    515,
 32703,  32703,  32703,
  -438,   -438,   -438,
   -11,    -11,    -11,
   477,    477,    477,
 32712,  32712,  32712,
  -410,   -410,   -410,
   -10,    -10,    -10,
   438,    438,    438,
 32720,  32720,  32720,
  -381,   -381,   -381,
    -8,     -8,     -8,
   401,    401,    401,
 32727,  32727,  32727,
  -352,   -352,   -352,
    -7,     -7,     -7,
   363,    363,    363,
 32734,  32734,  32734,
  -322,   -322,   -322,
    -6,     -6,     -6,
   326,    326,    326,
 32740,  32740,  32740,
  -293,   -293,   -293,
    -4,     -4,     -4,
   290,    290,    290,
 32746,  32746,  32746,
  -263,   -263,   -263,
    -3,     -3,     -3,
   254,    254,    254,
 32751,  32751,  32751,
  -233,   -233,   -233,
    -3,     -3,     -3,
   218,    218,    218,
 32755,  32755,  32755,
  -203,   -203,   -203,
    -2,     -2,     -2,
   184,    184,    184,
 32759,  32759,  32759,
  -172,   -172,   -172,
    -1,     -1,     -1,
   149,    149,    149,
 32762,  32762,  32762,
  -141,   -141,   -141,
    -1,     -1,     -1,
   115,    115,    115,
 32764,  32764,  32764,
  -110,   -110,   -110,
     0,      0,      0,
    82,     82,     82,
 32766,  32766,  32766,
   -79,    -79,    -79,
     0,      0,      0,
    49,     49,     49,
 32767,  32767,  32767,
   -48,    -48,    -48,
     0,      0,      0,
    16,     16,     16,
 32767,  32767,  32767,
   -16,    -16,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc2_3[] = {
   -32,    -32,    -32,
 32767,  32767,  32767,
    32,     32,     32,
     0,      0,      0,
   -95,    -95,    -95,
 32767,  32767,  32767,
    96,     96,     96,
     0,      0,      0,
  -158,   -158,   -158,
 32766,  32766,  32766,
   161,    161,    161,
    -1,     -1,     -1,
  -221,   -221,   -221,
 32765,  32765,  32765,
   226,    226,    226,
    -2,     -2,     -2,
  -283,   -283,   -283,
 32763,  32763,  32763,
   291,    291,    291,
    -3,     -3,     -3,
  -344,   -344,   -344,
 32760,  32760,  32760,
   356,    356,    356,
    -4,     -4,     -4,
  -406,   -406,   -406,
 32758,  32758,  32758,
   421,    421,    421,
    -5,     -5,     -5,
  -466,   -466,   -466,
 32754,  32754,  32754,
   487,    487,    487,
    -7,     -7,     -7,
  -526,   -526,   -526,
 32750,  32750,  32750,
   553,    553,    553,
    -9,     -9,     -9,
  -586,   -586,   -586,
 32746,  32746,  32746,
   619,    619,    619,
   -11,    -11,    -11,
  -645,   -645,   -645,
 32741,  32741,  32741,
   685,    685,    685,
   -13,    -13,    -13,
  -703,   -703,   -703,
 32735,  32735,  32735,
   752,    752,    752,
   -16,    -16,    -16,
  -761,   -761,   -761,
 32729,  32729,  32729,
   819,    819,    819,
   -19,    -19,    -19,
  -819,   -819,   -819,
 32723,  32723,  32723,
   886,    886,    886,
   -22,    -22,    -22,
  -876,   -876,   -876,
 32716,  32716,  32716,
   954,    954,    954,
   -26,    -26,    -26,
  -933,   -933,   -933,
 32709,  32709,  32709,
  1021,   1021,   1021,
   -29,    -29,    -29,
  -989,   -989,   -989,
 32701,  32701,  32701,
  1089,   1089,   1089,
   -33,    -33,    -33,
 -1045,  -1045,  -1045,
 32693,  32693,  32693,
  1157,   1157,   1157,
   -37,    -37,    -37,
 -1100,  -1100,  -1100,
 32684,  32684,  32684,
  1225,   1225,   1225,
   -41,    -41,    -41,
 -1155,  -1155,  -1155,
 32675,  32675,  32675,
  1294,   1294,   1294,
   -46,    -46,    -46,
 -1209,  -1209,  -1209,
 32665,  32665,  32665,
  1362,   1362,   1362,
   -50,    -50,    -50,
 -1263,  -1263,  -1263,
 32655,  32655,  32655,
  1431,   1431,   1431,
   -55,    -55,    -55,
 -1316,  -1316,  -1316,
 32644,  32644,  32644,
  1501,   1501,   1501,
   -61,    -61,    -61,
 -1369,  -1369,  -1369,
 32633,  32633,  32633,
  1570,   1570,   1570,
   -66,    -66,    -66,
 -1422,  -1422,  -1422,
 32622,  32622,  32622,
  1639,   1639,   1639,
   -71,    -71,    -71,
 -1473,  -1473,  -1473,
 32609,  32609,  32609,
  1709,   1709,   1709,
   -77,    -77,    -77,
 -1525,  -1525,  -1525,
 32597,  32597,  32597,
  1779,   1779,   1779,
   -83,    -83,    -83,
 -1576,  -1576,  -1576,
 32584,  32584,  32584,
  1849,   1849,   1849,
   -89,    -89,    -89,
 -1627,  -1627,  -1627,
 32571,  32571,  32571,
  1920,   1920,   1920,
   -96,    -96,    -96,
 -1677,  -1677,  -1677,
 32557,  32557,  32557,
  1991,   1991,   1991,
  -103,   -103,   -103,
 -1726,  -1726,  -1726,
 32542,  32542,  32542,
  2061,   2061,   2061,
  -109,   -109,   -109,
 -1776,  -1776,  -1776,
 32528,  32528,  32528,
  2132,   2132,   2132,
  -116,   -116,   -116,
 -1824,  -1824,  -1824,
 32512,  32512,  32512,
  2204,   2204,   2204,
  -124,   -124,   -124,
 -1873,  -1873,  -1873,
 32497,  32497,  32497,
  2275,   2275,   2275,
  -131,   -131,   -131,
 -1920,  -1920,  -1920,
 32480,  32480,  32480,
  2347,   2347,   2347,
  -139,   -139,   -139,
 -1968,  -1968,  -1968,
 32464,  32464,  32464,
  2419,   2419,   2419,
  -147,   -147,   -147,
 -2015,  -2015,  -2015,
 32447,  32447,  32447,
  2491,   2491,   2491,
  -155,   -155,   -155,
 -2061,  -2061,  -2061,
 32429,  32429,  32429,
  2563,   2563,   2563,
  -163,   -163,   -163,
 -2107,  -2107,  -2107,
 32411,  32411,  32411,
  2635,   2635,   2635,
  -171,   -171,   -171,
 -2153,  -2153,  -2153,
 32393,  32393,  32393,
  2708,   2708,   2708,
  -180,   -180,   -180,
 -2198,  -2198,  -2198,
 32374,  32374,  32374,
  2781,   2781,   2781,
  -189,   -189,   -189,
 -2243,  -2243,  -2243,
 32355,  32355,  32355,
  2854,   2854,   2854,
  -198,   -198,   -198,
 -2287,  -2287,  -2287,
 32335,  32335,  32335,
  2927,   2927,   2927,
  -207,   -207,   -207,
 -2331,  -2331,  -2331,
 32315,  32315,  32315,
  3000,   3000,   3000,
  -216,   -216,   -216,
 -2374,  -2374,  -2374,
 32294,  32294,  32294,
  3074,   3074,   3074,
  -226,   -226,   -226,
 -2417,  -2417,  -2417,
 32273,  32273,  32273,
  3148,   3148,   3148,
  -236,   -236,   -236,
 -2460,  -2460,  -2460,
 32252,  32252,  32252,
  3222,   3222,   3222,
  -246,   -246,   -246,
 -2502,  -2502,  -2502,
 32230,  32230,  32230,
  3296,   3296,   3296,
  -256,   -256,   -256,
 -2544,  -2544,  -2544,
 32208,  32208,  32208,
  3370,   3370,   3370,
  -266,   -266,   -266,
 -2585,  -2585,  -2585,
 32185,  32185,  32185,
  3445,   3445,   3445,
  -277,   -277,   -277,
 -2626,  -2626,  -2626,
 32162,  32162,  32162,
  3519,   3519,   3519,
  -287,   -287,   -287,
 -2666,  -2666,  -2666,
 32138,  32138,  32138,
  3594,   3594,   3594,
  -298,   -298,   -298,
 -2706,  -2706,  -2706,
 32114,  32114,  32114,
  3669,   3669,   3669,
  -309,   -309,   -309,
 -2746,  -2746,  -2746,
 32090,  32090,  32090,
  3744,   3744,   3744,
  -320,   -320,   -320,
 -2785,  -2785,  -2785,
 32065,  32065,  32065,
  3820,   3820,   3820,
  -332,   -332,   -332,
 -2824,  -2824,  -2824,
 32040,  32040,  32040,
  3895,   3895,   3895,
  -343,   -343,   -343,
 -2862,  -2862,  -2862,
 32014,  32014,  32014,
  3971,   3971,   3971,
  -355,   -355,   -355,
 -2900,  -2900,  -2900,
 31988,  31988,  31988,
  4047,   4047,   4047,
  -367,   -367,   -367,
 -2937,  -2937,  -2937,
 31961,  31961,  31961,
  4123,   4123,   4123,
  -379,   -379,   -379,
 -2974,  -2974,  -2974,
 31934,  31934,  31934,
  4199,   4199,   4199,
  -391,   -391,   -391,
 -3011,  -3011,  -3011,
 31907,  31907,  31907,
  4275,   4275,   4275,
  -403,   -403,   -403,
 -3047,  -3047,  -3047,
 31879,  31879,  31879,
  4352,   4352,   4352,
  -416,   -416,   -416,
 -3083,  -3083,  -3083,
 31851,  31851,  31851,
  4429,   4429,   4429,
  -429,   -429,   -429,
 -3118,  -3118,  -3118,
 31822,  31822,  31822,
  4506,   4506,   4506,
  -442,   -442,   -442,
 -3153,  -3153,  -3153,
 31793,  31793,  31793,
  4583,   4583,   4583,
  -455,   -455,   -455,
 -3188,  -3188,  -3188,
 31764,  31764,  31764,
  4660,   4660,   4660,
  -468,   -468,   -468,
 -3222,  -3222,  -3222,
 31734,  31734,  31734,
  4737,   4737,   4737,
  -481,   -481,   -481,
 -3256,  -3256,  -3256,
 31704,  31704,  31704,
  4814,   4814,   4814,
  -494,   -494,   -494,
 -3289,  -3289,  -3289,
 31673,  31673,  31673,
  4892,   4892,   4892,
  -508,   -508,   -508,
 -3322,  -3322,  -3322,
 31642,  31642,  31642,
  4970,   4970,   4970,
  -522,   -522,   -522,
 -3355,  -3355,  -3355,
 31611,  31611,  31611,
  5048,   5048,   5048,
  -536,   -536,   -536,
 -3387,  -3387,  -3387,
 31579,  31579,  31579,
  5126,   5126,   5126,
  -550,   -550,   -550,
 -3419,  -3419,  -3419,
 31547,  31547,  31547,
  5204,   5204,   5204,
  -564,   -564,   -564,
 -3450,  -3450,  -3450,
 31514,  31514,  31514,
  5282,   5282,   5282,
  -578,   -578,   -578,
 -3481,  -3481,  -3481,
 31481,  31481,  31481,
  5361,   5361,   5361,
  -593,   -593,   -593,
 -3512,  -3512,  -3512,
 31448,  31448,  31448,
  5439,   5439,   5439,
  -607,   -607,   -607,
 -3542,  -3542,  -3542,
 31414,  31414,  31414,
  5518,   5518,   5518,
  -622,   -622,   -622,
 -3572,  -3572,  -3572,
 31380,  31380,  31380,
  5597,   5597,   5597,
  -637,   -637,   -637,
 -3602,  -3602,  -3602,
 31346,  31346,  31346,
  5676,   5676,   5676,
  -652,   -652,   -652,
 -3631,  -3631,  -3631,
 31311,  31311,  31311,
  5755,   5755,   5755,
  -667,   -667,   -667,
 -3659,  -3659,  -3659,
 31275,  31275,  31275,
  5835,   5835,   5835,
  -683,   -683,   -683,
 -3688,  -3688,  -3688,
 31240,  31240,  31240,
  5914,   5914,   5914,
  -698,   -698,   -698,
 -3716,  -3716,  -3716,
 31204,  31204,  31204,
  5994,   5994,   5994,
  -714,   -714,   -714,
 -3743,  -3743,  -3743,
 31167,  31167,  31167,
  6073,   6073,   6073,
  -729,   -729,   -729,
 -3770,  -3770,  -3770,
 31130,  31130,  31130,
  6153,   6153,   6153,
  -745,   -745,   -745,
 -3797,  -3797,  -3797,
 31093,  31093,  31093,
  6233,   6233,   6233,
  -761,   -761,   -761,
 -3823,  -3823,  -3823,
 31055,  31055,  31055,
  6313,   6313,   6313,
  -777,   -777,   -777,
 -3849,  -3849,  -3849,
 31017,  31017,  31017,
  6393,   6393,   6393,
  -793,   -793,   -793,
 -3875,  -3875,  -3875,
 30979,  30979,  30979,
  6474,   6474,   6474,
  -810,   -810,   -810,
 -3900,  -3900,  -3900,
 30940,  30940,  30940,
  6554,   6554,   6554,
  -826,   -826,   -826,
 -3925,  -3925,  -3925,
 30901,  30901,  30901,
  6635,   6635,   6635,
  -843,   -843,   -843,
 -3950,  -3950,  -3950,
 30862,  30862,  30862,
  6716,   6716,   6716,
  -860,   -860,   -860,
 -3974,  -3974,  -3974,
 30822,  30822,  30822,
  6796,   6796,   6796,
  -876,   -876,   -876,
 -3998,  -3998,  -3998,
 30782,  30782,  30782,
  6877,   6877,   6877,
  -893,   -893,   -893,
 -4021,  -4021,  -4021,
 30741,  30741,  30741,
  6958,   6958,   6958,
  -910,   -910,   -910,
 -4045,  -4045,  -4045,
 30701,  30701,  30701,
  7039,   7039,   7039,
  -927,   -927,   -927,
 -4067,  -4067,  -4067,
 30659,  30659,  30659,
  7121,   7121,   7121,
  -945,   -945,   -945,
 -4090,  -4090,  -4090,
 30618,  30618,  30618,
  7202,   7202,   7202,
  -962,   -962,   -962,
 -4112,  -4112,  -4112,
 30576,  30576,  30576,
  7283,   7283,   7283,
  -979,   -979,   -979,
 -4133,  -4133,  -4133,
 30533,  30533,  30533,
  7365,   7365,   7365,
  -997,   -997,   -997,
 -4155,  -4155,  -4155,
 30491,  30491,  30491,
  7447,   7447,   7447,
 -1015,  -1015,  -1015,
 -4176,  -4176,  -4176,
 30448,  30448,  30448,
  7528,   7528,   7528,
 -1032,  -1032,  -1032,
 -4196,  -4196,  -4196,
 30404,  30404,  30404,
  7610,   7610,   7610,
 -1050,  -1050,  -1050,
 -4217,  -4217,  -4217,
 30361,  30361,  30361,
  7692,   7692,   7692,
 -1068,  -1068,  -1068,
 -4237,  -4237,  -4237,
 30317,  30317,  30317,
  7774,   7774,   7774,
 -1086,  -1086,  -1086,
 -4256,  -4256,  -4256,
 30272,  30272,  30272,
  7857,   7857,   7857,
 -1105,  -1105,  -1105,
 -4275,  -4275,  -4275,
 30227,  30227,  30227,
  7939,   7939,   7939,
 -1123,  -1123,  -1123,
 -4294,  -4294,  -4294,
 30182,  30182,  30182,
  8021,   8021,   8021,
 -1141,  -1141,  -1141,
 -4313,  -4313,  -4313,
 30137,  30137,  30137,
  8104,   8104,   8104,
 -1160,  -1160,  -1160,
 -4331,  -4331,  -4331,
 30091,  30091,  30091,
  8186,   8186,   8186,
 -1178,  -1178,  -1178,
 -4349,  -4349,  -4349,
 30045,  30045,  30045,
  8269,   8269,   8269,
 -1197,  -1197,  -1197,
 -4366,  -4366,  -4366,
 29998,  29998,  29998,
  8352,   8352,   8352,
 -1216,  -1216,  -1216,
 -4384,  -4384,  -4384,
 29952,  29952,  29952,
  8434,   8434,   8434,
 -1234,  -1234,  -1234,
 -4400,  -4400,  -4400,
 29904,  29904,  29904,
  8517,   8517,   8517,
 -1253,  -1253,  -1253,
 -4417,  -4417,  -4417,
 29857,  29857,  29857,
  8600,   8600,   8600,
 -1272,  -1272,  -1272,
 -4433,  -4433,  -4433,
 29809,  29809,  29809,
  8683,   8683,   8683,
 -1291,  -1291,  -1291,
 -4449,  -4449,  -4449,
 29761,  29761,  29761,
  8767,   8767,   8767,
 -1311,  -1311,  -1311,
 -4464,  -4464,  -4464,
 29712,  29712,  29712,
  8850,   8850,   8850,
 -1330,  -1330,  -1330,
 -4480,  -4480,  -4480,
 29664,  29664,  29664,
  8933,   8933,   8933,
 -1349,  -1349,  -1349,
 -4495,  -4495,  -4495,
 29615,  29615,  29615,
  9016,   9016,   9016,
 -1368,  -1368,  -1368,
 -4509,  -4509,  -4509,
 29565,  29565,  29565,
  9100,   9100,   9100,
 -1388,  -1388,  -1388,
 -4523,  -4523,  -4523,
 29515,  29515,  29515,
  9183,   9183,   9183,
 -1407,  -1407,  -1407,
 -4537,  -4537,  -4537,
 29465,  29465,  29465,
  9267,   9267,   9267,
 -1427,  -1427,  -1427,
 -4551,  -4551,  -4551,
 29415,  29415,  29415,
  9351,   9351,   9351,
 -1447,  -1447,  -1447,
 -4564,  -4564,  -4564,
 29364,  29364,  29364,
  9434,   9434,   9434,
 -1466,  -1466,  -1466,
 -4577,  -4577,  -4577,
 29313,  29313,  29313,
  9518,   9518,   9518,
 -1486,  -1486,  -1486,
 -4590,  -4590,  -4590,
 29262,  29262,  29262,
  9602,   9602,   9602,
 -1506,  -1506,  -1506,
 -4602,  -4602,  -4602,
 29210,  29210,  29210,
  9686,   9686,   9686,
 -1526,  -1526,  -1526,
 -4614,  -4614,  -4614,
 29158,  29158,  29158,
  9770,   9770,   9770,
 -1546,  -1546,  -1546,
 -4626,  -4626,  -4626,
 29106,  29106,  29106,
  9854,   9854,   9854,
 -1566,  -1566,  -1566,
 -4637,  -4637,  -4637,
 29053,  29053,  29053,
  9938,   9938,   9938,
 -1586,  -1586,  -1586,
 -4648,  -4648,  -4648,
 29000,  29000,  29000,
 10022,  10022,  10022,
 -1606,  -1606,  -1606,
 -4659,  -4659,  -4659,
 28947,  28947,  28947,
 10107,  10107,  10107,
 -1627,  -1627,  -1627,
 -4669,  -4669,  -4669,
 28893,  28893,  28893,
 10191,  10191,  10191,
 -1647,  -1647,  -1647,
 -4679,  -4679,  -4679,
 28839,  28839,  28839,
 10275,  10275,  10275,
 -1667,  -1667,  -1667,
 -4689,  -4689,  -4689,
 28785,  28785,  28785,
 10360,  10360,  10360,
 -1688,  -1688,  -1688,
 -4699,  -4699,  -4699,
 28731,  28731,  28731,
 10444,  10444,  10444,
 -1708,  -1708,  -1708,
 -4708,  -4708,  -4708,
 28676,  28676,  28676,
 10529,  10529,  10529,
 -1729,  -1729,  -1729,
 -4717,  -4717,  -4717,
 28621,  28621,  28621,
 10613,  10613,  10613,
 -1749,  -1749,  -1749,
 -4726,  -4726,  -4726,
 28566,  28566,  28566,
 10698,  10698,  10698,
 -1770,  -1770,  -1770,
 -4734,  -4734,  -4734,
 28510,  28510,  28510,
 10782,  10782,  10782,
 -1790,  -1790,  -1790,
 -4742,  -4742,  -4742,
 28454,  28454,  28454,
 10867,  10867,  10867,
 -1811,  -1811,  -1811,
 -4750,  -4750,  -4750,
 28398,  28398,  28398,
 10952,  10952,  10952,
 -1832,  -1832,  -1832,
 -4757,  -4757,  -4757,
 28341,  28341,  28341,
 11037,  11037,  11037,
 -1853,  -1853,  -1853,
 -4765,  -4765,  -4765,
 28285,  28285,  28285,
 11121,  11121,  11121,
 -1873,  -1873,  -1873,
 -4771,  -4771,  -4771,
 28227,  28227,  28227,
 11206,  11206,  11206,
 -1894,  -1894,  -1894,
 -4778,  -4778,  -4778,
 28170,  28170,  28170,
 11291,  11291,  11291,
 -1915,  -1915,  -1915,
 -4784,  -4784,  -4784,
 28112,  28112,  28112,
 11376,  11376,  11376,
 -1936,  -1936,  -1936,
 -4790,  -4790,  -4790,
 28054,  28054,  28054,
 11461,  11461,  11461,
 -1957,  -1957,  -1957,
 -4796,  -4796,  -4796,
 27996,  27996,  27996,
 11546,  11546,  11546,
 -1978,  -1978,  -1978,
 -4802,  -4802,  -4802,
 27938,  27938,  27938,
 11631,  11631,  11631,
 -1999,  -1999,  -1999,
 -4807,  -4807,  -4807,
 27879,  27879,  27879,
 11716,  11716,  11716,
 -2020,  -2020,  -2020,
 -4812,  -4812,  -4812,
 27820,  27820,  27820,
 11801,  11801,  11801,
 -2041,  -2041,  -2041,
 -4816,  -4816,  -4816,
 27760,  27760,  27760,
 11886,  11886,  11886,
 -2062,  -2062,  -2062,
 -4821,  -4821,  -4821,
 27701,  27701,  27701,
 11971,  11971,  11971,
 -2083,  -2083,  -2083,
 -4825,  -4825,  -4825,
 27641,  27641,  27641,
 12057,  12057,  12057,
 -2105,  -2105,  -2105,
 -4829,  -4829,  -4829,
 27581,  27581,  27581,
 12142,  12142,  12142,
 -2126,  -2126,  -2126,
 -4832,  -4832,  -4832,
 27520,  27520,  27520,
 12227,  12227,  12227,
 -2147,  -2147,  -2147,
 -4836,  -4836,  -4836,
 27460,  27460,  27460,
 12312,  12312,  12312,
 -2168,  -2168,  -2168,
 -4839,  -4839,  -4839,
 27399,  27399,  27399,
 12397,  12397,  12397,
 -2189,  -2189,  -2189,
 -4841,  -4841,  -4841,
 27337,  27337,  27337,
 12483,  12483,  12483,
 -2211,  -2211,  -2211,
 -4844,  -4844,  -4844,
 27276,  27276,  27276,
 12568,  12568,  12568,
 -2232,  -2232,  -2232,
 -4846,  -4846,  -4846,
 27214,  27214,  27214,
 12653,  12653,  12653,
 -2253,  -2253,  -2253,
 -4848,  -4848,  -4848,
 27152,  27152,  27152,
 12738,  12738,  12738,
 -2274,  -2274,  -2274,
 -4850,  -4850,  -4850,
 27090,  27090,  27090,
 12824,  12824,  12824,
 -2296,  -2296,  -2296,
 -4851,  -4851,  -4851,
 27027,  27027,  27027,
 12909,  12909,  12909,
 -2317,  -2317,  -2317,
 -4852,  -4852,  -4852,
 26964,  26964,  26964,
 12994,  12994,  12994,
 -2338,  -2338,  -2338,
 -4853,  -4853,  -4853,
 26901,  26901,  26901,
 13080,  13080,  13080,
 -2360,  -2360,  -2360,
 -4854,  -4854,  -4854,
 26838,  26838,  26838,
 13165,  13165,  13165,
 -2381,  -2381,  -2381,
 -4854,  -4854,  -4854,
 26774,  26774,  26774,
 13250,  13250,  13250,
 -2402,  -2402,  -2402,
 -4855,  -4855,  -4855,
 26711,  26711,  26711,
 13336,  13336,  13336,
 -2424,  -2424,  -2424,
 -4854,  -4854,  -4854,
 26646,  26646,  26646,
 13421,  13421,  13421,
 -2445,  -2445,  -2445,
 -4854,  -4854,  -4854,
 26582,  26582,  26582,
 13506,  13506,  13506,
 -2466,  -2466,  -2466,
 -4854,  -4854,  -4854,
 26518,  26518,  26518,
 13592,  13592,  13592,
 -2488,  -2488,  -2488,
 -4853,  -4853,  -4853,
 26453,  26453,  26453,
 13677,  13677,  13677,
 -2509,  -2509,  -2509,
 -4852,  -4852,  -4852,
 26388,  26388,  26388,
 13762,  13762,  13762,
 -2530,  -2530,  -2530,
 -4850,  -4850,  -4850,
 26322,  26322,  26322,
 13848,  13848,  13848,
 -2552,  -2552,  -2552,
 -4849,  -4849,  -4849,
 26257,  26257,  26257,
 13933,  13933,  13933,
 -2573,  -2573,  -2573,
 -4847,  -4847,  -4847,
 26191,  26191,  26191,
 14018,  14018,  14018,
 -2594,  -2594,  -2594,
 -4845,  -4845,  -4845,
 26125,  26125,  26125,
 14104,  14104,  14104,
 -2616,  -2616,  -2616,
 -4843,  -4843,  -4843,
 26059,  26059,  26059,
 14189,  14189,  14189,
 -2637,  -2637,  -2637,
 -4840,  -4840,  -4840,
 25992,  25992,  25992,
 14274,  14274,  14274,
 -2658,  -2658,  -2658,
 -4837,  -4837,  -4837,
 25925,  25925,  25925,
 14359,  14359,  14359,
 -2679,  -2679,  -2679,
 -4834,  -4834,  -4834,
 25858,  25858,  25858,
 14445,  14445,  14445,
 -2701,  -2701,  -2701,
 -4831,  -4831,  -4831,
 25791,  25791,  25791,
 14530,  14530,  14530,
 -2722,  -2722,  -2722,
 -4828,  -4828,  -4828,
 25724,  25724,  25724,
 14615,  14615,  14615,
 -2743,  -2743,  -2743,
 -4824,  -4824,  -4824,
 25656,  25656,  25656,
 14700,  14700,  14700,
 -2764,  -2764,  -2764,
 -4820,  -4820,  -4820,
 25588,  25588,  25588,
 14785,  14785,  14785,
 -2785,  -2785,  -2785,
 -4816,  -4816,  -4816,
 25520,  25520,  25520,
 14870,  14870,  14870,
 -2806,  -2806,  -2806,
 -4812,  -4812,  -4812,
 25452,  25452,  25452,
 14955,  14955,  14955,
 -2827,  -2827,  -2827,
 -4807,  -4807,  -4807,
 25383,  25383,  25383,
 15040,  15040,  15040,
 -2848,  -2848,  -2848,
 -4802,  -4802,  -4802,
 25314,  25314,  25314,
 15125,  15125,  15125,
 -2869,  -2869,  -2869,
 -4797,  -4797,  -4797,
 25245,  25245,  25245,
 15210,  15210,  15210,
 -2890,  -2890,  -2890,
 -4792,  -4792,  -4792,
 25176,  25176,  25176,
 15295,  15295,  15295,
 -2911,  -2911,  -2911,
 -4787,  -4787,  -4787,
 25107,  25107,  25107,
 15380,  15380,  15380,
 -2932,  -2932,  -2932,
 -4781,  -4781,  -4781,
 25037,  25037,  25037,
 15465,  15465,  15465,
 -2953,  -2953,  -2953,
 -4775,  -4775,  -4775,
 24967,  24967,  24967,
 15550,  15550,  15550,
 -2974,  -2974,  -2974,
 -4769,  -4769,  -4769,
 24897,  24897,  24897,
 15635,  15635,  15635,
 -2995,  -2995,  -2995,
 -4763,  -4763,  -4763,
 24827,  24827,  24827,
 15720,  15720,  15720,
 -3016,  -3016,  -3016,
 -4756,  -4756,  -4756,
 24756,  24756,  24756,
 15805,  15805,  15805,
 -3037,  -3037,  -3037,
 -4750,  -4750,  -4750,
 24686,  24686,  24686,
 15889,  15889,  15889,
 -3057,  -3057,  -3057,
 -4743,  -4743,  -4743,
 24615,  24615,  24615,
 15974,  15974,  15974,
 -3078,  -3078,  -3078,
 -4736,  -4736,  -4736,
 24544,  24544,  24544,
 16058,  16058,  16058,
 -3098,  -3098,  -3098,
 -4728,  -4728,  -4728,
 24472,  24472,  24472,
 16143,  16143,  16143,
 -3119,  -3119,  -3119,
 -4721,  -4721,  -4721,
 24401,  24401,  24401,
 16228,  16228,  16228,
 -3140,  -3140,  -3140,
 -4713,  -4713,  -4713,
 24329,  24329,  24329,
 16312,  16312,  16312,
 -3160,  -3160,  -3160,
 -4705,  -4705,  -4705,
 24257,  24257,  24257,
 16396,  16396,  16396,
 -3180,  -3180,  -3180,
 -4697,  -4697,  -4697,
 24185,  24185,  24185,
 16481,  16481,  16481,
 -3201,  -3201,  -3201,
 -4689,  -4689,  -4689,
 24113,  24113,  24113,
 16565,  16565,  16565,
 -3221,  -3221,  -3221,
 -4680,  -4680,  -4680,
 24040,  24040,  24040,
 16649,  16649,  16649,
 -3241,  -3241,  -3241,
 -4672,  -4672,  -4672,
 23968,  23968,  23968,
 16734,  16734,  16734,
 -3262,  -3262,  -3262,
 -4663,  -4663,  -4663,
 23895,  23895,  23895,
 16818,  16818,  16818,
 -3282,  -3282,  -3282,
 -4654,  -4654,  -4654,
 23822,  23822,  23822,
 16902,  16902,  16902,
 -3302,  -3302,  -3302,
 -4644,  -4644,  -4644,
 23748,  23748,  23748,
 16986,  16986,  16986,
 -3322,  -3322,  -3322,
 -4635,  -4635,  -4635,
 23675,  23675,  23675,
 17070,  17070,  17070,
 -3342,  -3342,  -3342,
 -4625,  -4625,  -4625,
 23601,  23601,  23601,
 17154,  17154,  17154,
 -3362,  -3362,  -3362,
 -4615,  -4615,  -4615,
 23527,  23527,  23527,
 17238,  17238,  17238,
 -3382,  -3382,  -3382,
 -4605,  -4605,  -4605,
 23453,  23453,  23453,
 17321,  17321,  17321,
 -3401,  -3401,  -3401,
 -4595,  -4595,  -4595,
 23379,  23379,  23379,
 17405,  17405,  17405,
 -3421,  -3421,  -3421,
 -4585,  -4585,  -4585,
 23305,  23305,  23305,
 17489,  17489,  17489,
 -3441,  -3441,  -3441,
 -4574,  -4574,  -4574,
 23230,  23230,  23230,
 17572,  17572,  17572,
 -3460,  -3460,  -3460,
 -4564,  -4564,  -4564,
 23156,  23156,  23156,
 17656,  17656,  17656,
 -3480,  -3480,  -3480,
 -4553,  -4553,  -4553,
 23081,  23081,  23081,
 17739,  17739,  17739,
 -3499,  -3499,  -3499,
 -4542,  -4542,  -4542,
 23006,  23006,  23006,
 17822,  17822,  17822,
 -3518,  -3518,  -3518,
 -4530,  -4530,  -4530,
 22930,  22930,  22930,
 17906,  17906,  17906,
 -3538,  -3538,  -3538,
 -4519,  -4519,  -4519,
 22855,  22855,  22855,
 17989,  17989,  17989,
 -3557,  -3557,  -3557,
 -4507,  -4507,  -4507,
 22779,  22779,  22779,
 18072,  18072,  18072,
 -3576,  -3576,  -3576,
 -4496,  -4496,  -4496,
 22704,  22704,  22704,
 18155,  18155,  18155,
 -3595,  -3595,  -3595,
 -4484,  -4484,  -4484,
 22628,  22628,  22628,
 18238,  18238,  18238,
 -3614,  -3614,  -3614,
 -4472,  -4472,  -4472,
 22552,  22552,  22552,
 18321,  18321,  18321,
 -3633,  -3633,  -3633,
 -4459,  -4459,  -4459,
 22475,  22475,  22475,
 18403,  18403,  18403,
 -3651,  -3651,  -3651,
 -4447,  -4447,  -4447,
 22399,  22399,  22399,
 18486,  18486,  18486,
 -3670,  -3670,  -3670,
 -4434,  -4434,  -4434,
 22322,  22322,  22322,
 18569,  18569,  18569,
 -3689,  -3689,  -3689,
 -4422,  -4422,  -4422,
 22246,  22246,  22246,
 18651,  18651,  18651,
 -3707,  -3707,  -3707,
 -4409,  -4409,  -4409,
 22169,  22169,  22169,
 18734,  18734,  18734,
 -3726,  -3726,  -3726,
 -4396,  -4396,  -4396,
 22092,  22092,  22092,
 18816,  18816,  18816,
 -3744,  -3744,  -3744,
 -4382,  -4382,  -4382,
 22014,  22014,  22014,
 18898,  18898,  18898,
 -3762,  -3762,  -3762,
 -4369,  -4369,  -4369,
 21937,  21937,  21937,
 18980,  18980,  18980,
 -3780,  -3780,  -3780,
 -4356,  -4356,  -4356,
 21860,  21860,  21860,
 19062,  19062,  19062,
 -3798,  -3798,  -3798,
 -4342,  -4342,  -4342,
 21782,  21782,  21782,
 19144,  19144,  19144,
 -3816,  -3816,  -3816,
 -4328,  -4328,  -4328,
 21704,  21704,  21704,
 19226,  19226,  19226,
 -3834,  -3834,  -3834,
 -4314,  -4314,  -4314,
 21626,  21626,  21626,
 19308,  19308,  19308,
 -3852,  -3852,  -3852,
 -4300,  -4300,  -4300,
 21548,  21548,  21548,
 19389,  19389,  19389,
 -3869,  -3869,  -3869,
 -4286,  -4286,  -4286,
 21470,  21470,  21470,
 19471,  19471,  19471,
 -3887,  -3887,  -3887,
 -4271,  -4271,  -4271,
 21391,  21391,  21391,
 19552,  19552,  19552,
 -3904,  -3904,  -3904,
 -4257,  -4257,  -4257,
 21313,  21313,  21313,
 19633,  19633,  19633,
 -3921,  -3921,  -3921,
 -4242,  -4242,  -4242,
 21234,  21234,  21234,
 19715,  19715,  19715,
 -3939,  -3939,  -3939,
 -4227,  -4227,  -4227,
 21155,  21155,  21155,
 19796,  19796,  19796,
 -3956,  -3956,  -3956,
 -4212,  -4212,  -4212,
 21076,  21076,  21076,
 19877,  19877,  19877,
 -3973,  -3973,  -3973,
 -4197,  -4197,  -4197,
 20997,  20997,  20997,
 19957,  19957,  19957,
 -3989,  -3989,  -3989,
 -4182,  -4182,  -4182,
 20918,  20918,  20918,
 20038,  20038,  20038,
 -4006,  -4006,  -4006,
 -4167,  -4167,  -4167,
 20839,  20839,  20839,
 20119,  20119,  20119,
 -4023,  -4023,  -4023,
 -4151,  -4151,  -4151,
 20759,  20759,  20759,
 20199,  20199,  20199,
 -4039,  -4039,  -4039,
 -4136,  -4136,  -4136,
 20680,  20680,  20680,
 20280,  20280,  20280,
 -4056,  -4056,  -4056,
 -4120,  -4120,  -4120,
 20600,  20600,  20600,
 20360,  20360,  20360,
 -4072,  -4072,  -4072,
 -4104,  -4104,  -4104,
 20520,  20520,  20520,
 20440,  20440,  20440,
 -4088,  -4088,  -4088,
 -4088,  -4088,  -4088,
 20440,  20440,  20440,
 20520,  20520,  20520,
 -4104,  -4104,  -4104,
 -4072,  -4072,  -4072,
 20360,  20360,  20360,
 20600,  20600,  20600,
 -4120,  -4120,  -4120,
 -4056,  -4056,  -4056,
 20280,  20280,  20280,
 20680,  20680,  20680,
 -4136,  -4136,  -4136,
 -4039,  -4039,  -4039,
 20199,  20199,  20199,
 20759,  20759,  20759,
 -4151,  -4151,  -4151,
 -4023,  -4023,  -4023,
 20119,  20119,  20119,
 20839,  20839,  20839,
 -4167,  -4167,  -4167,
 -4006,  -4006,  -4006,
 20038,  20038,  20038,
 20918,  20918,  20918,
 -4182,  -4182,  -4182,
 -3989,  -3989,  -3989,
 19957,  19957,  19957,
 20997,  20997,  20997,
 -4197,  -4197,  -4197,
 -3973,  -3973,  -3973,
 19877,  19877,  19877,
 21076,  21076,  21076,
 -4212,  -4212,  -4212,
 -3956,  -3956,  -3956,
 19796,  19796,  19796,
 21155,  21155,  21155,
 -4227,  -4227,  -4227,
 -3939,  -3939,  -3939,
 19715,  19715,  19715,
 21234,  21234,  21234,
 -4242,  -4242,  -4242,
 -3921,  -3921,  -3921,
 19633,  19633,  19633,
 21313,  21313,  21313,
 -4257,  -4257,  -4257,
 -3904,  -3904,  -3904,
 19552,  19552,  19552,
 21391,  21391,  21391,
 -4271,  -4271,  -4271,
 -3887,  -3887,  -3887,
 19471,  19471,  19471,
 21470,  21470,  21470,
 -4286,  -4286,  -4286,
 -3869,  -3869,  -3869,
 19389,  19389,  19389,
 21548,  21548,  21548,
 -4300,  -4300,  -4300,
 -3852,  -3852,  -3852,
 19308,  19308,  19308,
 21626,  21626,  21626,
 -4314,  -4314,  -4314,
 -3834,  -3834,  -3834,
 19226,  19226,  19226,
 21704,  21704,  21704,
 -4328,  -4328,  -4328,
 -3816,  -3816,  -3816,
 19144,  19144,  19144,
 21782,  21782,  21782,
 -4342,  -4342,  -4342,
 -3798,  -3798,  -3798,
 19062,  19062,  19062,
 21860,  21860,  21860,
 -4356,  -4356,  -4356,
 -3780,  -3780,  -3780,
 18980,  18980,  18980,
 21937,  21937,  21937,
 -4369,  -4369,  -4369,
 -3762,  -3762,  -3762,
 18898,  18898,  18898,
 22014,  22014,  22014,
 -4382,  -4382,  -4382,
 -3744,  -3744,  -3744,
 18816,  18816,  18816,
 22092,  22092,  22092,
 -4396,  -4396,  -4396,
 -3726,  -3726,  -3726,
 18734,  18734,  18734,
 22169,  22169,  22169,
 -4409,  -4409,  -4409,
 -3707,  -3707,  -3707,
 18651,  18651,  18651,
 22246,  22246,  22246,
 -4422,  -4422,  -4422,
 -3689,  -3689,  -3689,
 18569,  18569,  18569,
 22322,  22322,  22322,
 -4434,  -4434,  -4434,
 -3670,  -3670,  -3670,
 18486,  18486,  18486,
 22399,  22399,  22399,
 -4447,  -4447,  -4447,
 -3651,  -3651,  -3651,
 18403,  18403,  18403,
 22475,  22475,  22475,
 -4459,  -4459,  -4459,
 -3633,  -3633,  -3633,
 18321,  18321,  18321,
 22552,  22552,  22552,
 -4472,  -4472,  -4472,
 -3614,  -3614,  -3614,
 18238,  18238,  18238,
 22628,  22628,  22628,
 -4484,  -4484,  -4484,
 -3595,  -3595,  -3595,
 18155,  18155,  18155,
 22704,  22704,  22704,
 -4496,  -4496,  -4496,
 -3576,  -3576,  -3576,
 18072,  18072,  18072,
 22779,  22779,  22779,
 -4507,  -4507,  -4507,
 -3557,  -3557,  -3557,
 17989,  17989,  17989,
 22855,  22855,  22855,
 -4519,  -4519,  -4519,
 -3538,  -3538,  -3538,
 17906,  17906,  17906,
 22930,  22930,  22930,
 -4530,  -4530,  -4530,
 -3518,  -3518,  -3518,
 17822,  17822,  17822,
 23006,  23006,  23006,
 -4542,  -4542,  -4542,
 -3499,  -3499,  -3499,
 17739,  17739,  17739,
 23081,  23081,  23081,
 -4553,  -4553,  -4553,
 -3480,  -3480,  -3480,
 17656,  17656,  17656,
 23156,  23156,  23156,
 -4564,  -4564,  -4564,
 -3460,  -3460,  -3460,
 17572,  17572,  17572,
 23230,  23230,  23230,
 -4574,  -4574,  -4574,
 -3441,  -3441,  -3441,
 17489,  17489,  17489,
 23305,  23305,  23305,
 -4585,  -4585,  -4585,
 -3421,  -3421,  -3421,
 17405,  17405,  17405,
 23379,  23379,  23379,
 -4595,  -4595,  -4595,
 -3401,  -3401,  -3401,
 17321,  17321,  17321,
 23453,  23453,  23453,
 -4605,  -4605,  -4605,
 -3382,  -3382,  -3382,
 17238,  17238,  17238,
 23527,  23527,  23527,
 -4615,  -4615,  -4615,
 -3362,  -3362,  -3362,
 17154,  17154,  17154,
 23601,  23601,  23601,
 -4625,  -4625,  -4625,
 -3342,  -3342,  -3342,
 17070,  17070,  17070,
 23675,  23675,  23675,
 -4635,  -4635,  -4635,
 -3322,  -3322,  -3322,
 16986,  16986,  16986,
 23748,  23748,  23748,
 -4644,  -4644,  -4644,
 -3302,  -3302,  -3302,
 16902,  16902,  16902,
 23822,  23822,  23822,
 -4654,  -4654,  -4654,
 -3282,  -3282,  -3282,
 16818,  16818,  16818,
 23895,  23895,  23895,
 -4663,  -4663,  -4663,
 -3262,  -3262,  -3262,
 16734,  16734,  16734,
 23968,  23968,  23968,
 -4672,  -4672,  -4672,
 -3241,  -3241,  -3241,
 16649,  16649,  16649,
 24040,  24040,  24040,
 -4680,  -4680,  -4680,
 -3221,  -3221,  -3221,
 16565,  16565,  16565,
 24113,  24113,  24113,
 -4689,  -4689,  -4689,
 -3201,  -3201,  -3201,
 16481,  16481,  16481,
 24185,  24185,  24185,
 -4697,  -4697,  -4697,
 -3180,  -3180,  -3180,
 16396,  16396,  16396,
 24257,  24257,  24257,
 -4705,  -4705,  -4705,
 -3160,  -3160,  -3160,
 16312,  16312,  16312,
 24329,  24329,  24329,
 -4713,  -4713,  -4713,
 -3140,  -3140,  -3140,
 16228,  16228,  16228,
 24401,  24401,  24401,
 -4721,  -4721,  -4721,
 -3119,  -3119,  -3119,
 16143,  16143,  16143,
 24472,  24472,  24472,
 -4728,  -4728,  -4728,
 -3098,  -3098,  -3098,
 16058,  16058,  16058,
 24544,  24544,  24544,
 -4736,  -4736,  -4736,
 -3078,  -3078,  -3078,
 15974,  15974,  15974,
 24615,  24615,  24615,
 -4743,  -4743,  -4743,
 -3057,  -3057,  -3057,
 15889,  15889,  15889,
 24686,  24686,  24686,
 -4750,  -4750,  -4750,
 -3037,  -3037,  -3037,
 15805,  15805,  15805,
 24756,  24756,  24756,
 -4756,  -4756,  -4756,
 -3016,  -3016,  -3016,
 15720,  15720,  15720,
 24827,  24827,  24827,
 -4763,  -4763,  -4763,
 -2995,  -2995,  -2995,
 15635,  15635,  15635,
 24897,  24897,  24897,
 -4769,  -4769,  -4769,
 -2974,  -2974,  -2974,
 15550,  15550,  15550,
 24967,  24967,  24967,
 -4775,  -4775,  -4775,
 -2953,  -2953,  -2953,
 15465,  15465,  15465,
 25037,  25037,  25037,
 -4781,  -4781,  -4781,
 -2932,  -2932,  -2932,
 15380,  15380,  15380,
 25107,  25107,  25107,
 -4787,  -4787,  -4787,
 -2911,  -2911,  -2911,
 15295,  15295,  15295,
 25176,  25176,  25176,
 -4792,  -4792,  -4792,
 -2890,  -2890,  -2890,
 15210,  15210,  15210,
 25245,  25245,  25245,
 -4797,  -4797,  -4797,
 -2869,  -2869,  -2869,
 15125,  15125,  15125,
 25314,  25314,  25314,
 -4802,  -4802,  -4802,
 -2848,  -2848,  -2848,
 15040,  15040,  15040,
 25383,  25383,  25383,
 -4807,  -4807,  -4807,
 -2827,  -2827,  -2827,
 14955,  14955,  14955,
 25452,  25452,  25452,
 -4812,  -4812,  -4812,
 -2806,  -2806,  -2806,
 14870,  14870,  14870,
 25520,  25520,  25520,
 -4816,  -4816,  -4816,
 -2785,  -2785,  -2785,
 14785,  14785,  14785,
 25588,  25588,  25588,
 -4820,  -4820,  -4820,
 -2764,  -2764,  -2764,
 14700,  14700,  14700,
 25656,  25656,  25656,
 -4824,  -4824,  -4824,
 -2743,  -2743,  -2743,
 14615,  14615,  14615,
 25724,  25724,  25724,
 -4828,  -4828,  -4828,
 -2722,  -2722,  -2722,
 14530,  14530,  14530,
 25791,  25791,  25791,
 -4831,  -4831,  -4831,
 -2701,  -2701,  -2701,
 14445,  14445,  14445,
 25858,  25858,  25858,
 -4834,  -4834,  -4834,
 -2679,  -2679,  -2679,
 14359,  14359,  14359,
 25925,  25925,  25925,
 -4837,  -4837,  -4837,
 -2658,  -2658,  -2658,
 14274,  14274,  14274,
 25992,  25992,  25992,
 -4840,  -4840,  -4840,
 -2637,  -2637,  -2637,
 14189,  14189,  14189,
 26059,  26059,  26059,
 -4843,  -4843,  -4843,
 -2616,  -2616,  -2616,
 14104,  14104,  14104,
 26125,  26125,  26125,
 -4845,  -4845,  -4845,
 -2594,  -2594,  -2594,
 14018,  14018,  14018,
 26191,  26191,  26191,
 -4847,  -4847,  -4847,
 -2573,  -2573,  -2573,
 13933,  13933,  13933,
 26257,  26257,  26257,
 -4849,  -4849,  -4849,
 -2552,  -2552,  -2552,
 13848,  13848,  13848,
 26322,  26322,  26322,
 -4850,  -4850,  -4850,
 -2530,  -2530,  -2530,
 13762,  13762,  13762,
 26388,  26388,  26388,
 -4852,  -4852,  -4852,
 -2509,  -2509,  -2509,
 13677,  13677,  13677,
 26453,  26453,  26453,
 -4853,  -4853,  -4853,
 -2488,  -2488,  -2488,
 13592,  13592,  13592,
 26518,  26518,  26518,
 -4854,  -4854,  -4854,
 -2466,  -2466,  -2466,
 13506,  13506,  13506,
 26582,  26582,  26582,
 -4854,  -4854,  -4854,
 -2445,  -2445,  -2445,
 13421,  13421,  13421,
 26646,  26646,  26646,
 -4854,  -4854,  -4854,
 -2424,  -2424,  -2424,
 13336,  13336,  13336,
 26711,  26711,  26711,
 -4855,  -4855,  -4855,
 -2402,  -2402,  -2402,
 13250,  13250,  13250,
 26774,  26774,  26774,
 -4854,  -4854,  -4854,
 -2381,  -2381,  -2381,
 13165,  13165,  13165,
 26838,  26838,  26838,
 -4854,  -4854,  -4854,
 -2360,  -2360,  -2360,
 13080,  13080,  13080,
 26901,  26901,  26901,
 -4853,  -4853,  -4853,
 -2338,  -2338,  -2338,
 12994,  12994,  12994,
 26964,  26964,  26964,
 -4852,  -4852,  -4852,
 -2317,  -2317,  -2317,
 12909,  12909,  12909,
 27027,  27027,  27027,
 -4851,  -4851,  -4851,
 -2296,  -2296,  -2296,
 12824,  12824,  12824,
 27090,  27090,  27090,
 -4850,  -4850,  -4850,
 -2274,  -2274,  -2274,
 12738,  12738,  12738,
 27152,  27152,  27152,
 -4848,  -4848,  -4848,
 -2253,  -2253,  -2253,
 12653,  12653,  12653,
 27214,  27214,  27214,
 -4846,  -4846,  -4846,
 -2232,  -2232,  -2232,
 12568,  12568,  12568,
 27276,  27276,  27276,
 -4844,  -4844,  -4844,
 -2211,  -2211,  -2211,
 12483,  12483,  12483,
 27337,  27337,  27337,
 -4841,  -4841,  -4841,
 -2189,  -2189,  -2189,
 12397,  12397,  12397,
 27399,  27399,  27399,
 -4839,  -4839,  -4839,
 -2168,  -2168,  -2168,
 12312,  12312,  12312,
 27460,  27460,  27460,
 -4836,  -4836,  -4836,
 -2147,  -2147,  -2147,
 12227,  12227,  12227,
 27520,  27520,  27520,
 -4832,  -4832,  -4832,
 -2126,  -2126,  -2126,
 12142,  12142,  12142,
 27581,  27581,  27581,
 -4829,  -4829,  -4829,
 -2105,  -2105,  -2105,
 12057,  12057,  12057,
 27641,  27641,  27641,
 -4825,  -4825,  -4825,
 -2083,  -2083,  -2083,
 11971,  11971,  11971,
 27701,  27701,  27701,
 -4821,  -4821,  -4821,
 -2062,  -2062,  -2062,
 11886,  11886,  11886,
 27760,  27760,  27760,
 -4816,  -4816,  -4816,
 -2041,  -2041,  -2041,
 11801,  11801,  11801,
 27820,  27820,  27820,
 -4812,  -4812,  -4812,
 -2020,  -2020,  -2020,
 11716,  11716,  11716,
 27879,  27879,  27879,
 -4807,  -4807,  -4807,
 -1999,  -1999,  -1999,
 11631,  11631,  11631,
 27938,  27938,  27938,
 -4802,  -4802,  -4802,
 -1978,  -1978,  -1978,
 11546,  11546,  11546,
 27996,  27996,  27996,
 -4796,  -4796,  -4796,
 -1957,  -1957,  -1957,
 11461,  11461,  11461,
 28054,  28054,  28054,
 -4790,  -4790,  -4790,
 -1936,  -1936,  -1936,
 11376,  11376,  11376,
 28112,  28112,  28112,
 -4784,  -4784,  -4784,
 -1915,  -1915,  -1915,
 11291,  11291,  11291,
 28170,  28170,  28170,
 -4778,  -4778,  -4778,
 -1894,  -1894,  -1894,
 11206,  11206,  11206,
 28227,  28227,  28227,
 -4771,  -4771,  -4771,
 -1873,  -1873,  -1873,
 11121,  11121,  11121,
 28285,  28285,  28285,
 -4765,  -4765,  -4765,
 -1853,  -1853,  -1853,
 11037,  11037,  11037,
 28341,  28341,  28341,
 -4757,  -4757,  -4757,
 -1832,  -1832,  -1832,
 10952,  10952,  10952,
 28398,  28398,  28398,
 -4750,  -4750,  -4750,
 -1811,  -1811,  -1811,
 10867,  10867,  10867,
 28454,  28454,  28454,
 -4742,  -4742,  -4742,
 -1790,  -1790,  -1790,
 10782,  10782,  10782,
 28510,  28510,  28510,
 -4734,  -4734,  -4734,
 -1770,  -1770,  -1770,
 10698,  10698,  10698,
 28566,  28566,  28566,
 -4726,  -4726,  -4726,
 -1749,  -1749,  -1749,
 10613,  10613,  10613,
 28621,  28621,  28621,
 -4717,  -4717,  -4717,
 -1729,  -1729,  -1729,
 10529,  10529,  10529,
 28676,  28676,  28676,
 -4708,  -4708,  -4708,
 -1708,  -1708,  -1708,
 10444,  10444,  10444,
 28731,  28731,  28731,
 -4699,  -4699,  -4699,
 -1688,  -1688,  -1688,
 10360,  10360,  10360,
 28785,  28785,  28785,
 -4689,  -4689,  -4689,
 -1667,  -1667,  -1667,
 10275,  10275,  10275,
 28839,  28839,  28839,
 -4679,  -4679,  -4679,
 -1647,  -1647,  -1647,
 10191,  10191,  10191,
 28893,  28893,  28893,
 -4669,  -4669,  -4669,
 -1627,  -1627,  -1627,
 10107,  10107,  10107,
 28947,  28947,  28947,
 -4659,  -4659,  -4659,
 -1606,  -1606,  -1606,
 10022,  10022,  10022,
 29000,  29000,  29000,
 -4648,  -4648,  -4648,
 -1586,  -1586,  -1586,
  9938,   9938,   9938,
 29053,  29053,  29053,
 -4637,  -4637,  -4637,
 -1566,  -1566,  -1566,
  9854,   9854,   9854,
 29106,  29106,  29106,
 -4626,  -4626,  -4626,
 -1546,  -1546,  -1546,
  9770,   9770,   9770,
 29158,  29158,  29158,
 -4614,  -4614,  -4614,
 -1526,  -1526,  -1526,
  9686,   9686,   9686,
 29210,  29210,  29210,
 -4602,  -4602,  -4602,
 -1506,  -1506,  -1506,
  9602,   9602,   9602,
 29262,  29262,  29262,
 -4590,  -4590,  -4590,
 -1486,  -1486,  -1486,
  9518,   9518,   9518,
 29313,  29313,  29313,
 -4577,  -4577,  -4577,
 -1466,  -1466,  -1466,
  9434,   9434,   9434,
 29364,  29364,  29364,
 -4564,  -4564,  -4564,
 -1447,  -1447,  -1447,
  9351,   9351,   9351,
 29415,  29415,  29415,
 -4551,  -4551,  -4551,
 -1427,  -1427,  -1427,
  9267,   9267,   9267,
 29465,  29465,  29465,
 -4537,  -4537,  -4537,
 -1407,  -1407,  -1407,
  9183,   9183,   9183,
 29515,  29515,  29515,
 -4523,  -4523,  -4523,
 -1388,  -1388,  -1388,
  9100,   9100,   9100,
 29565,  29565,  29565,
 -4509,  -4509,  -4509,
 -1368,  -1368,  -1368,
  9016,   9016,   9016,
 29615,  29615,  29615,
 -4495,  -4495,  -4495,
 -1349,  -1349,  -1349,
  8933,   8933,   8933,
 29664,  29664,  29664,
 -4480,  -4480,  -4480,
 -1330,  -1330,  -1330,
  8850,   8850,   8850,
 29712,  29712,  29712,
 -4464,  -4464,  -4464,
 -1311,  -1311,  -1311,
  8767,   8767,   8767,
 29761,  29761,  29761,
 -4449,  -4449,  -4449,
 -1291,  -1291,  -1291,
  8683,   8683,   8683,
 29809,  29809,  29809,
 -4433,  -4433,  -4433,
 -1272,  -1272,  -1272,
  8600,   8600,   8600,
 29857,  29857,  29857,
 -4417,  -4417,  -4417,
 -1253,  -1253,  -1253,
  8517,   8517,   8517,
 29904,  29904,  29904,
 -4400,  -4400,  -4400,
 -1234,  -1234,  -1234,
  8434,   8434,   8434,
 29952,  29952,  29952,
 -4384,  -4384,  -4384,
 -1216,  -1216,  -1216,
  8352,   8352,   8352,
 29998,  29998,  29998,
 -4366,  -4366,  -4366,
 -1197,  -1197,  -1197,
  8269,   8269,   8269,
 30045,  30045,  30045,
 -4349,  -4349,  -4349,
 -1178,  -1178,  -1178,
  8186,   8186,   8186,
 30091,  30091,  30091,
 -4331,  -4331,  -4331,
 -1160,  -1160,  -1160,
  8104,   8104,   8104,
 30137,  30137,  30137,
 -4313,  -4313,  -4313,
 -1141,  -1141,  -1141,
  8021,   8021,   8021,
 30182,  30182,  30182,
 -4294,  -4294,  -4294,
 -1123,  -1123,  -1123,
  7939,   7939,   7939,
 30227,  30227,  30227,
 -4275,  -4275,  -4275,
 -1105,  -1105,  -1105,
  7857,   7857,   7857,
 30272,  30272,  30272,
 -4256,  -4256,  -4256,
 -1086,  -1086,  -1086,
  7774,   7774,   7774,
 30317,  30317,  30317,
 -4237,  -4237,  -4237,
 -1068,  -1068,  -1068,
  7692,   7692,   7692,
 30361,  30361,  30361,
 -4217,  -4217,  -4217,
 -1050,  -1050,  -1050,
  7610,   7610,   7610,
 30404,  30404,  30404,
 -4196,  -4196,  -4196,
 -1032,  -1032,  -1032,
  7528,   7528,   7528,
 30448,  30448,  30448,
 -4176,  -4176,  -4176,
 -1015,  -1015,  -1015,
  7447,   7447,   7447,
 30491,  30491,  30491,
 -4155,  -4155,  -4155,
  -997,   -997,   -997,
  7365,   7365,   7365,
 30533,  30533,  30533,
 -4133,  -4133,  -4133,
  -979,   -979,   -979,
  7283,   7283,   7283,
 30576,  30576,  30576,
 -4112,  -4112,  -4112,
  -962,   -962,   -962,
  7202,   7202,   7202,
 30618,  30618,  30618,
 -4090,  -4090,  -4090,
  -945,   -945,   -945,
  7121,   7121,   7121,
 30659,  30659,  30659,
 -4067,  -4067,  -4067,
  -927,   -927,   -927,
  7039,   7039,   7039,
 30701,  30701,  30701,
 -4045,  -4045,  -4045,
  -910,   -910,   -910,
  6958,   6958,   6958,
 30741,  30741,  30741,
 -4021,  -4021,  -4021,
  -893,   -893,   -893,
  6877,   6877,   6877,
 30782,  30782,  30782,
 -3998,  -3998,  -3998,
  -876,   -876,   -876,
  6796,   6796,   6796,
 30822,  30822,  30822,
 -3974,  -3974,  -3974,
  -860,   -860,   -860,
  6716,   6716,   6716,
 30862,  30862,  30862,
 -3950,  -3950,  -3950,
  -843,   -843,   -843,
  6635,   6635,   6635,
 30901,  30901,  30901,
 -3925,  -3925,  -3925,
  -826,   -826,   -826,
  6554,   6554,   6554,
 30940,  30940,  30940,
 -3900,  -3900,  -3900,
  -810,   -810,   -810,
  6474,   6474,   6474,
 30979,  30979,  30979,
 -3875,  -3875,  -3875,
  -793,   -793,   -793,
  6393,   6393,   6393,
 31017,  31017,  31017,
 -3849,  -3849,  -3849,
  -777,   -777,   -777,
  6313,   6313,   6313,
 31055,  31055,  31055,
 -3823,  -3823,  -3823,
  -761,   -761,   -761,
  6233,   6233,   6233,
 31093,  31093,  31093,
 -3797,  -3797,  -3797,
  -745,   -745,   -745,
  6153,   6153,   6153,
 31130,  31130,  31130,
 -3770,  -3770,  -3770,
  -729,   -729,   -729,
  6073,   6073,   6073,
 31167,  31167,  31167,
 -3743,  -3743,  -3743,
  -714,   -714,   -714,
  5994,   5994,   5994,
 31204,  31204,  31204,
 -3716,  -3716,  -3716,
  -698,   -698,   -698,
  5914,   5914,   5914,
 31240,  31240,  31240,
 -3688,  -3688,  -3688,
  -683,   -683,   -683,
  5835,   5835,   5835,
 31275,  31275,  31275,
 -3659,  -3659,  -3659,
  -667,   -667,   -667,
  5755,   5755,   5755,
 31311,  31311,  31311,
 -3631,  -3631,  -3631,
  -652,   -652,   -652,
  5676,   5676,   5676,
 31346,  31346,  31346,
 -3602,  -3602,  -3602,
  -637,   -637,   -637,
  5597,   5597,   5597,
 31380,  31380,  31380,
 -3572,  -3572,  -3572,
  -622,   -622,   -622,
  5518,   5518,   5518,
 31414,  31414,  31414,
 -3542,  -3542,  -3542,
  -607,   -607,   -607,
  5439,   5439,   5439,
 31448,  31448,  31448,
 -3512,  -3512,  -3512,
  -593,   -593,   -593,
  5361,   5361,   5361,
 31481,  31481,  31481,
 -3481,  -3481,  -3481,
  -578,   -578,   -578,
  5282,   5282,   5282,
 31514,  31514,  31514,
 -3450,  -3450,  -3450,
  -564,   -564,   -564,
  5204,   5204,   5204,
 31547,  31547,  31547,
 -3419,  -3419,  -3419,
  -550,   -550,   -550,
  5126,   5126,   5126,
 31579,  31579,  31579,
 -3387,  -3387,  -3387,
  -536,   -536,   -536,
  5048,   5048,   5048,
 31611,  31611,  31611,
 -3355,  -3355,  -3355,
  -522,   -522,   -522,
  4970,   4970,   4970,
 31642,  31642,  31642,
 -3322,  -3322,  -3322,
  -508,   -508,   -508,
  4892,   4892,   4892,
 31673,  31673,  31673,
 -3289,  -3289,  -3289,
  -494,   -494,   -494,
  4814,   4814,   4814,
 31704,  31704,  31704,
 -3256,  -3256,  -3256,
  -481,   -481,   -481,
  4737,   4737,   4737,
 31734,  31734,  31734,
 -3222,  -3222,  -3222,
  -468,   -468,   -468,
  4660,   4660,   4660,
 31764,  31764,  31764,
 -3188,  -3188,  -3188,
  -455,   -455,   -455,
  4583,   4583,   4583,
 31793,  31793,  31793,
 -3153,  -3153,  -3153,
  -442,   -442,   -442,
  4506,   4506,   4506,
 31822,  31822,  31822,
 -3118,  -3118,  -3118,
  -429,   -429,   -429,
  4429,   4429,   4429,
 31851,  31851,  31851,
 -3083,  -3083,  -3083,
  -416,   -416,   -416,
  4352,   4352,   4352,
 31879,  31879,  31879,
 -3047,  -3047,  -3047,
  -403,   -403,   -403,
  4275,   4275,   4275,
 31907,  31907,  31907,
 -3011,  -3011,  -3011,
  -391,   -391,   -391,
  4199,   4199,   4199,
 31934,  31934,  31934,
 -2974,  -2974,  -2974,
  -379,   -379,   -379,
  4123,   4123,   4123,
 31961,  31961,  31961,
 -2937,  -2937,  -2937,
  -367,   -367,   -367,
  4047,   4047,   4047,
 31988,  31988,  31988,
 -2900,  -2900,  -2900,
  -355,   -355,   -355,
  3971,   3971,   3971,
 32014,  32014,  32014,
 -2862,  -2862,  -2862,
  -343,   -343,   -343,
  3895,   3895,   3895,
 32040,  32040,  32040,
 -2824,  -2824,  -2824,
  -332,   -332,   -332,
  3820,   3820,   3820,
 32065,  32065,  32065,
 -2785,  -2785,  -2785,
  -320,   -320,   -320,
  3744,   3744,   3744,
 32090,  32090,  32090,
 -2746,  -2746,  -2746,
  -309,   -309,   -309,
  3669,   3669,   3669,
 32114,  32114,  32114,
 -2706,  -2706,  -2706,
  -298,   -298,   -298,
  3594,   3594,   3594,
 32138,  32138,  32138,
 -2666,  -2666,  -2666,
  -287,   -287,   -287,
  3519,   3519,   3519,
 32162,  32162,  32162,
 -2626,  -2626,  -2626,
  -277,   -277,   -277,
  3445,   3445,   3445,
 32185,  32185,  32185,
 -2585,  -2585,  -2585,
  -266,   -266,   -266,
  3370,   3370,   3370,
 32208,  32208,  32208,
 -2544,  -2544,  -2544,
  -256,   -256,   -256,
  3296,   3296,   3296,
 32230,  32230,  32230,
 -2502,  -2502,  -2502,
  -246,   -246,   -246,
  3222,   3222,   3222,
 32252,  32252,  32252,
 -2460,  -2460,  -2460,
  -236,   -236,   -236,
  3148,   3148,   3148,
 32273,  32273,  32273,
 -2417,  -2417,  -2417,
  -226,   -226,   -226,
  3074,   3074,   3074,
 32294,  32294,  32294,
 -2374,  -2374,  -2374,
  -216,   -216,   -216,
  3000,   3000,   3000,
 32315,  32315,  32315,
 -2331,  -2331,  -2331,
  -207,   -207,   -207,
  2927,   2927,   2927,
 32335,  32335,  32335,
 -2287,  -2287,  -2287,
  -198,   -198,   -198,
  2854,   2854,   2854,
 32355,  32355,  32355,
 -2243,  -2243,  -2243,
  -189,   -189,   -189,
  2781,   2781,   2781,
 32374,  32374,  32374,
 -2198,  -2198,  -2198,
  -180,   -180,   -180,
  2708,   2708,   2708,
 32393,  32393,  32393,
 -2153,  -2153,  -2153,
  -171,   -171,   -171,
  2635,   2635,   2635,
 32411,  32411,  32411,
 -2107,  -2107,  -2107,
  -163,   -163,   -163,
  2563,   2563,   2563,
 32429,  32429,  32429,
 -2061,  -2061,  -2061,
  -155,   -155,   -155,
  2491,   2491,   2491,
 32447,  32447,  32447,
 -2015,  -2015,  -2015,
  -147,   -147,   -147,
  2419,   2419,   2419,
 32464,  32464,  32464,
 -1968,  -1968,  -1968,
  -139,   -139,   -139,
  2347,   2347,   2347,
 32480,  32480,  32480,
 -1920,  -1920,  -1920,
  -131,   -131,   -131,
  2275,   2275,   2275,
 32497,  32497,  32497,
 -1873,  -1873,  -1873,
  -124,   -124,   -124,
  2204,   2204,   2204,
 32512,  32512,  32512,
 -1824,  -1824,  -1824,
  -116,   -116,   -116,
  2132,   2132,   2132,
 32528,  32528,  32528,
 -1776,  -1776,  -1776,
  -109,   -109,   -109,
  2061,   2061,   2061,
 32542,  32542,  32542,
 -1726,  -1726,  -1726,
  -103,   -103,   -103,
  1991,   1991,   1991,
 32557,  32557,  32557,
 -1677,  -1677,  -1677,
   -96,    -96,    -96,
  1920,   1920,   1920,
 32571,  32571,  32571,
 -1627,  -1627,  -1627,
   -89,    -89,    -89,
  1849,   1849,   1849,
 32584,  32584,  32584,
 -1576,  -1576,  -1576,
   -83,    -83,    -83,
  1779,   1779,   1779,
 32597,  32597,  32597,
 -1525,  -1525,  -1525,
   -77,    -77,    -77,
  1709,   1709,   1709,
 32609,  32609,  32609,
 -1473,  -1473,  -1473,
   -71,    -71,    -71,
  1639,   1639,   1639,
 32622,  32622,  32622,
 -1422,  -1422,  -1422,
   -66,    -66,    -66,
  1570,   1570,   1570,
 32633,  32633,  32633,
 -1369,  -1369,  -1369,
   -61,    -61,    -61,
  1501,   1501,   1501,
 32644,  32644,  32644,
 -1316,  -1316,  -1316,
   -55,    -55,    -55,
  1431,   1431,   1431,
 32655,  32655,  32655,
 -1263,  -1263,  -1263,
   -50,    -50,    -50,
  1362,   1362,   1362,
 32665,  32665,  32665,
 -1209,  -1209,  -1209,
   -46,    -46,    -46,
  1294,   1294,   1294,
 32675,  32675,  32675,
 -1155,  -1155,  -1155,
   -41,    -41,    -41,
  1225,   1225,   1225,
 32684,  32684,  32684,
 -1100,  -1100,  -1100,
   -37,    -37,    -37,
  1157,   1157,   1157,
 32693,  32693,  32693,
 -1045,  -1045,  -1045,
   -33,    -33,    -33,
  1089,   1089,   1089,
 32701,  32701,  32701,
  -989,   -989,   -989,
   -29,    -29,    -29,
  1021,   1021,   1021,
 32709,  32709,  32709,
  -933,   -933,   -933,
   -26,    -26,    -26,
   954,    954,    954,
 32716,  32716,  32716,
  -876,   -876,   -876,
   -22,    -22,    -22,
   886,    886,    886,
 32723,  32723,  32723,
  -819,   -819,   -819,
   -19,    -19,    -19,
   819,    819,    819,
 32729,  32729,  32729,
  -761,   -761,   -761,
   -16,    -16,    -16,
   752,    752,    752,
 32735,  32735,  32735,
  -703,   -703,   -703,
   -13,    -13,    -13,
   685,    685,    685,
 32741,  32741,  32741,
  -645,   -645,   -645,
   -11,    -11,    -11,
   619,    619,    619,
 32746,  32746,  32746,
  -586,   -586,   -586,
    -9,     -9,     -9,
   553,    553,    553,
 32750,  32750,  32750,
  -526,   -526,   -526,
    -7,     -7,     -7,
   487,    487,    487,
 32754,  32754,  32754,
  -466,   -466,   -466,
    -5,     -5,     -5,
   421,    421,    421,
 32758,  32758,  32758,
  -406,   -406,   -406,
    -4,     -4,     -4,
   356,    356,    356,
 32760,  32760,  32760,
  -344,   -344,   -344,
    -3,     -3,     -3,
   291,    291,    291,
 32763,  32763,  32763,
  -283,   -283,   -283,
    -2,     -2,     -2,
   226,    226,    226,
 32765,  32765,  32765,
  -221,   -221,   -221,
    -1,     -1,     -1,
   161,    161,    161,
 32766,  32766,  32766,
  -158,   -158,   -158,
     0,      0,      0,
    96,     96,     96,
 32767,  32767,  32767,
   -95,    -95,    -95,
     0,      0,      0,
    32,     32,     32,
 32767,  32767,  32767,
   -32,    -32,    -32
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc_4[] = {
   -16,    -16,    -16,    -16,
 32767,  32767,  32767,  32767,
    16,     16,     16,     16,
     0,      0,      0,      0,
   -48,    -48,    -48,    -48,
 32767,  32767,  32767,  32767,
    49,     49,     49,     49,
     0,      0,      0,      0,
   -79,    -79,    -79,    -79,
 32766,  32766,  32766,  32766,
    82,     82,     82,     82,
     0,      0,      0,      0,
  -110,   -110,   -110,   -110,
 32764,  32764,  32764,  32764,
   115,    115,    115,    115,
    -1,     -1,     -1,     -1,
  -141,   -141,   -141,   -141,
 32762,  32762,  32762,  32762,
   149,    149,    149,    149,
    -1,     -1,     -1,     -1,
  -172,   -172,   -172,   -172,
 32759,  32759,  32759,  32759,
   184,    184,    184,    184,
    -2,     -2,     -2,     -2,
  -203,   -203,   -203,   -203,
 32755,  32755,  32755,  32755,
   218,    218,    218,    218,
    -3,     -3,     -3,     -3,
  -233,   -233,   -233,   -233,
 32751,  32751,  32751,  32751,
   254,    254,    254,    254,
    -3,     -3,     -3,     -3,
  -263,   -263,   -263,   -263,
 32746,  32746,  32746,  32746,
   290,    290,    290,    290,
    -4,     -4,     -4,     -4,
  -293,   -293,   -293,   -293,
 32740,  32740,  32740,  32740,
   326,    326,    326,    326,
    -6,     -6,     -6,     -6,
  -322,   -322,   -322,   -322,
 32734,  32734,  32734,  32734,
   363,    363,    363,    363,
    -7,     -7,     -7,     -7,
  -352,   -352,   -352,   -352,
 32727,  32727,  32727,  32727,
   401,    401,    401,    401,
    -8,     -8,     -8,     -8,
  -381,   -381,   -381,   -381,
 32720,  32720,  32720,  32720,
   438,    438,    438,    438,
   -10,    -10,    -10,    -10,
  -410,   -410,   -410,   -410,
 32712,  32712,  32712,  32712,
   477,    477,    477,    477,
   -11,    -11,    -11,    -11,
  -438,   -438,   -438,   -438,
 32703,  32703,  32703,  32703,
   515,    515,    515,    515,
   -13,    -13,    -13,    -13,
  -466,   -466,   -466,   -466,
 32694,  32694,  32694,  32694,
   555,    555,    555,    555,
   -15,    -15,    -15,    -15,
  -495,   -495,   -495,   -495,
 32685,  32685,  32685,  32685,
   594,    594,    594,    594,
   -16,    -16,    -16,    -16,
  -522,   -522,   -522,   -522,
 32674,  32674,  32674,  32674,
   635,    635,    635,    635,
   -18,    -18,    -18,    -18,
  -550,   -550,   -550,   -550,
 32663,  32663,  32663,  32663,
   675,    675,    675,    675,
   -21,    -21,    -21,    -21,
  -577,   -577,   -577,   -577,
 32652,  32652,  32652,  32652,
   716,    716,    716,    716,
   -23,    -23,    -23,    -23,
  -605,   -605,   -605,   -605,
 32640,  32640,  32640,  32640,
   758,    758,    758,    758,
   -25,    -25,    -25,    -25,
  -631,   -631,   -631,   -631,
 32627,  32627,  32627,  32627,
   800,    800,    800,    800,
   -28,    -28,    -28,    -28,
  -658,   -658,   -658,   -658,
 32614,  32614,  32614,  32614,
   842,    842,    842,    842,
   -30,    -30,    -30,    -30,
  -685,   -685,   -685,   -685,
 32600,  32600,  32600,  32600,
   885,    885,    885,    885,
   -33,    -33,    -33,    -33,
  -711,   -711,   -711,   -711,
 32586,  32586,  32586,  32586,
   929,    929,    929,    929,
   -36,    -36,    -36,    -36,
  -737,   -737,   -737,   -737,
 32571,  32571,  32571,  32571,
   972,    972,    972,    972,
   -39,    -39,    -39,    -39,
  -762,   -762,   -762,   -762,
 32555,  32555,  32555,  32555,
  1017,   1017,   1017,   1017,
   -42,    -42,    -42,    -42,
  -788,   -788,   -788,   -788,
 32539,  32539,  32539,  32539,
  1061,   1061,   1061,   1061,
   -45,    -45,    -45,    -45,
  -813,   -813,   -813,   -813,
 32523,  32523,  32523,  32523,
  1107,   1107,   1107,   1107,
   -48,    -48,    -48,    -48,
  -838,   -838,   -838,   -838,
 32505,  32505,  32505,  32505,
  1152,   1152,   1152,   1152,
   -51,    -51,    -51,    -51,
  -863,   -863,   -863,   -863,
 32488,  32488,  32488,  32488,
  1198,   1198,   1198,   1198,
   -55,    -55,    -55,    -55,
  -888,   -888,   -888,   -888,
 32469,  32469,  32469,  32469,
  1245,   1245,   1245,   1245,
   -58,    -58,    -58,    -58,
  -912,   -912,   -912,   -912,
 32450,  32450,  32450,  32450,
  1291,   1291,   1291,   1291,
   -62,    -62,    -62,    -62,
  -936,   -936,   -936,   -936,
 32431,  32431,  32431,  32431,
  1339,   1339,   1339,   1339,
   -66,    -66,    -66,    -66,
  -960,   -960,   -960,   -960,
 32411,  32411,  32411,  32411,
  1387,   1387,   1387,   1387,
   -69,    -69,    -69,    -69,
  -984,   -984,   -984,   -984,
 32391,  32391,  32391,  32391,
  1435,   1435,   1435,   1435,
   -73,    -73,    -73,    -73,
 -1007,  -1007,  -1007,  -1007,
 32369,  32369,  32369,  32369,
  1483,   1483,   1483,   1483,
   -77,    -77,    -77,    -77,
 -1031,  -1031,  -1031,  -1031,
 32348,  32348,  32348,  32348,
  1532,   1532,   1532,   1532,
   -81,    -81,    -81,    -81,
 -1054,  -1054,  -1054,  -1054,
 32326,  32326,  32326,  32326,
  1582,   1582,   1582,   1582,
   -86,    -86,    -86,    -86,
 -1076,  -1076,  -1076,  -1076,
 32303,  32303,  32303,  32303,
  1631,   1631,   1631,   1631,
   -90,    -90,    -90,    -90,
 -1099,  -1099,  -1099,  -1099,
 32280,  32280,  32280,  32280,
  1682,   1682,   1682,   1682,
   -94,    -94,    -94,    -94,
 -1121,  -1121,  -1121,  -1121,
 32256,  32256,  32256,  32256,
  1732,   1732,   1732,   1732,
   -99,    -99,    -99,    -99,
 -1144,  -1144,  -1144,  -1144,
 32232,  32232,  32232,  32232,
  1783,   1783,   1783,   1783,
  -104,   -104,   -104,   -104,
 -1166,  -1166,  -1166,  -1166,
 32207,  32207,  32207,  32207,
  1835,   1835,   1835,   1835,
  -108,   -108,   -108,   -108,
 -1187,  -1187,  -1187,  -1187,
 32181,  32181,  32181,  32181,
  1887,   1887,   1887,   1887,
  -113,   -113,   -113,   -113,
 -1209,  -1209,  -1209,  -1209,
 32156,  32156,  32156,  32156,
  1939,   1939,   1939,   1939,
  -118,   -118,   -118,   -118,
 -1230,  -1230,  -1230,  -1230,
 32129,  32129,  32129,  32129,
  1992,   1992,   1992,   1992,
  -123,   -123,   -123,   -123,
 -1251,  -1251,  -1251,  -1251,
 32102,  32102,  32102,  32102,
  2045,   2045,   2045,   2045,
  -128,   -128,   -128,   -128,
 -1272,  -1272,  -1272,  -1272,
 32075,  32075,  32075,  32075,
  2098,   2098,   2098,   2098,
  -133,   -133,   -133,   -133,
 -1293,  -1293,  -1293,  -1293,
 32047,  32047,  32047,  32047,
  2152,   2152,   2152,   2152,
  -138,   -138,   -138,   -138,
 -1313,  -1313,  -1313,  -1313,
 32018,  32018,  32018,  32018,
  2206,   2206,   2206,   2206,
  -144,   -144,   -144,   -144,
 -1333,  -1333,  -1333,  -1333,
 31989,  31989,  31989,  31989,
  2261,   2261,   2261,   2261,
  -149,   -149,   -149,   -149,
 -1353,  -1353,  -1353,  -1353,
 31960,  31960,  31960,  31960,
  2316,   2316,   2316,   2316,
  -155,   -155,   -155,   -155,
 -1373,  -1373,  -1373,  -1373,
 31930,  31930,  31930,  31930,
  2371,   2371,   2371,   2371,
  -160,   -160,   -160,   -160,
 -1392,  -1392,  -1392,  -1392,
 31899,  31899,  31899,  31899,
  2427,   2427,   2427,   2427,
  -166,   -166,   -166,   -166,
 -1412,  -1412,  -1412,  -1412,
 31868,  31868,  31868,  31868,
  2483,   2483,   2483,   2483,
  -172,   -172,   -172,   -172,
 -1431,  -1431,  -1431,  -1431,
 31836,  31836,  31836,  31836,
  2540,   2540,   2540,   2540,
  -177,   -177,   -177,   -177,
 -1450,  -1450,  -1450,  -1450,
 31804,  31804,  31804,  31804,
  2597,   2597,   2597,   2597,
  -183,   -183,   -183,   -183,
 -1469,  -1469,  -1469,  -1469,
 31772,  31772,  31772,  31772,
  2654,   2654,   2654,   2654,
  -189,   -189,   -189,   -189,
 -1487,  -1487,  -1487,  -1487,
 31739,  31739,  31739,  31739,
  2712,   2712,   2712,   2712,
  -196,   -196,   -196,   -196,
 -1506,  -1506,  -1506,  -1506,
 31705,  31705,  31705,  31705,
  2770,   2770,   2770,   2770,
  -202,   -202,   -202,   -202,
 -1524,  -1524,  -1524,  -1524,
 31671,  31671,  31671,  31671,
  2828,   2828,   2828,   2828,
  -208,   -208,   -208,   -208,
 -1542,  -1542,  -1542,  -1542,
 31637,  31637,  31637,  31637,
  2887,   2887,   2887,   2887,
  -214,   -214,   -214,   -214,
 -1559,  -1559,  -1559,  -1559,
 31602,  31602,  31602,  31602,
  2946,   2946,   2946,   2946,
  -221,   -221,   -221,   -221,
 -1577,  -1577,  -1577,  -1577,
 31566,  31566,  31566,  31566,
  3006,   3006,   3006,   3006,
  -227,   -227,   -227,   -227,
 -1594,  -1594,  -1594,  -1594,
 31530,  31530,  31530,  31530,
  3066,   3066,   3066,   3066,
  -234,   -234,   -234,   -234,
 -1611,  -1611,  -1611,  -1611,
 31494,  31494,  31494,  31494,
  3126,   3126,   3126,   3126,
  -240,   -240,   -240,   -240,
 -1628,  -1628,  -1628,  -1628,
 31457,  31457,  31457,  31457,
  3186,   3186,   3186,   3186,
  -247,   -247,   -247,   -247,
 -1645,  -1645,  -1645,  -1645,
 31419,  31419,  31419,  31419,
  3247,   3247,   3247,   3247,
  -254,   -254,   -254,   -254,
 -1661,  -1661,  -1661,  -1661,
 31381,  31381,  31381,  31381,
  3309,   3309,   3309,   3309,
  -261,   -261,   -261,   -261,
 -1677,  -1677,  -1677,  -1677,
 31343,  31343,  31343,  31343,
  3370,   3370,   3370,   3370,
  -268,   -268,   -268,   -268,
 -1694,  -1694,  -1694,  -1694,
 31304,  31304,  31304,  31304,
  3432,   3432,   3432,   3432,
  -275,   -275,   -275,   -275,
 -1709,  -1709,  -1709,  -1709,
 31265,  31265,  31265,  31265,
  3495,   3495,   3495,   3495,
  -282,   -282,   -282,   -282,
 -1725,  -1725,  -1725,  -1725,
 31225,  31225,  31225,  31225,
  3557,   3557,   3557,   3557,
  -289,   -289,   -289,   -289,
 -1741,  -1741,  -1741,  -1741,
 31185,  31185,  31185,  31185,
  3620,   3620,   3620,   3620,
  -296,   -296,   -296,   -296,
 -1756,  -1756,  -1756,  -1756,
 31144,  31144,  31144,  31144,
  3683,   3683,   3683,   3683,
  -304,   -304,   -304,   -304,
 -1771,  -1771,  -1771,  -1771,
 31103,  31103,  31103,  31103,
  3747,   3747,   3747,   3747,
  -311,   -311,   -311,   -311,
 -1786,  -1786,  -1786,  -1786,
 31062,  31062,  31062,  31062,
  3811,   3811,   3811,   3811,
  -319,   -319,   -319,   -319,
 -1801,  -1801,  -1801,  -1801,
 31019,  31019,  31019,  31019,
  3875,   3875,   3875,   3875,
  -326,   -326,   -326,   -326,
 -1815,  -1815,  -1815,  -1815,
 30977,  30977,  30977,  30977,
  3940,   3940,   3940,   3940,
  -334,   -334,   -334,   -334,
 -1830,  -1830,  -1830,  -1830,
 30934,  30934,  30934,  30934,
  4005,   4005,   4005,   4005,
  -341,   -341,   -341,   -341,
 -1844,  -1844,  -1844,  -1844,
 30891,  30891,  30891,  30891,
  4070,   4070,   4070,   4070,
  -349,   -349,   -349,   -349,
 -1858,  -1858,  -1858,  -1858,
 30847,  30847,  30847,  30847,
  4136,   4136,   4136,   4136,
  -357,   -357,   -357,   -357,
 -1872,  -1872,  -1872,  -1872,
 30802,  30802,  30802,  30802,
  4202,   4202,   4202,   4202,
  -365,   -365,   -365,   -365,
 -1885,  -1885,  -1885,  -1885,
 30758,  30758,  30758,  30758,
  4268,   4268,   4268,   4268,
  -373,   -373,   -373,   -373,
 -1899,  -1899,  -1899,  -1899,
 30712,  30712,  30712,  30712,
  4335,   4335,   4335,   4335,
  -381,   -381,   -381,   -381,
 -1912,  -1912,  -1912,  -1912,
 30667,  30667,  30667,  30667,
  4402,   4402,   4402,   4402,
  -389,   -389,   -389,   -389,
 -1925,  -1925,  -1925,  -1925,
 30621,  30621,  30621,  30621,
  4469,   4469,   4469,   4469,
  -397,   -397,   -397,   -397,
 -1938,  -1938,  -1938,  -1938,
 30574,  30574,  30574,  30574,
  4536,   4536,   4536,   4536,
  -405,   -405,   -405,   -405,
 -1950,  -1950,  -1950,  -1950,
 30527,  30527,  30527,  30527,
  4604,   4604,   4604,   4604,
  -413,   -413,   -413,   -413,
 -1963,  -1963,  -1963,  -1963,
 30480,  30480,  30480,  30480,
  4672,   4672,   4672,   4672,
  -421,   -421,   -421,   -421,
 -1975,  -1975,  -1975,  -1975,
 30432,  30432,  30432,  30432,
  4741,   4741,   4741,   4741,
  -430,   -430,   -430,   -430,
 -1987,  -1987,  -1987,  -1987,
 30384,  30384,  30384,  30384,
  4809,   4809,   4809,   4809,
  -438,   -438,   -438,   -438,
 -1999,  -1999,  -1999,  -1999,
 30335,  30335,  30335,  30335,
  4878,   4878,   4878,   4878,
  -447,   -447,   -447,   -447,
 -2011,  -2011,  -2011,  -2011,
 30286,  30286,  30286,  30286,
  4948,   4948,   4948,   4948,
  -455,   -455,   -455,   -455,
 -2022,  -2022,  -2022,  -2022,
 30237,  30237,  30237,  30237,
  5017,   5017,   5017,   5017,
  -464,   -464,   -464,   -464,
 -2034,  -2034,  -2034,  -2034,
 30187,  30187,  30187,  30187,
  5087,   5087,   5087,   5087,
  -472,   -472,   -472,   -472,
 -2045,  -2045,  -2045,  -2045,
 30137,  30137,  30137,  30137,
  5157,   5157,   5157,   5157,
  -481,   -481,   -481,   -481,
 -2056,  -2056,  -2056,  -2056,
 30086,  30086,  30086,  30086,
  5228,   5228,   5228,   5228,
  -490,   -490,   -490,   -490,
 -2067,  -2067,  -2067,  -2067,
 30035,  30035,  30035,  30035,
  5298,   5298,   5298,   5298,
  -499,   -499,   -499,   -499,
 -2077,  -2077,  -2077,  -2077,
 29983,  29983,  29983,  29983,
  5369,   5369,   5369,   5369,
  -507,   -507,   -507,   -507,
 -2088,  -2088,  -2088,  -2088,
 29931,  29931,  29931,  29931,
  5441,   5441,   5441,   5441,
  -516,   -516,   -516,   -516,
 -2098,  -2098,  -2098,  -2098,
 29879,  29879,  29879,  29879,
  5512,   5512,   5512,   5512,
  -525,   -525,   -525,   -525,
 -2108,  -2108,  -2108,  -2108,
 29826,  29826,  29826,  29826,
  5584,   5584,   5584,   5584,
  -534,   -534,   -534,   -534,
 -2118,  -2118,  -2118,  -2118,
 29773,  29773,  29773,  29773,
  5656,   5656,   5656,   5656,
  -543,   -543,   -543,   -543,
 -2128,  -2128,  -2128,  -2128,
 29720,  29720,  29720,  29720,
  5729,   5729,   5729,   5729,
  -552,   -552,   -552,   -552,
 -2138,  -2138,  -2138,  -2138,
 29666,  29666,  29666,  29666,
  5801,   5801,   5801,   5801,
  -561,   -561,   -561,   -561,
 -2147,  -2147,  -2147,  -2147,
 29612,  29612,  29612,  29612,
  5874,   5874,   5874,   5874,
  -571,   -571,   -571,   -571,
 -2156,  -2156,  -2156,  -2156,
 29557,  29557,  29557,  29557,
  5947,   5947,   5947,   5947,
  -580,   -580,   -580,   -580,
 -2165,  -2165,  -2165,  -2165,
 29502,  29502,  29502,  29502,
  6021,   6021,   6021,   6021,
  -589,   -589,   -589,   -589,
 -2174,  -2174,  -2174,  -2174,
 29446,  29446,  29446,  29446,
  6094,   6094,   6094,   6094,
  -598,   -598,   -598,   -598,
 -2183,  -2183,  -2183,  -2183,
 29391,  29391,  29391,  29391,
  6168,   6168,   6168,   6168,
  -608,   -608,   -608,   -608,
 -2192,  -2192,  -2192,  -2192,
 29334,  29334,  29334,  29334,
  6243,   6243,   6243,   6243,
  -617,   -617,   -617,   -617,
 -2200,  -2200,  -2200,  -2200,
 29278,  29278,  29278,  29278,
  6317,   6317,   6317,   6317,
  -627,   -627,   -627,   -627,
 -2208,  -2208,  -2208,  -2208,
 29221,  29221,  29221,  29221,
  6392,   6392,   6392,   6392,
  -636,   -636,   -636,   -636,
 -2217,  -2217,  -2217,  -2217,
 29163,  29163,  29163,  29163,
  6467,   6467,   6467,   6467,
  -646,   -646,   -646,   -646,
 -2224,  -2224,  -2224,  -2224,
 29106,  29106,  29106,  29106,
  6542,   6542,   6542,   6542,
  -655,   -655,   -655,   -655,
 -2232,  -2232,  -2232,  -2232,
 29048,  29048,  29048,  29048,
  6617,   6617,   6617,   6617,
  -665,   -665,   -665,   -665,
 -2240,  -2240,  -2240,  -2240,
 28989,  28989,  28989,  28989,
  6693,   6693,   6693,   6693,
  -675,   -675,   -675,   -675,
 -2247,  -2247,  -2247,  -2247,
 28930,  28930,  28930,  28930,
  6769,   6769,   6769,   6769,
  -684,   -684,   -684,   -684,
 -2255,  -2255,  -2255,  -2255,
 28871,  28871,  28871,  28871,
  6845,   6845,   6845,   6845,
  -694,   -694,   -694,   -694,
 -2262,  -2262,  -2262,  -2262,
 28812,  28812,  28812,  28812,
  6922,   6922,   6922,   6922,
  -704,   -704,   -704,   -704,
 -2269,  -2269,  -2269,  -2269,
 28752,  28752,  28752,  28752,
  6998,   6998,   6998,   6998,
  -713,   -713,   -713,   -713,
 -2275,  -2275,  -2275,  -2275,
 28691,  28691,  28691,  28691,
  7075,   7075,   7075,   7075,
  -723,   -723,   -723,   -723,
 -2282,  -2282,  -2282,  -2282,
 28631,  28631,  28631,  28631,
  7152,   7152,   7152,   7152,
  -733,   -733,   -733,   -733,
 -2289,  -2289,  -2289,  -2289,
 28570,  28570,  28570,  28570,
  7230,   7230,   7230,   7230,
  -743,   -743,   -743,   -743,
 -2295,  -2295,  -2295,  -2295,
 28509,  28509,  28509,  28509,
  7307,   7307,   7307,   7307,
  -753,   -753,   -753,   -753,
 -2301,  -2301,  -2301,  -2301,
 28447,  28447,  28447,  28447,
  7385,   7385,   7385,   7385,
  -763,   -763,   -763,   -763,
 -2307,  -2307,  -2307,  -2307,
 28385,  28385,  28385,  28385,
  7463,   7463,   7463,   7463,
  -773,   -773,   -773,   -773,
 -2313,  -2313,  -2313,  -2313,
 28323,  28323,  28323,  28323,
  7541,   7541,   7541,   7541,
  -783,   -783,   -783,   -783,
 -2319,  -2319,  -2319,  -2319,
 28260,  28260,  28260,  28260,
  7620,   7620,   7620,   7620,
  -793,   -793,   -793,   -793,
 -2324,  -2324,  -2324,  -2324,
 28197,  28197,  28197,  28197,
  7698,   7698,   7698,   7698,
  -803,   -803,   -803,   -803,
 -2329,  -2329,  -2329,  -2329,
 28134,  28134,  28134,  28134,
  7777,   7777,   7777,   7777,
  -813,   -813,   -813,   -813,
 -2335,  -2335,  -2335,  -2335,
 28070,  28070,  28070,  28070,
  7856,   7856,   7856,   7856,
  -823,   -823,   -823,   -823,
 -2340,  -2340,  -2340,  -2340,
 28006,  28006,  28006,  28006,
  7936,   7936,   7936,   7936,
  -834,   -834,   -834,   -834,
 -2345,  -2345,  -2345,  -2345,
 27941,  27941,  27941,  27941,
  8015,   8015,   8015,   8015,
  -844,   -844,   -844,   -844,
 -2349,  -2349,  -2349,  -2349,
 27877,  27877,  27877,  27877,
  8095,   8095,   8095,   8095,
  -854,   -854,   -854,   -854,
 -2354,  -2354,  -2354,  -2354,
 27812,  27812,  27812,  27812,
  8175,   8175,   8175,   8175,
  -864,   -864,   -864,   -864,
 -2359,  -2359,  -2359,  -2359,
 27746,  27746,  27746,  27746,
  8255,   8255,   8255,   8255,
  -875,   -875,   -875,   -875,
 -2363,  -2363,  -2363,  -2363,
 27681,  27681,  27681,  27681,
  8335,   8335,   8335,   8335,
  -885,   -885,   -885,   -885,
 -2367,  -2367,  -2367,  -2367,
 27615,  27615,  27615,  27615,
  8415,   8415,   8415,   8415,
  -895,   -895,   -895,   -895,
 -2371,  -2371,  -2371,  -2371,
 27549,  27549,  27549,  27549,
  8496,   8496,   8496,   8496,
  -906,   -906,   -906,   -906,
 -2375,  -2375,  -2375,  -2375,
 27482,  27482,  27482,  27482,
  8577,   8577,   8577,   8577,
  -916,   -916,   -916,   -916,
 -2379,  -2379,  -2379,  -2379,
 27415,  27415,  27415,  27415,
  8658,   8658,   8658,   8658,
  -926,   -926,   -926,   -926,
 -2382,  -2382,  -2382,  -2382,
 27348,  27348,  27348,  27348,
  8739,   8739,   8739,   8739,
  -937,   -937,   -937,   -937,
 -2386,  -2386,  -2386,  -2386,
 27280,  27280,  27280,  27280,
  8821,   8821,   8821,   8821,
  -947,   -947,   -947,   -947,
 -2389,  -2389,  -2389,  -2389,
 27212,  27212,  27212,  27212,
  8902,   8902,   8902,   8902,
  -958,   -958,   -958,   -958,
 -2392,  -2392,  -2392,  -2392,
 27144,  27144,  27144,  27144,
  8984,   8984,   8984,   8984,
  -968,   -968,   -968,   -968,
 -2395,  -2395,  -2395,  -2395,
 27076,  27076,  27076,  27076,
  9066,   9066,   9066,   9066,
  -979,   -979,   -979,   -979,
 -2398,  -2398,  -2398,  -2398,
 27007,  27007,  27007,  27007,
  9148,   9148,   9148,   9148,
  -989,   -989,   -989,   -989,
 -2401,  -2401,  -2401,  -2401,
 26938,  26938,  26938,  26938,
  9230,   9230,   9230,   9230,
 -1000,  -1000,  -1000,  -1000,
 -2403,  -2403,  -2403,  -2403,
 26869,  26869,  26869,  26869,
  9313,   9313,   9313,   9313,
 -1010,  -1010,  -1010,  -1010,
 -2406,  -2406,  -2406,  -2406,
 26799,  26799,  26799,  26799,
  9395,   9395,   9395,   9395,
 -1021,  -1021,  -1021,  -1021,
 -2408,  -2408,  -2408,  -2408,
 26729,  26729,  26729,  26729,
  9478,   9478,   9478,   9478,
 -1031,  -1031,  -1031,  -1031,
 -2410,  -2410,  -2410,  -2410,
 26659,  26659,  26659,  26659,
  9561,   9561,   9561,   9561,
 -1042,  -1042,  -1042,  -1042,
 -2412,  -2412,  -2412,  -2412,
 26589,  26589,  26589,  26589,
  9644,   9644,   9644,   9644,
 -1052,  -1052,  -1052,  -1052,
 -2414,  -2414,  -2414,  -2414,
 26518,  26518,  26518,  26518,
  9727,   9727,   9727,   9727,
 -1063,  -1063,  -1063,  -1063,
 -2416,  -2416,  -2416,  -2416,
 26447,  26447,  26447,  26447,
  9811,   9811,   9811,   9811,
 -1073,  -1073,  -1073,  -1073,
 -2418,  -2418,  -2418,  -2418,
 26376,  26376,  26376,  26376,
  9894,   9894,   9894,   9894,
 -1084,  -1084,  -1084,  -1084,
 -2419,  -2419,  -2419,  -2419,
 26304,  26304,  26304,  26304,
  9978,   9978,   9978,   9978,
 -1095,  -1095,  -1095,  -1095,
 -2421,  -2421,  -2421,  -2421,
 26232,  26232,  26232,  26232,
 10062,  10062,  10062,  10062,
 -1105,  -1105,  -1105,  -1105,
 -2422,  -2422,  -2422,  -2422,
 26160,  26160,  26160,  26160,
 10146,  10146,  10146,  10146,
 -1116,  -1116,  -1116,  -1116,
 -2423,  -2423,  -2423,  -2423,
 26087,  26087,  26087,  26087,
 10230,  10230,  10230,  10230,
 -1127,  -1127,  -1127,  -1127,
 -2424,  -2424,  -2424,  -2424,
 26015,  26015,  26015,  26015,
 10314,  10314,  10314,  10314,
 -1137,  -1137,  -1137,  -1137,
 -2425,  -2425,  -2425,  -2425,
 25942,  25942,  25942,  25942,
 10399,  10399,  10399,  10399,
 -1148,  -1148,  -1148,  -1148,
 -2426,  -2426,  -2426,  -2426,
 25869,  25869,  25869,  25869,
 10483,  10483,  10483,  10483,
 -1159,  -1159,  -1159,  -1159,
 -2426,  -2426,  -2426,  -2426,
 25795,  25795,  25795,  25795,
 10568,  10568,  10568,  10568,
 -1169,  -1169,  -1169,  -1169,
 -2427,  -2427,  -2427,  -2427,
 25721,  25721,  25721,  25721,
 10653,  10653,  10653,  10653,
 -1180,  -1180,  -1180,  -1180,
 -2427,  -2427,  -2427,  -2427,
 25647,  25647,  25647,  25647,
 10738,  10738,  10738,  10738,
 -1191,  -1191,  -1191,  -1191,
 -2427,  -2427,  -2427,  -2427,
 25573,  25573,  25573,  25573,
 10823,  10823,  10823,  10823,
 -1201,  -1201,  -1201,  -1201,
 -2427,  -2427,  -2427,  -2427,
 25499,  25499,  25499,  25499,
 10908,  10908,  10908,  10908,
 -1212,  -1212,  -1212,  -1212,
 -2427,  -2427,  -2427,  -2427,
 25424,  25424,  25424,  25424,
 10994,  10994,  10994,  10994,
 -1223,  -1223,  -1223,  -1223,
 -2427,  -2427,  -2427,  -2427,
 25349,  25349,  25349,  25349,
 11079,  11079,  11079,  11079,
 -1233,  -1233,  -1233,  -1233,
 -2427,  -2427,  -2427,  -2427,
 25274,  25274,  25274,  25274,
 11165,  11165,  11165,  11165,
 -1244,  -1244,  -1244,  -1244,
 -2426,  -2426,  -2426,  -2426,
 25198,  25198,  25198,  25198,
 11251,  11251,  11251,  11251,
 -1255,  -1255,  -1255,  -1255,
 -2426,  -2426,  -2426,  -2426,
 25122,  25122,  25122,  25122,
 11337,  11337,  11337,  11337,
 -1265,  -1265,  -1265,  -1265,
 -2425,  -2425,  -2425,  -2425,
 25046,  25046,  25046,  25046,
 11422,  11422,  11422,  11422,
 -1276,  -1276,  -1276,  -1276,
 -2424,  -2424,  -2424,  -2424,
 24970,  24970,  24970,  24970,
 11509,  11509,  11509,  11509,
 -1286,  -1286,  -1286,  -1286,
 -2423,  -2423,  -2423,  -2423,
 24894,  24894,  24894,  24894,
 11595,  11595,  11595,  11595,
 -1297,  -1297,  -1297,  -1297,
 -2422,  -2422,  -2422,  -2422,
 24817,  24817,  24817,  24817,
 11681,  11681,  11681,  11681,
 -1308,  -1308,  -1308,  -1308,
 -2421,  -2421,  -2421,  -2421,
 24740,  24740,  24740,  24740,
 11767,  11767,  11767,  11767,
 -1318,  -1318,  -1318,  -1318,
 -2420,  -2420,  -2420,  -2420,
 24663,  24663,  24663,  24663,
 11854,  11854,  11854,  11854,
 -1329,  -1329,  -1329,  -1329,
 -2419,  -2419,  -2419,  -2419,
 24586,  24586,  24586,  24586,
 11941,  11941,  11941,  11941,
 -1340,  -1340,  -1340,  -1340,
 -2417,  -2417,  -2417,  -2417,
 24508,  24508,  24508,  24508,
 12027,  12027,  12027,  12027,
 -1350,  -1350,  -1350,  -1350,
 -2416,  -2416,  -2416,  -2416,
 24430,  24430,  24430,  24430,
 12114,  12114,  12114,  12114,
 -1361,  -1361,  -1361,  -1361,
 -2414,  -2414,  -2414,  -2414,
 24352,  24352,  24352,  24352,
 12201,  12201,  12201,  12201,
 -1371,  -1371,  -1371,  -1371,
 -2412,  -2412,  -2412,  -2412,
 24274,  24274,  24274,  24274,
 12288,  12288,  12288,  12288,
 -1382,  -1382,  -1382,  -1382,
 -2410,  -2410,  -2410,  -2410,
 24196,  24196,  24196,  24196,
 12375,  12375,  12375,  12375,
 -1393,  -1393,  -1393,  -1393,
 -2408,  -2408,  -2408,  -2408,
 24117,  24117,  24117,  24117,
 12462,  12462,  12462,  12462,
 -1403,  -1403,  -1403,  -1403,
 -2406,  -2406,  -2406,  -2406,
 24038,  24038,  24038,  24038,
 12549,  12549,  12549,  12549,
 -1414,  -1414,  -1414,  -1414,
 -2404,  -2404,  -2404,  -2404,
 23959,  23959,  23959,  23959,
 12637,  12637,  12637,  12637,
 -1424,  -1424,  -1424,  -1424,
 -2401,  -2401,  -2401,  -2401,
 23880,  23880,  23880,  23880,
 12724,  12724,  12724,  12724,
 -1435,  -1435,  -1435,  -1435,
 -2399,  -2399,  -2399,  -2399,
 23800,  23800,  23800,  23800,
 12812,  12812,  12812,  12812,
 -1445,  -1445,  -1445,  -1445,
 -2396,  -2396,  -2396,  -2396,
 23721,  23721,  23721,  23721,
 12899,  12899,  12899,  12899,
 -1456,  -1456,  -1456,  -1456,
 -2393,  -2393,  -2393,  -2393,
 23641,  23641,  23641,  23641,
 12987,  12987,  12987,  12987,
 -1466,  -1466,  -1466,  -1466,
 -2391,  -2391,  -2391,  -2391,
 23561,  23561,  23561,  23561,
 13075,  13075,  13075,  13075,
 -1477,  -1477,  -1477,  -1477,
 -2388,  -2388,  -2388,  -2388,
 23480,  23480,  23480,  23480,
 13163,  13163,  13163,  13163,
 -1487,  -1487,  -1487,  -1487,
 -2385,  -2385,  -2385,  -2385,
 23400,  23400,  23400,  23400,
 13250,  13250,  13250,  13250,
 -1497,  -1497,  -1497,  -1497,
 -2381,  -2381,  -2381,  -2381,
 23319,  23319,  23319,  23319,
 13338,  13338,  13338,  13338,
 -1508,  -1508,  -1508,  -1508,
 -2378,  -2378,  -2378,  -2378,
 23238,  23238,  23238,  23238,
 13426,  13426,  13426,  13426,
 -1518,  -1518,  -1518,  -1518,
 -2375,  -2375,  -2375,  -2375,
 23157,  23157,  23157,  23157,
 13514,  13514,  13514,  13514,
 -1529,  -1529,  -1529,  -1529,
 -2371,  -2371,  -2371,  -2371,
 23076,  23076,  23076,  23076,
 13602,  13602,  13602,  13602,
 -1539,  -1539,  -1539,  -1539,
 -2368,  -2368,  -2368,  -2368,
 22994,  22994,  22994,  22994,
 13691,  13691,  13691,  13691,
 -1549,  -1549,  -1549,  -1549,
 -2364,  -2364,  -2364,  -2364,
 22913,  22913,  22913,  22913,
 13779,  13779,  13779,  13779,
 -1560,  -1560,  -1560,  -1560,
 -2360,  -2360,  -2360,  -2360,
 22831,  22831,  22831,  22831,
 13867,  13867,  13867,  13867,
 -1570,  -1570,  -1570,  -1570,
 -2357,  -2357,  -2357,  -2357,
 22749,  22749,  22749,  22749,
 13955,  13955,  13955,  13955,
 -1580,  -1580,  -1580,  -1580,
 -2353,  -2353,  -2353,  -2353,
 22667,  22667,  22667,  22667,
 14044,  14044,  14044,  14044,
 -1590,  -1590,  -1590,  -1590,
 -2349,  -2349,  -2349,  -2349,
 22585,  22585,  22585,  22585,
 14132,  14132,  14132,  14132,
 -1600,  -1600,  -1600,  -1600,
 -2344,  -2344,  -2344,  -2344,
 22502,  22502,  22502,  22502,
 14221,  14221,  14221,  14221,
 -1611,  -1611,  -1611,  -1611,
 -2340,  -2340,  -2340,  -2340,
 22420,  22420,  22420,  22420,
 14309,  14309,  14309,  14309,
 -1621,  -1621,  -1621,  -1621,
 -2336,  -2336,  -2336,  -2336,
 22337,  22337,  22337,  22337,
 14398,  14398,  14398,  14398,
 -1631,  -1631,  -1631,  -1631,
 -2331,  -2331,  -2331,  -2331,
 22254,  22254,  22254,  22254,
 14486,  14486,  14486,  14486,
 -1641,  -1641,  -1641,  -1641,
 -2327,  -2327,  -2327,  -2327,
 22171,  22171,  22171,  22171,
 14575,  14575,  14575,  14575,
 -1651,  -1651,  -1651,  -1651,
 -2322,  -2322,  -2322,  -2322,
 22087,  22087,  22087,  22087,
 14664,  14664,  14664,  14664,
 -1661,  -1661,  -1661,  -1661,
 -2317,  -2317,  -2317,  -2317,
 22004,  22004,  22004,  22004,
 14752,  14752,  14752,  14752,
 -1671,  -1671,  -1671,  -1671,
 -2313,  -2313,  -2313,  -2313,
 21920,  21920,  21920,  21920,
 14841,  14841,  14841,  14841,
 -1681,  -1681,  -1681,  -1681,
 -2308,  -2308,  -2308,  -2308,
 21837,  21837,  21837,  21837,
 14930,  14930,  14930,  14930,
 -1691,  -1691,  -1691,  -1691,
 -2303,  -2303,  -2303,  -2303,
 21753,  21753,  21753,  21753,
 15019,  15019,  15019,  15019,
 -1701,  -1701,  -1701,  -1701,
 -2298,  -2298,  -2298,  -2298,
 21669,  21669,  21669,  21669,
 15107,  15107,  15107,  15107,
 -1710,  -1710,  -1710,  -1710,
 -2292,  -2292,  -2292,  -2292,
 21585,  21585,  21585,  21585,
 15196,  15196,  15196,  15196,
 -1720,  -1720,  -1720,  -1720,
 -2287,  -2287,  -2287,  -2287,
 21500,  21500,  21500,  21500,
 15285,  15285,  15285,  15285,
 -1730,  -1730,  -1730,  -1730,
 -2282,  -2282,  -2282,  -2282,
 21416,  21416,  21416,  21416,
 15374,  15374,  15374,  15374,
 -1740,  -1740,  -1740,  -1740,
 -2276,  -2276,  -2276,  -2276,
 21331,  21331,  21331,  21331,
 15463,  15463,  15463,  15463,
 -1750,  -1750,  -1750,  -1750,
 -2271,  -2271,  -2271,  -2271,
 21246,  21246,  21246,  21246,
 15552,  15552,  15552,  15552,
 -1759,  -1759,  -1759,  -1759,
 -2265,  -2265,  -2265,  -2265,
 21162,  21162,  21162,  21162,
 15640,  15640,  15640,  15640,
 -1769,  -1769,  -1769,  -1769,
 -2259,  -2259,  -2259,  -2259,
 21077,  21077,  21077,  21077,
 15729,  15729,  15729,  15729,
 -1778,  -1778,  -1778,  -1778,
 -2254,  -2254,  -2254,  -2254,
 20991,  20991,  20991,  20991,
 15818,  15818,  15818,  15818,
 -1788,  -1788,  -1788,  -1788,
 -2248,  -2248,  -2248,  -2248,
 20906,  20906,  20906,  20906,
 15907,  15907,  15907,  15907,
 -1797,  -1797,  -1797,  -1797,
 -2242,  -2242,  -2242,  -2242,
 20821,  20821,  20821,  20821,
 15996,  15996,  15996,  15996,
 -1807,  -1807,  -1807,  -1807,
 -2236,  -2236,  -2236,  -2236,
 20735,  20735,  20735,  20735,
 16085,  16085,  16085,  16085,
 -1816,  -1816,  -1816,  -1816,
 -2230,  -2230,  -2230,  -2230,
 20650,  20650,  20650,  20650,
 16174,  16174,  16174,  16174,
 -1826,  -1826,  -1826,  -1826,
 -2223,  -2223,  -2223,  -2223,
 20564,  20564,  20564,  20564,
 16263,  16263,  16263,  16263,
 -1835,  -1835,  -1835,  -1835,
 -2217,  -2217,  -2217,  -2217,
 20478,  20478,  20478,  20478,
 16351,  16351,  16351,  16351,
 -1844,  -1844,  -1844,  -1844,
 -2211,  -2211,  -2211,  -2211,
 20392,  20392,  20392,  20392,
 16440,  16440,  16440,  16440,
 -1854,  -1854,  -1854,  -1854,
 -2204,  -2204,  -2204,  -2204,
 20306,  20306,  20306,  20306,
 16529,  16529,  16529,  16529,
 -1863,  -1863,  -1863,  -1863,
 -2198,  -2198,  -2198,  -2198,
 20220,  20220,  20220,  20220,
 16618,  16618,  16618,  16618,
 -1872,  -1872,  -1872,  -1872,
 -2191,  -2191,  -2191,  -2191,
 20133,  20133,  20133,  20133,
 16707,  16707,  16707,  16707,
 -1881,  -1881,  -1881,  -1881,
 -2185,  -2185,  -2185,  -2185,
 20047,  20047,  20047,  20047,
 16796,  16796,  16796,  16796,
 -1890,  -1890,  -1890,  -1890,
 -2178,  -2178,  -2178,  -2178,
 19960,  19960,  19960,  19960,
 16884,  16884,  16884,  16884,
 -1899,  -1899,  -1899,  -1899,
 -2171,  -2171,  -2171,  -2171,
 19874,  19874,  19874,  19874,
 16973,  16973,  16973,  16973,
 -1908,  -1908,  -1908,  -1908,
 -2164,  -2164,  -2164,  -2164,
 19787,  19787,  19787,  19787,
 17062,  17062,  17062,  17062,
 -1917,  -1917,  -1917,  -1917,
 -2157,  -2157,  -2157,  -2157,
 19700,  19700,  19700,  19700,
 17151,  17151,  17151,  17151,
 -1926,  -1926,  -1926,  -1926,
 -2150,  -2150,  -2150,  -2150,
 19613,  19613,  19613,  19613,
 17239,  17239,  17239,  17239,
 -1935,  -1935,  -1935,  -1935,
 -2143,  -2143,  -2143,  -2143,
 19526,  19526,  19526,  19526,
 17328,  17328,  17328,  17328,
 -1943,  -1943,  -1943,  -1943,
 -2136,  -2136,  -2136,  -2136,
 19439,  19439,  19439,  19439,
 17416,  17416,  17416,  17416,
 -1952,  -1952,  -1952,  -1952,
 -2128,  -2128,  -2128,  -2128,
 19352,  19352,  19352,  19352,
 17505,  17505,  17505,  17505,
 -1961,  -1961,  -1961,  -1961,
 -2121,  -2121,  -2121,  -2121,
 19265,  19265,  19265,  19265,
 17593,  17593,  17593,  17593,
 -1969,  -1969,  -1969,  -1969,
 -2114,  -2114,  -2114,  -2114,
 19178,  19178,  19178,  19178,
 17682,  17682,  17682,  17682,
 -1978,  -1978,  -1978,  -1978,
 -2106,  -2106,  -2106,  -2106,
 19090,  19090,  19090,  19090,
 17770,  17770,  17770,  17770,
 -1986,  -1986,  -1986,  -1986,
 -2099,  -2099,  -2099,  -2099,
 19003,  19003,  19003,  19003,
 17859,  17859,  17859,  17859,
 -1995,  -1995,  -1995,  -1995,
 -2091,  -2091,  -2091,  -2091,
 18915,  18915,  18915,  18915,
 17947,  17947,  17947,  17947,
 -2003,  -2003,  -2003,  -2003,
 -2083,  -2083,  -2083,  -2083,
 18827,  18827,  18827,  18827,
 18035,  18035,  18035,  18035,
 -2011,  -2011,  -2011,  -2011,
 -2076,  -2076,  -2076,  -2076,
 18740,  18740,  18740,  18740,
 18124,  18124,  18124,  18124,
 -2020,  -2020,  -2020,  -2020,
 -2068,  -2068,  -2068,  -2068,
 18652,  18652,  18652,  18652,
 18212,  18212,  18212,  18212,
 -2028,  -2028,  -2028,  -2028,
 -2060,  -2060,  -2060,  -2060,
 18564,  18564,  18564,  18564,
 18300,  18300,  18300,  18300,
 -2036,  -2036,  -2036,  -2036,
 -2052,  -2052,  -2052,  -2052,
 18476,  18476,  18476,  18476,
 18388,  18388,  18388,  18388,
 -2044,  -2044,  -2044,  -2044,
 -2044,  -2044,  -2044,  -2044,
 18388,  18388,  18388,  18388,
 18476,  18476,  18476,  18476,
 -2052,  -2052,  -2052,  -2052,
 -2036,  -2036,  -2036,  -2036,
 18300,  18300,  18300,  18300,
 18564,  18564,  18564,  18564,
 -2060,  -2060,  -2060,  -2060,
 -2028,  -2028,  -2028,  -2028,
 18212,  18212,  18212,  18212,
 18652,  18652,  18652,  18652,
 -2068,  -2068,  -2068,  -2068,
 -2020,  -2020,  -2020,  -2020,
 18124,  18124,  18124,  18124,
 18740,  18740,  18740,  18740,
 -2076,  -2076,  -2076,  -2076,
 -2011,  -2011,  -2011,  -2011,
 18035,  18035,  18035,  18035,
 18827,  18827,  18827,  18827,
 -2083,  -2083,  -2083,  -2083,
 -2003,  -2003,  -2003,  -2003,
 17947,  17947,  17947,  17947,
 18915,  18915,  18915,  18915,
 -2091,  -2091,  -2091,  -2091,
 -1995,  -1995,  -1995,  -1995,
 17859,  17859,  17859,  17859,
 19003,  19003,  19003,  19003,
 -2099,  -2099,  -2099,  -2099,
 -1986,  -1986,  -1986,  -1986,
 17770,  17770,  17770,  17770,
 19090,  19090,  19090,  19090,
 -2106,  -2106,  -2106,  -2106,
 -1978,  -1978,  -1978,  -1978,
 17682,  17682,  17682,  17682,
 19178,  19178,  19178,  19178,
 -2114,  -2114,  -2114,  -2114,
 -1969,  -1969,  -1969,  -1969,
 17593,  17593,  17593,  17593,
 19265,  19265,  19265,  19265,
 -2121,  -2121,  -2121,  -2121,
 -1961,  -1961,  -1961,  -1961,
 17505,  17505,  17505,  17505,
 19352,  19352,  19352,  19352,
 -2128,  -2128,  -2128,  -2128,
 -1952,  -1952,  -1952,  -1952,
 17416,  17416,  17416,  17416,
 19439,  19439,  19439,  19439,
 -2136,  -2136,  -2136,  -2136,
 -1943,  -1943,  -1943,  -1943,
 17328,  17328,  17328,  17328,
 19526,  19526,  19526,  19526,
 -2143,  -2143,  -2143,  -2143,
 -1935,  -1935,  -1935,  -1935,
 17239,  17239,  17239,  17239,
 19613,  19613,  19613,  19613,
 -2150,  -2150,  -2150,  -2150,
 -1926,  -1926,  -1926,  -1926,
 17151,  17151,  17151,  17151,
 19700,  19700,  19700,  19700,
 -2157,  -2157,  -2157,  -2157,
 -1917,  -1917,  -1917,  -1917,
 17062,  17062,  17062,  17062,
 19787,  19787,  19787,  19787,
 -2164,  -2164,  -2164,  -2164,
 -1908,  -1908,  -1908,  -1908,
 16973,  16973,  16973,  16973,
 19874,  19874,  19874,  19874,
 -2171,  -2171,  -2171,  -2171,
 -1899,  -1899,  -1899,  -1899,
 16884,  16884,  16884,  16884,
 19960,  19960,  19960,  19960,
 -2178,  -2178,  -2178,  -2178,
 -1890,  -1890,  -1890,  -1890,
 16796,  16796,  16796,  16796,
 20047,  20047,  20047,  20047,
 -2185,  -2185,  -2185,  -2185,
 -1881,  -1881,  -1881,  -1881,
 16707,  16707,  16707,  16707,
 20133,  20133,  20133,  20133,
 -2191,  -2191,  -2191,  -2191,
 -1872,  -1872,  -1872,  -1872,
 16618,  16618,  16618,  16618,
 20220,  20220,  20220,  20220,
 -2198,  -2198,  -2198,  -2198,
 -1863,  -1863,  -1863,  -1863,
 16529,  16529,  16529,  16529,
 20306,  20306,  20306,  20306,
 -2204,  -2204,  -2204,  -2204,
 -1854,  -1854,  -1854,  -1854,
 16440,  16440,  16440,  16440,
 20392,  20392,  20392,  20392,
 -2211,  -2211,  -2211,  -2211,
 -1844,  -1844,  -1844,  -1844,
 16351,  16351,  16351,  16351,
 20478,  20478,  20478,  20478,
 -2217,  -2217,  -2217,  -2217,
 -1835,  -1835,  -1835,  -1835,
 16263,  16263,  16263,  16263,
 20564,  20564,  20564,  20564,
 -2223,  -2223,  -2223,  -2223,
 -1826,  -1826,  -1826,  -1826,
 16174,  16174,  16174,  16174,
 20650,  20650,  20650,  20650,
 -2230,  -2230,  -2230,  -2230,
 -1816,  -1816,  -1816,  -1816,
 16085,  16085,  16085,  16085,
 20735,  20735,  20735,  20735,
 -2236,  -2236,  -2236,  -2236,
 -1807,  -1807,  -1807,  -1807,
 15996,  15996,  15996,  15996,
 20821,  20821,  20821,  20821,
 -2242,  -2242,  -2242,  -2242,
 -1797,  -1797,  -1797,  -1797,
 15907,  15907,  15907,  15907,
 20906,  20906,  20906,  20906,
 -2248,  -2248,  -2248,  -2248,
 -1788,  -1788,  -1788,  -1788,
 15818,  15818,  15818,  15818,
 20991,  20991,  20991,  20991,
 -2254,  -2254,  -2254,  -2254,
 -1778,  -1778,  -1778,  -1778,
 15729,  15729,  15729,  15729,
 21077,  21077,  21077,  21077,
 -2259,  -2259,  -2259,  -2259,
 -1769,  -1769,  -1769,  -1769,
 15640,  15640,  15640,  15640,
 21162,  21162,  21162,  21162,
 -2265,  -2265,  -2265,  -2265,
 -1759,  -1759,  -1759,  -1759,
 15552,  15552,  15552,  15552,
 21246,  21246,  21246,  21246,
 -2271,  -2271,  -2271,  -2271,
 -1750,  -1750,  -1750,  -1750,
 15463,  15463,  15463,  15463,
 21331,  21331,  21331,  21331,
 -2276,  -2276,  -2276,  -2276,
 -1740,  -1740,  -1740,  -1740,
 15374,  15374,  15374,  15374,
 21416,  21416,  21416,  21416,
 -2282,  -2282,  -2282,  -2282,
 -1730,  -1730,  -1730,  -1730,
 15285,  15285,  15285,  15285,
 21500,  21500,  21500,  21500,
 -2287,  -2287,  -2287,  -2287,
 -1720,  -1720,  -1720,  -1720,
 15196,  15196,  15196,  15196,
 21585,  21585,  21585,  21585,
 -2292,  -2292,  -2292,  -2292,
 -1710,  -1710,  -1710,  -1710,
 15107,  15107,  15107,  15107,
 21669,  21669,  21669,  21669,
 -2298,  -2298,  -2298,  -2298,
 -1701,  -1701,  -1701,  -1701,
 15019,  15019,  15019,  15019,
 21753,  21753,  21753,  21753,
 -2303,  -2303,  -2303,  -2303,
 -1691,  -1691,  -1691,  -1691,
 14930,  14930,  14930,  14930,
 21837,  21837,  21837,  21837,
 -2308,  -2308,  -2308,  -2308,
 -1681,  -1681,  -1681,  -1681,
 14841,  14841,  14841,  14841,
 21920,  21920,  21920,  21920,
 -2313,  -2313,  -2313,  -2313,
 -1671,  -1671,  -1671,  -1671,
 14752,  14752,  14752,  14752,
 22004,  22004,  22004,  22004,
 -2317,  -2317,  -2317,  -2317,
 -1661,  -1661,  -1661,  -1661,
 14664,  14664,  14664,  14664,
 22087,  22087,  22087,  22087,
 -2322,  -2322,  -2322,  -2322,
 -1651,  -1651,  -1651,  -1651,
 14575,  14575,  14575,  14575,
 22171,  22171,  22171,  22171,
 -2327,  -2327,  -2327,  -2327,
 -1641,  -1641,  -1641,  -1641,
 14486,  14486,  14486,  14486,
 22254,  22254,  22254,  22254,
 -2331,  -2331,  -2331,  -2331,
 -1631,  -1631,  -1631,  -1631,
 14398,  14398,  14398,  14398,
 22337,  22337,  22337,  22337,
 -2336,  -2336,  -2336,  -2336,
 -1621,  -1621,  -1621,  -1621,
 14309,  14309,  14309,  14309,
 22420,  22420,  22420,  22420,
 -2340,  -2340,  -2340,  -2340,
 -1611,  -1611,  -1611,  -1611,
 14221,  14221,  14221,  14221,
 22502,  22502,  22502,  22502,
 -2344,  -2344,  -2344,  -2344,
 -1600,  -1600,  -1600,  -1600,
 14132,  14132,  14132,  14132,
 22585,  22585,  22585,  22585,
 -2349,  -2349,  -2349,  -2349,
 -1590,  -1590,  -1590,  -1590,
 14044,  14044,  14044,  14044,
 22667,  22667,  22667,  22667,
 -2353,  -2353,  -2353,  -2353,
 -1580,  -1580,  -1580,  -1580,
 13955,  13955,  13955,  13955,
 22749,  22749,  22749,  22749,
 -2357,  -2357,  -2357,  -2357,
 -1570,  -1570,  -1570,  -1570,
 13867,  13867,  13867,  13867,
 22831,  22831,  22831,  22831,
 -2360,  -2360,  -2360,  -2360,
 -1560,  -1560,  -1560,  -1560,
 13779,  13779,  13779,  13779,
 22913,  22913,  22913,  22913,
 -2364,  -2364,  -2364,  -2364,
 -1549,  -1549,  -1549,  -1549,
 13691,  13691,  13691,  13691,
 22994,  22994,  22994,  22994,
 -2368,  -2368,  -2368,  -2368,
 -1539,  -1539,  -1539,  -1539,
 13602,  13602,  13602,  13602,
 23076,  23076,  23076,  23076,
 -2371,  -2371,  -2371,  -2371,
 -1529,  -1529,  -1529,  -1529,
 13514,  13514,  13514,  13514,
 23157,  23157,  23157,  23157,
 -2375,  -2375,  -2375,  -2375,
 -1518,  -1518,  -1518,  -1518,
 13426,  13426,  13426,  13426,
 23238,  23238,  23238,  23238,
 -2378,  -2378,  -2378,  -2378,
 -1508,  -1508,  -1508,  -1508,
 13338,  13338,  13338,  13338,
 23319,  23319,  23319,  23319,
 -2381,  -2381,  -2381,  -2381,
 -1497,  -1497,  -1497,  -1497,
 13250,  13250,  13250,  13250,
 23400,  23400,  23400,  23400,
 -2385,  -2385,  -2385,  -2385,
 -1487,  -1487,  -1487,  -1487,
 13163,  13163,  13163,  13163,
 23480,  23480,  23480,  23480,
 -2388,  -2388,  -2388,  -2388,
 -1477,  -1477,  -1477,  -1477,
 13075,  13075,  13075,  13075,
 23561,  23561,  23561,  23561,
 -2391,  -2391,  -2391,  -2391,
 -1466,  -1466,  -1466,  -1466,
 12987,  12987,  12987,  12987,
 23641,  23641,  23641,  23641,
 -2393,  -2393,  -2393,  -2393,
 -1456,  -1456,  -1456,  -1456,
 12899,  12899,  12899,  12899,
 23721,  23721,  23721,  23721,
 -2396,  -2396,  -2396,  -2396,
 -1445,  -1445,  -1445,  -1445,
 12812,  12812,  12812,  12812,
 23800,  23800,  23800,  23800,
 -2399,  -2399,  -2399,  -2399,
 -1435,  -1435,  -1435,  -1435,
 12724,  12724,  12724,  12724,
 23880,  23880,  23880,  23880,
 -2401,  -2401,  -2401,  -2401,
 -1424,  -1424,  -1424,  -1424,
 12637,  12637,  12637,  12637,
 23959,  23959,  23959,  23959,
 -2404,  -2404,  -2404,  -2404,
 -1414,  -1414,  -1414,  -1414,
 12549,  12549,  12549,  12549,
 24038,  24038,  24038,  24038,
 -2406,  -2406,  -2406,  -2406,
 -1403,  -1403,  -1403,  -1403,
 12462,  12462,  12462,  12462,
 24117,  24117,  24117,  24117,
 -2408,  -2408,  -2408,  -2408,
 -1393,  -1393,  -1393,  -1393,
 12375,  12375,  12375,  12375,
 24196,  24196,  24196,  24196,
 -2410,  -2410,  -2410,  -2410,
 -1382,  -1382,  -1382,  -1382,
 12288,  12288,  12288,  12288,
 24274,  24274,  24274,  24274,
 -2412,  -2412,  -2412,  -2412,
 -1371,  -1371,  -1371,  -1371,
 12201,  12201,  12201,  12201,
 24352,  24352,  24352,  24352,
 -2414,  -2414,  -2414,  -2414,
 -1361,  -1361,  -1361,  -1361,
 12114,  12114,  12114,  12114,
 24430,  24430,  24430,  24430,
 -2416,  -2416,  -2416,  -2416,
 -1350,  -1350,  -1350,  -1350,
 12027,  12027,  12027,  12027,
 24508,  24508,  24508,  24508,
 -2417,  -2417,  -2417,  -2417,
 -1340,  -1340,  -1340,  -1340,
 11941,  11941,  11941,  11941,
 24586,  24586,  24586,  24586,
 -2419,  -2419,  -2419,  -2419,
 -1329,  -1329,  -1329,  -1329,
 11854,  11854,  11854,  11854,
 24663,  24663,  24663,  24663,
 -2420,  -2420,  -2420,  -2420,
 -1318,  -1318,  -1318,  -1318,
 11767,  11767,  11767,  11767,
 24740,  24740,  24740,  24740,
 -2421,  -2421,  -2421,  -2421,
 -1308,  -1308,  -1308,  -1308,
 11681,  11681,  11681,  11681,
 24817,  24817,  24817,  24817,
 -2422,  -2422,  -2422,  -2422,
 -1297,  -1297,  -1297,  -1297,
 11595,  11595,  11595,  11595,
 24894,  24894,  24894,  24894,
 -2423,  -2423,  -2423,  -2423,
 -1286,  -1286,  -1286,  -1286,
 11509,  11509,  11509,  11509,
 24970,  24970,  24970,  24970,
 -2424,  -2424,  -2424,  -2424,
 -1276,  -1276,  -1276,  -1276,
 11422,  11422,  11422,  11422,
 25046,  25046,  25046,  25046,
 -2425,  -2425,  -2425,  -2425,
 -1265,  -1265,  -1265,  -1265,
 11337,  11337,  11337,  11337,
 25122,  25122,  25122,  25122,
 -2426,  -2426,  -2426,  -2426,
 -1255,  -1255,  -1255,  -1255,
 11251,  11251,  11251,  11251,
 25198,  25198,  25198,  25198,
 -2426,  -2426,  -2426,  -2426,
 -1244,  -1244,  -1244,  -1244,
 11165,  11165,  11165,  11165,
 25274,  25274,  25274,  25274,
 -2427,  -2427,  -2427,  -2427,
 -1233,  -1233,  -1233,  -1233,
 11079,  11079,  11079,  11079,
 25349,  25349,  25349,  25349,
 -2427,  -2427,  -2427,  -2427,
 -1223,  -1223,  -1223,  -1223,
 10994,  10994,  10994,  10994,
 25424,  25424,  25424,  25424,
 -2427,  -2427,  -2427,  -2427,
 -1212,  -1212,  -1212,  -1212,
 10908,  10908,  10908,  10908,
 25499,  25499,  25499,  25499,
 -2427,  -2427,  -2427,  -2427,
 -1201,  -1201,  -1201,  -1201,
 10823,  10823,  10823,  10823,
 25573,  25573,  25573,  25573,
 -2427,  -2427,  -2427,  -2427,
 -1191,  -1191,  -1191,  -1191,
 10738,  10738,  10738,  10738,
 25647,  25647,  25647,  25647,
 -2427,  -2427,  -2427,  -2427,
 -1180,  -1180,  -1180,  -1180,
 10653,  10653,  10653,  10653,
 25721,  25721,  25721,  25721,
 -2427,  -2427,  -2427,  -2427,
 -1169,  -1169,  -1169,  -1169,
 10568,  10568,  10568,  10568,
 25795,  25795,  25795,  25795,
 -2426,  -2426,  -2426,  -2426,
 -1159,  -1159,  -1159,  -1159,
 10483,  10483,  10483,  10483,
 25869,  25869,  25869,  25869,
 -2426,  -2426,  -2426,  -2426,
 -1148,  -1148,  -1148,  -1148,
 10399,  10399,  10399,  10399,
 25942,  25942,  25942,  25942,
 -2425,  -2425,  -2425,  -2425,
 -1137,  -1137,  -1137,  -1137,
 10314,  10314,  10314,  10314,
 26015,  26015,  26015,  26015,
 -2424,  -2424,  -2424,  -2424,
 -1127,  -1127,  -1127,  -1127,
 10230,  10230,  10230,  10230,
 26087,  26087,  26087,  26087,
 -2423,  -2423,  -2423,  -2423,
 -1116,  -1116,  -1116,  -1116,
 10146,  10146,  10146,  10146,
 26160,  26160,  26160,  26160,
 -2422,  -2422,  -2422,  -2422,
 -1105,  -1105,  -1105,  -1105,
 10062,  10062,  10062,  10062,
 26232,  26232,  26232,  26232,
 -2421,  -2421,  -2421,  -2421,
 -1095,  -1095,  -1095,  -1095,
  9978,   9978,   9978,   9978,
 26304,  26304,  26304,  26304,
 -2419,  -2419,  -2419,  -2419,
 -1084,  -1084,  -1084,  -1084,
  9894,   9894,   9894,   9894,
 26376,  26376,  26376,  26376,
 -2418,  -2418,  -2418,  -2418,
 -1073,  -1073,  -1073,  -1073,
  9811,   9811,   9811,   9811,
 26447,  26447,  26447,  26447,
 -2416,  -2416,  -2416,  -2416,
 -1063,  -1063,  -1063,  -1063,
  9727,   9727,   9727,   9727,
 26518,  26518,  26518,  26518,
 -2414,  -2414,  -2414,  -2414,
 -1052,  -1052,  -1052,  -1052,
  9644,   9644,   9644,   9644,
 26589,  26589,  26589,  26589,
 -2412,  -2412,  -2412,  -2412,
 -1042,  -1042,  -1042,  -1042,
  9561,   9561,   9561,   9561,
 26659,  26659,  26659,  26659,
 -2410,  -2410,  -2410,  -2410,
 -1031,  -1031,  -1031,  -1031,
  9478,   9478,   9478,   9478,
 26729,  26729,  26729,  26729,
 -2408,  -2408,  -2408,  -2408,
 -1021,  -1021,  -1021,  -1021,
  9395,   9395,   9395,   9395,
 26799,  26799,  26799,  26799,
 -2406,  -2406,  -2406,  -2406,
 -1010,  -1010,  -1010,  -1010,
  9313,   9313,   9313,   9313,
 26869,  26869,  26869,  26869,
 -2403,  -2403,  -2403,  -2403,
 -1000,  -1000,  -1000,  -1000,
  9230,   9230,   9230,   9230,
 26938,  26938,  26938,  26938,
 -2401,  -2401,  -2401,  -2401,
  -989,   -989,   -989,   -989,
  9148,   9148,   9148,   9148,
 27007,  27007,  27007,  27007,
 -2398,  -2398,  -2398,  -2398,
  -979,   -979,   -979,   -979,
  9066,   9066,   9066,   9066,
 27076,  27076,  27076,  27076,
 -2395,  -2395,  -2395,  -2395,
  -968,   -968,   -968,   -968,
  8984,   8984,   8984,   8984,
 27144,  27144,  27144,  27144,
 -2392,  -2392,  -2392,  -2392,
  -958,   -958,   -958,   -958,
  8902,   8902,   8902,   8902,
 27212,  27212,  27212,  27212,
 -2389,  -2389,  -2389,  -2389,
  -947,   -947,   -947,   -947,
  8821,   8821,   8821,   8821,
 27280,  27280,  27280,  27280,
 -2386,  -2386,  -2386,  -2386,
  -937,   -937,   -937,   -937,
  8739,   8739,   8739,   8739,
 27348,  27348,  27348,  27348,
 -2382,  -2382,  -2382,  -2382,
  -926,   -926,   -926,   -926,
  8658,   8658,   8658,   8658,
 27415,  27415,  27415,  27415,
 -2379,  -2379,  -2379,  -2379,
  -916,   -916,   -916,   -916,
  8577,   8577,   8577,   8577,
 27482,  27482,  27482,  27482,
 -2375,  -2375,  -2375,  -2375,
  -906,   -906,   -906,   -906,
  8496,   8496,   8496,   8496,
 27549,  27549,  27549,  27549,
 -2371,  -2371,  -2371,  -2371,
  -895,   -895,   -895,   -895,
  8415,   8415,   8415,   8415,
 27615,  27615,  27615,  27615,
 -2367,  -2367,  -2367,  -2367,
  -885,   -885,   -885,   -885,
  8335,   8335,   8335,   8335,
 27681,  27681,  27681,  27681,
 -2363,  -2363,  -2363,  -2363,
  -875,   -875,   -875,   -875,
  8255,   8255,   8255,   8255,
 27746,  27746,  27746,  27746,
 -2359,  -2359,  -2359,  -2359,
  -864,   -864,   -864,   -864,
  8175,   8175,   8175,   8175,
 27812,  27812,  27812,  27812,
 -2354,  -2354,  -2354,  -2354,
  -854,   -854,   -854,   -854,
  8095,   8095,   8095,   8095,
 27877,  27877,  27877,  27877,
 -2349,  -2349,  -2349,  -2349,
  -844,   -844,   -844,   -844,
  8015,   8015,   8015,   8015,
 27941,  27941,  27941,  27941,
 -2345,  -2345,  -2345,  -2345,
  -834,   -834,   -834,   -834,
  7936,   7936,   7936,   7936,
 28006,  28006,  28006,  28006,
 -2340,  -2340,  -2340,  -2340,
  -823,   -823,   -823,   -823,
  7856,   7856,   7856,   7856,
 28070,  28070,  28070,  28070,
 -2335,  -2335,  -2335,  -2335,
  -813,   -813,   -813,   -813,
  7777,   7777,   7777,   7777,
 28134,  28134,  28134,  28134,
 -2329,  -2329,  -2329,  -2329,
  -803,   -803,   -803,   -803,
  7698,   7698,   7698,   7698,
 28197,  28197,  28197,  28197,
 -2324,  -2324,  -2324,  -2324,
  -793,   -793,   -793,   -793,
  7620,   7620,   7620,   7620,
 28260,  28260,  28260,  28260,
 -2319,  -2319,  -2319,  -2319,
  -783,   -783,   -783,   -783,
  7541,   7541,   7541,   7541,
 28323,  28323,  28323,  28323,
 -2313,  -2313,  -2313,  -2313,
  -773,   -773,   -773,   -773,
  7463,   7463,   7463,   7463,
 28385,  28385,  28385,  28385,
 -2307,  -2307,  -2307,  -2307,
  -763,   -763,   -763,   -763,
  7385,   7385,   7385,   7385,
 28447,  28447,  28447,  28447,
 -2301,  -2301,  -2301,  -2301,
  -753,   -753,   -753,   -753,
  7307,   7307,   7307,   7307,
 28509,  28509,  28509,  28509,
 -2295,  -2295,  -2295,  -2295,
  -743,   -743,   -743,   -743,
  7230,   7230,   7230,   7230,
 28570,  28570,  28570,  28570,
 -2289,  -2289,  -2289,  -2289,
  -733,   -733,   -733,   -733,
  7152,   7152,   7152,   7152,
 28631,  28631,  28631,  28631,
 -2282,  -2282,  -2282,  -2282,
  -723,   -723,   -723,   -723,
  7075,   7075,   7075,   7075,
 28691,  28691,  28691,  28691,
 -2275,  -2275,  -2275,  -2275,
  -713,   -713,   -713,   -713,
  6998,   6998,   6998,   6998,
 28752,  28752,  28752,  28752,
 -2269,  -2269,  -2269,  -2269,
  -704,   -704,   -704,   -704,
  6922,   6922,   6922,   6922,
 28812,  28812,  28812,  28812,
 -2262,  -2262,  -2262,  -2262,
  -694,   -694,   -694,   -694,
  6845,   6845,   6845,   6845,
 28871,  28871,  28871,  28871,
 -2255,  -2255,  -2255,  -2255,
  -684,   -684,   -684,   -684,
  6769,   6769,   6769,   6769,
 28930,  28930,  28930,  28930,
 -2247,  -2247,  -2247,  -2247,
  -675,   -675,   -675,   -675,
  6693,   6693,   6693,   6693,
 28989,  28989,  28989,  28989,
 -2240,  -2240,  -2240,  -2240,
  -665,   -665,   -665,   -665,
  6617,   6617,   6617,   6617,
 29048,  29048,  29048,  29048,
 -2232,  -2232,  -2232,  -2232,
  -655,   -655,   -655,   -655,
  6542,   6542,   6542,   6542,
 29106,  29106,  29106,  29106,
 -2224,  -2224,  -2224,  -2224,
  -646,   -646,   -646,   -646,
  6467,   6467,   6467,   6467,
 29163,  29163,  29163,  29163,
 -2217,  -2217,  -2217,  -2217,
  -636,   -636,   -636,   -636,
  6392,   6392,   6392,   6392,
 29221,  29221,  29221,  29221,
 -2208,  -2208,  -2208,  -2208,
  -627,   -627,   -627,   -627,
  6317,   6317,   6317,   6317,
 29278,  29278,  29278,  29278,
 -2200,  -2200,  -2200,  -2200,
  -617,   -617,   -617,   -617,
  6243,   6243,   6243,   6243,
 29334,  29334,  29334,  29334,
 -2192,  -2192,  -2192,  -2192,
  -608,   -608,   -608,   -608,
  6168,   6168,   6168,   6168,
 29391,  29391,  29391,  29391,
 -2183,  -2183,  -2183,  -2183,
  -598,   -598,   -598,   -598,
  6094,   6094,   6094,   6094,
 29446,  29446,  29446,  29446,
 -2174,  -2174,  -2174,  -2174,
  -589,   -589,   -589,   -589,
  6021,   6021,   6021,   6021,
 29502,  29502,  29502,  29502,
 -2165,  -2165,  -2165,  -2165,
  -580,   -580,   -580,   -580,
  5947,   5947,   5947,   5947,
 29557,  29557,  29557,  29557,
 -2156,  -2156,  -2156,  -2156,
  -571,   -571,   -571,   -571,
  5874,   5874,   5874,   5874,
 29612,  29612,  29612,  29612,
 -2147,  -2147,  -2147,  -2147,
  -561,   -561,   -561,   -561,
  5801,   5801,   5801,   5801,
 29666,  29666,  29666,  29666,
 -2138,  -2138,  -2138,  -2138,
  -552,   -552,   -552,   -552,
  5729,   5729,   5729,   5729,
 29720,  29720,  29720,  29720,
 -2128,  -2128,  -2128,  -2128,
  -543,   -543,   -543,   -543,
  5656,   5656,   5656,   5656,
 29773,  29773,  29773,  29773,
 -2118,  -2118,  -2118,  -2118,
  -534,   -534,   -534,   -534,
  5584,   5584,   5584,   5584,
 29826,  29826,  29826,  29826,
 -2108,  -2108,  -2108,  -2108,
  -525,   -525,   -525,   -525,
  5512,   5512,   5512,   5512,
 29879,  29879,  29879,  29879,
 -2098,  -2098,  -2098,  -2098,
  -516,   -516,   -516,   -516,
  5441,   5441,   5441,   5441,
 29931,  29931,  29931,  29931,
 -2088,  -2088,  -2088,  -2088,
  -507,   -507,   -507,   -507,
  5369,   5369,   5369,   5369,
 29983,  29983,  29983,  29983,
 -2077,  -2077,  -2077,  -2077,
  -499,   -499,   -499,   -499,
  5298,   5298,   5298,   5298,
 30035,  30035,  30035,  30035,
 -2067,  -2067,  -2067,  -2067,
  -490,   -490,   -490,   -490,
  5228,   5228,   5228,   5228,
 30086,  30086,  30086,  30086,
 -2056,  -2056,  -2056,  -2056,
  -481,   -481,   -481,   -481,
  5157,   5157,   5157,   5157,
 30137,  30137,  30137,  30137,
 -2045,  -2045,  -2045,  -2045,
  -472,   -472,   -472,   -472,
  5087,   5087,   5087,   5087,
 30187,  30187,  30187,  30187,
 -2034,  -2034,  -2034,  -2034,
  -464,   -464,   -464,   -464,
  5017,   5017,   5017,   5017,
 30237,  30237,  30237,  30237,
 -2022,  -2022,  -2022,  -2022,
  -455,   -455,   -455,   -455,
  4948,   4948,   4948,   4948,
 30286,  30286,  30286,  30286,
 -2011,  -2011,  -2011,  -2011,
  -447,   -447,   -447,   -447,
  4878,   4878,   4878,   4878,
 30335,  30335,  30335,  30335,
 -1999,  -1999,  -1999,  -1999,
  -438,   -438,   -438,   -438,
  4809,   4809,   4809,   4809,
 30384,  30384,  30384,  30384,
 -1987,  -1987,  -1987,  -1987,
  -430,   -430,   -430,   -430,
  4741,   4741,   4741,   4741,
 30432,  30432,  30432,  30432,
 -1975,  -1975,  -1975,  -1975,
  -421,   -421,   -421,   -421,
  4672,   4672,   4672,   4672,
 30480,  30480,  30480,  30480,
 -1963,  -1963,  -1963,  -1963,
  -413,   -413,   -413,   -413,
  4604,   4604,   4604,   4604,
 30527,  30527,  30527,  30527,
 -1950,  -1950,  -1950,  -1950,
  -405,   -405,   -405,   -405,
  4536,   4536,   4536,   4536,
 30574,  30574,  30574,  30574,
 -1938,  -1938,  -1938,  -1938,
  -397,   -397,   -397,   -397,
  4469,   4469,   4469,   4469,
 30621,  30621,  30621,  30621,
 -1925,  -1925,  -1925,  -1925,
  -389,   -389,   -389,   -389,
  4402,   4402,   4402,   4402,
 30667,  30667,  30667,  30667,
 -1912,  -1912,  -1912,  -1912,
  -381,   -381,   -381,   -381,
  4335,   4335,   4335,   4335,
 30712,  30712,  30712,  30712,
 -1899,  -1899,  -1899,  -1899,
  -373,   -373,   -373,   -373,
  4268,   4268,   4268,   4268,
 30758,  30758,  30758,  30758,
 -1885,  -1885,  -1885,  -1885,
  -365,   -365,   -365,   -365,
  4202,   4202,   4202,   4202,
 30802,  30802,  30802,  30802,
 -1872,  -1872,  -1872,  -1872,
  -357,   -357,   -357,   -357,
  4136,   4136,   4136,   4136,
 30847,  30847,  30847,  30847,
 -1858,  -1858,  -1858,  -1858,
  -349,   -349,   -349,   -349,
  4070,   4070,   4070,   4070,
 30891,  30891,  30891,  30891,
 -1844,  -1844,  -1844,  -1844,
  -341,   -341,   -341,   -341,
  4005,   4005,   4005,   4005,
 30934,  30934,  30934,  30934,
 -1830,  -1830,  -1830,  -1830,
  -334,   -334,   -334,   -334,
  3940,   3940,   3940,   3940,
 30977,  30977,  30977,  30977,
 -1815,  -1815,  -1815,  -1815,
  -326,   -326,   -326,   -326,
  3875,   3875,   3875,   3875,
 31019,  31019,  31019,  31019,
 -1801,  -1801,  -1801,  -1801,
  -319,   -319,   -319,   -319,
  3811,   3811,   3811,   3811,
 31062,  31062,  31062,  31062,
 -1786,  -1786,  -1786,  -1786,
  -311,   -311,   -311,   -311,
  3747,   3747,   3747,   3747,
 31103,  31103,  31103,  31103,
 -1771,  -1771,  -1771,  -1771,
  -304,   -304,   -304,   -304,
  3683,   3683,   3683,   3683,
 31144,  31144,  31144,  31144,
 -1756,  -1756,  -1756,  -1756,
  -296,   -296,   -296,   -296,
  3620,   3620,   3620,   3620,
 31185,  31185,  31185,  31185,
 -1741,  -1741,  -1741,  -1741,
  -289,   -289,   -289,   -289,
  3557,   3557,   3557,   3557,
 31225,  31225,  31225,  31225,
 -1725,  -1725,  -1725,  -1725,
  -282,   -282,   -282,   -282,
  3495,   3495,   3495,   3495,
 31265,  31265,  31265,  31265,
 -1709,  -1709,  -1709,  -1709,
  -275,   -275,   -275,   -275,
  3432,   3432,   3432,   3432,
 31304,  31304,  31304,  31304,
 -1694,  -1694,  -1694,  -1694,
  -268,   -268,   -268,   -268,
  3370,   3370,   3370,   3370,
 31343,  31343,  31343,  31343,
 -1677,  -1677,  -1677,  -1677,
  -261,   -261,   -261,   -261,
  3309,   3309,   3309,   3309,
 31381,  31381,  31381,  31381,
 -1661,  -1661,  -1661,  -1661,
  -254,   -254,   -254,   -254,
  3247,   3247,   3247,   3247,
 31419,  31419,  31419,  31419,
 -1645,  -1645,  -1645,  -1645,
  -247,   -247,   -247,   -247,
  3186,   3186,   3186,   3186,
 31457,  31457,  31457,  31457,
 -1628,  -1628,  -1628,  -1628,
  -240,   -240,   -240,   -240,
  3126,   3126,   3126,   3126,
 31494,  31494,  31494,  31494,
 -1611,  -1611,  -1611,  -1611,
  -234,   -234,   -234,   -234,
  3066,   3066,   3066,   3066,
 31530,  31530,  31530,  31530,
 -1594,  -1594,  -1594,  -1594,
  -227,   -227,   -227,   -227,
  3006,   3006,   3006,   3006,
 31566,  31566,  31566,  31566,
 -1577,  -1577,  -1577,  -1577,
  -221,   -221,   -221,   -221,
  2946,   2946,   2946,   2946,
 31602,  31602,  31602,  31602,
 -1559,  -1559,  -1559,  -1559,
  -214,   -214,   -214,   -214,
  2887,   2887,   2887,   2887,
 31637,  31637,  31637,  31637,
 -1542,  -1542,  -1542,  -1542,
  -208,   -208,   -208,   -208,
  2828,   2828,   2828,   2828,
 31671,  31671,  31671,  31671,
 -1524,  -1524,  -1524,  -1524,
  -202,   -202,   -202,   -202,
  2770,   2770,   2770,   2770,
 31705,  31705,  31705,  31705,
 -1506,  -1506,  -1506,  -1506,
  -196,   -196,   -196,   -196,
  2712,   2712,   2712,   2712,
 31739,  31739,  31739,  31739,
 -1487,  -1487,  -1487,  -1487,
  -189,   -189,   -189,   -189,
  2654,   2654,   2654,   2654,
 31772,  31772,  31772,  31772,
 -1469,  -1469,  -1469,  -1469,
  -183,   -183,   -183,   -183,
  2597,   2597,   2597,   2597,
 31804,  31804,  31804,  31804,
 -1450,  -1450,  -1450,  -1450,
  -177,   -177,   -177,   -177,
  2540,   2540,   2540,   2540,
 31836,  31836,  31836,  31836,
 -1431,  -1431,  -1431,  -1431,
  -172,   -172,   -172,   -172,
  2483,   2483,   2483,   2483,
 31868,  31868,  31868,  31868,
 -1412,  -1412,  -1412,  -1412,
  -166,   -166,   -166,   -166,
  2427,   2427,   2427,   2427,
 31899,  31899,  31899,  31899,
 -1392,  -1392,  -1392,  -1392,
  -160,   -160,   -160,   -160,
  2371,   2371,   2371,   2371,
 31930,  31930,  31930,  31930,
 -1373,  -1373,  -1373,  -1373,
  -155,   -155,   -155,   -155,
  2316,   2316,   2316,   2316,
 31960,  31960,  31960,  31960,
 -1353,  -1353,  -1353,  -1353,
  -149,   -149,   -149,   -149,
  2261,   2261,   2261,   2261,
 31989,  31989,  31989,  31989,
 -1333,  -1333,  -1333,  -1333,
  -144,   -144,   -144,   -144,
  2206,   2206,   2206,   2206,
 32018,  32018,  32018,  32018,
 -1313,  -1313,  -1313,  -1313,
  -138,   -138,   -138,   -138,
  2152,   2152,   2152,   2152,
 32047,  32047,  32047,  32047,
 -1293,  -1293,  -1293,  -1293,
  -133,   -133,   -133,   -133,
  2098,   2098,   2098,   2098,
 32075,  32075,  32075,  32075,
 -1272,  -1272,  -1272,  -1272,
  -128,   -128,   -128,   -128,
  2045,   2045,   2045,   2045,
 32102,  32102,  32102,  32102,
 -1251,  -1251,  -1251,  -1251,
  -123,   -123,   -123,   -123,
  1992,   1992,   1992,   1992,
 32129,  32129,  32129,  32129,
 -1230,  -1230,  -1230,  -1230,
  -118,   -118,   -118,   -118,
  1939,   1939,   1939,   1939,
 32156,  32156,  32156,  32156,
 -1209,  -1209,  -1209,  -1209,
  -113,   -113,   -113,   -113,
  1887,   1887,   1887,   1887,
 32181,  32181,  32181,  32181,
 -1187,  -1187,  -1187,  -1187,
  -108,   -108,   -108,   -108,
  1835,   1835,   1835,   1835,
 32207,  32207,  32207,  32207,
 -1166,  -1166,  -1166,  -1166,
  -104,   -104,   -104,   -104,
  1783,   1783,   1783,   1783,
 32232,  32232,  32232,  32232,
 -1144,  -1144,  -1144,  -1144,
   -99,    -99,    -99,    -99,
  1732,   1732,   1732,   1732,
 32256,  32256,  32256,  32256,
 -1121,  -1121,  -1121,  -1121,
   -94,    -94,    -94,    -94,
  1682,   1682,   1682,   1682,
 32280,  32280,  32280,  32280,
 -1099,  -1099,  -1099,  -1099,
   -90,    -90,    -90,    -90,
  1631,   1631,   1631,   1631,
 32303,  32303,  32303,  32303,
 -1076,  -1076,  -1076,  -1076,
   -86,    -86,    -86,    -86,
  1582,   1582,   1582,   1582,
 32326,  32326,  32326,  32326,
 -1054,  -1054,  -1054,  -1054,
   -81,    -81,    -81,    -81,
  1532,   1532,   1532,   1532,
 32348,  32348,  32348,  32348,
 -1031,  -1031,  -1031,  -1031,
   -77,    -77,    -77,    -77,
  1483,   1483,   1483,   1483,
 32369,  32369,  32369,  32369,
 -1007,  -1007,  -1007,  -1007,
   -73,    -73,    -73,    -73,
  1435,   1435,   1435,   1435,
 32391,  32391,  32391,  32391,
  -984,   -984,   -984,   -984,
   -69,    -69,    -69,    -69,
  1387,   1387,   1387,   1387,
 32411,  32411,  32411,  32411,
  -960,   -960,   -960,   -960,
   -66,    -66,    -66,    -66,
  1339,   1339,   1339,   1339,
 32431,  32431,  32431,  32431,
  -936,   -936,   -936,   -936,
   -62,    -62,    -62,    -62,
  1291,   1291,   1291,   1291,
 32450,  32450,  32450,  32450,
  -912,   -912,   -912,   -912,
   -58,    -58,    -58,    -58,
  1245,   1245,   1245,   1245,
 32469,  32469,  32469,  32469,
  -888,   -888,   -888,   -888,
   -55,    -55,    -55,    -55,
  1198,   1198,   1198,   1198,
 32488,  32488,  32488,  32488,
  -863,   -863,   -863,   -863,
   -51,    -51,    -51,    -51,
  1152,   1152,   1152,   1152,
 32505,  32505,  32505,  32505,
  -838,   -838,   -838,   -838,
   -48,    -48,    -48,    -48,
  1107,   1107,   1107,   1107,
 32523,  32523,  32523,  32523,
  -813,   -813,   -813,   -813,
   -45,    -45,    -45,    -45,
  1061,   1061,   1061,   1061,
 32539,  32539,  32539,  32539,
  -788,   -788,   -788,   -788,
   -42,    -42,    -42,    -42,
  1017,   1017,   1017,   1017,
 32555,  32555,  32555,  32555,
  -762,   -762,   -762,   -762,
   -39,    -39,    -39,    -39,
   972,    972,    972,    972,
 32571,  32571,  32571,  32571,
  -737,   -737,   -737,   -737,
   -36,    -36,    -36,    -36,
   929,    929,    929,    929,
 32586,  32586,  32586,  32586,
  -711,   -711,   -711,   -711,
   -33,    -33,    -33,    -33,
   885,    885,    885,    885,
 32600,  32600,  32600,  32600,
  -685,   -685,   -685,   -685,
   -30,    -30,    -30,    -30,
   842,    842,    842,    842,
 32614,  32614,  32614,  32614,
  -658,   -658,   -658,   -658,
   -28,    -28,    -28,    -28,
   800,    800,    800,    800,
 32627,  32627,  32627,  32627,
  -631,   -631,   -631,   -631,
   -25,    -25,    -25,    -25,
   758,    758,    758,    758,
 32640,  32640,  32640,  32640,
  -605,   -605,   -605,   -605,
   -23,    -23,    -23,    -23,
   716,    716,    716,    716,
 32652,  32652,  32652,  32652,
  -577,   -577,   -577,   -577,
   -21,    -21,    -21,    -21,
   675,    675,    675,    675,
 32663,  32663,  32663,  32663,
  -550,   -550,   -550,   -550,
   -18,    -18,    -18,    -18,
   635,    635,    635,    635,
 32674,  32674,  32674,  32674,
  -522,   -522,   -522,   -522,
   -16,    -16,    -16,    -16,
   594,    594,    594,    594,
 32685,  32685,  32685,  32685,
  -495,   -495,   -495,   -495,
   -15,    -15,    -15,    -15,
   555,    555,    555,    555,
 32694,  32694,  32694,  32694,
  -466,   -466,   -466,   -466,
   -13,    -13,    -13,    -13,
   515,    515,    515,    515,
 32703,  32703,  32703,  32703,
  -438,   -438,   -438,   -438,
   -11,    -11,    -11,    -11,
   477,    477,    477,    477,
 32712,  32712,  32712,  32712,
  -410,   -410,   -410,   -410,
   -10,    -10,    -10,    -10,
   438,    438,    438,    438,
 32720,  32720,  32720,  32720,
  -381,   -381,   -381,   -381,
    -8,     -8,     -8,     -8,
   401,    401,    401,    401,
 32727,  32727,  32727,  32727,
  -352,   -352,   -352,   -352,
    -7,     -7,     -7,     -7,
   363,    363,    363,    363,
 32734,  32734,  32734,  32734,
  -322,   -322,   -322,   -322,
    -6,     -6,     -6,     -6,
   326,    326,    326,    326,
 32740,  32740,  32740,  32740,
  -293,   -293,   -293,   -293,
    -4,     -4,     -4,     -4,
   290,    290,    290,    290,
 32746,  32746,  32746,  32746,
  -263,   -263,   -263,   -263,
    -3,     -3,     -3,     -3,
   254,    254,    254,    254,
 32751,  32751,  32751,  32751,
  -233,   -233,   -233,   -233,
    -3,     -3,     -3,     -3,
   218,    218,    218,    218,
 32755,  32755,  32755,  32755,
  -203,   -203,   -203,   -203,
    -2,     -2,     -2,     -2,
   184,    184,    184,    184,
 32759,  32759,  32759,  32759,
  -172,   -172,   -172,   -172,
    -1,     -1,     -1,     -1,
   149,    149,    149,    149,
 32762,  32762,  32762,  32762,
  -141,   -141,   -141,   -141,
    -1,     -1,     -1,     -1,
   115,    115,    115,    115,
 32764,  32764,  32764,  32764,
  -110,   -110,   -110,   -110,
     0,      0,      0,      0,
    82,     82,     82,     82,
 32766,  32766,  32766,  32766,
   -79,    -79,    -79,    -79,
     0,      0,      0,      0,
    49,     49,     49,     49,
 32767,  32767,  32767,  32767,
   -48,    -48,    -48,    -48,
     0,      0,      0,      0,
    16,     16,     16,     16,
 32767,  32767,  32767,  32767,
   -16,    -16,    -16,    -16
};

/***************************************************************/
const mlib_s16 mlib_filters_s16_bc2_4[] = {
   -32,    -32,    -32,    -32,
 32767,  32767,  32767,  32767,
    32,     32,     32,     32,
     0,      0,      0,      0,
   -95,    -95,    -95,    -95,
 32767,  32767,  32767,  32767,
    96,     96,     96,     96,
     0,      0,      0,      0,
  -158,   -158,   -158,   -158,
 32766,  32766,  32766,  32766,
   161,    161,    161,    161,
    -1,     -1,     -1,     -1,
  -221,   -221,   -221,   -221,
 32765,  32765,  32765,  32765,
   226,    226,    226,    226,
    -2,     -2,     -2,     -2,
  -283,   -283,   -283,   -283,
 32763,  32763,  32763,  32763,
   291,    291,    291,    291,
    -3,     -3,     -3,     -3,
  -344,   -344,   -344,   -344,
 32760,  32760,  32760,  32760,
   356,    356,    356,    356,
    -4,     -4,     -4,     -4,
  -406,   -406,   -406,   -406,
 32758,  32758,  32758,  32758,
   421,    421,    421,    421,
    -5,     -5,     -5,     -5,
  -466,   -466,   -466,   -466,
 32754,  32754,  32754,  32754,
   487,    487,    487,    487,
    -7,     -7,     -7,     -7,
  -526,   -526,   -526,   -526,
 32750,  32750,  32750,  32750,
   553,    553,    553,    553,
    -9,     -9,     -9,     -9,
  -586,   -586,   -586,   -586,
 32746,  32746,  32746,  32746,
   619,    619,    619,    619,
   -11,    -11,    -11,    -11,
  -645,   -645,   -645,   -645,
 32741,  32741,  32741,  32741,
   685,    685,    685,    685,
   -13,    -13,    -13,    -13,
  -703,   -703,   -703,   -703,
 32735,  32735,  32735,  32735,
   752,    752,    752,    752,
   -16,    -16,    -16,    -16,
  -761,   -761,   -761,   -761,
 32729,  32729,  32729,  32729,
   819,    819,    819,    819,
   -19,    -19,    -19,    -19,
  -819,   -819,   -819,   -819,
 32723,  32723,  32723,  32723,
   886,    886,    886,    886,
   -22,    -22,    -22,    -22,
  -876,   -876,   -876,   -876,
 32716,  32716,  32716,  32716,
   954,    954,    954,    954,
   -26,    -26,    -26,    -26,
  -933,   -933,   -933,   -933,
 32709,  32709,  32709,  32709,
  1021,   1021,   1021,   1021,
   -29,    -29,    -29,    -29,
  -989,   -989,   -989,   -989,
 32701,  32701,  32701,  32701,
  1089,   1089,   1089,   1089,
   -33,    -33,    -33,    -33,
 -1045,  -1045,  -1045,  -1045,
 32693,  32693,  32693,  32693,
  1157,   1157,   1157,   1157,
   -37,    -37,    -37,    -37,
 -1100,  -1100,  -1100,  -1100,
 32684,  32684,  32684,  32684,
  1225,   1225,   1225,   1225,
   -41,    -41,    -41,    -41,
 -1155,  -1155,  -1155,  -1155,
 32675,  32675,  32675,  32675,
  1294,   1294,   1294,   1294,
   -46,    -46,    -46,    -46,
 -1209,  -1209,  -1209,  -1209,
 32665,  32665,  32665,  32665,
  1362,   1362,   1362,   1362,
   -50,    -50,    -50,    -50,
 -1263,  -1263,  -1263,  -1263,
 32655,  32655,  32655,  32655,
  1431,   1431,   1431,   1431,
   -55,    -55,    -55,    -55,
 -1316,  -1316,  -1316,  -1316,
 32644,  32644,  32644,  32644,
  1501,   1501,   1501,   1501,
   -61,    -61,    -61,    -61,
 -1369,  -1369,  -1369,  -1369,
 32633,  32633,  32633,  32633,
  1570,   1570,   1570,   1570,
   -66,    -66,    -66,    -66,
 -1422,  -1422,  -1422,  -1422,
 32622,  32622,  32622,  32622,
  1639,   1639,   1639,   1639,
   -71,    -71,    -71,    -71,
 -1473,  -1473,  -1473,  -1473,
 32609,  32609,  32609,  32609,
  1709,   1709,   1709,   1709,
   -77,    -77,    -77,    -77,
 -1525,  -1525,  -1525,  -1525,
 32597,  32597,  32597,  32597,
  1779,   1779,   1779,   1779,
   -83,    -83,    -83,    -83,
 -1576,  -1576,  -1576,  -1576,
 32584,  32584,  32584,  32584,
  1849,   1849,   1849,   1849,
   -89,    -89,    -89,    -89,
 -1627,  -1627,  -1627,  -1627,
 32571,  32571,  32571,  32571,
  1920,   1920,   1920,   1920,
   -96,    -96,    -96,    -96,
 -1677,  -1677,  -1677,  -1677,
 32557,  32557,  32557,  32557,
  1991,   1991,   1991,   1991,
  -103,   -103,   -103,   -103,
 -1726,  -1726,  -1726,  -1726,
 32542,  32542,  32542,  32542,
  2061,   2061,   2061,   2061,
  -109,   -109,   -109,   -109,
 -1776,  -1776,  -1776,  -1776,
 32528,  32528,  32528,  32528,
  2132,   2132,   2132,   2132,
  -116,   -116,   -116,   -116,
 -1824,  -1824,  -1824,  -1824,
 32512,  32512,  32512,  32512,
  2204,   2204,   2204,   2204,
  -124,   -124,   -124,   -124,
 -1873,  -1873,  -1873,  -1873,
 32497,  32497,  32497,  32497,
  2275,   2275,   2275,   2275,
  -131,   -131,   -131,   -131,
 -1920,  -1920,  -1920,  -1920,
 32480,  32480,  32480,  32480,
  2347,   2347,   2347,   2347,
  -139,   -139,   -139,   -139,
 -1968,  -1968,  -1968,  -1968,
 32464,  32464,  32464,  32464,
  2419,   2419,   2419,   2419,
  -147,   -147,   -147,   -147,
 -2015,  -2015,  -2015,  -2015,
 32447,  32447,  32447,  32447,
  2491,   2491,   2491,   2491,
  -155,   -155,   -155,   -155,
 -2061,  -2061,  -2061,  -2061,
 32429,  32429,  32429,  32429,
  2563,   2563,   2563,   2563,
  -163,   -163,   -163,   -163,
 -2107,  -2107,  -2107,  -2107,
 32411,  32411,  32411,  32411,
  2635,   2635,   2635,   2635,
  -171,   -171,   -171,   -171,
 -2153,  -2153,  -2153,  -2153,
 32393,  32393,  32393,  32393,
  2708,   2708,   2708,   2708,
  -180,   -180,   -180,   -180,
 -2198,  -2198,  -2198,  -2198,
 32374,  32374,  32374,  32374,
  2781,   2781,   2781,   2781,
  -189,   -189,   -189,   -189,
 -2243,  -2243,  -2243,  -2243,
 32355,  32355,  32355,  32355,
  2854,   2854,   2854,   2854,
  -198,   -198,   -198,   -198,
 -2287,  -2287,  -2287,  -2287,
 32335,  32335,  32335,  32335,
  2927,   2927,   2927,   2927,
  -207,   -207,   -207,   -207,
 -2331,  -2331,  -2331,  -2331,
 32315,  32315,  32315,  32315,
  3000,   3000,   3000,   3000,
  -216,   -216,   -216,   -216,
 -2374,  -2374,  -2374,  -2374,
 32294,  32294,  32294,  32294,
  3074,   3074,   3074,   3074,
  -226,   -226,   -226,   -226,
 -2417,  -2417,  -2417,  -2417,
 32273,  32273,  32273,  32273,
  3148,   3148,   3148,   3148,
  -236,   -236,   -236,   -236,
 -2460,  -2460,  -2460,  -2460,
 32252,  32252,  32252,  32252,
  3222,   3222,   3222,   3222,
  -246,   -246,   -246,   -246,
 -2502,  -2502,  -2502,  -2502,
 32230,  32230,  32230,  32230,
  3296,   3296,   3296,   3296,
  -256,   -256,   -256,   -256,
 -2544,  -2544,  -2544,  -2544,
 32208,  32208,  32208,  32208,
  3370,   3370,   3370,   3370,
  -266,   -266,   -266,   -266,
 -2585,  -2585,  -2585,  -2585,
 32185,  32185,  32185,  32185,
  3445,   3445,   3445,   3445,
  -277,   -277,   -277,   -277,
 -2626,  -2626,  -2626,  -2626,
 32162,  32162,  32162,  32162,
  3519,   3519,   3519,   3519,
  -287,   -287,   -287,   -287,
 -2666,  -2666,  -2666,  -2666,
 32138,  32138,  32138,  32138,
  3594,   3594,   3594,   3594,
  -298,   -298,   -298,   -298,
 -2706,  -2706,  -2706,  -2706,
 32114,  32114,  32114,  32114,
  3669,   3669,   3669,   3669,
  -309,   -309,   -309,   -309,
 -2746,  -2746,  -2746,  -2746,
 32090,  32090,  32090,  32090,
  3744,   3744,   3744,   3744,
  -320,   -320,   -320,   -320,
 -2785,  -2785,  -2785,  -2785,
 32065,  32065,  32065,  32065,
  3820,   3820,   3820,   3820,
  -332,   -332,   -332,   -332,
 -2824,  -2824,  -2824,  -2824,
 32040,  32040,  32040,  32040,
  3895,   3895,   3895,   3895,
  -343,   -343,   -343,   -343,
 -2862,  -2862,  -2862,  -2862,
 32014,  32014,  32014,  32014,
  3971,   3971,   3971,   3971,
  -355,   -355,   -355,   -355,
 -2900,  -2900,  -2900,  -2900,
 31988,  31988,  31988,  31988,
  4047,   4047,   4047,   4047,
  -367,   -367,   -367,   -367,
 -2937,  -2937,  -2937,  -2937,
 31961,  31961,  31961,  31961,
  4123,   4123,   4123,   4123,
  -379,   -379,   -379,   -379,
 -2974,  -2974,  -2974,  -2974,
 31934,  31934,  31934,  31934,
  4199,   4199,   4199,   4199,
  -391,   -391,   -391,   -391,
 -3011,  -3011,  -3011,  -3011,
 31907,  31907,  31907,  31907,
  4275,   4275,   4275,   4275,
  -403,   -403,   -403,   -403,
 -3047,  -3047,  -3047,  -3047,
 31879,  31879,  31879,  31879,
  4352,   4352,   4352,   4352,
  -416,   -416,   -416,   -416,
 -3083,  -3083,  -3083,  -3083,
 31851,  31851,  31851,  31851,
  4429,   4429,   4429,   4429,
  -429,   -429,   -429,   -429,
 -3118,  -3118,  -3118,  -3118,
 31822,  31822,  31822,  31822,
  4506,   4506,   4506,   4506,
  -442,   -442,   -442,   -442,
 -3153,  -3153,  -3153,  -3153,
 31793,  31793,  31793,  31793,
  4583,   4583,   4583,   4583,
  -455,   -455,   -455,   -455,
 -3188,  -3188,  -3188,  -3188,
 31764,  31764,  31764,  31764,
  4660,   4660,   4660,   4660,
  -468,   -468,   -468,   -468,
 -3222,  -3222,  -3222,  -3222,
 31734,  31734,  31734,  31734,
  4737,   4737,   4737,   4737,
  -481,   -481,   -481,   -481,
 -3256,  -3256,  -3256,  -3256,
 31704,  31704,  31704,  31704,
  4814,   4814,   4814,   4814,
  -494,   -494,   -494,   -494,
 -3289,  -3289,  -3289,  -3289,
 31673,  31673,  31673,  31673,
  4892,   4892,   4892,   4892,
  -508,   -508,   -508,   -508,
 -3322,  -3322,  -3322,  -3322,
 31642,  31642,  31642,  31642,
  4970,   4970,   4970,   4970,
  -522,   -522,   -522,   -522,
 -3355,  -3355,  -3355,  -3355,
 31611,  31611,  31611,  31611,
  5048,   5048,   5048,   5048,
  -536,   -536,   -536,   -536,
 -3387,  -3387,  -3387,  -3387,
 31579,  31579,  31579,  31579,
  5126,   5126,   5126,   5126,
  -550,   -550,   -550,   -550,
 -3419,  -3419,  -3419,  -3419,
 31547,  31547,  31547,  31547,
  5204,   5204,   5204,   5204,
  -564,   -564,   -564,   -564,
 -3450,  -3450,  -3450,  -3450,
 31514,  31514,  31514,  31514,
  5282,   5282,   5282,   5282,
  -578,   -578,   -578,   -578,
 -3481,  -3481,  -3481,  -3481,
 31481,  31481,  31481,  31481,
  5361,   5361,   5361,   5361,
  -593,   -593,   -593,   -593,
 -3512,  -3512,  -3512,  -3512,
 31448,  31448,  31448,  31448,
  5439,   5439,   5439,   5439,
  -607,   -607,   -607,   -607,
 -3542,  -3542,  -3542,  -3542,
 31414,  31414,  31414,  31414,
  5518,   5518,   5518,   5518,
  -622,   -622,   -622,   -622,
 -3572,  -3572,  -3572,  -3572,
 31380,  31380,  31380,  31380,
  5597,   5597,   5597,   5597,
  -637,   -637,   -637,   -637,
 -3602,  -3602,  -3602,  -3602,
 31346,  31346,  31346,  31346,
  5676,   5676,   5676,   5676,
  -652,   -652,   -652,   -652,
 -3631,  -3631,  -3631,  -3631,
 31311,  31311,  31311,  31311,
  5755,   5755,   5755,   5755,
  -667,   -667,   -667,   -667,
 -3659,  -3659,  -3659,  -3659,
 31275,  31275,  31275,  31275,
  5835,   5835,   5835,   5835,
  -683,   -683,   -683,   -683,
 -3688,  -3688,  -3688,  -3688,
 31240,  31240,  31240,  31240,
  5914,   5914,   5914,   5914,
  -698,   -698,   -698,   -698,
 -3716,  -3716,  -3716,  -3716,
 31204,  31204,  31204,  31204,
  5994,   5994,   5994,   5994,
  -714,   -714,   -714,   -714,
 -3743,  -3743,  -3743,  -3743,
 31167,  31167,  31167,  31167,
  6073,   6073,   6073,   6073,
  -729,   -729,   -729,   -729,
 -3770,  -3770,  -3770,  -3770,
 31130,  31130,  31130,  31130,
  6153,   6153,   6153,   6153,
  -745,   -745,   -745,   -745,
 -3797,  -3797,  -3797,  -3797,
 31093,  31093,  31093,  31093,
  6233,   6233,   6233,   6233,
  -761,   -761,   -761,   -761,
 -3823,  -3823,  -3823,  -3823,
 31055,  31055,  31055,  31055,
  6313,   6313,   6313,   6313,
  -777,   -777,   -777,   -777,
 -3849,  -3849,  -3849,  -3849,
 31017,  31017,  31017,  31017,
  6393,   6393,   6393,   6393,
  -793,   -793,   -793,   -793,
 -3875,  -3875,  -3875,  -3875,
 30979,  30979,  30979,  30979,
  6474,   6474,   6474,   6474,
  -810,   -810,   -810,   -810,
 -3900,  -3900,  -3900,  -3900,
 30940,  30940,  30940,  30940,
  6554,   6554,   6554,   6554,
  -826,   -826,   -826,   -826,
 -3925,  -3925,  -3925,  -3925,
 30901,  30901,  30901,  30901,
  6635,   6635,   6635,   6635,
  -843,   -843,   -843,   -843,
 -3950,  -3950,  -3950,  -3950,
 30862,  30862,  30862,  30862,
  6716,   6716,   6716,   6716,
  -860,   -860,   -860,   -860,
 -3974,  -3974,  -3974,  -3974,
 30822,  30822,  30822,  30822,
  6796,   6796,   6796,   6796,
  -876,   -876,   -876,   -876,
 -3998,  -3998,  -3998,  -3998,
 30782,  30782,  30782,  30782,
  6877,   6877,   6877,   6877,
  -893,   -893,   -893,   -893,
 -4021,  -4021,  -4021,  -4021,
 30741,  30741,  30741,  30741,
  6958,   6958,   6958,   6958,
  -910,   -910,   -910,   -910,
 -4045,  -4045,  -4045,  -4045,
 30701,  30701,  30701,  30701,
  7039,   7039,   7039,   7039,
  -927,   -927,   -927,   -927,
 -4067,  -4067,  -4067,  -4067,
 30659,  30659,  30659,  30659,
  7121,   7121,   7121,   7121,
  -945,   -945,   -945,   -945,
 -4090,  -4090,  -4090,  -4090,
 30618,  30618,  30618,  30618,
  7202,   7202,   7202,   7202,
  -962,   -962,   -962,   -962,
 -4112,  -4112,  -4112,  -4112,
 30576,  30576,  30576,  30576,
  7283,   7283,   7283,   7283,
  -979,   -979,   -979,   -979,
 -4133,  -4133,  -4133,  -4133,
 30533,  30533,  30533,  30533,
  7365,   7365,   7365,   7365,
  -997,   -997,   -997,   -997,
 -4155,  -4155,  -4155,  -4155,
 30491,  30491,  30491,  30491,
  7447,   7447,   7447,   7447,
 -1015,  -1015,  -1015,  -1015,
 -4176,  -4176,  -4176,  -4176,
 30448,  30448,  30448,  30448,
  7528,   7528,   7528,   7528,
 -1032,  -1032,  -1032,  -1032,
 -4196,  -4196,  -4196,  -4196,
 30404,  30404,  30404,  30404,
  7610,   7610,   7610,   7610,
 -1050,  -1050,  -1050,  -1050,
 -4217,  -4217,  -4217,  -4217,
 30361,  30361,  30361,  30361,
  7692,   7692,   7692,   7692,
 -1068,  -1068,  -1068,  -1068,
 -4237,  -4237,  -4237,  -4237,
 30317,  30317,  30317,  30317,
  7774,   7774,   7774,   7774,
 -1086,  -1086,  -1086,  -1086,
 -4256,  -4256,  -4256,  -4256,
 30272,  30272,  30272,  30272,
  7857,   7857,   7857,   7857,
 -1105,  -1105,  -1105,  -1105,
 -4275,  -4275,  -4275,  -4275,
 30227,  30227,  30227,  30227,
  7939,   7939,   7939,   7939,
 -1123,  -1123,  -1123,  -1123,
 -4294,  -4294,  -4294,  -4294,
 30182,  30182,  30182,  30182,
  8021,   8021,   8021,   8021,
 -1141,  -1141,  -1141,  -1141,
 -4313,  -4313,  -4313,  -4313,
 30137,  30137,  30137,  30137,
  8104,   8104,   8104,   8104,
 -1160,  -1160,  -1160,  -1160,
 -4331,  -4331,  -4331,  -4331,
 30091,  30091,  30091,  30091,
  8186,   8186,   8186,   8186,
 -1178,  -1178,  -1178,  -1178,
 -4349,  -4349,  -4349,  -4349,
 30045,  30045,  30045,  30045,
  8269,   8269,   8269,   8269,
 -1197,  -1197,  -1197,  -1197,
 -4366,  -4366,  -4366,  -4366,
 29998,  29998,  29998,  29998,
  8352,   8352,   8352,   8352,
 -1216,  -1216,  -1216,  -1216,
 -4384,  -4384,  -4384,  -4384,
 29952,  29952,  29952,  29952,
  8434,   8434,   8434,   8434,
 -1234,  -1234,  -1234,  -1234,
 -4400,  -4400,  -4400,  -4400,
 29904,  29904,  29904,  29904,
  8517,   8517,   8517,   8517,
 -1253,  -1253,  -1253,  -1253,
 -4417,  -4417,  -4417,  -4417,
 29857,  29857,  29857,  29857,
  8600,   8600,   8600,   8600,
 -1272,  -1272,  -1272,  -1272,
 -4433,  -4433,  -4433,  -4433,
 29809,  29809,  29809,  29809,
  8683,   8683,   8683,   8683,
 -1291,  -1291,  -1291,  -1291,
 -4449,  -4449,  -4449,  -4449,
 29761,  29761,  29761,  29761,
  8767,   8767,   8767,   8767,
 -1311,  -1311,  -1311,  -1311,
 -4464,  -4464,  -4464,  -4464,
 29712,  29712,  29712,  29712,
  8850,   8850,   8850,   8850,
 -1330,  -1330,  -1330,  -1330,
 -4480,  -4480,  -4480,  -4480,
 29664,  29664,  29664,  29664,
  8933,   8933,   8933,   8933,
 -1349,  -1349,  -1349,  -1349,
 -4495,  -4495,  -4495,  -4495,
 29615,  29615,  29615,  29615,
  9016,   9016,   9016,   9016,
 -1368,  -1368,  -1368,  -1368,
 -4509,  -4509,  -4509,  -4509,
 29565,  29565,  29565,  29565,
  9100,   9100,   9100,   9100,
 -1388,  -1388,  -1388,  -1388,
 -4523,  -4523,  -4523,  -4523,
 29515,  29515,  29515,  29515,
  9183,   9183,   9183,   9183,
 -1407,  -1407,  -1407,  -1407,
 -4537,  -4537,  -4537,  -4537,
 29465,  29465,  29465,  29465,
  9267,   9267,   9267,   9267,
 -1427,  -1427,  -1427,  -1427,
 -4551,  -4551,  -4551,  -4551,
 29415,  29415,  29415,  29415,
  9351,   9351,   9351,   9351,
 -1447,  -1447,  -1447,  -1447,
 -4564,  -4564,  -4564,  -4564,
 29364,  29364,  29364,  29364,
  9434,   9434,   9434,   9434,
 -1466,  -1466,  -1466,  -1466,
 -4577,  -4577,  -4577,  -4577,
 29313,  29313,  29313,  29313,
  9518,   9518,   9518,   9518,
 -1486,  -1486,  -1486,  -1486,
 -4590,  -4590,  -4590,  -4590,
 29262,  29262,  29262,  29262,
  9602,   9602,   9602,   9602,
 -1506,  -1506,  -1506,  -1506,
 -4602,  -4602,  -4602,  -4602,
 29210,  29210,  29210,  29210,
  9686,   9686,   9686,   9686,
 -1526,  -1526,  -1526,  -1526,
 -4614,  -4614,  -4614,  -4614,
 29158,  29158,  29158,  29158,
  9770,   9770,   9770,   9770,
 -1546,  -1546,  -1546,  -1546,
 -4626,  -4626,  -4626,  -4626,
 29106,  29106,  29106,  29106,
  9854,   9854,   9854,   9854,
 -1566,  -1566,  -1566,  -1566,
 -4637,  -4637,  -4637,  -4637,
 29053,  29053,  29053,  29053,
  9938,   9938,   9938,   9938,
 -1586,  -1586,  -1586,  -1586,
 -4648,  -4648,  -4648,  -4648,
 29000,  29000,  29000,  29000,
 10022,  10022,  10022,  10022,
 -1606,  -1606,  -1606,  -1606,
 -4659,  -4659,  -4659,  -4659,
 28947,  28947,  28947,  28947,
 10107,  10107,  10107,  10107,
 -1627,  -1627,  -1627,  -1627,
 -4669,  -4669,  -4669,  -4669,
 28893,  28893,  28893,  28893,
 10191,  10191,  10191,  10191,
 -1647,  -1647,  -1647,  -1647,
 -4679,  -4679,  -4679,  -4679,
 28839,  28839,  28839,  28839,
 10275,  10275,  10275,  10275,
 -1667,  -1667,  -1667,  -1667,
 -4689,  -4689,  -4689,  -4689,
 28785,  28785,  28785,  28785,
 10360,  10360,  10360,  10360,
 -1688,  -1688,  -1688,  -1688,
 -4699,  -4699,  -4699,  -4699,
 28731,  28731,  28731,  28731,
 10444,  10444,  10444,  10444,
 -1708,  -1708,  -1708,  -1708,
 -4708,  -4708,  -4708,  -4708,
 28676,  28676,  28676,  28676,
 10529,  10529,  10529,  10529,
 -1729,  -1729,  -1729,  -1729,
 -4717,  -4717,  -4717,  -4717,
 28621,  28621,  28621,  28621,
 10613,  10613,  10613,  10613,
 -1749,  -1749,  -1749,  -1749,
 -4726,  -4726,  -4726,  -4726,
 28566,  28566,  28566,  28566,
 10698,  10698,  10698,  10698,
 -1770,  -1770,  -1770,  -1770,
 -4734,  -4734,  -4734,  -4734,
 28510,  28510,  28510,  28510,
 10782,  10782,  10782,  10782,
 -1790,  -1790,  -1790,  -1790,
 -4742,  -4742,  -4742,  -4742,
 28454,  28454,  28454,  28454,
 10867,  10867,  10867,  10867,
 -1811,  -1811,  -1811,  -1811,
 -4750,  -4750,  -4750,  -4750,
 28398,  28398,  28398,  28398,
 10952,  10952,  10952,  10952,
 -1832,  -1832,  -1832,  -1832,
 -4757,  -4757,  -4757,  -4757,
 28341,  28341,  28341,  28341,
 11037,  11037,  11037,  11037,
 -1853,  -1853,  -1853,  -1853,
 -4765,  -4765,  -4765,  -4765,
 28285,  28285,  28285,  28285,
 11121,  11121,  11121,  11121,
 -1873,  -1873,  -1873,  -1873,
 -4771,  -4771,  -4771,  -4771,
 28227,  28227,  28227,  28227,
 11206,  11206,  11206,  11206,
 -1894,  -1894,  -1894,  -1894,
 -4778,  -4778,  -4778,  -4778,
 28170,  28170,  28170,  28170,
 11291,  11291,  11291,  11291,
 -1915,  -1915,  -1915,  -1915,
 -4784,  -4784,  -4784,  -4784,
 28112,  28112,  28112,  28112,
 11376,  11376,  11376,  11376,
 -1936,  -1936,  -1936,  -1936,
 -4790,  -4790,  -4790,  -4790,
 28054,  28054,  28054,  28054,
 11461,  11461,  11461,  11461,
 -1957,  -1957,  -1957,  -1957,
 -4796,  -4796,  -4796,  -4796,
 27996,  27996,  27996,  27996,
 11546,  11546,  11546,  11546,
 -1978,  -1978,  -1978,  -1978,
 -4802,  -4802,  -4802,  -4802,
 27938,  27938,  27938,  27938,
 11631,  11631,  11631,  11631,
 -1999,  -1999,  -1999,  -1999,
 -4807,  -4807,  -4807,  -4807,
 27879,  27879,  27879,  27879,
 11716,  11716,  11716,  11716,
 -2020,  -2020,  -2020,  -2020,
 -4812,  -4812,  -4812,  -4812,
 27820,  27820,  27820,  27820,
 11801,  11801,  11801,  11801,
 -2041,  -2041,  -2041,  -2041,
 -4816,  -4816,  -4816,  -4816,
 27760,  27760,  27760,  27760,
 11886,  11886,  11886,  11886,
 -2062,  -2062,  -2062,  -2062,
 -4821,  -4821,  -4821,  -4821,
 27701,  27701,  27701,  27701,
 11971,  11971,  11971,  11971,
 -2083,  -2083,  -2083,  -2083,
 -4825,  -4825,  -4825,  -4825,
 27641,  27641,  27641,  27641,
 12057,  12057,  12057,  12057,
 -2105,  -2105,  -2105,  -2105,
 -4829,  -4829,  -4829,  -4829,
 27581,  27581,  27581,  27581,
 12142,  12142,  12142,  12142,
 -2126,  -2126,  -2126,  -2126,
 -4832,  -4832,  -4832,  -4832,
 27520,  27520,  27520,  27520,
 12227,  12227,  12227,  12227,
 -2147,  -2147,  -2147,  -2147,
 -4836,  -4836,  -4836,  -4836,
 27460,  27460,  27460,  27460,
 12312,  12312,  12312,  12312,
 -2168,  -2168,  -2168,  -2168,
 -4839,  -4839,  -4839,  -4839,
 27399,  27399,  27399,  27399,
 12397,  12397,  12397,  12397,
 -2189,  -2189,  -2189,  -2189,
 -4841,  -4841,  -4841,  -4841,
 27337,  27337,  27337,  27337,
 12483,  12483,  12483,  12483,
 -2211,  -2211,  -2211,  -2211,
 -4844,  -4844,  -4844,  -4844,
 27276,  27276,  27276,  27276,
 12568,  12568,  12568,  12568,
 -2232,  -2232,  -2232,  -2232,
 -4846,  -4846,  -4846,  -4846,
 27214,  27214,  27214,  27214,
 12653,  12653,  12653,  12653,
 -2253,  -2253,  -2253,  -2253,
 -4848,  -4848,  -4848,  -4848,
 27152,  27152,  27152,  27152,
 12738,  12738,  12738,  12738,
 -2274,  -2274,  -2274,  -2274,
 -4850,  -4850,  -4850,  -4850,
 27090,  27090,  27090,  27090,
 12824,  12824,  12824,  12824,
 -2296,  -2296,  -2296,  -2296,
 -4851,  -4851,  -4851,  -4851,
 27027,  27027,  27027,  27027,
 12909,  12909,  12909,  12909,
 -2317,  -2317,  -2317,  -2317,
 -4852,  -4852,  -4852,  -4852,
 26964,  26964,  26964,  26964,
 12994,  12994,  12994,  12994,
 -2338,  -2338,  -2338,  -2338,
 -4853,  -4853,  -4853,  -4853,
 26901,  26901,  26901,  26901,
 13080,  13080,  13080,  13080,
 -2360,  -2360,  -2360,  -2360,
 -4854,  -4854,  -4854,  -4854,
 26838,  26838,  26838,  26838,
 13165,  13165,  13165,  13165,
 -2381,  -2381,  -2381,  -2381,
 -4854,  -4854,  -4854,  -4854,
 26774,  26774,  26774,  26774,
 13250,  13250,  13250,  13250,
 -2402,  -2402,  -2402,  -2402,
 -4855,  -4855,  -4855,  -4855,
 26711,  26711,  26711,  26711,
 13336,  13336,  13336,  13336,
 -2424,  -2424,  -2424,  -2424,
 -4854,  -4854,  -4854,  -4854,
 26646,  26646,  26646,  26646,
 13421,  13421,  13421,  13421,
 -2445,  -2445,  -2445,  -2445,
 -4854,  -4854,  -4854,  -4854,
 26582,  26582,  26582,  26582,
 13506,  13506,  13506,  13506,
 -2466,  -2466,  -2466,  -2466,
 -4854,  -4854,  -4854,  -4854,
 26518,  26518,  26518,  26518,
 13592,  13592,  13592,  13592,
 -2488,  -2488,  -2488,  -2488,
 -4853,  -4853,  -4853,  -4853,
 26453,  26453,  26453,  26453,
 13677,  13677,  13677,  13677,
 -2509,  -2509,  -2509,  -2509,
 -4852,  -4852,  -4852,  -4852,
 26388,  26388,  26388,  26388,
 13762,  13762,  13762,  13762,
 -2530,  -2530,  -2530,  -2530,
 -4850,  -4850,  -4850,  -4850,
 26322,  26322,  26322,  26322,
 13848,  13848,  13848,  13848,
 -2552,  -2552,  -2552,  -2552,
 -4849,  -4849,  -4849,  -4849,
 26257,  26257,  26257,  26257,
 13933,  13933,  13933,  13933,
 -2573,  -2573,  -2573,  -2573,
 -4847,  -4847,  -4847,  -4847,
 26191,  26191,  26191,  26191,
 14018,  14018,  14018,  14018,
 -2594,  -2594,  -2594,  -2594,
 -4845,  -4845,  -4845,  -4845,
 26125,  26125,  26125,  26125,
 14104,  14104,  14104,  14104,
 -2616,  -2616,  -2616,  -2616,
 -4843,  -4843,  -4843,  -4843,
 26059,  26059,  26059,  26059,
 14189,  14189,  14189,  14189,
 -2637,  -2637,  -2637,  -2637,
 -4840,  -4840,  -4840,  -4840,
 25992,  25992,  25992,  25992,
 14274,  14274,  14274,  14274,
 -2658,  -2658,  -2658,  -2658,
 -4837,  -4837,  -4837,  -4837,
 25925,  25925,  25925,  25925,
 14359,  14359,  14359,  14359,
 -2679,  -2679,  -2679,  -2679,
 -4834,  -4834,  -4834,  -4834,
 25858,  25858,  25858,  25858,
 14445,  14445,  14445,  14445,
 -2701,  -2701,  -2701,  -2701,
 -4831,  -4831,  -4831,  -4831,
 25791,  25791,  25791,  25791,
 14530,  14530,  14530,  14530,
 -2722,  -2722,  -2722,  -2722,
 -4828,  -4828,  -4828,  -4828,
 25724,  25724,  25724,  25724,
 14615,  14615,  14615,  14615,
 -2743,  -2743,  -2743,  -2743,
 -4824,  -4824,  -4824,  -4824,
 25656,  25656,  25656,  25656,
 14700,  14700,  14700,  14700,
 -2764,  -2764,  -2764,  -2764,
 -4820,  -4820,  -4820,  -4820,
 25588,  25588,  25588,  25588,
 14785,  14785,  14785,  14785,
 -2785,  -2785,  -2785,  -2785,
 -4816,  -4816,  -4816,  -4816,
 25520,  25520,  25520,  25520,
 14870,  14870,  14870,  14870,
 -2806,  -2806,  -2806,  -2806,
 -4812,  -4812,  -4812,  -4812,
 25452,  25452,  25452,  25452,
 14955,  14955,  14955,  14955,
 -2827,  -2827,  -2827,  -2827,
 -4807,  -4807,  -4807,  -4807,
 25383,  25383,  25383,  25383,
 15040,  15040,  15040,  15040,
 -2848,  -2848,  -2848,  -2848,
 -4802,  -4802,  -4802,  -4802,
 25314,  25314,  25314,  25314,
 15125,  15125,  15125,  15125,
 -2869,  -2869,  -2869,  -2869,
 -4797,  -4797,  -4797,  -4797,
 25245,  25245,  25245,  25245,
 15210,  15210,  15210,  15210,
 -2890,  -2890,  -2890,  -2890,
 -4792,  -4792,  -4792,  -4792,
 25176,  25176,  25176,  25176,
 15295,  15295,  15295,  15295,
 -2911,  -2911,  -2911,  -2911,
 -4787,  -4787,  -4787,  -4787,
 25107,  25107,  25107,  25107,
 15380,  15380,  15380,  15380,
 -2932,  -2932,  -2932,  -2932,
 -4781,  -4781,  -4781,  -4781,
 25037,  25037,  25037,  25037,
 15465,  15465,  15465,  15465,
 -2953,  -2953,  -2953,  -2953,
 -4775,  -4775,  -4775,  -4775,
 24967,  24967,  24967,  24967,
 15550,  15550,  15550,  15550,
 -2974,  -2974,  -2974,  -2974,
 -4769,  -4769,  -4769,  -4769,
 24897,  24897,  24897,  24897,
 15635,  15635,  15635,  15635,
 -2995,  -2995,  -2995,  -2995,
 -4763,  -4763,  -4763,  -4763,
 24827,  24827,  24827,  24827,
 15720,  15720,  15720,  15720,
 -3016,  -3016,  -3016,  -3016,
 -4756,  -4756,  -4756,  -4756,
 24756,  24756,  24756,  24756,
 15805,  15805,  15805,  15805,
 -3037,  -3037,  -3037,  -3037,
 -4750,  -4750,  -4750,  -4750,
 24686,  24686,  24686,  24686,
 15889,  15889,  15889,  15889,
 -3057,  -3057,  -3057,  -3057,
 -4743,  -4743,  -4743,  -4743,
 24615,  24615,  24615,  24615,
 15974,  15974,  15974,  15974,
 -3078,  -3078,  -3078,  -3078,
 -4736,  -4736,  -4736,  -4736,
 24544,  24544,  24544,  24544,
 16058,  16058,  16058,  16058,
 -3098,  -3098,  -3098,  -3098,
 -4728,  -4728,  -4728,  -4728,
 24472,  24472,  24472,  24472,
 16143,  16143,  16143,  16143,
 -3119,  -3119,  -3119,  -3119,
 -4721,  -4721,  -4721,  -4721,
 24401,  24401,  24401,  24401,
 16228,  16228,  16228,  16228,
 -3140,  -3140,  -3140,  -3140,
 -4713,  -4713,  -4713,  -4713,
 24329,  24329,  24329,  24329,
 16312,  16312,  16312,  16312,
 -3160,  -3160,  -3160,  -3160,
 -4705,  -4705,  -4705,  -4705,
 24257,  24257,  24257,  24257,
 16396,  16396,  16396,  16396,
 -3180,  -3180,  -3180,  -3180,
 -4697,  -4697,  -4697,  -4697,
 24185,  24185,  24185,  24185,
 16481,  16481,  16481,  16481,
 -3201,  -3201,  -3201,  -3201,
 -4689,  -4689,  -4689,  -4689,
 24113,  24113,  24113,  24113,
 16565,  16565,  16565,  16565,
 -3221,  -3221,  -3221,  -3221,
 -4680,  -4680,  -4680,  -4680,
 24040,  24040,  24040,  24040,
 16649,  16649,  16649,  16649,
 -3241,  -3241,  -3241,  -3241,
 -4672,  -4672,  -4672,  -4672,
 23968,  23968,  23968,  23968,
 16734,  16734,  16734,  16734,
 -3262,  -3262,  -3262,  -3262,
 -4663,  -4663,  -4663,  -4663,
 23895,  23895,  23895,  23895,
 16818,  16818,  16818,  16818,
 -3282,  -3282,  -3282,  -3282,
 -4654,  -4654,  -4654,  -4654,
 23822,  23822,  23822,  23822,
 16902,  16902,  16902,  16902,
 -3302,  -3302,  -3302,  -3302,
 -4644,  -4644,  -4644,  -4644,
 23748,  23748,  23748,  23748,
 16986,  16986,  16986,  16986,
 -3322,  -3322,  -3322,  -3322,
 -4635,  -4635,  -4635,  -4635,
 23675,  23675,  23675,  23675,
 17070,  17070,  17070,  17070,
 -3342,  -3342,  -3342,  -3342,
 -4625,  -4625,  -4625,  -4625,
 23601,  23601,  23601,  23601,
 17154,  17154,  17154,  17154,
 -3362,  -3362,  -3362,  -3362,
 -4615,  -4615,  -4615,  -4615,
 23527,  23527,  23527,  23527,
 17238,  17238,  17238,  17238,
 -3382,  -3382,  -3382,  -3382,
 -4605,  -4605,  -4605,  -4605,
 23453,  23453,  23453,  23453,
 17321,  17321,  17321,  17321,
 -3401,  -3401,  -3401,  -3401,
 -4595,  -4595,  -4595,  -4595,
 23379,  23379,  23379,  23379,
 17405,  17405,  17405,  17405,
 -3421,  -3421,  -3421,  -3421,
 -4585,  -4585,  -4585,  -4585,
 23305,  23305,  23305,  23305,
 17489,  17489,  17489,  17489,
 -3441,  -3441,  -3441,  -3441,
 -4574,  -4574,  -4574,  -4574,
 23230,  23230,  23230,  23230,
 17572,  17572,  17572,  17572,
 -3460,  -3460,  -3460,  -3460,
 -4564,  -4564,  -4564,  -4564,
 23156,  23156,  23156,  23156,
 17656,  17656,  17656,  17656,
 -3480,  -3480,  -3480,  -3480,
 -4553,  -4553,  -4553,  -4553,
 23081,  23081,  23081,  23081,
 17739,  17739,  17739,  17739,
 -3499,  -3499,  -3499,  -3499,
 -4542,  -4542,  -4542,  -4542,
 23006,  23006,  23006,  23006,
 17822,  17822,  17822,  17822,
 -3518,  -3518,  -3518,  -3518,
 -4530,  -4530,  -4530,  -4530,
 22930,  22930,  22930,  22930,
 17906,  17906,  17906,  17906,
 -3538,  -3538,  -3538,  -3538,
 -4519,  -4519,  -4519,  -4519,
 22855,  22855,  22855,  22855,
 17989,  17989,  17989,  17989,
 -3557,  -3557,  -3557,  -3557,
 -4507,  -4507,  -4507,  -4507,
 22779,  22779,  22779,  22779,
 18072,  18072,  18072,  18072,
 -3576,  -3576,  -3576,  -3576,
 -4496,  -4496,  -4496,  -4496,
 22704,  22704,  22704,  22704,
 18155,  18155,  18155,  18155,
 -3595,  -3595,  -3595,  -3595,
 -4484,  -4484,  -4484,  -4484,
 22628,  22628,  22628,  22628,
 18238,  18238,  18238,  18238,
 -3614,  -3614,  -3614,  -3614,
 -4472,  -4472,  -4472,  -4472,
 22552,  22552,  22552,  22552,
 18321,  18321,  18321,  18321,
 -3633,  -3633,  -3633,  -3633,
 -4459,  -4459,  -4459,  -4459,
 22475,  22475,  22475,  22475,
 18403,  18403,  18403,  18403,
 -3651,  -3651,  -3651,  -3651,
 -4447,  -4447,  -4447,  -4447,
 22399,  22399,  22399,  22399,
 18486,  18486,  18486,  18486,
 -3670,  -3670,  -3670,  -3670,
 -4434,  -4434,  -4434,  -4434,
 22322,  22322,  22322,  22322,
 18569,  18569,  18569,  18569,
 -3689,  -3689,  -3689,  -3689,
 -4422,  -4422,  -4422,  -4422,
 22246,  22246,  22246,  22246,
 18651,  18651,  18651,  18651,
 -3707,  -3707,  -3707,  -3707,
 -4409,  -4409,  -4409,  -4409,
 22169,  22169,  22169,  22169,
 18734,  18734,  18734,  18734,
 -3726,  -3726,  -3726,  -3726,
 -4396,  -4396,  -4396,  -4396,
 22092,  22092,  22092,  22092,
 18816,  18816,  18816,  18816,
 -3744,  -3744,  -3744,  -3744,
 -4382,  -4382,  -4382,  -4382,
 22014,  22014,  22014,  22014,
 18898,  18898,  18898,  18898,
 -3762,  -3762,  -3762,  -3762,
 -4369,  -4369,  -4369,  -4369,
 21937,  21937,  21937,  21937,
 18980,  18980,  18980,  18980,
 -3780,  -3780,  -3780,  -3780,
 -4356,  -4356,  -4356,  -4356,
 21860,  21860,  21860,  21860,
 19062,  19062,  19062,  19062,
 -3798,  -3798,  -3798,  -3798,
 -4342,  -4342,  -4342,  -4342,
 21782,  21782,  21782,  21782,
 19144,  19144,  19144,  19144,
 -3816,  -3816,  -3816,  -3816,
 -4328,  -4328,  -4328,  -4328,
 21704,  21704,  21704,  21704,
 19226,  19226,  19226,  19226,
 -3834,  -3834,  -3834,  -3834,
 -4314,  -4314,  -4314,  -4314,
 21626,  21626,  21626,  21626,
 19308,  19308,  19308,  19308,
 -3852,  -3852,  -3852,  -3852,
 -4300,  -4300,  -4300,  -4300,
 21548,  21548,  21548,  21548,
 19389,  19389,  19389,  19389,
 -3869,  -3869,  -3869,  -3869,
 -4286,  -4286,  -4286,  -4286,
 21470,  21470,  21470,  21470,
 19471,  19471,  19471,  19471,
 -3887,  -3887,  -3887,  -3887,
 -4271,  -4271,  -4271,  -4271,
 21391,  21391,  21391,  21391,
 19552,  19552,  19552,  19552,
 -3904,  -3904,  -3904,  -3904,
 -4257,  -4257,  -4257,  -4257,
 21313,  21313,  21313,  21313,
 19633,  19633,  19633,  19633,
 -3921,  -3921,  -3921,  -3921,
 -4242,  -4242,  -4242,  -4242,
 21234,  21234,  21234,  21234,
 19715,  19715,  19715,  19715,
 -3939,  -3939,  -3939,  -3939,
 -4227,  -4227,  -4227,  -4227,
 21155,  21155,  21155,  21155,
 19796,  19796,  19796,  19796,
 -3956,  -3956,  -3956,  -3956,
 -4212,  -4212,  -4212,  -4212,
 21076,  21076,  21076,  21076,
 19877,  19877,  19877,  19877,
 -3973,  -3973,  -3973,  -3973,
 -4197,  -4197,  -4197,  -4197,
 20997,  20997,  20997,  20997,
 19957,  19957,  19957,  19957,
 -3989,  -3989,  -3989,  -3989,
 -4182,  -4182,  -4182,  -4182,
 20918,  20918,  20918,  20918,
 20038,  20038,  20038,  20038,
 -4006,  -4006,  -4006,  -4006,
 -4167,  -4167,  -4167,  -4167,
 20839,  20839,  20839,  20839,
 20119,  20119,  20119,  20119,
 -4023,  -4023,  -4023,  -4023,
 -4151,  -4151,  -4151,  -4151,
 20759,  20759,  20759,  20759,
 20199,  20199,  20199,  20199,
 -4039,  -4039,  -4039,  -4039,
 -4136,  -4136,  -4136,  -4136,
 20680,  20680,  20680,  20680,
 20280,  20280,  20280,  20280,
 -4056,  -4056,  -4056,  -4056,
 -4120,  -4120,  -4120,  -4120,
 20600,  20600,  20600,  20600,
 20360,  20360,  20360,  20360,
 -4072,  -4072,  -4072,  -4072,
 -4104,  -4104,  -4104,  -4104,
 20520,  20520,  20520,  20520,
 20440,  20440,  20440,  20440,
 -4088,  -4088,  -4088,  -4088,
 -4088,  -4088,  -4088,  -4088,
 20440,  20440,  20440,  20440,
 20520,  20520,  20520,  20520,
 -4104,  -4104,  -4104,  -4104,
 -4072,  -4072,  -4072,  -4072,
 20360,  20360,  20360,  20360,
 20600,  20600,  20600,  20600,
 -4120,  -4120,  -4120,  -4120,
 -4056,  -4056,  -4056,  -4056,
 20280,  20280,  20280,  20280,
 20680,  20680,  20680,  20680,
 -4136,  -4136,  -4136,  -4136,
 -4039,  -4039,  -4039,  -4039,
 20199,  20199,  20199,  20199,
 20759,  20759,  20759,  20759,
 -4151,  -4151,  -4151,  -4151,
 -4023,  -4023,  -4023,  -4023,
 20119,  20119,  20119,  20119,
 20839,  20839,  20839,  20839,
 -4167,  -4167,  -4167,  -4167,
 -4006,  -4006,  -4006,  -4006,
 20038,  20038,  20038,  20038,
 20918,  20918,  20918,  20918,
 -4182,  -4182,  -4182,  -4182,
 -3989,  -3989,  -3989,  -3989,
 19957,  19957,  19957,  19957,
 20997,  20997,  20997,  20997,
 -4197,  -4197,  -4197,  -4197,
 -3973,  -3973,  -3973,  -3973,
 19877,  19877,  19877,  19877,
 21076,  21076,  21076,  21076,
 -4212,  -4212,  -4212,  -4212,
 -3956,  -3956,  -3956,  -3956,
 19796,  19796,  19796,  19796,
 21155,  21155,  21155,  21155,
 -4227,  -4227,  -4227,  -4227,
 -3939,  -3939,  -3939,  -3939,
 19715,  19715,  19715,  19715,
 21234,  21234,  21234,  21234,
 -4242,  -4242,  -4242,  -4242,
 -3921,  -3921,  -3921,  -3921,
 19633,  19633,  19633,  19633,
 21313,  21313,  21313,  21313,
 -4257,  -4257,  -4257,  -4257,
 -3904,  -3904,  -3904,  -3904,
 19552,  19552,  19552,  19552,
 21391,  21391,  21391,  21391,
 -4271,  -4271,  -4271,  -4271,
 -3887,  -3887,  -3887,  -3887,
 19471,  19471,  19471,  19471,
 21470,  21470,  21470,  21470,
 -4286,  -4286,  -4286,  -4286,
 -3869,  -3869,  -3869,  -3869,
 19389,  19389,  19389,  19389,
 21548,  21548,  21548,  21548,
 -4300,  -4300,  -4300,  -4300,
 -3852,  -3852,  -3852,  -3852,
 19308,  19308,  19308,  19308,
 21626,  21626,  21626,  21626,
 -4314,  -4314,  -4314,  -4314,
 -3834,  -3834,  -3834,  -3834,
 19226,  19226,  19226,  19226,
 21704,  21704,  21704,  21704,
 -4328,  -4328,  -4328,  -4328,
 -3816,  -3816,  -3816,  -3816,
 19144,  19144,  19144,  19144,
 21782,  21782,  21782,  21782,
 -4342,  -4342,  -4342,  -4342,
 -3798,  -3798,  -3798,  -3798,
 19062,  19062,  19062,  19062,
 21860,  21860,  21860,  21860,
 -4356,  -4356,  -4356,  -4356,
 -3780,  -3780,  -3780,  -3780,
 18980,  18980,  18980,  18980,
 21937,  21937,  21937,  21937,
 -4369,  -4369,  -4369,  -4369,
 -3762,  -3762,  -3762,  -3762,
 18898,  18898,  18898,  18898,
 22014,  22014,  22014,  22014,
 -4382,  -4382,  -4382,  -4382,
 -3744,  -3744,  -3744,  -3744,
 18816,  18816,  18816,  18816,
 22092,  22092,  22092,  22092,
 -4396,  -4396,  -4396,  -4396,
 -3726,  -3726,  -3726,  -3726,
 18734,  18734,  18734,  18734,
 22169,  22169,  22169,  22169,
 -4409,  -4409,  -4409,  -4409,
 -3707,  -3707,  -3707,  -3707,
 18651,  18651,  18651,  18651,
 22246,  22246,  22246,  22246,
 -4422,  -4422,  -4422,  -4422,
 -3689,  -3689,  -3689,  -3689,
 18569,  18569,  18569,  18569,
 22322,  22322,  22322,  22322,
 -4434,  -4434,  -4434,  -4434,
 -3670,  -3670,  -3670,  -3670,
 18486,  18486,  18486,  18486,
 22399,  22399,  22399,  22399,
 -4447,  -4447,  -4447,  -4447,
 -3651,  -3651,  -3651,  -3651,
 18403,  18403,  18403,  18403,
 22475,  22475,  22475,  22475,
 -4459,  -4459,  -4459,  -4459,
 -3633,  -3633,  -3633,  -3633,
 18321,  18321,  18321,  18321,
 22552,  22552,  22552,  22552,
 -4472,  -4472,  -4472,  -4472,
 -3614,  -3614,  -3614,  -3614,
 18238,  18238,  18238,  18238,
 22628,  22628,  22628,  22628,
 -4484,  -4484,  -4484,  -4484,
 -3595,  -3595,  -3595,  -3595,
 18155,  18155,  18155,  18155,
 22704,  22704,  22704,  22704,
 -4496,  -4496,  -4496,  -4496,
 -3576,  -3576,  -3576,  -3576,
 18072,  18072,  18072,  18072,
 22779,  22779,  22779,  22779,
 -4507,  -4507,  -4507,  -4507,
 -3557,  -3557,  -3557,  -3557,
 17989,  17989,  17989,  17989,
 22855,  22855,  22855,  22855,
 -4519,  -4519,  -4519,  -4519,
 -3538,  -3538,  -3538,  -3538,
 17906,  17906,  17906,  17906,
 22930,  22930,  22930,  22930,
 -4530,  -4530,  -4530,  -4530,
 -3518,  -3518,  -3518,  -3518,
 17822,  17822,  17822,  17822,
 23006,  23006,  23006,  23006,
 -4542,  -4542,  -4542,  -4542,
 -3499,  -3499,  -3499,  -3499,
 17739,  17739,  17739,  17739,
 23081,  23081,  23081,  23081,
 -4553,  -4553,  -4553,  -4553,
 -3480,  -3480,  -3480,  -3480,
 17656,  17656,  17656,  17656,
 23156,  23156,  23156,  23156,
 -4564,  -4564,  -4564,  -4564,
 -3460,  -3460,  -3460,  -3460,
 17572,  17572,  17572,  17572,
 23230,  23230,  23230,  23230,
 -4574,  -4574,  -4574,  -4574,
 -3441,  -3441,  -3441,  -3441,
 17489,  17489,  17489,  17489,
 23305,  23305,  23305,  23305,
 -4585,  -4585,  -4585,  -4585,
 -3421,  -3421,  -3421,  -3421,
 17405,  17405,  17405,  17405,
 23379,  23379,  23379,  23379,
 -4595,  -4595,  -4595,  -4595,
 -3401,  -3401,  -3401,  -3401,
 17321,  17321,  17321,  17321,
 23453,  23453,  23453,  23453,
 -4605,  -4605,  -4605,  -4605,
 -3382,  -3382,  -3382,  -3382,
 17238,  17238,  17238,  17238,
 23527,  23527,  23527,  23527,
 -4615,  -4615,  -4615,  -4615,
 -3362,  -3362,  -3362,  -3362,
 17154,  17154,  17154,  17154,
 23601,  23601,  23601,  23601,
 -4625,  -4625,  -4625,  -4625,
 -3342,  -3342,  -3342,  -3342,
 17070,  17070,  17070,  17070,
 23675,  23675,  23675,  23675,
 -4635,  -4635,  -4635,  -4635,
 -3322,  -3322,  -3322,  -3322,
 16986,  16986,  16986,  16986,
 23748,  23748,  23748,  23748,
 -4644,  -4644,  -4644,  -4644,
 -3302,  -3302,  -3302,  -3302,
 16902,  16902,  16902,  16902,
 23822,  23822,  23822,  23822,
 -4654,  -4654,  -4654,  -4654,
 -3282,  -3282,  -3282,  -3282,
 16818,  16818,  16818,  16818,
 23895,  23895,  23895,  23895,
 -4663,  -4663,  -4663,  -4663,
 -3262,  -3262,  -3262,  -3262,
 16734,  16734,  16734,  16734,
 23968,  23968,  23968,  23968,
 -4672,  -4672,  -4672,  -4672,
 -3241,  -3241,  -3241,  -3241,
 16649,  16649,  16649,  16649,
 24040,  24040,  24040,  24040,
 -4680,  -4680,  -4680,  -4680,
 -3221,  -3221,  -3221,  -3221,
 16565,  16565,  16565,  16565,
 24113,  24113,  24113,  24113,
 -4689,  -4689,  -4689,  -4689,
 -3201,  -3201,  -3201,  -3201,
 16481,  16481,  16481,  16481,
 24185,  24185,  24185,  24185,
 -4697,  -4697,  -4697,  -4697,
 -3180,  -3180,  -3180,  -3180,
 16396,  16396,  16396,  16396,
 24257,  24257,  24257,  24257,
 -4705,  -4705,  -4705,  -4705,
 -3160,  -3160,  -3160,  -3160,
 16312,  16312,  16312,  16312,
 24329,  24329,  24329,  24329,
 -4713,  -4713,  -4713,  -4713,
 -3140,  -3140,  -3140,  -3140,
 16228,  16228,  16228,  16228,
 24401,  24401,  24401,  24401,
 -4721,  -4721,  -4721,  -4721,
 -3119,  -3119,  -3119,  -3119,
 16143,  16143,  16143,  16143,
 24472,  24472,  24472,  24472,
 -4728,  -4728,  -4728,  -4728,
 -3098,  -3098,  -3098,  -3098,
 16058,  16058,  16058,  16058,
 24544,  24544,  24544,  24544,
 -4736,  -4736,  -4736,  -4736,
 -3078,  -3078,  -3078,  -3078,
 15974,  15974,  15974,  15974,
 24615,  24615,  24615,  24615,
 -4743,  -4743,  -4743,  -4743,
 -3057,  -3057,  -3057,  -3057,
 15889,  15889,  15889,  15889,
 24686,  24686,  24686,  24686,
 -4750,  -4750,  -4750,  -4750,
 -3037,  -3037,  -3037,  -3037,
 15805,  15805,  15805,  15805,
 24756,  24756,  24756,  24756,
 -4756,  -4756,  -4756,  -4756,
 -3016,  -3016,  -3016,  -3016,
 15720,  15720,  15720,  15720,
 24827,  24827,  24827,  24827,
 -4763,  -4763,  -4763,  -4763,
 -2995,  -2995,  -2995,  -2995,
 15635,  15635,  15635,  15635,
 24897,  24897,  24897,  24897,
 -4769,  -4769,  -4769,  -4769,
 -2974,  -2974,  -2974,  -2974,
 15550,  15550,  15550,  15550,
 24967,  24967,  24967,  24967,
 -4775,  -4775,  -4775,  -4775,
 -2953,  -2953,  -2953,  -2953,
 15465,  15465,  15465,  15465,
 25037,  25037,  25037,  25037,
 -4781,  -4781,  -4781,  -4781,
 -2932,  -2932,  -2932,  -2932,
 15380,  15380,  15380,  15380,
 25107,  25107,  25107,  25107,
 -4787,  -4787,  -4787,  -4787,
 -2911,  -2911,  -2911,  -2911,
 15295,  15295,  15295,  15295,
 25176,  25176,  25176,  25176,
 -4792,  -4792,  -4792,  -4792,
 -2890,  -2890,  -2890,  -2890,
 15210,  15210,  15210,  15210,
 25245,  25245,  25245,  25245,
 -4797,  -4797,  -4797,  -4797,
 -2869,  -2869,  -2869,  -2869,
 15125,  15125,  15125,  15125,
 25314,  25314,  25314,  25314,
 -4802,  -4802,  -4802,  -4802,
 -2848,  -2848,  -2848,  -2848,
 15040,  15040,  15040,  15040,
 25383,  25383,  25383,  25383,
 -4807,  -4807,  -4807,  -4807,
 -2827,  -2827,  -2827,  -2827,
 14955,  14955,  14955,  14955,
 25452,  25452,  25452,  25452,
 -4812,  -4812,  -4812,  -4812,
 -2806,  -2806,  -2806,  -2806,
 14870,  14870,  14870,  14870,
 25520,  25520,  25520,  25520,
 -4816,  -4816,  -4816,  -4816,
 -2785,  -2785,  -2785,  -2785,
 14785,  14785,  14785,  14785,
 25588,  25588,  25588,  25588,
 -4820,  -4820,  -4820,  -4820,
 -2764,  -2764,  -2764,  -2764,
 14700,  14700,  14700,  14700,
 25656,  25656,  25656,  25656,
 -4824,  -4824,  -4824,  -4824,
 -2743,  -2743,  -2743,  -2743,
 14615,  14615,  14615,  14615,
 25724,  25724,  25724,  25724,
 -4828,  -4828,  -4828,  -4828,
 -2722,  -2722,  -2722,  -2722,
 14530,  14530,  14530,  14530,
 25791,  25791,  25791,  25791,
 -4831,  -4831,  -4831,  -4831,
 -2701,  -2701,  -2701,  -2701,
 14445,  14445,  14445,  14445,
 25858,  25858,  25858,  25858,
 -4834,  -4834,  -4834,  -4834,
 -2679,  -2679,  -2679,  -2679,
 14359,  14359,  14359,  14359,
 25925,  25925,  25925,  25925,
 -4837,  -4837,  -4837,  -4837,
 -2658,  -2658,  -2658,  -2658,
 14274,  14274,  14274,  14274,
 25992,  25992,  25992,  25992,
 -4840,  -4840,  -4840,  -4840,
 -2637,  -2637,  -2637,  -2637,
 14189,  14189,  14189,  14189,
 26059,  26059,  26059,  26059,
 -4843,  -4843,  -4843,  -4843,
 -2616,  -2616,  -2616,  -2616,
 14104,  14104,  14104,  14104,
 26125,  26125,  26125,  26125,
 -4845,  -4845,  -4845,  -4845,
 -2594,  -2594,  -2594,  -2594,
 14018,  14018,  14018,  14018,
 26191,  26191,  26191,  26191,
 -4847,  -4847,  -4847,  -4847,
 -2573,  -2573,  -2573,  -2573,
 13933,  13933,  13933,  13933,
 26257,  26257,  26257,  26257,
 -4849,  -4849,  -4849,  -4849,
 -2552,  -2552,  -2552,  -2552,
 13848,  13848,  13848,  13848,
 26322,  26322,  26322,  26322,
 -4850,  -4850,  -4850,  -4850,
 -2530,  -2530,  -2530,  -2530,
 13762,  13762,  13762,  13762,
 26388,  26388,  26388,  26388,
 -4852,  -4852,  -4852,  -4852,
 -2509,  -2509,  -2509,  -2509,
 13677,  13677,  13677,  13677,
 26453,  26453,  26453,  26453,
 -4853,  -4853,  -4853,  -4853,
 -2488,  -2488,  -2488,  -2488,
 13592,  13592,  13592,  13592,
 26518,  26518,  26518,  26518,
 -4854,  -4854,  -4854,  -4854,
 -2466,  -2466,  -2466,  -2466,
 13506,  13506,  13506,  13506,
 26582,  26582,  26582,  26582,
 -4854,  -4854,  -4854,  -4854,
 -2445,  -2445,  -2445,  -2445,
 13421,  13421,  13421,  13421,
 26646,  26646,  26646,  26646,
 -4854,  -4854,  -4854,  -4854,
 -2424,  -2424,  -2424,  -2424,
 13336,  13336,  13336,  13336,
 26711,  26711,  26711,  26711,
 -4855,  -4855,  -4855,  -4855,
 -2402,  -2402,  -2402,  -2402,
 13250,  13250,  13250,  13250,
 26774,  26774,  26774,  26774,
 -4854,  -4854,  -4854,  -4854,
 -2381,  -2381,  -2381,  -2381,
 13165,  13165,  13165,  13165,
 26838,  26838,  26838,  26838,
 -4854,  -4854,  -4854,  -4854,
 -2360,  -2360,  -2360,  -2360,
 13080,  13080,  13080,  13080,
 26901,  26901,  26901,  26901,
 -4853,  -4853,  -4853,  -4853,
 -2338,  -2338,  -2338,  -2338,
 12994,  12994,  12994,  12994,
 26964,  26964,  26964,  26964,
 -4852,  -4852,  -4852,  -4852,
 -2317,  -2317,  -2317,  -2317,
 12909,  12909,  12909,  12909,
 27027,  27027,  27027,  27027,
 -4851,  -4851,  -4851,  -4851,
 -2296,  -2296,  -2296,  -2296,
 12824,  12824,  12824,  12824,
 27090,  27090,  27090,  27090,
 -4850,  -4850,  -4850,  -4850,
 -2274,  -2274,  -2274,  -2274,
 12738,  12738,  12738,  12738,
 27152,  27152,  27152,  27152,
 -4848,  -4848,  -4848,  -4848,
 -2253,  -2253,  -2253,  -2253,
 12653,  12653,  12653,  12653,
 27214,  27214,  27214,  27214,
 -4846,  -4846,  -4846,  -4846,
 -2232,  -2232,  -2232,  -2232,
 12568,  12568,  12568,  12568,
 27276,  27276,  27276,  27276,
 -4844,  -4844,  -4844,  -4844,
 -2211,  -2211,  -2211,  -2211,
 12483,  12483,  12483,  12483,
 27337,  27337,  27337,  27337,
 -4841,  -4841,  -4841,  -4841,
 -2189,  -2189,  -2189,  -2189,
 12397,  12397,  12397,  12397,
 27399,  27399,  27399,  27399,
 -4839,  -4839,  -4839,  -4839,
 -2168,  -2168,  -2168,  -2168,
 12312,  12312,  12312,  12312,
 27460,  27460,  27460,  27460,
 -4836,  -4836,  -4836,  -4836,
 -2147,  -2147,  -2147,  -2147,
 12227,  12227,  12227,  12227,
 27520,  27520,  27520,  27520,
 -4832,  -4832,  -4832,  -4832,
 -2126,  -2126,  -2126,  -2126,
 12142,  12142,  12142,  12142,
 27581,  27581,  27581,  27581,
 -4829,  -4829,  -4829,  -4829,
 -2105,  -2105,  -2105,  -2105,
 12057,  12057,  12057,  12057,
 27641,  27641,  27641,  27641,
 -4825,  -4825,  -4825,  -4825,
 -2083,  -2083,  -2083,  -2083,
 11971,  11971,  11971,  11971,
 27701,  27701,  27701,  27701,
 -4821,  -4821,  -4821,  -4821,
 -2062,  -2062,  -2062,  -2062,
 11886,  11886,  11886,  11886,
 27760,  27760,  27760,  27760,
 -4816,  -4816,  -4816,  -4816,
 -2041,  -2041,  -2041,  -2041,
 11801,  11801,  11801,  11801,
 27820,  27820,  27820,  27820,
 -4812,  -4812,  -4812,  -4812,
 -2020,  -2020,  -2020,  -2020,
 11716,  11716,  11716,  11716,
 27879,  27879,  27879,  27879,
 -4807,  -4807,  -4807,  -4807,
 -1999,  -1999,  -1999,  -1999,
 11631,  11631,  11631,  11631,
 27938,  27938,  27938,  27938,
 -4802,  -4802,  -4802,  -4802,
 -1978,  -1978,  -1978,  -1978,
 11546,  11546,  11546,  11546,
 27996,  27996,  27996,  27996,
 -4796,  -4796,  -4796,  -4796,
 -1957,  -1957,  -1957,  -1957,
 11461,  11461,  11461,  11461,
 28054,  28054,  28054,  28054,
 -4790,  -4790,  -4790,  -4790,
 -1936,  -1936,  -1936,  -1936,
 11376,  11376,  11376,  11376,
 28112,  28112,  28112,  28112,
 -4784,  -4784,  -4784,  -4784,
 -1915,  -1915,  -1915,  -1915,
 11291,  11291,  11291,  11291,
 28170,  28170,  28170,  28170,
 -4778,  -4778,  -4778,  -4778,
 -1894,  -1894,  -1894,  -1894,
 11206,  11206,  11206,  11206,
 28227,  28227,  28227,  28227,
 -4771,  -4771,  -4771,  -4771,
 -1873,  -1873,  -1873,  -1873,
 11121,  11121,  11121,  11121,
 28285,  28285,  28285,  28285,
 -4765,  -4765,  -4765,  -4765,
 -1853,  -1853,  -1853,  -1853,
 11037,  11037,  11037,  11037,
 28341,  28341,  28341,  28341,
 -4757,  -4757,  -4757,  -4757,
 -1832,  -1832,  -1832,  -1832,
 10952,  10952,  10952,  10952,
 28398,  28398,  28398,  28398,
 -4750,  -4750,  -4750,  -4750,
 -1811,  -1811,  -1811,  -1811,
 10867,  10867,  10867,  10867,
 28454,  28454,  28454,  28454,
 -4742,  -4742,  -4742,  -4742,
 -1790,  -1790,  -1790,  -1790,
 10782,  10782,  10782,  10782,
 28510,  28510,  28510,  28510,
 -4734,  -4734,  -4734,  -4734,
 -1770,  -1770,  -1770,  -1770,
 10698,  10698,  10698,  10698,
 28566,  28566,  28566,  28566,
 -4726,  -4726,  -4726,  -4726,
 -1749,  -1749,  -1749,  -1749,
 10613,  10613,  10613,  10613,
 28621,  28621,  28621,  28621,
 -4717,  -4717,  -4717,  -4717,
 -1729,  -1729,  -1729,  -1729,
 10529,  10529,  10529,  10529,
 28676,  28676,  28676,  28676,
 -4708,  -4708,  -4708,  -4708,
 -1708,  -1708,  -1708,  -1708,
 10444,  10444,  10444,  10444,
 28731,  28731,  28731,  28731,
 -4699,  -4699,  -4699,  -4699,
 -1688,  -1688,  -1688,  -1688,
 10360,  10360,  10360,  10360,
 28785,  28785,  28785,  28785,
 -4689,  -4689,  -4689,  -4689,
 -1667,  -1667,  -1667,  -1667,
 10275,  10275,  10275,  10275,
 28839,  28839,  28839,  28839,
 -4679,  -4679,  -4679,  -4679,
 -1647,  -1647,  -1647,  -1647,
 10191,  10191,  10191,  10191,
 28893,  28893,  28893,  28893,
 -4669,  -4669,  -4669,  -4669,
 -1627,  -1627,  -1627,  -1627,
 10107,  10107,  10107,  10107,
 28947,  28947,  28947,  28947,
 -4659,  -4659,  -4659,  -4659,
 -1606,  -1606,  -1606,  -1606,
 10022,  10022,  10022,  10022,
 29000,  29000,  29000,  29000,
 -4648,  -4648,  -4648,  -4648,
 -1586,  -1586,  -1586,  -1586,
  9938,   9938,   9938,   9938,
 29053,  29053,  29053,  29053,
 -4637,  -4637,  -4637,  -4637,
 -1566,  -1566,  -1566,  -1566,
  9854,   9854,   9854,   9854,
 29106,  29106,  29106,  29106,
 -4626,  -4626,  -4626,  -4626,
 -1546,  -1546,  -1546,  -1546,
  9770,   9770,   9770,   9770,
 29158,  29158,  29158,  29158,
 -4614,  -4614,  -4614,  -4614,
 -1526,  -1526,  -1526,  -1526,
  9686,   9686,   9686,   9686,
 29210,  29210,  29210,  29210,
 -4602,  -4602,  -4602,  -4602,
 -1506,  -1506,  -1506,  -1506,
  9602,   9602,   9602,   9602,
 29262,  29262,  29262,  29262,
 -4590,  -4590,  -4590,  -4590,
 -1486,  -1486,  -1486,  -1486,
  9518,   9518,   9518,   9518,
 29313,  29313,  29313,  29313,
 -4577,  -4577,  -4577,  -4577,
 -1466,  -1466,  -1466,  -1466,
  9434,   9434,   9434,   9434,
 29364,  29364,  29364,  29364,
 -4564,  -4564,  -4564,  -4564,
 -1447,  -1447,  -1447,  -1447,
  9351,   9351,   9351,   9351,
 29415,  29415,  29415,  29415,
 -4551,  -4551,  -4551,  -4551,
 -1427,  -1427,  -1427,  -1427,
  9267,   9267,   9267,   9267,
 29465,  29465,  29465,  29465,
 -4537,  -4537,  -4537,  -4537,
 -1407,  -1407,  -1407,  -1407,
  9183,   9183,   9183,   9183,
 29515,  29515,  29515,  29515,
 -4523,  -4523,  -4523,  -4523,
 -1388,  -1388,  -1388,  -1388,
  9100,   9100,   9100,   9100,
 29565,  29565,  29565,  29565,
 -4509,  -4509,  -4509,  -4509,
 -1368,  -1368,  -1368,  -1368,
  9016,   9016,   9016,   9016,
 29615,  29615,  29615,  29615,
 -4495,  -4495,  -4495,  -4495,
 -1349,  -1349,  -1349,  -1349,
  8933,   8933,   8933,   8933,
 29664,  29664,  29664,  29664,
 -4480,  -4480,  -4480,  -4480,
 -1330,  -1330,  -1330,  -1330,
  8850,   8850,   8850,   8850,
 29712,  29712,  29712,  29712,
 -4464,  -4464,  -4464,  -4464,
 -1311,  -1311,  -1311,  -1311,
  8767,   8767,   8767,   8767,
 29761,  29761,  29761,  29761,
 -4449,  -4449,  -4449,  -4449,
 -1291,  -1291,  -1291,  -1291,
  8683,   8683,   8683,   8683,
 29809,  29809,  29809,  29809,
 -4433,  -4433,  -4433,  -4433,
 -1272,  -1272,  -1272,  -1272,
  8600,   8600,   8600,   8600,
 29857,  29857,  29857,  29857,
 -4417,  -4417,  -4417,  -4417,
 -1253,  -1253,  -1253,  -1253,
  8517,   8517,   8517,   8517,
 29904,  29904,  29904,  29904,
 -4400,  -4400,  -4400,  -4400,
 -1234,  -1234,  -1234,  -1234,
  8434,   8434,   8434,   8434,
 29952,  29952,  29952,  29952,
 -4384,  -4384,  -4384,  -4384,
 -1216,  -1216,  -1216,  -1216,
  8352,   8352,   8352,   8352,
 29998,  29998,  29998,  29998,
 -4366,  -4366,  -4366,  -4366,
 -1197,  -1197,  -1197,  -1197,
  8269,   8269,   8269,   8269,
 30045,  30045,  30045,  30045,
 -4349,  -4349,  -4349,  -4349,
 -1178,  -1178,  -1178,  -1178,
  8186,   8186,   8186,   8186,
 30091,  30091,  30091,  30091,
 -4331,  -4331,  -4331,  -4331,
 -1160,  -1160,  -1160,  -1160,
  8104,   8104,   8104,   8104,
 30137,  30137,  30137,  30137,
 -4313,  -4313,  -4313,  -4313,
 -1141,  -1141,  -1141,  -1141,
  8021,   8021,   8021,   8021,
 30182,  30182,  30182,  30182,
 -4294,  -4294,  -4294,  -4294,
 -1123,  -1123,  -1123,  -1123,
  7939,   7939,   7939,   7939,
 30227,  30227,  30227,  30227,
 -4275,  -4275,  -4275,  -4275,
 -1105,  -1105,  -1105,  -1105,
  7857,   7857,   7857,   7857,
 30272,  30272,  30272,  30272,
 -4256,  -4256,  -4256,  -4256,
 -1086,  -1086,  -1086,  -1086,
  7774,   7774,   7774,   7774,
 30317,  30317,  30317,  30317,
 -4237,  -4237,  -4237,  -4237,
 -1068,  -1068,  -1068,  -1068,
  7692,   7692,   7692,   7692,
 30361,  30361,  30361,  30361,
 -4217,  -4217,  -4217,  -4217,
 -1050,  -1050,  -1050,  -1050,
  7610,   7610,   7610,   7610,
 30404,  30404,  30404,  30404,
 -4196,  -4196,  -4196,  -4196,
 -1032,  -1032,  -1032,  -1032,
  7528,   7528,   7528,   7528,
 30448,  30448,  30448,  30448,
 -4176,  -4176,  -4176,  -4176,
 -1015,  -1015,  -1015,  -1015,
  7447,   7447,   7447,   7447,
 30491,  30491,  30491,  30491,
 -4155,  -4155,  -4155,  -4155,
  -997,   -997,   -997,   -997,
  7365,   7365,   7365,   7365,
 30533,  30533,  30533,  30533,
 -4133,  -4133,  -4133,  -4133,
  -979,   -979,   -979,   -979,
  7283,   7283,   7283,   7283,
 30576,  30576,  30576,  30576,
 -4112,  -4112,  -4112,  -4112,
  -962,   -962,   -962,   -962,
  7202,   7202,   7202,   7202,
 30618,  30618,  30618,  30618,
 -4090,  -4090,  -4090,  -4090,
  -945,   -945,   -945,   -945,
  7121,   7121,   7121,   7121,
 30659,  30659,  30659,  30659,
 -4067,  -4067,  -4067,  -4067,
  -927,   -927,   -927,   -927,
  7039,   7039,   7039,   7039,
 30701,  30701,  30701,  30701,
 -4045,  -4045,  -4045,  -4045,
  -910,   -910,   -910,   -910,
  6958,   6958,   6958,   6958,
 30741,  30741,  30741,  30741,
 -4021,  -4021,  -4021,  -4021,
  -893,   -893,   -893,   -893,
  6877,   6877,   6877,   6877,
 30782,  30782,  30782,  30782,
 -3998,  -3998,  -3998,  -3998,
  -876,   -876,   -876,   -876,
  6796,   6796,   6796,   6796,
 30822,  30822,  30822,  30822,
 -3974,  -3974,  -3974,  -3974,
  -860,   -860,   -860,   -860,
  6716,   6716,   6716,   6716,
 30862,  30862,  30862,  30862,
 -3950,  -3950,  -3950,  -3950,
  -843,   -843,   -843,   -843,
  6635,   6635,   6635,   6635,
 30901,  30901,  30901,  30901,
 -3925,  -3925,  -3925,  -3925,
  -826,   -826,   -826,   -826,
  6554,   6554,   6554,   6554,
 30940,  30940,  30940,  30940,
 -3900,  -3900,  -3900,  -3900,
  -810,   -810,   -810,   -810,
  6474,   6474,   6474,   6474,
 30979,  30979,  30979,  30979,
 -3875,  -3875,  -3875,  -3875,
  -793,   -793,   -793,   -793,
  6393,   6393,   6393,   6393,
 31017,  31017,  31017,  31017,
 -3849,  -3849,  -3849,  -3849,
  -777,   -777,   -777,   -777,
  6313,   6313,   6313,   6313,
 31055,  31055,  31055,  31055,
 -3823,  -3823,  -3823,  -3823,
  -761,   -761,   -761,   -761,
  6233,   6233,   6233,   6233,
 31093,  31093,  31093,  31093,
 -3797,  -3797,  -3797,  -3797,
  -745,   -745,   -745,   -745,
  6153,   6153,   6153,   6153,
 31130,  31130,  31130,  31130,
 -3770,  -3770,  -3770,  -3770,
  -729,   -729,   -729,   -729,
  6073,   6073,   6073,   6073,
 31167,  31167,  31167,  31167,
 -3743,  -3743,  -3743,  -3743,
  -714,   -714,   -714,   -714,
  5994,   5994,   5994,   5994,
 31204,  31204,  31204,  31204,
 -3716,  -3716,  -3716,  -3716,
  -698,   -698,   -698,   -698,
  5914,   5914,   5914,   5914,
 31240,  31240,  31240,  31240,
 -3688,  -3688,  -3688,  -3688,
  -683,   -683,   -683,   -683,
  5835,   5835,   5835,   5835,
 31275,  31275,  31275,  31275,
 -3659,  -3659,  -3659,  -3659,
  -667,   -667,   -667,   -667,
  5755,   5755,   5755,   5755,
 31311,  31311,  31311,  31311,
 -3631,  -3631,  -3631,  -3631,
  -652,   -652,   -652,   -652,
  5676,   5676,   5676,   5676,
 31346,  31346,  31346,  31346,
 -3602,  -3602,  -3602,  -3602,
  -637,   -637,   -637,   -637,
  5597,   5597,   5597,   5597,
 31380,  31380,  31380,  31380,
 -3572,  -3572,  -3572,  -3572,
  -622,   -622,   -622,   -622,
  5518,   5518,   5518,   5518,
 31414,  31414,  31414,  31414,
 -3542,  -3542,  -3542,  -3542,
  -607,   -607,   -607,   -607,
  5439,   5439,   5439,   5439,
 31448,  31448,  31448,  31448,
 -3512,  -3512,  -3512,  -3512,
  -593,   -593,   -593,   -593,
  5361,   5361,   5361,   5361,
 31481,  31481,  31481,  31481,
 -3481,  -3481,  -3481,  -3481,
  -578,   -578,   -578,   -578,
  5282,   5282,   5282,   5282,
 31514,  31514,  31514,  31514,
 -3450,  -3450,  -3450,  -3450,
  -564,   -564,   -564,   -564,
  5204,   5204,   5204,   5204,
 31547,  31547,  31547,  31547,
 -3419,  -3419,  -3419,  -3419,
  -550,   -550,   -550,   -550,
  5126,   5126,   5126,   5126,
 31579,  31579,  31579,  31579,
 -3387,  -3387,  -3387,  -3387,
  -536,   -536,   -536,   -536,
  5048,   5048,   5048,   5048,
 31611,  31611,  31611,  31611,
 -3355,  -3355,  -3355,  -3355,
  -522,   -522,   -522,   -522,
  4970,   4970,   4970,   4970,
 31642,  31642,  31642,  31642,
 -3322,  -3322,  -3322,  -3322,
  -508,   -508,   -508,   -508,
  4892,   4892,   4892,   4892,
 31673,  31673,  31673,  31673,
 -3289,  -3289,  -3289,  -3289,
  -494,   -494,   -494,   -494,
  4814,   4814,   4814,   4814,
 31704,  31704,  31704,  31704,
 -3256,  -3256,  -3256,  -3256,
  -481,   -481,   -481,   -481,
  4737,   4737,   4737,   4737,
 31734,  31734,  31734,  31734,
 -3222,  -3222,  -3222,  -3222,
  -468,   -468,   -468,   -468,
  4660,   4660,   4660,   4660,
 31764,  31764,  31764,  31764,
 -3188,  -3188,  -3188,  -3188,
  -455,   -455,   -455,   -455,
  4583,   4583,   4583,   4583,
 31793,  31793,  31793,  31793,
 -3153,  -3153,  -3153,  -3153,
  -442,   -442,   -442,   -442,
  4506,   4506,   4506,   4506,
 31822,  31822,  31822,  31822,
 -3118,  -3118,  -3118,  -3118,
  -429,   -429,   -429,   -429,
  4429,   4429,   4429,   4429,
 31851,  31851,  31851,  31851,
 -3083,  -3083,  -3083,  -3083,
  -416,   -416,   -416,   -416,
  4352,   4352,   4352,   4352,
 31879,  31879,  31879,  31879,
 -3047,  -3047,  -3047,  -3047,
  -403,   -403,   -403,   -403,
  4275,   4275,   4275,   4275,
 31907,  31907,  31907,  31907,
 -3011,  -3011,  -3011,  -3011,
  -391,   -391,   -391,   -391,
  4199,   4199,   4199,   4199,
 31934,  31934,  31934,  31934,
 -2974,  -2974,  -2974,  -2974,
  -379,   -379,   -379,   -379,
  4123,   4123,   4123,   4123,
 31961,  31961,  31961,  31961,
 -2937,  -2937,  -2937,  -2937,
  -367,   -367,   -367,   -367,
  4047,   4047,   4047,   4047,
 31988,  31988,  31988,  31988,
 -2900,  -2900,  -2900,  -2900,
  -355,   -355,   -355,   -355,
  3971,   3971,   3971,   3971,
 32014,  32014,  32014,  32014,
 -2862,  -2862,  -2862,  -2862,
  -343,   -343,   -343,   -343,
  3895,   3895,   3895,   3895,
 32040,  32040,  32040,  32040,
 -2824,  -2824,  -2824,  -2824,
  -332,   -332,   -332,   -332,
  3820,   3820,   3820,   3820,
 32065,  32065,  32065,  32065,
 -2785,  -2785,  -2785,  -2785,
  -320,   -320,   -320,   -320,
  3744,   3744,   3744,   3744,
 32090,  32090,  32090,  32090,
 -2746,  -2746,  -2746,  -2746,
  -309,   -309,   -309,   -309,
  3669,   3669,   3669,   3669,
 32114,  32114,  32114,  32114,
 -2706,  -2706,  -2706,  -2706,
  -298,   -298,   -298,   -298,
  3594,   3594,   3594,   3594,
 32138,  32138,  32138,  32138,
 -2666,  -2666,  -2666,  -2666,
  -287,   -287,   -287,   -287,
  3519,   3519,   3519,   3519,
 32162,  32162,  32162,  32162,
 -2626,  -2626,  -2626,  -2626,
  -277,   -277,   -277,   -277,
  3445,   3445,   3445,   3445,
 32185,  32185,  32185,  32185,
 -2585,  -2585,  -2585,  -2585,
  -266,   -266,   -266,   -266,
  3370,   3370,   3370,   3370,
 32208,  32208,  32208,  32208,
 -2544,  -2544,  -2544,  -2544,
  -256,   -256,   -256,   -256,
  3296,   3296,   3296,   3296,
 32230,  32230,  32230,  32230,
 -2502,  -2502,  -2502,  -2502,
  -246,   -246,   -246,   -246,
  3222,   3222,   3222,   3222,
 32252,  32252,  32252,  32252,
 -2460,  -2460,  -2460,  -2460,
  -236,   -236,   -236,   -236,
  3148,   3148,   3148,   3148,
 32273,  32273,  32273,  32273,
 -2417,  -2417,  -2417,  -2417,
  -226,   -226,   -226,   -226,
  3074,   3074,   3074,   3074,
 32294,  32294,  32294,  32294,
 -2374,  -2374,  -2374,  -2374,
  -216,   -216,   -216,   -216,
  3000,   3000,   3000,   3000,
 32315,  32315,  32315,  32315,
 -2331,  -2331,  -2331,  -2331,
  -207,   -207,   -207,   -207,
  2927,   2927,   2927,   2927,
 32335,  32335,  32335,  32335,
 -2287,  -2287,  -2287,  -2287,
  -198,   -198,   -198,   -198,
  2854,   2854,   2854,   2854,
 32355,  32355,  32355,  32355,
 -2243,  -2243,  -2243,  -2243,
  -189,   -189,   -189,   -189,
  2781,   2781,   2781,   2781,
 32374,  32374,  32374,  32374,
 -2198,  -2198,  -2198,  -2198,
  -180,   -180,   -180,   -180,
  2708,   2708,   2708,   2708,
 32393,  32393,  32393,  32393,
 -2153,  -2153,  -2153,  -2153,
  -171,   -171,   -171,   -171,
  2635,   2635,   2635,   2635,
 32411,  32411,  32411,  32411,
 -2107,  -2107,  -2107,  -2107,
  -163,   -163,   -163,   -163,
  2563,   2563,   2563,   2563,
 32429,  32429,  32429,  32429,
 -2061,  -2061,  -2061,  -2061,
  -155,   -155,   -155,   -155,
  2491,   2491,   2491,   2491,
 32447,  32447,  32447,  32447,
 -2015,  -2015,  -2015,  -2015,
  -147,   -147,   -147,   -147,
  2419,   2419,   2419,   2419,
 32464,  32464,  32464,  32464,
 -1968,  -1968,  -1968,  -1968,
  -139,   -139,   -139,   -139,
  2347,   2347,   2347,   2347,
 32480,  32480,  32480,  32480,
 -1920,  -1920,  -1920,  -1920,
  -131,   -131,   -131,   -131,
  2275,   2275,   2275,   2275,
 32497,  32497,  32497,  32497,
 -1873,  -1873,  -1873,  -1873,
  -124,   -124,   -124,   -124,
  2204,   2204,   2204,   2204,
 32512,  32512,  32512,  32512,
 -1824,  -1824,  -1824,  -1824,
  -116,   -116,   -116,   -116,
  2132,   2132,   2132,   2132,
 32528,  32528,  32528,  32528,
 -1776,  -1776,  -1776,  -1776,
  -109,   -109,   -109,   -109,
  2061,   2061,   2061,   2061,
 32542,  32542,  32542,  32542,
 -1726,  -1726,  -1726,  -1726,
  -103,   -103,   -103,   -103,
  1991,   1991,   1991,   1991,
 32557,  32557,  32557,  32557,
 -1677,  -1677,  -1677,  -1677,
   -96,    -96,    -96,    -96,
  1920,   1920,   1920,   1920,
 32571,  32571,  32571,  32571,
 -1627,  -1627,  -1627,  -1627,
   -89,    -89,    -89,    -89,
  1849,   1849,   1849,   1849,
 32584,  32584,  32584,  32584,
 -1576,  -1576,  -1576,  -1576,
   -83,    -83,    -83,    -83,
  1779,   1779,   1779,   1779,
 32597,  32597,  32597,  32597,
 -1525,  -1525,  -1525,  -1525,
   -77,    -77,    -77,    -77,
  1709,   1709,   1709,   1709,
 32609,  32609,  32609,  32609,
 -1473,  -1473,  -1473,  -1473,
   -71,    -71,    -71,    -71,
  1639,   1639,   1639,   1639,
 32622,  32622,  32622,  32622,
 -1422,  -1422,  -1422,  -1422,
   -66,    -66,    -66,    -66,
  1570,   1570,   1570,   1570,
 32633,  32633,  32633,  32633,
 -1369,  -1369,  -1369,  -1369,
   -61,    -61,    -61,    -61,
  1501,   1501,   1501,   1501,
 32644,  32644,  32644,  32644,
 -1316,  -1316,  -1316,  -1316,
   -55,    -55,    -55,    -55,
  1431,   1431,   1431,   1431,
 32655,  32655,  32655,  32655,
 -1263,  -1263,  -1263,  -1263,
   -50,    -50,    -50,    -50,
  1362,   1362,   1362,   1362,
 32665,  32665,  32665,  32665,
 -1209,  -1209,  -1209,  -1209,
   -46,    -46,    -46,    -46,
  1294,   1294,   1294,   1294,
 32675,  32675,  32675,  32675,
 -1155,  -1155,  -1155,  -1155,
   -41,    -41,    -41,    -41,
  1225,   1225,   1225,   1225,
 32684,  32684,  32684,  32684,
 -1100,  -1100,  -1100,  -1100,
   -37,    -37,    -37,    -37,
  1157,   1157,   1157,   1157,
 32693,  32693,  32693,  32693,
 -1045,  -1045,  -1045,  -1045,
   -33,    -33,    -33,    -33,
  1089,   1089,   1089,   1089,
 32701,  32701,  32701,  32701,
  -989,   -989,   -989,   -989,
   -29,    -29,    -29,    -29,
  1021,   1021,   1021,   1021,
 32709,  32709,  32709,  32709,
  -933,   -933,   -933,   -933,
   -26,    -26,    -26,    -26,
   954,    954,    954,    954,
 32716,  32716,  32716,  32716,
  -876,   -876,   -876,   -876,
   -22,    -22,    -22,    -22,
   886,    886,    886,    886,
 32723,  32723,  32723,  32723,
  -819,   -819,   -819,   -819,
   -19,    -19,    -19,    -19,
   819,    819,    819,    819,
 32729,  32729,  32729,  32729,
  -761,   -761,   -761,   -761,
   -16,    -16,    -16,    -16,
   752,    752,    752,    752,
 32735,  32735,  32735,  32735,
  -703,   -703,   -703,   -703,
   -13,    -13,    -13,    -13,
   685,    685,    685,    685,
 32741,  32741,  32741,  32741,
  -645,   -645,   -645,   -645,
   -11,    -11,    -11,    -11,
   619,    619,    619,    619,
 32746,  32746,  32746,  32746,
  -586,   -586,   -586,   -586,
    -9,     -9,     -9,     -9,
   553,    553,    553,    553,
 32750,  32750,  32750,  32750,
  -526,   -526,   -526,   -526,
    -7,     -7,     -7,     -7,
   487,    487,    487,    487,
 32754,  32754,  32754,  32754,
  -466,   -466,   -466,   -466,
    -5,     -5,     -5,     -5,
   421,    421,    421,    421,
 32758,  32758,  32758,  32758,
  -406,   -406,   -406,   -406,
    -4,     -4,     -4,     -4,
   356,    356,    356,    356,
 32760,  32760,  32760,  32760,
  -344,   -344,   -344,   -344,
    -3,     -3,     -3,     -3,
   291,    291,    291,    291,
 32763,  32763,  32763,  32763,
  -283,   -283,   -283,   -283,
    -2,     -2,     -2,     -2,
   226,    226,    226,    226,
 32765,  32765,  32765,  32765,
  -221,   -221,   -221,   -221,
    -1,     -1,     -1,     -1,
   161,    161,    161,    161,
 32766,  32766,  32766,  32766,
  -158,   -158,   -158,   -158,
     0,      0,      0,      0,
    96,     96,     96,     96,
 32767,  32767,  32767,  32767,
   -95,    -95,    -95,    -95,
     0,      0,      0,      0,
    32,     32,     32,     32,
 32767,  32767,  32767,  32767,
   -32,    -32,    -32,    -32
};
