library(DiceDesign)
set.seed(123)

dimension <- 2
size <- 10
X <- lhsDesign(size, dimension)$design
dt1 <- system.time( result <- discrepSA_LHS(X,T0=10,c=0.999,it=50000,criterion="C2",profile="GEOM") )
print(dt1)
print(min(result$critValues))
print(discrepancyCriteria(result$design, type='C2'))
png("dice_lhs_sa_geom_10.png")
plot(result$design, col="blue", xlab="", ylab="", main="LHS design of size = 10, optimization of C2 criterion using geometric SA")
dev.off()
png("dice_c2_crit.png")
plot(result$critValues,type="l", col='blue', xlab="Iterations", ylab="C2 criterion", main="C2 criterion history of optimal design")
dev.off()
png("dice_c2_proba.png")
plot(result$probaValues,type="p", pch=".", xlab="Iterations", ylab="Probability", main="Probability history of optimal design")
dev.off()
png("dice_geom_profile.png")
plot(result$tempValues,type="l", col='red', xlab="Iterations", ylab="Temperature criterion", main="Temperature criterion history of optimal design")
dev.off()

dt2 <- system.time( result <- maximinSA_LHS(X,T0=10,it=50000,profile="LINEAR") )
print(dt2)
print(mindist(result$design))
png("dice_lhs_sa_lin_10.png")
plot(result$design, col="blue", xlab="", ylab="", main="LHS design of size = 10, optimization of MinDist criterion using linear SA")
dev.off()
png("dice_mindist_crit.png")
plot(result$critValues,type="l", col='blue', xlab="Iterations", ylab="PhiP criterion", main="PhiP criterion history of optimal design")
dev.off()
png("dice_mindist_proba.png")
plot(result$probaValues,type="p", pch=".", xlab="Iterations", ylab="Probability", main="Probability history of optimal design")
dev.off()
png("dice_lin_profile.png")
plot(result$tempValues,type="l", col='red', xlab="Iterations", ylab="Temperature criterion", main="Temperature criterion history of optimal design")
dev.off()
