#! /usr/bin/env python

import os

width = 32

# check that python can load OpenTURNS module
print '1: Python module load'.ljust(width),
try:
    import openturns as ot
    print 'OK'
except:
    print 'no'

# check that python can find the Viewer module
# If it fails, check that matplotlib package is installed
print '2: Viewer (matplotlib)'.ljust(width),
try:
    import openturns.viewer
    print 'OK'
except:
    print 'no'

# check that OpenTURNS can run R
# It should produce a file named testDraw.png
print '3: drawing (R)'.ljust(width),
try:
    graph = ot.Normal().drawPDF()
    fname = 'testDraw.png'
    try:
        graph.draw(fname)
        os.remove(fname)
    except:
        raise
    print 'OK'
except:
    print 'no'

# check that rot package is installed
print '4: linear model (R.rot)'.ljust(width),
try:
    lm = ot.LinearModelFactory().build(
        ot.Normal(2).getSample(10), ot.Normal().getSample(10))
    print 'OK'
except:
    print 'no'

# check XML support
print '5: serialization (LibXML2)'.ljust(width),
try:
    storageManager = ot.XMLStorageManager('myFile.xml')
    print 'OK'
except:
    print 'no'

# check that the sample wrappers are accessible
print '6: compiled wrappers'.ljust(width),
try:
    f = ot.NumericalMathFunction('poutre')
    print 'OK'
except:
    print 'no'

# check that analytical function are available
print '7: analytical function (muParser)'.ljust(width),
try:
    f = ot.NumericalMathFunction(['x1', 'x2'], ['y'], ['x1+x2'])
    print 'OK'
except:
    print 'no'

# check that hmat library was found
print '8: HMat'.ljust(width),
try:
    # This is a little bit tricky because HMat 1.0 fails with 1x1 matrices
    ot.ResourceMap.SetAsUnsignedInteger(
        "TemporalNormalProcess-SamplingMethod", 1)
    vertices = ot.NumericalSample(0, 3)
    vertices.add([0.0, 0.0, 0.0])
    vertices.add([1.0, 0.0, 0.0])
    vertices.add([0.0, 1.0, 0.0])
    vertices.add([0.0, 0.0, 1.0])
    simplices = ot.IndicesCollection(0)
    simplices.add([0, 1, 2, 3])
    # Discard messages from HMat
    ot.Log.Show(0)
    process = ot.TemporalNormalProcess(
        ot.ExponentialModel(3), ot.Mesh(vertices, simplices))
    f = process.getRealization()
    print 'OK'
except:
    print 'no'
