\name{computeTestChiSquaredGeometric}
\alias{computeTestChiSquaredGeometric}
\title{Compute the chi squared test for Geometric Distribution.}
\description{
This ROT function, called from a Test C++ object, is given a sample,
the geometric distribution parameter, and optionnaly a test level. 
It then returns the result of a X2 test against the null hypothesis 
that the sample has un underlying Geometric distribution and returns a
list containing the result, statistic and test p-value.
}
\usage{
computeTestChiSquaredGeometric(numericalSample,  p, testLevel = 0.95, estimatedParameters)
}
\arguments{
  \item{numericalSample}{the sample to be tested (numeric vector)}
  \item{p}{The p parameter (scalar)}
  \item{testLevel}{the test level. (scalar in [0:1])}
  \item{estimatedParameters}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pValue}{The test p-value. (scalar)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
# Standard Normal distribution example. 

print(computeTestChiSquaredGeometric(rgeom(1000, 0.5), 0.5))
print(computeTestChiSquaredGeometric(rgeom(1000, 0.5), 0.25))
}
\keyword{distribution}
