\name{computeTestSpearman}
\alias{computeTestSpearman}
\title{Compute the Spearman Test on 2 data sets.}
\description{
This ROT function, called from a Test C++ object, is given 2 samples,
and optionnaly a test level. It then returns the result of a S test against the 
null hypothesis that the in/out variables are not correlated, and 
the test p-values.
}
\usage{
computeTestSpearman(inData, outData, testLevel = 0.95)
}
\arguments{
  \item{inData}{The 'in' sample. (m-by-n matrix)}
  \item{outData}{The 'out' sample (n vector).}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pvalues}{The test pvalues. (vector)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
outData=runif(4)
inData=matrix(runif(40), 4, 10)
computeTestSpearman(inData,outData)
}
\keyword{multivariate}
