##################################################################################
#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# Ref: John Cobb
# This script is released under the GNU GPL v2
#
# Updated: 04/07/2009 
# Antu Sanadi <santu@secpod.com>
#
################################################################################

if(description)
{
  script_id(17227);
  script_bugtraq_id(12549);
  script_cve_id("CVE-2005-0442", "CVE-2005-0443");
  script_version("$Revision: 7198 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_name("Brooky CubeCart index.php language XSS");
  desc = "
  The remote host runs CubeCart, is an eCommerce script written with PHP & MySQL.
  This version is vulnerable to cross-site scripting and remote script
  injection due to a lack of sanitization of user-supplied data.
  Successful exploitation of this issue may allow an attacker to execute
  malicious script code on a vulnerable server.

  Solution: Upgrade to version 2.0.5 or higher
  Risk factor : Medium";

  script_description(desc);
  script_summary("Checks Brooky CubeCart language XSS");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2005 David Maciejak");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  script_dependencie("secpod_cubecart_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

version = get_kb_item(string("www/", port, "/cubecart"));
if(!version){
  exit(0);
}

if(!safe_checks())
{
  foreach dir (make_list("/cubecart/upload","/upload", cgi_dirs()))
  {
    buf= http_get(item:string(dir,"/index.php?&language=<script>foo</script>"), port:port);
    r = http_send_recv(port:port, data:buf);
    if(egrep(pattern:"<script>foo</script>", string:r)){
      security_warning(port);
      exit(0);
     }
  }
}

if(version_is_less_equal(version:version, test_version:"2.0.4")){
  security_warning(port);
}
