# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 197-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53441);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 197-1 (courier)";
 script_name(name);

 desc = "The remote host is missing an update to courier
announced via advisory DSA 197-1.

A problem in the Courier sqwebmail package, a CGI program to grant
authenticated access to local mailboxes, has been discovered.  The
program did not drop permissions fast enough upon startup under
certain circumstances so a local shell user can execute the sqwebmail
binary and manage to read an arbitrary file on the local filesystem.

This problem has been fixed in version 0.37.3-2.3 for the current
stable distribution (woody) and in version 0.40.0-1 for the unstable
distribution (sid).  The old stable distribution (potato) does not
contain Courier sqwebmail packages.

We recommend that you upgrade your sqwebmail package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20197-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 197-1 (courier)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"courier-doc", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authdaemon", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authmysql", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-base", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-debug", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap", ver:"1.4.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap-ssl", ver:"1.4.3-3.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-ldap", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-maildrop", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mlm", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mta", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pcp", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pop", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-webadmin", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sqwebmail", ver:"0.37.3-2.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
