###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for drupal-cck FEDORA-2008-9479
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860300);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-9479");
  script_name( "Fedora Update for drupal-cck FEDORA-2008-9479");
  desc = "

  Vulnerability Insight:
  The Content Construction Kit allows you create and customize fields using
  a web browser. The 4.7x version of CCK creates custom content types and
  allows you to add custom fields to them. In Drupal 5.x custom content
  types can be created in core, and CCK allows you to add custom fields to
  any content type.


  Affected Software/OS:
  drupal-cck on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-November/msg00178.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of drupal-cck");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"drupal-cck", rpm:"drupal-cck~6.x.2.0~3.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}