###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for console-tools MDKA-2007:077 (console-tools)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830188);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:077");
  script_name( "Mandriva Update for console-tools MDKA-2007:077 (console-tools)");
  desc = "

  Vulnerability Insight:

  vt-is-UTF8 utility included in console-tools package, and used by
  Mandriva initscripts, can hang, causing random problems like preventing
  a local/remote system reboot, unless user take interactive action
  (#27948). Also, when executed on a terminal different from a linux vt,
  it can cause errors and make it unresponsive.
  
  Updated packages fixes both problems, and also removes setkeycodes
  limit, better fix for a previous issue alread addressed (#21741).

  Affected Software/OS:
  console-tools on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-07/msg00004.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of console-tools");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"console-tools", rpm:"console-tools~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0", rpm:"libconsole0~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0-devel", rpm:"libconsole0-devel~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0-static-devel", rpm:"libconsole0-static-devel~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0", rpm:"lib64console0~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0-devel", rpm:"lib64console0-devel~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0-static-devel", rpm:"lib64console0-static-devel~0.2.3~61.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"console-tools", rpm:"console-tools~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0", rpm:"libconsole0~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0-devel", rpm:"libconsole0-devel~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libconsole0-static-devel", rpm:"libconsole0-static-devel~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0", rpm:"lib64console0~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0-devel", rpm:"lib64console0-devel~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64console0-static-devel", rpm:"lib64console0-static-devel~0.2.3~60.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}