###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mort_bay_jetty_mult_xss_vuln.nasl 6816 2010-02-01 12:33:29 feb $
#
# MortMort Bay Jetty Multiple Cross Site Scripting Vulnerabilities
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800285);
  script_version("$Revision$: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4612");
  script_name("Mort Bay Jetty Multiple Cross-Site Scripting Vulnerabilities");
  desc = "
  Overview: This host is running Mort Bay Jetty and is prone to multiple Cross
  Site Scripting vulnerabilities.

  Vulnerability Insight:
  Multiple flaws exists due to error in 'PATH_INFO' parameter, it is not
  properly sanitised data before used via the default URI under 'jspsnoop/',
  'jspsnoop/ERROR/', 'jspsnoop/IOException/' and 'snoop.jsp'

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary HTML
  and script code in a user's browser session in the context of an affected site
  allowing Cross-Site Scripting attacks.

  Impact Level: Application.

  Affected Software/OS:
  Jetty version 6.0.x to 6.1.21

  Fix:
  No solution or patch is available as on 01st, February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mortbay.org/jetty/

  Workaround:
  Apply workaround from below link,
  http://seclists.org/fulldisclosure/2009/Oct/319

  References:
  http://seclists.org/fulldisclosure/2009/Oct/319
  http://www.ush.it/team/ush/hack_httpd_escape/adv.txt

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Mort Bay Jetty");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_dependencies("gb_jetty_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

jettyPort = get_http_port(default:8080);
if(!jettyPort){
  exit(0);
}

jettyVer = get_kb_item("www/" + jettyPort + "/Jetty");
if(!jettyVer){
  exit(0);
}

jettyVer = eregmatch(pattern:"([0-9.]+)", string:jettyVer);
if(!safe_checks())
{
  sndReq = http_get(item:string(jettyVer, "/jspsnoop/%3Cscript%3Ealert(123)%" +
                                    "3C/script%3E"), port:jettyPort);
  rcvRes = http_send_recv(port:jettyPort, data:sndReq);
  if("123" >< rcvRes);
  {
    security_warning(jettyPort);
    exit(0);
  }
}

if(jettyVer[1] != NULL)
{
  if(version_in_range(version:jettyVer[1], test_version:"6.0.0", test_version2:"6.1.21")){
    security_warning(jettyPort);
  }
}

