###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_outlook_express_dos_vuln.nasl 659 2008-12-16 17:31:56Z dec $
#
# Microsoft Outlook Express Malformed MIME Message DoS Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800083);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5424");
  script_bugtraq_id(32702);
  script_name("Microsoft Outlook Express Malformed MIME Message DoS Vulnerability");
  desc = "

  Overview: The host is installed with Microsoft Outlook Express and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Flaw is caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and e-mail messages with many Content-type: message/rfc822
  headers in MimeOleClearDirtyTree function of InetComm.dll file.

  Impact:
  Successful exploitation could result in application to crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Outlook Express 6.x to 6.00.2900.5512

  Fix: No solution or patch is available as on 16th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://office.microsoft.com/en-us/outlook/default.aspx

  References:
  http://www.securityfocus.com/archive/1/499038
  http://www.securityfocus.com/archive/1/499045
  http://mime.recurity.com/cgi-bin/twiki/view/Main/AttackIntro

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Outlook Express");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:dllPath + "\inetcomm.dll");

# Get version for inetcomm.dll file
dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Version match from 6.0 to 6.00.2900.5512
if(version_in_range(version:dllVer, test_version:"6.0",
                    test_version2:"6.00.2900.5512")){
  security_warning(0);
}
