###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-053.nasl 5261 2009-10-14 00:52:09Z oct $
#
# Microsoft IIS FTP Service Remote Code Execution Vulnerabilities (975254)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900874);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2521", "CVE-2009-3023");
  script_bugtraq_id(36273, 36189);
  script_name("Microsoft IIS FTP Service Remote Code Execution Vulnerabilities (975254)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-053.

  Vulnerability Insight:
  - This issue is caused by an error when processing directory listing commands
    including the '*' character and '../' sequences, which could be exploited
    to exhaust the stack.
  - An heap-based buffer overflow error occurs in the FTP service when processing
    a specially crafted 'NLST' command.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code with
  SYSTEM privileges which may result Denial of Service on the affected server.

  Impact Level: System/Application.

  Affected Software/OS:
  Microsoft Internet Information Server (IIS) 5.0/5/1/6.0

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-053.mspx

  References:
  http://support.microsoft.com/kb/975254
  http://www.vupen.com/english/advisories/2009/2542
  http://www.vupen.com/english/advisories/2009/2481
  http://www.microsoft.com/technet/security/bulletin/MS09-053.mspx

  CVSS Score Report:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 7.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ftpsvc2.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl", "secpod_ms_iis_ftpd_detect.nasl");
  script_require_keys("MS/IIS-FTP/Installed");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("MS/IIS-FTP/Installed")){
  exit(0);
}

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-053 Hotfix check
if((hotfix_missing(name:"975254") == 0)){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\inetsrv\ftpsvc2.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for ftpsvc2.dll version < 5.0.2195.7336
  if(version_is_less(version:dllVer, test_version:"5.0.2195.7336")){
    security_hole(21);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for ftpsvc2.dll < 6.0.2600.3624
    if(version_is_less(version:dllVer, test_version:"6.0.2600.3624")){
      security_hole(21);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for ftpsvc2.dll < 6.0.2600.5875
    if(version_is_less(version:dllVer, test_version:"6.0.2600.5875")){
      security_hole(21);
    }
    exit(0);
  }
  security_hole(21);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for ftpsvc2.dll version < 6.0.3790.4584
    if(version_is_less(version:dllVer, test_version:"6.0.3790.4584")){
      security_hole(21);
    }
    exit(0);
  }
  security_hole(21);
}
