# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 458-3
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53710);
 script_cve_id("CVE-2004-0150");
 script_bugtraq_id(9836);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 458-3 (python2.2)";
 script_name(name);

 desc = "The remote host is missing an update to python2.2
announced via advisory DSA 458-3.

This security advisory corrects DSA 458-2 which caused a problem in
the gethostbyaddr routine.

The original advisory said:

Sebastian Schmidt discovered a buffer overflow bug in Python's
getaddrinfo function, which could allow an IPv6 address, supplied by a
remote attacker via DNS, to overwrite memory on the stack.

This bug only exists in python 2.2 and 2.2.1, and only when IPv6
support is disabled.  The python2.2 package in Debian woody meets
these conditions (the 'python' package does not).

For the stable distribution (woody), this bug has been fixed in
version 2.2.1-4.6.

The testing and unstable distribution (sid) are not affected by this
problem.

We recommend that you update your python2.2 packages.




Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20458-3

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 458-3 (python2.2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"idle-python2.2", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-doc", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-elisp", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-examples", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-dev", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-gdbm", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-mpz", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-tk", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-xmlbase", ver:"2.2.1-4.6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
