###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_avast_av_mult_vuln_oct09_win.nasl 5171 2009-10-06 16:31:26Z oct $
#
# avast! Multiple Vulnerabilities - Oct09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801111);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3522", "CVE-2009-3523", "CVE-2009-3524");
  script_bugtraq_id(36507);
  script_name("avast! Multiple Vulnerabilities - Oct09 (Win)");
  desc = "
  Overview: This host is installed with avast! AntiVirus and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - A boundary error exists in the 'aswMon2' kernel driver when processing
    IOCTLs. This can be exploited to cause a stack-based buffer overflow
    via a specially crafted 0xB2C80018 IOCTL.
  - An error in the 'AavmKer4.sys' kernel driver that can be exploited to
    corrupt memory via a specially crafted 0xB2D6000C or 0xB2D60034 IOCTL.
  - An unspecified error exists in the ashWsFtr.dll library which can be
    exploited to cause unknow impact.

  Impact:
  Successful exploitation will let the local attackers to cause a Denial of
  Service or gain escalated privileges on the victim's system.

  Impact Level: System/Application

  Affected Software/OS:
  avast! Home and Professional version prior to 4.8.1356 on Windows

  Fix: Upgrade to avast! version 4.8.1356 or later
  http://www.avast.com/eng/download.html

  References:
  http://secunia.com/advisories/36858/
  http://www.securityfocus.com/archive/1/506681
  http://www.vupen.com/english/advisories/2009/2761

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check  the version of avas ! Antivirus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_avast_av_detect_win.nasl");
  script_require_keys("Avast!/AV/Win/Ver");
  exit(0);
}


include("version_func.inc");

avastVer = get_kb_item("Avast!/AV/Win/Ver");
if(isnull(avastVer)){
  exit(0);
}

# Check for avast! versions prior to 4.8.1356
if(version_is_less(version:avastVer, test_version:"4.8.1356")){
  security_hole(0);
}
