###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for evolution vulnerabilities USN-615-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840324);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "615-1");
  script_cve_id("CVE-2008-1108", "CVE-2008-1109");
  script_name( "Ubuntu Update for evolution vulnerabilities USN-615-1");
  desc = "

  Vulnerability Insight:

  Alin Rad Pop of Secunia Research discovered that Evolution did not
  properly validate timezone data when processing iCalendar attachments.
  If a user disabled the ITip Formatter plugin and viewed a crafted
  iCalendar attachment, an attacker could cause a denial of service or
  possibly execute code with user privileges. Note that the ITip
  Formatter plugin is enabled by default in Ubuntu. (CVE-2008-1108)
  
  Alin Rad Pop of Secunia Research discovered that Evolution did not
  properly validate the DESCRIPTION field when processing iCalendar
  attachments. If a user were tricked into accepting a crafted
  iCalendar attachment and replied to it from the calendar window, an
  attacker code cause a denial of service or execute code with user
  privileges. (CVE-2008-1109)
  
  Matej Cepl discovered that Evolution did not properly validate date
  fields when processing iCalendar attachments. If a user disabled the
  ITip Formatter plugin and viewed a crafted iCalendar attachment, an
  attacker could cause a denial of service. Note that the ITip
  Formatter plugin is enabled by default in Ubuntu.

  Affected Software/OS:
  evolution vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000715.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of evolution vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.6.1-0ubuntu7.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.6.1-0ubuntu7.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.6.1-0ubuntu7.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.6.1-0ubuntu7.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins-experimental", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-common", ver:"2.10.1-0ubuntu2.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins-experimental", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-common", ver:"2.22.2-0ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-dev", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-plugins-experimental", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-common", ver:"2.12.1-0ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}