Minutes from 31st OpenVDB TSC meeting, October 31st, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M., *Peter* C.

Additional Attendees: Bruce Chernia (Intel)

Agenda:

1) Confirm quorum
2) Secretary
3) EasyCLA (PRs #227 #493 #498)
4) PR 537
5) OVDB-119
6) OVDB-122
7) OVDB-124
8) Refactoring Tree (OVDB-121 / PR536 + PR539)
9) OVDB-123 (Gaussian and principal curvatures)
10) Follow Up on Leaf Node Memory Usage
11) Next Meeting


1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) EasyCLA (PRs #227 #493)

Jeff confirmed that the EasyCLA has started working on his pull requests. We
are now in a position to start asking for contributors to update their PRs and
go through the automated CLA process. Jeff to follow up on PR 227. Dan to follow
up with PR 493 with additional comments about his brief tests. Nick to follow
up with PR 498.

4) PR 537

Changes confirmed by Peter. Jeff to re-trigger the build and then merge. There
seems to be no easy way to re-trigger builds through the github UI/API due to
the LF setup. Nick to mention this to John.

5) OVDB-119

Reported by Jeff, there is a reproducible case where level set construction from
a closed water-tight surface seems to be failing with artifacts similar to
those seen with failures during signed flood filling. Bringing this to the
attention of TSC members.

6) OVDB-122

Reported by Jeff, there was an issue with the way group membership was
transfered to VDB points from Houdini geometry, due to the mixed and incorrect
use of GA_Index and GA_Offet. Nick believes this was fixed in PR263 which has
since been merged. Jeff to check and report back.

7) OVDB-124

Reported by Dan, this is the result of a continued investigation by the TSC into
ways in which VDB tools are designed, primarily comparing tools which exist as
methods on the Tree to those that exist as free functions. This particular
ticket represents the only method (RootNode::addChild()) which has been
highlighted thus far to be missing for an example VDB merge free function which
would not have private member access. There were concerns that accessors that
are caching the current node being added may be referencing different trees
after the child has been set, however it was generally agreed that it is the
responsibility of whoever is providing the child to invalidate the accessor. Dan
mentioned that you are already able to set arbitrary nodes on Internal nodes by
leveraging the Tree Iterators setItem() function, however it was generally
agreed that this was not its intended public use and that, were we to pursue
this, we should consider adding methods to the InteralNode too. Some discussion
around the function name (addNode vs addChild), where addChild is only capable
of adding a child type. addNode is a more powerful method as it lets users add
any node type are the appropriate descendant location.

Discussion also around the addLeaf and addLeafAndCache methods. These exist on
the Tree and on the ValueAccessors. The intended use of addLeafAndCache is
mainly through the ValueAccessor API which ensures that a given ValueAccessor's
cache is updated to cache the descendant path to added leaf nodes. This is
intended to provide performance improvements on subsequent leaf additions which
reside within the same branch of the Tree. Noted that adding addChild methods to
the ValueAccessor which mimic those proposed to the RootNode would provide no
benefit as no branch traversal need be performed.

8) Refactoring Tree (OVDB-121 / PR536 + PR539)

Next TSC meeting to attempt to progress this discussion. TSC members to look at
both PRs. One additional thing to consider is what to do with other possible
counting methods which benefit heavily from better parallelization. General
consensus was that both methods could coexist whilst we continue this
investigation.

9) OVDB-123 (Gaussian and principal curvatures)

Ken's methods to compute principal curvature, Gaussian curvature and
disconnected components are almost completed. These will slot into existing
frameworks in VDB however an initial PR will most likely not expose them
to Houdini. The Gaussian curvature analysis also allows for computation of the
genus value of a given surface.

10) Follow Up on Leaf Node Memory Usage

Still some investigation to do here, but agreement that it is a priority due to
an ABI 7 release date approaching. Ken mentioned that his read-only Tree
implementation was able to cut down memory usage from ~90 to ~16 bytes.

Agreement that focus should be on ABI 7 changes for the next few weeks.

11) Next Meeting

Next planned meeting is:

November 14th 2019. 2pm-3pm EST (GMT-5)
