Minutes from 45th OpenVDB TSC meeting, April 9th, 2020, (GMT)

Attendees: *Nick* A., *Jeff* L., *Ken* M.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Peter Cheng (DW), Andre Pradhana (DW)

Regrets: *Peter* C., *Dan* B.

Agenda:

1) Confirm quorum
2) Secretary
3) OpenVDB AX recap
4) Forum/Github Issues update
5) Plan for Improved Morphology
6) Google Summer of Code
7) CI Updated
8) VDB Activate/Activate SDF
9) OVDB-136
10) OpenVDB & USD
11) Next meeting

1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) OpenVDB AX recap

Discussion ongoing between Nick and Jeff as various AX features are nailed down.
A number of proposed changes have been approved -  bitwise operations on
integer vectors, restricting comparison operation on container types and correct
implementation of fmod. Two outstanding requests are the beahviour of
matrix and scalar operations and container (vector) extension. Jeff's preferred
behaviour for the prior is to treat scalar promotion as an identity matrix
with its identity components set to the corresponding scalar. For the latter,
VEX currently extends vectors with a value of one to better match the behaviour
of various applications against matrices of otherwise incompatible sizes and to
better correspond to a default value of colour (alpha) or homogeneous coordiante
(w). The alternative would be to explicitly error on this behaviour. AX
currently already errors on assignment of containers of mismatching sizes.

4) Nick proposed that every TSC meeting additionally begin with a quick recap
of newly opened forum posts or github issues. Unanimous consensus. Two topics
for discussion.

4a) OpenVDB Documentation

New forum post requesting update on OpenVDB documentation. Agreement that
OpenVDB technical documentation needs a revamp and could benefit from extension.
This is a significant task with no obvious starting point. Andre mentioned that
the unit tests have served as a good place to observe various intended usage of
VDB methods. Using the unit tests would provide a base set of examples to start
writing documentation. Nick, concern that as the unit tests have not necessarily
been designed for this that some of the logic in there could be "inaccurate" in
terms of an optimal implementation solution. Additional care to be taken that
the unit tests are first and foremost that, with clear documentation of the
intended example. Nick to create a ticket with a task to identity some of the
larger tools missing documentation and corresponding unit tests which could be
used as a first doc attempt.

4b) Hessian computation of VDB grids

Github issue asking if OpenVDB supports the computation of the Hessian matrix
from a scalar Grid. Currently unsupported. Ken, should be fairly trivial to
implement. However, as the result per value is a matrix, there is no native way
to store this information as VDB does not register matrix grids by default.
Registering these grid types would be one option - however compile and runtime
variants of "strided" grids (where each voxel/tile value contains an array of
scalar values of a fixed size) were discussed as alternative solutions which
could add more flexibility. Some potential confusion when inferring values on
a grid with an "intrinsic" type i.e. Vec3f vs float[3] collocated vs staggered
interpretation. General agreement that runtime variants would be interesting to
pursue. Nick to create a ticket and reply to issue.

5) Plan for Improved Morphology

Ken and Nick to catch up at a later date.

6) Google Summer of Code

Two mentors are needed. Dan has already volunteered to be one. Nick has
volunteered to be the second, with an agreement with Ken to share responsibility
if required.

7) CI Updated

General notice that all VDB builds should now be passing on new PRs and that PRs
should not be merged if any builds fail. Dan has a fix in the works to re-enable
the Houdini 18 Debug builds.

8) VDB Activate/Activate SDF

Two open PRs (PR692, PR695) could do with additional review from Ken and Nick.

9) OVDB-136 (Point Merging/Moving)

Nick needs to review PRs PR652 and PR631.

10) OpenVDB & USD

Additional discussion to be had next meeting.

11) Next meeting

April 16th 2020. 2pm-3pm EDT (GMT-4).
