'\"
'\" Copyright (c) 2003-2006 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Library manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH OWCAPI 1 2004 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B owcapi
\- easy C-language 1-wire interface
.SH SYNOPSIS
.B libowcapi
library to link with your program
.SS Initialization
.B ssize_t OW_init(
.I device name or full parameter string
.B )
.br
.B ssize_t OW_init_args(
.I int argc, char ** args
.B )
.PP
The full set of initialization options is extensive. They correspond roughly to the command line options of
.B owfs (1)
.B owhttpd (1)
and
.B owftpd (1)
.SS Get data
.B int OW_present(
.I const char * path
.B )
.br
.B int OW_get(
.I const char * path, char ** buffer, size_t * buffer_length
.B )
.br
.B ssize_t OW_lread(
.I const char * path, unsigned char * buffer, const size_t size, const off_t offset
.B )
.SS Set data
.B ssize_t OW_put(
.I const char * path, const char * buffer, size_t * buffer_length
.B )
.br
.B ssize_t OW_lwrite(
.I const char * path, const unsigned char * buffer, const size_t size, const off_t offset
.B )
.SS Debug
.B void OW_set_error_level(
.I const char *param
.B )
.br
.B void OW_set_error_print(
.I const char *param
.B )
.SS Close
.B void OW_finish(
.I void
.B )
.SH FUNCTIONS
.SS OW_init
.I OW_init_string
offers the full flexibility of the
.B owfs (1)
and
.B owhttpd (1)
command line.
.TP
.I Arguments
Can be as simple as jus the device name, a full parameter specification.
One or more device names (includes tcp, serial, usb...) and command line switches. See
.B owfs (1)
for full syntax.
.TP
.I Returns
0 for success. \-1 on error and
.I errno
will be set.
.I OW_finish
does not need to be called if
.I OW_init
fails.
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_init_args
.I OW_init_args
offers the full flexibility of the
.B owfs (1)
and
.B owhttpd (1)
command line.
.TP
.I Arguments
One or more device names (includes tcp, serial, usb...) and command line switches. See
.B owfs (1)
for full syntax. Unlike
.I OW_init_string
the arguments are in argv/argc format.
.TP
.I Returns
0 for success. \-1 on error and
.I errno
will be set.
.I OW_finish
does not need to be called if
.I OW_init
fails.
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_present
.I OW_present
is used to check presence of a 1-wire device.
.TP
.I Arguments
.I path
is the path to the directory or file (property).
.TP
.I Returns
0 on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_get
.I OW_get
is used to get directory listings and file contents. The results are put in a dynamically allocated buffer.
.TP
.I Arguments
.I path
is the path to the directory or file (property).
.I *buffer
returns a pointer to a buffer containing the directory (comma separated) or value.
.I buffer_length
returns the length of the value/string in
.I buffer
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.TP
.I Important note
.I buffer
is allocated ( with malloc ) by
.I OW_get
but must be freed in your program. See
.B malloc (3)
and
.B free (3)
.SS OW_lread
.I OW_lread
is used to read 1-wire memory chips. Think of it as a combination of
.I lseek
and
.I read
It allows random-access to the memory, specifying location and length. Unlike
.I OW_get
directories cannot be obtained and the buffer must be pre-allocated rather than allocated by the routine.
.I buffer
must be at least
.I size
length.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the (pre-allocated) memory area where the value will be placed.
.I size
is the length of bytes requested.
.I offset
is the position in file to start reading.
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_put
.I OW_put
is an easy way to write to 1-wire chips.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the value to be written.
.I buffer_length
is the length of the value
.I buffer.
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_lwrite
.I OW_lwrite
is the companion of
.I OW_lread.
It allows writing to arbitrary positions in 1-wire memory.
Think of it as a combination of
.I lseek
and
.I write.
.I buffer
must be at least
.I size
length.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the data to be written.
.I size
is the length of bytes to be written.
.I offset
is the position in file to start writing.
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_set_error_level
.I OW_set_error_level
sets the debug output to a certain level. 0 is default, and higher value gives more output.
.br
(0=default, 1=err_connect, 2=err_call, 3=err_data, 4=err_detail, 5=err_debug, 6=err_beyond)
.TP
.I Arguments
.I params
is the level. Should be an integer.
.TP
.I Returns
None
.TP
.I Sequence
One of the
.I init
functions must be called before setting the level, since
.I init
defaults to level 0.
.SS OW_set_error_print
.I OW_set_error_print
sets where the debug output should be directed. 0=mixed output, 1=syslog, 2=console.
.TP
.I Arguments
.I params
is the level. Should be an integer between 0 and 2.
.TP
.I Returns
None
.TP
.I Sequence
One of the
.I init
functions must be called before setting the level, since
.I init
defaults to 0 (mixed output).
.SS OW_finish
.I OW_finish
cleans up the
.I OWFS
1-wire routines, releases devices and memory.
.TP
.I Arguments
None.
.TP
.I Returns
None
.TP
.I Sequence
.I OW_finish
is optional since cleanup is automatic on program exit.
.SH "DESCRIPTION"
.so man1/description.1so
.SS libowcapi
.B libowcapi (1)
is an encapsulation of the full
.B libow
library for C programs.
.PP
.B libowcapi (1)
allows a C program to use
.I OWFS
principles (consistent naming scheme, multiple adapters, devices, and compatibility) directly from a C program. There are analogous modules for other programming languages:
.TP
.I C
libowcapi
.TP
.I perl
owperl
.TP
.I php
owphp
.TP
.I python
owpython
.TP
.I tcl
owtcl
.SH EXAMPLE
/* Simple directory listing -- no error checking */
.br
#include <owcapi.h>
.br
unsigned char * buf;
.br
size_t s ;
.br
OW_init("/dev/ttyS0");
.br
OW_set_error_print("2");
.br
OW_set_error_level("6");
.br
OW_get("/",&buf,&s) ;
.br
printf("Directory %s\n",buf);
.br
free(buf);
.br
OW_finish() ;
.SH SEE ALSO
.so man1/seealso.1so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
