'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH LCD 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B LCD
\- LCD controller
.SH SYNOPSIS
1-wire LCD controller by Louis Swart
.PP
.B FF
[.]XXXXXXXXXXXX[XX][/[
.B backlight
|
.B counters.[0-3|ALL]
|
.B cumulative.[0-3|ALL]
|
.B branch.[0-1|ALL]
|
.B data
|
.B gpio.[0-3|ALL]
|
.B LCDon
|
.B line16.[0-3|ALL]
|
.B line20.[0-3|ALL]
|
.B line40.[0|1|ALL]
|
.B memory
|
.B register
|
.B screen16
|
.B screen20
|
.B screen40
|
.B version
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I FF
.SH SPECIAL PROPERTIES
.SS backlight
.I write-only,yes-no
.br
Write a non-zero value to turn on the LCD backlight. Write zero to turn off.
.SS counters[0-3,ALL]
.I read-only,unsigned integer
.br
Read the number of times the gpio has been externally changed. If wired to a push switch, will count twice per button press. The LCD firmware resets all the counter when any one is read. Use the
.I ALL
extension to read them all, simultaneously, or use the
.I cumulative
property instead.
.br
.I ALL
is an aggregate of the properties, comma separated. Read atomically.
.SS cumulative[0-3,ALL]
.I read-write,unsigned integer
.br
Cumulative sum of the
.I counters
property. To reset, write a zero. The cumulative counter can have any value written, which allows preservation of counts across program restarts if the value at program termination is stored.
.br
Reading
.I cumulative
will reset the
.I counters
property. All the cumulative counters will be updated so that no counts will be lost. Reads of
.I counters
can be interspersed without losing
.I cumulative
accuracy.
.br
Note:
.I cumulative
requires the
.I caching
system be compiled into libow.
.br
.I ALL
is an aggregate of the properties, comma separated.
.SS data
.I read-write,unsigned int
.br
Contents of the LCD data byte (see datasheet). Not usually needed.
.SS LCDon
.I write-only,yes-no
.br
Write a non-zero value to turn on the LCD screen (also clears). Write a zero to turn off.
.SS line16[0-3,ALL] line20[0-3,ALL] line40[0-1,ALL]
.I write-only,ascii
.br
Write text to the LCD screen. Assumes 16/20/40 char width. (Cannot be determined from controller).
.br
.I ALL
is an aggregate of the properties, comma separated. Each is set in turn.
.SS memory
.I read-write,binary
.br
112 bytes of on-board memory.
.SS register
.I read-write,unsigned int
.br
Contents of the LCD register (see datasheet). Not usually needed.
.SS screen16 screen20 screen40
.I write-only,ascii
.br
Write text to the LCD screen. Assumes 16/20/40 char width. (Cannot be determined from controller).
.br
.SS version
.I read-only,ascii
.br
Self-reported LCD controller version. 16 bytes.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None implemented.
.SH DESCRIPTION
.so man3/description.3so
.SS LCD
The
.B LCD (3)
controller is a microprocessor driven device that simulates the operation of 1-wire devices. It's creator has arbitrarily chosen the
.I family code
FF. The controller requires external power. Full details are available from the designer.
.br
The main draw of the
.B LCD
controller is as any easy way to provide output to users.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
Available from http://www.louisswart.co.za/1-Wire_index.html
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
